<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use App\Http\Controllers\ModuloController;
use Illuminate\Support\Facades\Storage;  
use App\Models\Curso;
use App\Models\Modulo;
use App\Models\Matricula;
use App\Models\Nota;
use App\Models\User;
use App\Models\Firma;
use App\Models\Prueba;
use App\Models\Certificado;
use Carbon\Carbon; 


class CertificaController extends Controller
{
    //
  public function index(Curso $curso, Modulo $modulo, Matricula $matricula, User $user, Prueba $prueba, Request $request){
    $cedula=$request->get('buscador');
    
      //Consulta los certificados que tenga registrados el usuario
      $certificas = Certificado::join('cursos','certificados.id_curso', '=', 'cursos.id')
                                ->where('certificados.cedula_estudiante', '=', $cedula )
                                ->orderBy('certificados.id','desc')
                                ->paginate();
                                
                        
        return view('certificas.index', compact('certificas'));

  }

    public function show(Certificado $id, Request $request){
        
      $cedula=$request->cedula;
      $id_curso=$request->id_curso;
        
         //consultar dia, mes y a09o                      
          $now = Carbon::now();
          $currentDate = $now->format('y-m-d');
          
        $fecha = $currentDate;
        $fechaEntera = strtotime($fecha);
        $anio = date("Y", $fechaEntera);
        $mes = date("m", $fechaEntera);
        $dia = date("d", $fechaEntera);
            
      //consulta de la fecha de aprobación del curso
      $certificas = Certificado::join('cursos','certificados.id_curso', '=', 'cursos.id')
                            ->select('certificados.fecha_aprobacion', 'certificados.cedula_estudiante' ,'cursos.titulo_curso', 'cursos.ih')
                            ->where('certificados.cedula_estudiante', '=', $cedula)
                            ->where('certificados.id_curso', '=', $id_curso)
                            ->first();
                            /* dd($certificas); */
      $usuarios = User::select('name', 'tipo_documento')->where('cedula', $cedula)->first();    
      
      $titular_firma = 'Secretario(a)';
      $firmas = Firma::select('archivo')->where('titular_firma', '=', $titular_firma)->first(); 
                 
        
        if($id_curso != 20){
           return view('certificas.show', compact('id', 'certificas', 'usuarios', 'firmas'));
       }
        else{
                return view('certifica_UAM_s.show', compact('id', 'certificas', 'firmas', 'anio', 'mes', 'dia', 'usuarios'));
            }
      }
}
