<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use App\Http\Controllers\ModuloController;
use Illuminate\Support\Facades\Storage;  
use App\Models\Curso;
use App\Models\Modulo;
use App\Models\Matricula;
use App\Models\Nota;
use App\Models\User;
use App\Models\Prueba;
use App\Models\Certificado;
use Mockery\Matcher\Not;
use App\Models\Firma;
use Carbon\Carbon; 

class CertificadoController extends Controller
{
    //
    public function index(Curso $curso, Modulo $modulo, Matricula $matricula, User $user, Prueba $prueba, Request $request){

      $usuario =  auth()->user()->cedula;
      $codigo_curso = $curso->id;
     
      //Valida si el usuario esta registrado en el curso y lista de los cursos en los que esta inscrito
      $certificados = Certificado::join('cursos','certificados.id_curso', '=', 'cursos.id')
                            ->where('certificados.cedula_estudiante', '=', $usuario)
                            ->paginate();

      return view('certificados.index', compact('certificados'));        
    }

    public function show(Certificado $id, Curso $curso, Request $request){
      $usuario =  auth()->user()->cedula;
      $id_curso=$request->id_curso;
      
      //consultar dia, mes y a09o                      
          $now = Carbon::now();
          $currentDate = $now->format('y-m-d');
          
            $fecha = $currentDate;
            $fechaEntera = strtotime($fecha);
            $anio = date("Y", $fechaEntera);
            $mes = date("m", $fechaEntera);
            $dia = date("d", $fechaEntera);
     
      //consulta de la fecha de aprobación del curso
      $certificados = Certificado::join('cursos','certificados.id_curso', '=', 'cursos.id')
                            ->select('certificados.fecha_aprobacion', 'certificados.cedula_estudiante' ,'cursos.titulo_curso', 'cursos.ih')
                            ->where('certificados.cedula_estudiante', '=', $usuario)
                            ->where('certificados.id_curso', '=', $id_curso)
                            ->first();  

      $titular_firma = 'Secretario(a)';
      $firmas = Firma::select('archivo')->where('titular_firma', '=', $titular_firma)->first(); 

       if($id_curso != 20){
           return view('certificados.show', compact('id','certificados', 'firmas', 'id_curso'));
       }
        else{
                return view('certificado_UAM_s.show', compact('id', 'certificados', 'firmas', 'anio', 'mes', 'dia'));
            }
    }
}
  