<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use App\Http\Controllers\ModuloController;
use Illuminate\Support\Facades\Storage;  
use App\Models\Curso;
use App\Models\Modulo;
use App\Models\Matricula;
use App\Models\Nota;
use App\Models\User;
use App\Models\Prueba;
use App\Models\Certificado;
use App\Models\Firma;
use Carbon\Carbon; 

class CertificoController extends Controller
{
    public function index(Curso $curso, Modulo $modulo, Matricula $matricula, User $user, Prueba $prueba, Request $request){
        $cedula=$request->get('buscador');
        
          //Consulta los certificados que tenga registrados el usuario
          $certificos = Certificado::join('cursos','certificados.id_curso', '=', 'cursos.id')
                                    ->where('certificados.cedula_estudiante', '=', $cedula )
                                    ->orderBy('certificados.id','desc')
                                    ->paginate();
                                    
                            
            return view('certificos.index', compact('certificos'));
    
      }
    
        public function show(Certificado $id, Request $request){
            
          $cedula=$request->cedula;
          $id_curso=$request->id_curso;
          //consulta de la fecha de aprobación del curso
          $certificos = Certificado::join('cursos','certificados.id_curso', '=', 'cursos.id')
                                ->select('certificados.fecha_aprobacion', 'certificados.cedula_estudiante' ,'cursos.titulo_curso', 'cursos.ih')
                                ->where('certificados.cedula_estudiante', '=', $cedula)
                                ->where('certificados.id_curso', '=', $id_curso)
                                ->first();
                                /* dd($certificas); */
          
          //consultar dia, mes y a09o                      
          $now = Carbon::now();
          $currentDate = $now->format('y-m-d');
          
            $fecha = $currentDate;
            $fechaEntera = strtotime($fecha);
            $anio = date("Y", $fechaEntera);
            $mes = date("m", $fechaEntera);
            $dia = date("d", $fechaEntera);
                         
                                
          $usuarios = User::select('name', 'tipo_documento')->where('cedula', $cedula)->first();    
          
          $titular_firma = 'Secretario(a)';
          $firmas = Firma::select('archivo')->where('titular_firma', '=', $titular_firma)->first();
                     
            if($id_curso != 20){
                return view('certificos.show', compact('id', 'certificos', 'usuarios', 'firmas'));
            }
            else{
                return view('certifico_UAM_s.show', compact('id', 'certificos', 'usuarios', 'firmas', 'anio', 'mes', 'dia'));
            }
          }
    }
    