<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use App\Http\Controllers\ModuloController;
use Illuminate\Support\Facades\Storage;  
use App\Models\Curso;
use App\Models\Modulo;
use App\Models\Matricula; 
use App\Models\Nota;
use App\Models\User;
use App\Models\Prueba;
use App\Models\Certificado; 

class ConstanciaController extends Controller
{
    //
    
    public function index(Curso $curso, Request $request){
        
        $usuario =  auth()->user()->cedula;
        
        $visitante_UAM = 'Visitante_UAM';
        
        $consulta_perfil_UAM = User::where('cedula', $usuario)->where('perfil', $visitante_UAM)->first();
        
        if($consulta_perfil_UAM){
            $curso_UAM = 20;
            $cursos = Curso::where('id', '=', $curso_UAM)
                           ->OrderBy('id', 'desc')
                           ->paginate();
                           
                           
            $constancias = Certificado::OrderBy('id', 'desc')->paginate();
            //consulta de los cursos registrados
          
    
            $curso=$request->get('curso');
            
            //consulta el nombre del curso consultado
            $nombre_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                        ->select('cursos.titulo_curso')
                                        ->where('certificados.id_curso', '=', $curso_UAM )
                                        ->first();
    
            //Consulta los certificados que tenga registrados el usuario
            $certificados = Certificado::select('users.cedula', 'users.name', 'users.lugar_trabajo', 'users.email', 'users.telefono',
                                                'certificados.created_at', 'certificados.cedula_estudiante', 'certificados.email_estudiante',
                                                'certificados.id_curso')
                                         
                                        
                                        ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                       
                                        
                                        ->where('certificados.id_curso', '=', $curso_UAM )
                                        
                                        ->Orderby('certificados.fecha_aprobacion', 'Desc')
                                       
                                        ->paginate(300);
                                        
            $contador = Certificado::where('id_curso', '=', $curso_UAM)->get();
                                                        
        
            $resultado_contador = count($certificados);
        }

        else{
            $constancias = Certificado::OrderBy('id', 'desc')->paginate();
            //consulta de los cursos registrados
            $cursos = Curso::OrderBy('id', 'desc')->paginate();
    
            $curso=$request->get('curso');
            
            //consulta el nombre del curso consultado
            $nombre_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                        ->select('cursos.titulo_curso')
                                        ->where('certificados.id_curso', '=', $curso)
                                        ->max('cursos.titulo_curso');
    
            //Consulta los certificados que tenga registrados el usuario
            $certificados = Certificado::select('users.cedula', 'users.name', 'users.lugar_trabajo', 'users.email', 'users.telefono',
                                                'certificados.created_at', 'certificados.cedula_estudiante', 'certificados.email_estudiante',
                                                'certificados.id_curso')
                                         
                                        
                                        ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                       
                                        
                                        ->where('certificados.id_curso', '=', $curso )
                                        
                                        ->Orderby('certificados.fecha_aprobacion', 'Desc')
                                       
                                        ->paginate(300);
                                        
                                        
            $contador = Certificado::where('id_curso', '=', $curso)->get();
                                                        
        
         $resultado_contador = count($certificados);
                            
        }

       return view('constancias.index', compact('constancias', 'cursos', 'certificados', 'nombre_curso', 'resultado_contador'));
    }
      
}
