<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Mail\ContactanosMailable;
use Illuminate\Support\Facades\Mail;
use App\Models\Curso;
use App\Models\User;


class ContactanosController extends Controller
{
    //el método index muestra el formulario y el store lo procesa
    public function index(Request $request, Curso $curso){
        
         $iden_curso = $request->id_curso; 
         
         $usuario =  auth()->user()->cedula;
         
         $nombre =  auth()->user()->name;
         
         $email_estudiante =  auth()->user()->email;
        
        $correo_tutor = Curso::select('email_responsable')->where('id', '=', $iden_curso)->max('email_responsable');
        
        $nombre_curso = Curso::select('titulo_curso')->where('id', '=', $iden_curso)->max('titulo_curso');
        
        return view('contactanos.index', compact('correo_tutor', 'nombre', 'email_estudiante', 'nombre_curso'));
 
    } 

    public function store(Request $request){
        
        $email_tutor = $request->correo_tutor;
       
 
         $request->validate([
             'name' => 'required',
             'correo' => 'required|email',
             'correo_tutor' => 'required|email',
             'nombre_curso' => 'required',
             'mensaje' => 'required',
         ]);

        $correo = new ContactanosMailable($request->all());

        Mail::to($email_tutor)->send($correo);
        
        $correo2 = new ContactanosMailable($request->all());

        Mail::to('siis@manizales.gov.co')->send($correo2);

        return redirect()->route('contactanos.index')->with('info', 'Mensaje enviado');

    }
}

