<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use App\Http\Controllers\CertificadoController;
use Illuminate\Support\Facades\Storage;  
use App\Models\Curso;
use App\Models\Modulo;
use App\Models\Matricula;
use App\Models\Nota;
use App\Models\User;
use App\Models\Prueba; 
use App\Models\Certificado;
use Carbon\Carbon; 
use Nette\Utils\ArrayList;
use PhpParser\Node\Stmt\Foreach_;
use Prophecy\Doubler\Generator\Node\ReturnTypeNode;



class CursoController extends Controller
{
    //protegemos las rutas, para evitar daños de terceros
    public function __construct()
    {
        $this->middleware('can:cursos.index')->only('index');
        $this->middleware('can:cursos.create')->only('create', 'store');
        $this->middleware('can:cursos.edit')->only('edit', 'update');
        $this->middleware('can:cursos.destroy')->only('destroy');
    }
    // 
    public function index(Curso $curso, Matricula $matricula){

        //validamos si el perfil es docente o administrador(a)
        $now = Carbon::now();
        $currentDate = $now->format('Y-m-d');
        $usuario =  auth()->user()->cedula;
        $var_doc = 'Docente';
        $var_adm = 'Admin';
        $visitante_UAM = 'Visitante_UAM';
        $consulta_perfil = User::where('cedula', $usuario)->where('perfil', $var_doc)->first();
        $consulta_perfil2 = User::where('cedula', $usuario)->where('perfil', $var_adm)->first();
        $consulta_perfil_UAM = User::where('cedula', $usuario)->where('perfil', $visitante_UAM)->first();
        
        if($consulta_perfil or $consulta_perfil2){
            $cursos = Curso::OrderBy('id', 'desc')
                            ->paginate();
        }
        else{
        //validamos la fecha de cierre del curso, para saber si se muestra o no.
        $now = Carbon::now();
        $currentDate = $now->format('Y-m-d');
        $estudiante_publico = 'Estudiante';
        $estudiante_privado = 'Estudiante_privado';
        $curso_publico = 'Publico';
        $curso_privado = 'Privado';
        $usuario =  auth()->user()->cedula;

        //Consulta si el estudiante es público o privado
        $consulta_perfil_estudiante = User::where('cedula', $usuario)->where('perfil', $estudiante_publico)->first();

        if($consulta_perfil_estudiante){
            $usuario =  auth()->user()->cedula;
            // se utiliza paginate para distribuir en páginas el contenido
            $cursos = Curso::join('matriculas', 'cursos.id', '=', 'matriculas.id_curso')
                            ->where('matriculas.cedula_estudiante', $usuario)
                            ->where('cursos.fecha_inicio', '<', $currentDate)
                            ->where('cursos.fecha_cierre', '>', $currentDate)
                            ->OrderBy('cursos.id', 'desc')
                            ->paginate();

           $id_cursos = Curso::select('id')
                             ->OrderBy('id', 'desc')
                             ->first();
            
          
       
            /* $user = User::join('matriculas','cedula', '=', 'matriculas.cedula_estudiante')
            ->where('matriculas.cedula_estudiante', $usuario)
            ->where('id_curso', $id_cursos)
            ->select('users.id','users.name')
            ->get();    
           
            return $user; */
        }
        else{

            // se utiliza paginate para distribuir en páginas el contenido
            $cursos = Curso::join('matriculas', 'cursos.id', '=', 'matriculas.id_curso')
                            ->where('matriculas.cedula_estudiante', $usuario)
                            ->where('cursos.fecha_inicio', '<', $currentDate)
                            ->where('cursos.fecha_cierre', '>', $currentDate)
                            ->where('cursos.categoria', $curso_publico )
                            ->OrderBy('cursos.id', 'desc')
                            ->paginate();
        }
        
    }
    //si el usuario que ingresa es de la Universidad Autonoma de Manizales
    if($consulta_perfil_UAM){
        $curso_UAM = 20;
        $cursos = Curso::where('id', '=', $curso_UAM)
                       ->OrderBy('id', 'desc')
                       ->paginate();
    }
    
        
        return view('cursos.index', compact('cursos'));


    }

    public function create(){
        return view('cursos.create');

    }

    public function store(Request $request){ 
       if ($request->archivo)
        {
            
            $ruta = $request->archivo->store('public/archivos');
            $url = Storage::url($ruta);

                $curso = new Curso();  
                 Curso::create([ 
                    
                'titulo_curso'=>$curso->titulo_curso = $request->titulo_curso,
                'slug'=>$curso->slug = $request['slug'] = Str::slug($request->titulo_curso),
                'descripcion'=>$curso->descripcion = $request->descripcion,
                'enlace_video'=>$curso->enlace_video = $request->enlace_video,
                'fecha_inicio'=>$curso->fecha_inicio = $request->fecha_inicio,
                'dias'=>$curso->dias = $request->dias,
                'ih'=>$curso->ih = $request->ih,
                'fecha_cierre'=>$curso->fecha_cierre = $request->fecha_cierre,
                'responsable'=>$curso->responsable = $request->responsable,
                'email_responsable'=>$curso->email_responsable = $request->email_responsable,
                'categoria'=>$curso->categoria = $request->categoria,
                'archivo'=>$curso->archivo=$url,

            ]); 

        }
        else{
            $curso = new Curso();  
                 Curso::create([ 
                    
                'titulo_curso'=>$curso->titulo_curso = $request->titulo_curso,
                'slug'=>$curso->slug = $request['slug'] = Str::slug($request->titulo_curso),
                'descripcion'=>$curso->descripcion = $request->descripcion,
                'enlace_video'=>$curso->enlace_video = $request->enlace_video,
                'fecha_inicio'=>$curso->fecha_inicio = $request->fecha_inicio,
                'dias'=>$curso->dias = $request->dias,
                'ih'=>$curso->ih = $request->ih,
                'fecha_cierre'=>$curso->fecha_cierre = $request->fecha_cierre,
                'responsable'=>$curso->responsable = $request->responsable,
                'email_responsable'=>$curso->email_responsable = $request->email_responsable,
                'categoria'=>$curso->categoria = $request->categoria,
                'archivo'=>$curso->archivo=$request->archivo,

            ]); 

        }
 
       return redirect()->route('cursos.index', compact('curso')); 
 
    }
    //////////////////////////////////////

    public function show(Curso $curso, Modulo $modulo, Matricula $matricula, User $user, Prueba $prueba, Request $request){
        
        $usuario =  auth()->user()->cedula;
        $codigo_curso = $curso->id;
        $codigo_modulo = $modulo->id;
        $iden_modulo = $request->id_modulo;
        
        $now = Carbon::now();
        $currentDate = $now->format('Y-m-d');

        
        $dias= Curso::select('dias')
                     ->where('id', '=', $codigo_curso)
                     ->max('dias');

                                    
        $fecha_matricula= Matricula::select('created_at')
                                     ->where('id_curso', '=', $codigo_curso)
                                     ->max('created_at');                             

      
       $limit = date('Y-m-d', strtotime($fecha_matricula. ' + '. $dias. ' days'));
  
      //validamos si el perfil es docente
        $var_doc = 'Docente';
        $var_adm = 'Admin';
        $var_estudiante = 'Estudiante';
        $var_estudiante_privado = 'Estudiante_privado';
        $visitante_UAM = 'Visitante_UAM';
        
        $consulta_perfil = User::where('cedula', $usuario)->where('perfil', $var_doc)->first();
        $consulta_perfil2 = User::where('cedula', $usuario)->where('perfil', $var_adm)->first();
        $consulta_perfil3 = User::where('cedula', $usuario)->where('perfil', $var_estudiante)->first();
        $consulta_perfil4 = User::where('cedula', $usuario)->where('perfil', $var_estudiante_privado)->first();
        $consulta_perfil_UAM = User::where('cedula', $usuario)->where('perfil', $visitante_UAM)->first();
        
        
        if($consulta_perfil3 or $consulta_perfil4){
            
            if($limit <=  $currentDate){
            
               $consul = Matricula::where('id_curso', '=', $codigo_curso)
                                   ->where('cedula_estudiante', '=', $usuario)
                                   ->first();
                $consul->delete();

                $consul1 = Nota::where('id_curso', '=', $codigo_curso)
                                ->where('cedula_estudiante', '=', $usuario)
                                ->first();
                $consul1->delete();                
        
                return redirect()->route('lista_cursos.index');
        
           
        }
        }
       
         
        
        
        if($consulta_perfil or $consulta_perfil2 or $consulta_perfil_UAM){
            $modulos = Modulo::where('id_curso', $codigo_curso)
                             ->get();
            //Consulta los cursos disponibles
            $cursos = Curso::OrderBy('id', 'desc')->get();

            //Consulta quienes están inscritos en cada curso
            $users = User::join('matriculas','cedula', '=', 'matriculas.cedula_estudiante')
                        ->where('id_curso', $codigo_curso)
                        ->select('users.id','users.name')
                        ->get();

            //Consulta el nombre del creador del curso
            $docentes = User::join('cursos','cedula', '=', 'cursos.responsable')
                            ->select('users.id','users.name')
                            ->where('cursos.id', $codigo_curso)
                            ->get();

            
            //Consulta las pruebas que se han creado para cada uno de los módulos
            $pruebas = Prueba::where('id_curso', $codigo_curso)
               
                ->get();
                
             //Tiempo limite para desarrollar el curso
            $fecha_matricula= Matricula::select('created_at')
                                     ->where('id_curso', '=', $codigo_curso)
                                     ->where('cedula_docente', '=', $usuario)
                                     ->max('created_at');
                                     
            return view('cursos.show', compact('modulo','modulos', 'curso', 'users', 'docentes', 'pruebas', 'fecha_matricula' )); 
        }
        else{
        
        //Valida si el usuario esta registrado en el curso
       $consulta_inscripcion = Matricula::select('cedula_estudiante', 'id_curso')
                                          ->where('cedula_estudiante', '=', $usuario)
                                          ->where('id_curso', '=', $codigo_curso)
                                          ->first();

       if ($consulta_inscripcion)  
       {
            $usuario =  auth()->user()->cedula;
            $email_e =  auth()->user()->email;
            //echo $usuario;
            $codigo_curso = $curso->id;
            /*echo "Código del Curso: ";
            echo $codigo_curso;
            echo '<br>'; */
            
            //consulta el código del módulo mayor del curso
            $bandera = Modulo::select('id')->where('id_curso', $codigo_curso)->max('id');
            /*echo "modulo mayor: ";
            echo $bandera;
            echo '<br>';
            echo "usuario: ";
            echo $usuario;*/

            //consulta si el estudiante ya presento un examen
            $notas = Nota::select('id_curso', 'id_modulo', 'cedula_estudiante')
                           ->where('id_curso' , $codigo_curso)
                           ->where('id_modulo', '<=', $bandera)
                           ->where('cedula_estudiante' ,$usuario)
                           ->first();
                          
            /* dd($notas);  */ 
            if($notas){
                
                $codigo_curso = $curso->id;
                //consulta el módulo actual del cuál el estudiante ha presentado el examen
                $nota = Nota::select('id_modulo')->where('id_curso','=',  $codigo_curso)->where('cedula_estudiante','=', $usuario)->max('id_modulo');
                
                //dd($nota);
               echo '<br>';
                /*echo "módulo actual: ";
                echo $nota;
                echo '<br>';*/
                $var= Modulo::where('id_curso', $codigo_curso)->max('id');
                //echo "Último módulo: ";
                // echo $var; 

                if ($var > $nota) {
                    //se muestra el siguiente módulo y examen
                    $nota = $nota + 1;
                    /* echo '<br>';
                    echo "bandera: ";
                    echo $nota; */
                    $modulos = Modulo::where('id_curso', $codigo_curso)
                                      ->where ('id', $nota)
                                    ->get();
                                    /* echo '<br>';
                                    echo "Módulo actual: ";  
                                    echo $nota;  */
                }
                elseif($var = $nota){ 
                    
                    $modulos = Modulo::where('id_curso', $codigo_curso)
                                      ->get();
                                      
                    echo "<div class='alert alert-success'>
                          <strong>";
                    echo "<h1>";         
                    echo "HA CONCLUIDO CON EL CURSO, PUEDE DESCARGAR EL CERTIFICADO CORRESPONDIENTE.";
                    echo "</h1>";
                    echo"</strong>
                          </div>";                  
                    
                    $consulta_certificado = Certificado::where('id_curso', $codigo_curso)
                                                        ->where('cedula_estudiante', $usuario)
                                                        ->first();
                    if($consulta_certificado){
                         ////No guarda por más de una vez la validación
                    }
                    else{
                         //insertar en la tabla certificados el ok de aprobación
                    $aprobo = 'aprobo';
                    $usuario =  auth()->user()->cedula;
                    $email_e =  auth()->user()->email;
                    $now = Carbon::now();
                    $currentDate = $now->format('Y-m-d');
                    $certificado = new Certificado();  
                    Certificado::create([ 
                        
                       'validacion'=>$certificado->validacion = $aprobo,
                       'cedula_estudiante' =>$certificado->cedula_estudiante =$usuario,
                       'email_estudiante' =>$certificado->email_estudiante =$email_e,
                       'id_curso' => $certificado->id_curso = $codigo_curso,
                       'fecha_aprobacion' => $certificado->fecha_aprobacion = $currentDate,
                  
                   ]); 
                }
                } 
               
            }  
            else{

                $codigo_curso = $curso->id;
                /* return $codigo_curso; */
                //consulta el primer módulo de cada curso
                $modulos = Modulo::where('id_curso', $codigo_curso)
                                    ->OrderBy('id', 'asc')
                                    ->latest('id')
                                    ->limit(1)
                                    ->get();

                                    //Consulta los cursos disponibles
                $cursos = Curso::OrderBy('id', 'desc')->get();

                 /* dd($modulos);    */                 
                /* return view('cursoss.show', compact('curso','modulo','modulos','cursos')); */

            }            
            
            //Consulta quienes están inscritos en cada curso
            $users = User::join('matriculas','cedula', '=', 'matriculas.cedula_estudiante')
                           ->where('id_curso', $codigo_curso)
                           ->select('users.id','users.name')
                           ->get();
            
            //Consulta el nombre del creador del curso
            $docentes = User::join('cursos','cedula', '=', 'cursos.responsable')
                             ->select('users.id','users.name')
                             ->where('cursos.id', $codigo_curso)
                             ->get();
             
                             
            //Consulta las pruebas que se han creado para cada uno de los módulos
            $pruebas = Prueba::where('id_curso', $codigo_curso)
                               ->where('id_modulo', $iden_modulo)
                               ->get();
                               
             //Tiempo limite para desarrollar el curso
            $fecha_matricula= Matricula::select('created_at')
                                     ->where('id_curso', '=', $codigo_curso)
                                     ->where('cedula_estudiante', '=', $usuario)
                                     ->max('created_at');                  

       
            return view('cursos.show', compact('curso','modulos', 'users', 'docentes', 'pruebas', 'fecha_matricula'));
                   
                       
       }
       else 
       {
           return redirect()->route('lista_cursos.index')->withFlashMessage('Debe inscribirse primero');
       }
    }
    if($consulta_perfil_UAM){
            $modulos = Modulo::where('id_curso', $codigo_curso)
                             ->get();
            //Consulta los cursos disponibles
            $cursos = Curso::OrderBy('id', 'desc')->get();

            //Consulta quienes están inscritos en cada curso
            $users = User::join('matriculas','cedula', '=', 'matriculas.cedula_estudiante')
                        ->where('id_curso', $codigo_curso)
                        ->select('users.id','users.name')
                        ->get();

            //Consulta el nombre del creador del curso
            $docentes = User::join('cursos','cedula', '=', 'cursos.responsable')
                            ->select('users.id','users.name')
                            ->where('cursos.id', $codigo_curso)
                            ->get();

            
            //Consulta las pruebas que se han creado para cada uno de los módulos
            $pruebas = Prueba::where('id_curso', $codigo_curso)
               
                ->get();
                
             //Tiempo limite para desarrollar el curso
            $fecha_matricula= Matricula::select('created_at')
                                     ->where('id_curso', '=', $codigo_curso)
                                     ->where('cedula_docente', '=', $usuario)
                                     ->max('created_at');
                                     
            return view('cursos.show', compact('modulo','modulos', 'curso', 'users', 'docentes', 'pruebas', 'fecha_matricula' )); 
        }
    }

    public function edit(Curso $curso){
        //regla de autorización
        $this->authorize('responsable', $curso);
        
        return view('cursos.edit', compact('curso'));

    }

    public function update(Curso $curso, Request $request){
        //regla de autorización
        $this->authorize('responsable', $curso);
        
        if($request->hasFile('archivo')){

            $ruta = $request->file('archivo')->store('public/archivos');
            $url = Storage::url($ruta);
                
            $curso->titulo_curso = $request->titulo_curso;
            $curso->slug = $request['slug'] = Str::slug($request->titulo_curso);
            $curso->enlace_video = $request->enlace_video;
            $curso->descripcion = $request->descripcion;
            $curso->categoria = $request->categoria;
            $curso->fecha_inicio = $request->fecha_inicio;
            $curso->dias = $request->dias;
            $curso->ih = $request->ih;
            $curso->fecha_cierre = $request->fecha_cierre;
            $curso->archivo = $url;
               
                
            }
        
            $curso->titulo_curso = $request->titulo_curso;
            $curso->slug = $request['slug'] = Str::slug($request->titulo_curso);
            $curso->enlace_video = $request->enlace_video;
            $curso->descripcion = $request->descripcion;
            $curso->categoria = $request->categoria;
            $curso->fecha_inicio = $request->fecha_inicio;
            $curso->dias = $request->dias;
            $curso->ih = $request->ih;
            $curso->fecha_cierre = $request->fecha_cierre; 
               
            $curso->save();
               
    
            return redirect()->route('cursos.index');

    }

    public function destroy(Curso $curso){
        //regla de autorización
        $this->authorize('responsable', $curso);
        
        $curso->delete();

        return redirect()->route('cursos.index');

    }
} 