<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\Team;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Laravel\Fortify\Contracts\CreatesNewUsers;
use Laravel\Jetstream\Jetstream;
use Spatie\Permission\Models\Role;
use App\Actions\Fortify\PasswordValidationRules;
use Laravel\Fortify\Contracts\ResetsUserPasswords;

class DocenteController extends Controller 
{
    //protegemos las rutas, para evitar daños de terceros
    public function __construct()
    {
        $this->middleware('can:docentes.index')->only('index');
        $this->middleware('can:docentes.create')->only('create', 'store');
        $this->middleware('can:docentes.edit')->only('edit', 'update');
        $this->middleware('can:docentes.destroy')->only('destroy');
    }

    use PasswordValidationRules;
    //creamos los metodos que se requieren, para crear, mostrar, editar, eliminar
    public function index(Request $request){
        $buscador=$request->get('buscador');
        $cedula=$request->get('n_cedula');
        $estado=('Activo(a)');
        $perfil=('Docente');

        if($buscador){
            $docentes = User::where('lugar_trabajo', 'LIKE','%'. $buscador .'%')
                            ->where('Perfil', $perfil)
                            ->orderBy('id','desc')
                            ->paginate();
        }
        
        
        else{
            $docentes = User::where('cedula', '=', $cedula)
                            ->where('Perfil', $perfil)
                            ->orderBy('id','desc')
                            ->paginate();
        }

    
          return view('docentes.index', compact('docentes'));
    }
 
    public function create(Request $request, Role $role){
        $roles = Role::select('id', 'name')->get();
        return view('docentes.create', compact('roles')); 
    }  

    public function store(Request $request){  

        

       
            $user = new User();      
            tap(User::create([
                'name'=>$user->name = $request->name,
                'cedula'=>$user->cedula = $request->cedula,
                'tipo_documento'=>$user->tipo_documento = $request->tipo_documento,
                'lugar_trabajo'=>$user->lugar_trabajo = $request->lugar_trabajo,
                'telefono'=>$user->telefono = $request->telefono,
                'perfil'=>$user->perfil = $request->perfil,
                'estado'=>$user->estado = $request->estado,
                'email'=>$user->email = $request->email,
                'password' => Hash::make($request['password']),
                'terms' => Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['required', 'accepted'] : '',
                
                
            ]), function (User $user) {
                $this->createTeam($user);
                $user->assignRole('Docente');
            }); 
     
       
        return redirect()->route('docentes.index')->withFlashMessage('Docente ingresado');
   }

    public function show(User $docente){
        return view('docentes.show', compact('docente'));
}

    public function edit(User $docente){

        $roles = Role::all();
        return view('docentes.edit', compact('docente', 'roles'));
    } 
  
    public function update(Request $request, User $docente){

            if($request->password){
                $docente->name = $request->name;
                $docente->cedula = $request->cedula;
                $docente->tipo_documento = $request->tipo_documento;
                $docente->lugar_trabajo = $request->lugar_trabajo;
                $docente->telefono = $request->telefono;
                $docente->perfil = $request->perfil;
                $docente->email = $request->email;
                $docente->estado = $request->estado;
                $docente->password = Hash::make($request['password']);
                Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['required', 'accepted'] : '';
            }
            else{
                $docente->name = $request->name;
                $docente->cedula = $request->cedula;
                $docente->tipo_documento = $request->tipo_documento;
                $docente->lugar_trabajo = $request->lugar_trabajo;
                $docente->telefono = $request->telefono;
                $docente->perfil = $request->perfil;
                $docente->email = $request->email;
                $docente->estado = $request->estado;
                Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['required', 'accepted'] : '';
                }
     
            
            
        $docente->save();
          
        return redirect()->route('docentes.show', $docente);
        
    }
    public function reset($user, array $input)
    {
        Validator::make($input, [
            'password' => $this->passwordRules(),
        ])->validate();

        $user->forceFill([
            'password' => Hash::make($input['password']),
        ])->save();
    }
    

    public function destroy(User $docente){
        $docente->delete();

        return redirect()->route('docentes.index');
    }


    /**
     * Create a personal team for the user.
     *
     * @param  \App\Models\User  $user
     * @return void
     */
    protected function createTeam(User $user)
    {
        $user->ownedTeams()->save(Team::forceCreate([
            'user_id' => $user->id,
            'name' => explode(' ', $user->name, 2)[0]."'s Team",
            'personal_team' => true,
            
        ]));
    }
}
