<?php

namespace App\Http\Controllers;

use App\Models\Curso;
use Illuminate\Http\Request; 
Use App\Models\Matricula;
Use App\models\User;
use Carbon\Carbon; 

class Editar_matricula_Controller extends Controller
{
    //
    public function index(Request $request, Matricula $matricula){
        
        $cedula=$request->get('n_cedula'); 
        $estado=('Activo(a)');
        $perfil=('Estudiante'); 
 

            $estudiantes = User::where('cedula','=', $cedula)
                            ->where('perfil', 'LIKE','%'. $perfil .'%')
                            ->first();

                            

        
            $matriculas = Matricula::
                                    where('cedula_estudiante', '=', $cedula )
                                
                                    ->orderBy('id','desc')
                                    ->paginate();

            $editar_matriculas = Matricula::join('cursos', 'matriculas.id_curso', '=', 'cursos.id')
                                            ->where('cedula_estudiante', '=', $cedula )
                                        
                                            ->orderBy('matriculas.id','desc')
                                            ->paginate();           


                                   
            
            $now = Carbon::now();
            $currentDate = $now->format(format: 'Y-m-d');
            $cursos = Curso::where('cursos.fecha_inicio', '<', $currentDate)
                            ->where('cursos.fecha_cierre', '>', $currentDate)
                            ->OrderBy('id', 'desc')->paginate();

                       
        
      

         return view('editar_matriculas.index', compact('estudiantes', 'editar_matriculas', 'matriculas'));

    } 

    public function show(Matricula $editar_matricula){
        return view('editar_matriculas.show', compact('editar_matricula'));
    }

    public function edit(Request $request, Matricula $matricula){
        return view('editar_matriculas.index', $matricula);
    }

    public function update(Request $request, Matricula $matricula){

        
            $matricula->id_curso = $request->id;

        $matricula->save();
          
        return redirect()->route('editar_matriculas.index');

    }

    public function destroy(Request $request, Matricula $editar_matricula){
        
       
        $editar_matricula->delete();

        return redirect()->route('editar_matriculas.index');

    }
    
}
  