<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Curso;
use Laravel\Jetstream\Jetstream;
use Spatie\Permission\Models\Role;
use App\Actions\Fortify\PasswordValidationRules;
use Illuminate\Support\Facades\Hash;
use App\Models\Team;
use Illuminate\Support\Facades\DB;

class EstudianteController extends Controller
{
    //protegemos las rutas, para evitar daños de terceros
    public function __construct()
    {
        $this->middleware('can:estudiantes.index')->only('index');
        /* $this->middleware('can:estudiantes.create')->only('create'); */
        $this->middleware('can:estudiantes.edit')->only('edit', 'update');
        $this->middleware('can:estudiantes.destroy')->only('destroy');
    }
    
    use PasswordValidationRules;
    //creamos los metodos que se requieren, para crear, mostrar, editar, eliminar
    public function index(Request $request){
        $buscador=$request->get('buscador');
        $categoria=$request->get('categoria');
        $cedula=$request->get('n_cedula');
        $estado=('Activo(a)');
        $perfil=('Estudiante');

        if($buscador){
            $estudiantes = User::where('lugar_trabajo', 'LIKE','%'. $buscador .'%')
                           ->where('perfil', 'LIKE','%'. $perfil .'%')
                           ->orderBy('id','desc')
                           ->paginate();
        }
       /*  elseif($categoria){
            $estudiantes1 = User::where('perfil', '=', $categoria)
                           ->orderBy('id','desc')
                           ->paginate();
        } */
        else{
            $estudiantes = User::where('cedula', '=', $cedula)
                                ->where('perfil', 'LIKE','%'. $perfil .'%')
                                ->orderBy('id','desc')
                                ->paginate();
        }
 

        
          
          return view('estudiantes.index', compact('estudiantes'));
    }
    
    public function show(User $estudiante){
        $usuario =  auth()->user()->cedula; 
        
        return view('estudiantes.show', compact('estudiante'));
}

   public function create(){
       return view('estudiantes.create');
   } 

   public function store(Request $request){
    $user = new User();      
    tap(User::create([
        'name'=>$user->name = $request->name,
        'cedula'=>$user->cedula = $request->cedula,
        'tipo_documento'=>$user->tipo_documento = $request->tipo_documento,
        'lugar_trabajo'=>$user->lugar_trabajo = $request->lugar_trabajo,
        'telefono'=>$user->telefono = $request->telefono,
        'perfil'=>$user->perfil = $request->perfil,
        'estado'=>$user->estado = $request->estado,
        'email'=>$user->email = $request->email,
        'password' => Hash::make($request['password']),
        'terms' => Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['required', 'accepted'] : '',
        
         
    ]), function (User $user) {
        $this->createTeam($user);
        $user->assignRole('Estudiante_privado');
    });
  

    return redirect()->route('matricula_cursos_privados.index')->withFlashMessage('Estudiante ingresado');

   }

    public function edit(User $estudiante){
        return view('estudiantes.edit', compact('estudiante'));
    } 

    public function update(Request $request, User $estudiante){

            if($request->password){
                $estudiante->name = $request->name;
                $estudiante->cedula = $request->cedula; 
                $estudiante->tipo_documento = $request->tipo_documento;
                $estudiante->lugar_trabajo = $request->lugar_trabajo;
                $estudiante->telefono = $request->telefono;
                $estudiante->perfil = $request->perfil;
                $estudiante->email = $request->email;
                $estudiante->estado = $request->estado;
                $estudiante->password = Hash::make($request['password']);
                Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['required', 'accepted'] : '';
            }
            else{
                $estudiante->name = $request->name;
                $estudiante->cedula = $request->cedula; 
                $estudiante->tipo_documento = $request->tipo_documento;
                $estudiante->lugar_trabajo = $request->lugar_trabajo;
                $estudiante->telefono = $request->telefono;
                $estudiante->perfil = $request->perfil;
                $estudiante->email = $request->email;
                $estudiante->estado = $request->estado;
                Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['required', 'accepted'] : '';
            }

        $estudiante->save();
          
        return redirect()->route('estudiantes.show', $estudiante);
        
    }

    public function destroy(User $estudiante){
        $estudiante->delete();

        return redirect()->route('estudiantes.index');
    }


    

    /**
     * Create a personal team for the user.
     *
     * @param  \App\Models\User  $user
     * @return void
     */
    protected function createTeam(User $user)
    {
        $user->ownedTeams()->save(Team::forceCreate([
            'user_id' => $user->id,
            'name' => explode(' ', $user->name, 2)[0]."'s Team",
            'personal_team' => true,
            
        ]));
    }
}

 