<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Firma;
use Illuminate\Support\Facades\Storage; 

class FirmaController extends Controller
{
    //
    public function index(){
        $firmas = Firma::OrderBy('id', 'desc')->paginate();

        return view('firmas.index', compact('firmas'));
    }

    public function create(){
        return view('firmas.create'); 
    }

    public function store(Request $request, Firma $firma){
        if ($request->archivo)
        {
            $titular_firma = $request->titular_firma; 
            $archivo = $request->archivo; 
                
                $ruta = $request->archivo->store('public/archivos');
                $url = Storage::url($ruta);
                    
                        $firma = new Firma();
                        Firma::create([  
                            
                        'titular_firma'=>$firma->titular_firma = $request->titular_firma,
                        'archivo'=>$firma->archivo = $url,

                    ]); 
        
        
            return redirect()->route('firmas.index'); 
        }else
            {
                return redirect()->route('firmas.create', compact('firmas')); 
            }
    }

    public function show(){

     
    }

    public function edit(Firma $firma){ 
        return view('firmas.edit', compact('firma'));
    }

    public function update(Firma $firma, Request $request){
        if($request->hasFile('archivo')){

            $ruta = $request->file('archivo')->store('public/archivos');
            $url = Storage::url($ruta);
                
                $firma->titular_firma = $request->titular_firma;    
                $firma->archivo = $url;
                
                
            }
                $firma->titular_firma = $request->titular_firma;
               
            $firma->save();
              
    
            return redirect()->route('firmas.index');

    }

    public function destroy(Firma $firma){
        $firma->delete();

        return redirect()->route('firmas.index');

    }

}
