<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Curso;
use App\Models\Certificado;
use Carbon\Carbon;

class HomeController extends Controller
{
    //
    public function __invoke(Request $request, Curso $curso)
    {
        //validamos la fecha de cierre del curso, para saber si se muestra o no.
        $now = Carbon::now();
        $currentDate = $now->format('Y-m-d');
        $categoria = 'Publico';
        $cursos = Curso::where('fecha_inicio', '<', $currentDate)
                        ->where('fecha_cierre', '>', $currentDate)
                        ->where ('categoria', $categoria)
                        ->OrderBy('id', 'desc')
                        ->paginate();

        $codigos =  Curso::select('id')
                        ->where('fecha_cierre', '>', $currentDate)
                        ->where ('categoria', $categoria)
                        ->Groupby('id')
                        ->pluck('id');         
                             
       
                   
       return view('home', compact('cursos'));
    }
    
   
    
} 
 