<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use App\Http\Controllers\ModuloController;
use Illuminate\Support\Facades\Storage;  
use App\Models\Certificado;
use App\Models\Curso;
use App\Models\User;


class Lista_numero_certificacioneController extends Controller
{
    // 
    public function index(){  
        //$usuario =  auth()->user()->cedula;

        $usuario = 'Estudiante';
      
        //Consulta los usuarios certificados
        $listas = User::select('cedula', 'lugar_trabajo', 'users.name')

                        ->orderBy('users.cedula','desc')
                        
                        ->distinct('users.cedula')
                        
                        ->where('users.perfil', '=', $usuario)
                        
                        ->paginate(700);
                                    

                                                        
        
         $resultado_contador = count($listas);
         
         
         $lista_2s = User::join('certificados', 'users.cedula', 'certificados.cedula_estudiante')
                        ->select('users.cedula', 'users.lugar_trabajo', 'users.email', 'users.telefono', 'users.ultimo_ingreso', 'users.name','users.created_at')

                        ->orderBy('users.cedula','desc')
                        
                        ->distinct('users.cedula')
                        
                        ->where('users.perfil', '=', $usuario)
                        
                        ->paginate(700);
                                    

                                                        
        
         $resultado_contador2 = count($lista_2s);
         
         $lista_usuarios = User::select('cedula')
                                 ->where('perfil', '=', $usuario)
                                 ->DISTINCT()
                                 ->orderBy('cedula','desc')
                                 ->pluck('cedula');                                             
                                                         
            
        $array_usuarios = $lista_usuarios;
        
        //dd($array_usuarios);
        
        $num = count($array_usuarios);
        
        for($a=0; $a < $num; $a ++){
            $usuario_id = $array_usuarios[$a];
             
                //total # de certificaciones
                $certificado = Certificado::join('users', 'certificados.cedula_estudiante', '=', 'users.cedula')
                                             ->select('certificados.cedula_estudiante')
                                             ->where('certificados.cedula_estudiante', 'LIKE', $usuario_id)
                                             ->orderBy('certificados.cedula', 'Desc')
                                             ->DISTINCT()
                                            
                                             ->count();
                                                             
                $numero_certificados[] = $certificado;
                
                //nombre_curso 1 BÚSQUEDAS ACTIVAS INSTITUCIONALES (BAI)
                $nombre_1_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id') 
                                            ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('certificados.cedula_estudiante', 'LIKE', $usuario_id)
                                            ->where('certificados.email_estudiante', '=', 'users.email')
                                            ->where('cursos.id', '=', 16)
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
                $nombre_1_cursos[] = $nombre_1_curso;
                
                //nombre_curso 2 PROMOCIÓN ESTILOS DE VIDA SALUDABLES
                $nombre_2_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                            ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('certificados.cedula_estudiante', 'LIKE', $usuario_id)
                                            ->where('certificados.email_estudiante', '=', 'users.email')
                                            ->where('cursos.id', '=', 18)
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
                $nombre_2_cursos[] = $nombre_2_curso;
                
                
                //nombre_curso 3 INFORMES PROGRAMA MUNICIPAL DE TUBERCULOSIS
                $nombre_3_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                            ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('certificados.cedula_estudiante', 'LIKE', $usuario_id)
                                            ->where('certificados.email_estudiante', '=', 'users.email')
                                            ->where('cursos.id', '=', 19)
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
                $nombre_3_cursos[] = $nombre_3_curso;
                
                //nombre_curso 4 SALUD BUCAL GESTANTES, PRIMERA INFANCIA E INFANCIA...
                $nombre_4_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                            ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('certificados.cedula_estudiante', 'LIKE', $usuario_id)
                                            ->where('certificados.email_estudiante', '=', 'users.email')
                                            ->where('cursos.id', '=', 20)
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
                $nombre_4_cursos[] = $nombre_4_curso;
                
                
                //nombre_curso 5 SALUD BUCAL GESTANTES, PRIMERA INFANCIA E INFANCIA...
                $nombre_5_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                            ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('certificados.cedula_estudiante', 'LIKE', $usuario_id)
                                            ->where('certificados.email_estudiante', '=', 'users.email')
                                            ->where('cursos.id', '=', 21)
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
                $nombre_5_cursos[] = $nombre_5_curso;
                
                
                //nombre_curso 6 MANEJO INTEGRAL DE LAS INFECCIONES ASOCIADAS A LA ATENCIÓN EN SALUD ( IAAS), INFECCIONES ASOCIADAS A DISPOSITIVOS....
                $nombre_6_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                            ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('certificados.cedula_estudiante', 'LIKE', $usuario_id)
                                            ->where('certificados.email_estudiante', '=', 'users.email')
                                            ->where('cursos.id', '=', 22)
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
                $nombre_6_cursos[] = $nombre_6_curso;
                //dd($numero_certificados);
                //return $certificado;
        }
        
        //total de certificados  
        $certificados_total = Certificado::select('cedula_estudiante')
                                                     
                                                     ->Orderby('cedula_estudiante', 'Desc')
                                                     
                                                     ->distinct()
                                                     ->count();
                                                     
        $total_certificados[] = $certificados_total;
        
        $sum_certificados = 0;
          
        foreach ($total_certificados as $total_certificado => $object_certificado) {
              
            $sum_certificados += $object_certificado;
           
          }
          $total = $sum_certificados;
          
          //total certificaciones nombre_curso 1 BÚSQUEDAS ACTIVAS INSTITUCIONALES (BAI)
          $t_1_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                    ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('cursos.id', '=', 16)
                                            ->distinct()
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
        $t_1_cursos[] = $t_1_curso;
                                            
        $sum_t1 = 0;
          
        foreach ($t_1_cursos as $t_1_curso => $object_t1) {
              
            $sum_t1 += $object_t1;
           
          }
          $total_c1 = $sum_t1;
          
          
          //total certificaciones nombre_curso 2 PROMOCIÓN ESTILOS DE VIDA SALUDABLES
          $t_2_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                   ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('cursos.id', '=', 18)
                                            ->distinct()
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
        $t_2_cursos[] = $t_2_curso;
                                            
        $sum_t2 = 0;
          
        foreach ($t_2_cursos as $t_2_curso => $object_t2) {
              
            $sum_t2 += $object_t2;
           
          }
          $total_c2 = $sum_t2;
          
          
          //total certificaciones nombre_curso 3 INFORMES PROGRAMA MUNICIPAL DE TUBERCULOSIS
          $t_3_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                    ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('cursos.id', '=', 19)
                                            ->distinct()
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
        $t_3_cursos[] = $t_3_curso;
                                            
        $sum_t3 = 0;
          
        foreach ($t_3_cursos as $t_3_curso => $object_t3) {
              
            $sum_t3 += $object_t3;
           
          }
          $total_c3 = $sum_t3;
          
          
          //total certificaciones nombre_curso 4 SALUD BUCAL GESTANTES, PRIMERA INFANCIA E INFANCIA PARA EQUIPO DE SALUD
          $t_4_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                    ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('cursos.id', '=', 20)
                                            ->distinct()
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
        $t_4_cursos[] = $t_4_curso;
                                            
        $sum_t4 = 0;
          
        foreach ($t_4_cursos as $t_4_curso => $object_t4) {
              
            $sum_t4 += $object_t4;
           
          }
          $total_c4 = $sum_t4;
          
          
          //total certificaciones nombre_curso 5 PROCESOS BASICOS PARA EL USO DEL APLICATIVO SISTEMA DE VIGILANCIA EPIDEMIOLÓGICA - SIVIGILA
          $t_5_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                    ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('cursos.id', '=', 21)
                                            ->distinct()
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
        $t_5_cursos[] = $t_5_curso;
                                            
        $sum_t5 = 0;
          
        foreach ($t_5_cursos as $t_5_curso => $object_t5) {
              
            $sum_t5 += $object_t5;
           
          }
          $total_c5 = $sum_t5;
          
          
          //total certificaciones nombre_curso 6 MANEJO INTEGRAL DE LAS INFECCIONES ASOCIADAS A LA ATENCIÓN EN SALUD ( IAAS), INFECCIONES ASOCIADAS A DISPOSITIVOS.
          $t_6_curso = Certificado::join('cursos', 'certificados.id_curso', '=', 'cursos.id')
                                            ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                            ->select('cursos.titulo_curso')
                                            ->where('cursos.id', '=', 22)
                                            ->distinct()
                                            ->orderBy('certificados.cedula_estudiante', 'Desc')
                                            ->count();
                                            
                                            
        $t_6_cursos[] = $t_6_curso;
                                            
        $sum_t6 = 0;
          
        foreach ($t_6_cursos as $t_6_curso => $object_t6) {
              
            $sum_t6 += $object_t6;
           
          }
          $total_c6 = $sum_t6;
          
        

        //dd($sum_certificados);
        return view('lista_numero_certificaciones.index', compact('listas',  'resultado_contador', 'numero_certificados', 'total', 'nombre_1_cursos',
                                                                  'nombre_2_cursos', 'nombre_3_cursos', 'nombre_4_cursos', 'nombre_5_cursos', 'nombre_6_cursos',
                                                                  'total_c1', 'total_c2', 'total_c3', 'total_c4', 'total_c5', 'total_c6', 'resultado_contador2'));
    }
}
