<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Manual;
use Illuminate\Support\Facades\Storage; 

class ManualController extends Controller
{
    //
    public function index(){
        $perfil1 = 'Admin'; 
        $perfil2 = 'Docente';
        $perfil3 = 'Estudiante';
        $perfil4 = 'Estudiante_privado';

        $manual1s = Manual::where('perfil', $perfil1)->paginate();

        $manual2s = Manual::where('perfil', $perfil2)->paginate();

        $manual3s = Manual::where('perfil', $perfil3)->paginate();

        $manual4s = Manual::where('perfil', $perfil4)->paginate();

        return view('manuals.index', compact('manual1s', 'manual2s', 'manual3s', 'manual4s'));
    }

    public function create(Request $request){

        return view('manuals.create');

    } 

    public function store(Request $request, Manual $manual){
        if ($request->archivo)
        {
            $num = $request->archivo; 
            
            for ($i = 0; $i < count($num); $i++) 
            {
            
                
                $num[$i]; 
                $valor2 = $request->perfil[$i];
                
                $ruta = $num[$i]->store('public/archivos');
                $url = Storage::url($ruta);
                    
                        $manual = new Manual();
                        Manual::create([  
                            
                        'perfil'=>$manual->titulo_modulo = $valor2,
                        'archivo'=>$manual->archivo = $url,

                    ]); 
        
        }
            return redirect()->route('manuals.index'); 
        }else
            {
                return redirect()->route('manuals.create', compact('manuals')); 
            }
     
         
    } 
 
    public function show(){ 

    } 

    public function edit(Manual $manual, Request $request){
        $codigo = $request->id;
        $manuals = Manual::where('id', $codigo)->first();
        return view('manuals.edit', compact('manuals'));

    }

    public function update(Request $request, Manual $manual){
        if($request->hasFile('archivo')){

            $ruta = $request->file('archivo')->store('public/archivos');
            $url = Storage::url($ruta);
                    
                $manual->archivo = $url;
                
            }
                $manual->perfil = $request->perfil;
               
            $manual->save();
              
    
            return redirect()->route('manuals.index');
            
            
        }

    public function destroy(Manual $manual, Request $request){
        $codigo = $request->id;
        $manual->delete();

        return redirect()->route('manuals.index');
    }
}
 