<?php

namespace App\Http\Controllers;

use App\Models\Curso;
use Illuminate\Http\Request;
Use App\Models\Matricula;
use App\Models\User;
use App\Http\Controllers\DB;
use Carbon\Carbon; 

class MatriculaController extends Controller
{

    public function index(Request $request, Matricula $matricula){
        
        $cedula=$request->get('n_cedula'); 
        $estado=('Activo(a)');
        $perfil=('Estudiante'); 
 

            $estudiantes = User::where('cedula','=', $cedula)
                            ->where('perfil', 'LIKE','%'. $perfil .'%')
                            ->first();

                            

        
            $matriculas = Matricula::
                                    where('cedula_estudiante', '=', $cedula )
                                
                                    ->orderBy('id','desc')
                                    ->paginate();

            $matriculas = Matricula::select('matriculas.id', 'cursos.titulo_curso')->join('cursos', 'matriculas.id_curso', '=', 'cursos.id')
                                            ->where('cedula_estudiante', '=', $cedula )
                                        
                                            ->orderBy('matriculas.id','desc')
                                            ->paginate();           


                                   
            
            $now = Carbon::now();
            $currentDate = $now->format('Y-m-d');
            $cursos = Curso::where('cursos.fecha_inicio', '<', $currentDate)
                            ->where('cursos.fecha_cierre', '>', $currentDate)
                            ->OrderBy('id', 'desc')->paginate();

                       
        
      

         return view('matriculas.index', compact('estudiantes', 'matriculas'));

    } 

    public function create(){  
        return view('cursos.create');
 
    }   

    public function store(Request $request, Curso $curso, Matricula $matricula, User $user){ 
        
        $usuario = $request->cedula_estudiante;
        $codigo_curso = $matricula->id_curso = $request->id_curso;
        
       //Valida si los registros a los cursos
       $consulta = Matricula::select('cedula_estudiante', 'id_curso', 'email_estudiante')->where('cedula_estudiante', '=', $usuario)->where('id_curso', '=', $codigo_curso)->first();
      
       //Consulta el curso al cuál se ha registrado el usuario
       $nombre_curso = Curso::select('titulo_curso')->where('id', $codigo_curso)->first();
    

        if ($consulta) {
           
             return redirect()->route('cursos.index')->withFlashMessage('Ya está registrado(a) en el curso: '.$nombre_curso.'.');
            
		} else  { 
            
            $matricula = new Matricula();  
         
            Matricula::create([ 
               'id_curso'=>$matricula->id_curso = $request->id_curso,
               'cedula_estudiante'=>$matricula->cedula_estudiante = $request->cedula_estudiante,
               'email_estudiante'=>$matricula->email_estudiante = $request->email_estudiante,
               'cedula_docente'=>$matricula->cedula_docente = $request->cedula_docente,

               
               
           ]); 
           //
            $now = Carbon::now();
            $currentDate = $now->format('Y-m-d');

            
            $dias= Curso::select('dias')
                                        ->where('id', '=', $codigo_curso)
                                        ->max('dias');

                                        
            $fecha_matricula= Matricula::select('created_at')
                                        ->where('id_curso', '=', $codigo_curso)
                                        ->max('created_at');                             

        
             $limit = date('Y-m-d', strtotime($fecha_matricula. ' + '. $dias. ' days'));

           return redirect()->route('cursos.index')->withFlashMessage('Se ha registrado con éxito en el curso: "'.$nombre_curso.'"' .' .Tiene hasta el  '.$limit.','.' para estudiar cada uno de los módulos, presentar sus respectivos exámenes y poder certificarse.');
       
		}
         

    }
    public function show(Matricula $matricula){
        return view('matriculas.show', compact('matricula'));

    }
 
    

    public function edit(Matricula $matricula){

        $now = Carbon::now();
        $currentDate = $now->format('Y-m-d');

        $cursos = Curso::where('cursos.fecha_inicio', '<', $currentDate)
                        ->where('cursos.fecha_cierre', '>', $currentDate)
                        ->OrderBy('id', 'desc')->paginate();
                        
        return view('matriculas.edit', compact('matricula', 'cursos'));
    }

    public function update(Request $request, Matricula $matricula){

        
        $matricula->id_curso = $request->id_curso;

        $matricula->save();
          
        return redirect()->route('matriculas.index');

    }

    public function destroy(Matricula $matricula){
        
       
        $matricula->delete();

        return redirect()->route('matriculas.index');

    }
    
}