<?php

namespace App\Http\Controllers;

use App\Models\Curso;
use Illuminate\Http\Request;
Use App\Models\Matricula;
use App\Models\User;
use Carbon\Carbon; 

class Matricula_cursos_privadosController extends Controller
{
    //
    public function index(Request $request){
        $buscador=$request->get('buscador');
        $categoria=$request->get('categoria');
        $cedula=$request->get('n_cedula'); 
        $estado=('Activo(a)');
        $perfil=('Estudiante');

        if($buscador){
            $estudiantes = User::where('lugar_trabajo', 'LIKE','%'. $buscador .'%')
                           ->where('perfil', 'LIKE','%'. $perfil .'%')
                           ->orderBy('id','desc')
                           ->paginate(150);
        }
       /*  elseif($categoria){
            $estudiantes1 = User::where('perfil', '=', $categoria)
                           ->orderBy('id','desc')
                           ->paginate();
        } */
        else{ 
            $estudiantes = User::where('perfil', 'LIKE','%'. $perfil .'%')
                                ->orderBy('id','desc')
                                ->paginate(150);
        }

         return view('matricula_cursos_privados.index', compact('estudiantes'));
    } 

    public function show(User $matricula_cursos_privado, Curso $curso){
        $categoria_curso = 'Privado';
        $now = Carbon::now();
        $currentDate = $now->format('Y-m-d');

        $cursos = Curso::where('categoria', $categoria_curso)
                        ->where('cursos.fecha_inicio', '<', $currentDate)
                        ->where('cursos.fecha_cierre', '>', $currentDate)
                        ->OrderBy('id', 'desc')->paginate();
        
        return view('matricula_cursos_privados.show', compact('matricula_cursos_privado', 'cursos'));
    }

    public function create(){ 
         return view('matricula_cursos_privados.create');
    } 

    public function store(Request $request, Curso $curso, Matricula $matricula, User $user){

        $usuario = $request->cedula_estudiante;
        $codigo_curso = $request->id_curso = $request->id_curso;
        
       //Valida si los registros a los cursos
       $consulta = Matricula::select('cedula_estudiante', 'id_curso')
                              ->where('cedula_estudiante', '=', $usuario)
                              ->where('id_curso', '=', $codigo_curso)
                              ->first();
      
       //Consulta el curso al cuál se ha registrado el usuario
       $nombre_curso = Curso::select('titulo_curso')->where('id', $codigo_curso)->first();
    

        if ($consulta) {
           
             return redirect()->route('matricula_cursos_privados.index')->withFlashMessage('Ya está registrado(a) en el curso: '.$nombre_curso.'.');
            
		} else  {
            
            $matricula = new Matricula();  
         
            Matricula::create([ 
               'id_curso'=>$matricula->id_curso = $request->id_curso,
               'cedula_estudiante'=>$matricula->cedula_estudiante = $request->cedula_estudiante,
               'cedula_docente'=>$matricula->cedula_docente = $request->cedula_docente,

               
               
           ]); 
           return redirect()->route('cursos.index')->withFlashMessage('Se ha registrado con éxito en el curso '.$nombre_curso.'.');
       
		}
         

    }
    

    public function edit(){

    }

    public function update(){

    }

    public function destroy(Matricula $matricula){
        
       
        $matricula->delete();

        return redirect()->route('editar_matriculas.index');

    }


}
 