<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use App\Http\Controllers\CursoController;
use Illuminate\Support\Facades\Storage; 
use App\Models\Curso; 
use App\Models\Modulo;
use App\Models\User;
use Illuminate\http\UploadedFile;
use Illuminate\Support\Facades\File;

class ModuloController extends Controller
{
    //protegemos las rutas, para evitar daños de terceros
    public function __construct()
    {
        $this->middleware('can:modulos.index')->only('index');
        $this->middleware('can:modulos.create')->only('create', 'store');
        $this->middleware('can:modulos.edit')->only('edit', 'update');
        $this->middleware('can:modulos.destroy')->only('destroy');
    }

    public function index(){
        $var_adm = 'Admin'; 
        $usuario =  auth()->user()->cedula;
        $consulta_perfil2 = User::where('cedula', $usuario)->where('perfil', $var_adm)->first();

        if($consulta_perfil2){
            // se utiliza paginate para distribuir en páginas el contenido
            //$modulos = Modulo::OrderBy('id', 'Asc')->paginate();
            
            $modulos = Modulo::join('cursos', 'modulos.id_curso', '=', 'cursos.id')
                             ->select('modulos.slug', 'modulos.id', 'modulos.titulo_modulo' ,'cursos.titulo_curso')
                             ->Orderby('modulos.id', 'Asc')
                             ->paginate(100);
            

            $cursos = Curso::join('modulos', 'cursos.id', '=', 'modulos.id_curso')
                             ->select('cursos.titulo_curso', 'modulos.titulo_modulo')
                             ->Orderby('cursos.id', 'desc')
                             ->paginate(100);
        }
        else{
            // se utiliza paginate para distribuir en páginas el contenido
            $modulos = Modulo::where('responsable', $usuario)->OrderBy('id', 'Asc')->paginate();
        }
        
        
        return view('modulos.index', compact('modulos'));
 
    } 

    public function create(Request $request){

        $usuario =  auth()->user()->cedula;
        $cursos = Curso::where('responsable', $usuario)->get();
        return view('modulos.create', compact('cursos'));

    } 

    public function store(Request $request, Curso $curso, Modulo $modulos){
        if ($request->archivo)
        {
            $num = $request->archivo; 
            
            for ($i = 0; $i < count($num); $i++) 
            {
            
                
                $num[$i];
                $valor2 = $request->titulo_modulo[$i];
                $valor3 = $request->id_curso;
                $valor4 = $request->responsable;
                $valor5 = $request->enlace_video[$i];
                $valor6 = $request->descripcion[$i]; 

                
                $ruta = $num[$i]->store('public/archivos');
                $url = Storage::url($ruta);
                    
                        $modulo = new Modulo(); 
                        Modulo::create([  
                            
                        'titulo_modulo'=>$modulo->titulo_modulo = $valor2,
                        'slug'=>$modulo->slug = $request['slug'] = Str::slug($valor2),
                        'archivo'=>$modulo->archivo = $url,
                        'id_curso'=>$modulo->id_curso = $valor3,
                        'responsable'=>$curso->responsable = $valor4,
                        'enlace_video'=>$curso->enlace_video = $valor5,
                        'descripcion'=>$curso->descripcion = $valor6,

                    ]); 
        
        }
            return redirect()->route('cursos.index'); 
        }else
            {
                return redirect()->route('modulos.create', compact('modulos')); 
            }
     
        
    }
    
    //
    public function show(Modulo $modulo, Curso $curso, Request $request){
       
        $var_curso = $modulo->id_curso;
       
        $cursos = Curso::join('modulos', 'cursos.id', '=', 'modulos.id_curso')
                        ->where('cursos.id', $var_curso)
                        ->limit(1)
                        ->get();

        return view('modulos.show', compact('modulo', 'cursos'));
    }

    public function edit(Modulo $modulo){
        //regla de autorización
        $this->authorize('responsable', $modulo);
        
        return view('modulos.edit', compact('modulo'));
    }
 
    public function update(Request $request, Modulo $modulo){
        //regla de autorización
        $this->authorize('responsable', $modulo);

        if($request->hasFile('archivo')){

            $ruta = $request->file('archivo')->store('public/archivos');
            $url = Storage::url($ruta);
                    
                $modulo->archivo = $url;
                $modulo->titulo_modulo = $request->titulo_modulo;
                $modulo->slug = $request['slug'] = Str::slug($request->titulo_modulo);
                $modulo->enlace_video = $request->enlace_video;
                $modulo->enlace_video2 = $request->enlace_video2;
                $modulo->enlace_video3 = $request->enlace_video3;
                $modulo->enlace_video4 = $request->enlace_video4;
                $modulo->descripcion = $request->descripcion;
                
            }
                $modulo->titulo_modulo = $request->titulo_modulo;
                $modulo->slug = $request['slug'] = Str::slug($request->titulo_modulo);
                $modulo->enlace_video = $request->enlace_video;
                $modulo->enlace_video2 = $request->enlace_video2;
                $modulo->enlace_video3 = $request->enlace_video3;
                $modulo->enlace_video4 = $request->enlace_video4;
                $modulo->descripcion = $request->descripcion;
               
            $modulo->save();
              
    
            return redirect()->route('modulos.index');
            
            
        }


    public function destroy(Modulo $modulo){
        //regla de autorización
        $this->authorize('responsable', $modulo);
        $modulo->delete();

        return redirect()->route('cursos.index');

    }
}

