<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use Illuminate\Support\Facades\Storage; 
use App\Models\Curso; 
use App\Models\Modulo;
use App\Models\Prueba; 
use App\Models\Nota;
use App\Models\Punto;
use Mockery\Matcher\Not;

class NotaController extends Controller
{
    //
    public function index(Curso $curso, Modulo $modulo, Request $request){
    }

    public function create(){
        //se consultan los cursos y módulos creados por el usuario logueado
        $usuario =  auth()->user()->cedula;
        $cursos = Curso::where('responsable', $usuario)->get();
        $modulos = Modulo::where('responsable', $usuario)->get();
        return view('pruebas.create', compact('modulos', 'cursos'));

    }
    public function store(Request $request, Nota $nota){

        $iden_curso = $request->id_curso;
        $iden_modulo = $request->id_modulo;
        $usuario =  auth()->user()->cedula;

        //consulta para saber si ya presento en examen actual
        $consulta = Nota::select('id_curso', 'id_modulo', 'cedula_estudiante')
                          ->where('id_curso', '=', $iden_curso)
                          ->where('id_modulo', '=', $iden_modulo)
                          ->where('cedula_estudiante', '=', $usuario)
                          ->first();

                      
        if ($consulta){

            return redirect()->route('cursos.index')->withFlashMessage('Ya presento este examen y lo aprobo.');
        }
        else{
 
            if ($request->pregunta)
            {
                //Número de preguntas contestadas
                $num = $request->calificacion;

                
                
                for ($i = 0; $i <= count($num); $i++) 
                {
                    $resultado = array_sum($request->calificacion);
                    
                }
                //Número de preguntas
                $num2 = count($request->pregunta);
                
            }
            
        
            $resu = $num2 * 70 /100;
            /*echo $resu;
            echo '<br>';
            echo $resultado;
            echo '<br>';
             return $resu; */
            
            if($resultado <= $resu){ 
            $num2 = $request->pregunta;
            for ($i = 0; $i < count($num2); $i++) 
            { 
                        $num2[$i];
                        $value1 = $request->pregunta[$i];
                        $value2 = $request->calificacion[$i];
                        $value3 = $request->id_curso;
                        $value4 = $request->id_modulo;
                        $value5 =$request->cedula_estudiante;
                        
                        $intentos = count($request->pregunta);
                        $punto = new Punto();
                        Punto::create([  
                     
                        'pregunta'=>$punto->pregunta = $value1,
                        'calificacion'=>$punto->calificacion = $value2,
                        'id_curso'=>$punto->id_curso = $value3,
                        'id_modulo'=>$punto->id_modulo = $value4,
                        'cedula_estudiante'=>$punto->cedula_estudiante = $value5,
                         ]); 


            }
            $cedula_estudiante = $request->cedula_estudiante;
            $cali = 0;
             $preguntas = Punto::select('pregunta', 'calificacion')
                                ->where('cedula_estudiante', '=', $cedula_estudiante)
                                ->where('id_curso', '=', $iden_curso)
                                ->where('id_modulo', '=', $iden_modulo)
                                ->latest()
                                ->take($intentos)
                                
                               /*  ->take(3) */
                                ->get();
            
            //$pregus[] = $preguntas;
            /**Debe contestar correctamente como minimo el 75% de las preguntas */
                 return view('notas.index', compact('preguntas'));
                 //return redirect()->route('cursos.index', compact('preguntas'))->withFlashMessage('¡¡¡ DEBE REPETIR EL EXAMEN !!!.  '. '____ '.'Número de preguntas contestadas correctamente:  '. $resultado);
               
            }
            else{
                $nota = new Nota(); 
                Nota::create([  
            
                    'id_curso'=>$nota->id_curso = $request->id_curso, 
                    'id_modulo'=>$nota->id_modulo = $request->id_modulo,
                    'calificacion'=>$nota->calificacion = $resultado,
                    'cedula_estudiante'=>$nota->cedula_estudiante = $request->cedula_estudiante,
                ]); 

                return redirect()->route('cursos.index')->withFlashMessage('Examen presentado y aprobado. Preguntas contestadas correctamente: '.$resultado.' puede ingresar nuevamente al curso, para conocer si existen más módulos o si ha finalizado dicho curso.'); 
            }
            }                  
            
    }
}
