<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use Illuminate\Support\Facades\Storage; 
use App\Models\Curso; 
use App\Models\Modulo;
use App\Models\Prueba; 


class PruebaController extends Controller
{
    //protegemos las rutas, para evitar daños de terceros
    public function __construct()
    {
        $this->middleware('can:pruebas.index')->only('index');
        $this->middleware('can:pruebas.create')->only('create', 'store');
        $this->middleware('can:pruebas.edit')->only('edit', 'update');
        $this->middleware('can:pruebas.destroy')->only('destroy');
    }

    // se utiliza paginate para distribuir en páginas el contenido
    public function index(Curso $curso, Request $request){
        // Se traen los id del curso y del módulo, para imprimir el exámen correspondiente

        $iden_curso = $request->id_curso; 
        $iden_modulo = $request->id_modulo;
         
        $pruebas = Prueba::select('pregunta', 'resp1', 'resp2', 'resp3','resp4','resp5', 'resp6', 'valor1', 'valor2', 'valor3', 'valor4', 'valor5', 'valor6')
                          ->where('id_curso', $iden_curso)
                          ->where('id_modulo', $iden_modulo)
                          ->orderBy((Prueba::raw('RAND()')))
                          ->get();

        $cursos = Curso::where('id', $iden_curso)->OrderBy('id','desc')->get();

        $modulos = Modulo::where('id', $iden_modulo)->OrderBy('id', 'desc')->get();
     
        $tiempo = Prueba::select('tiempo')
                          ->where('id_curso', $iden_curso)
                          ->where('id_modulo', $iden_modulo)->max('tiempo');
        

        return view('pruebas.index', ['data'=>json_encode($tiempo)], compact('pruebas', 'cursos', 'modulos', 'tiempo'));

    }

    public function create(){
        //se consultan los cursos y módulos creados por el usuario logueado
        $usuario =  auth()->user()->cedula;
        $cursos = Curso::where('responsable', $usuario)->get();
        $modulos = Modulo::where('responsable', $usuario)->get();
        return view('pruebas.create', compact('modulos', 'cursos'));
 
    }

   public function store(Request $request){
   
        if ($request->pregunta) 
        {
            
            $num = $request->pregunta;
            
            for ($i = 0; $i < count($num); $i++) 
            { 
                        $num[$i];

                          echo $num[$i];
                          echo '<br>';
                          echo $request->resp1[$i];
                          echo '<br>';
                          echo $request->valor1[$i];
                          echo '<br>';
                          echo $request->resp2[$i];
                          echo '<br>';
                          echo $request->valor2[$i];
                          echo '<br>';
                          echo $request->resp3[$i];
                          echo '<br>';
                          echo $request->valor3[$i];
                          echo '<br>';
                          echo $request->resp4[$i];
                          echo '<br>';
                          echo $request->valor4[$i];
                          echo '<br>';
                          echo $request->resp5[$i];
                          echo '<br>';
                          echo $request->valor5[$i];
                          echo '<br>';
                          echo '<br>';
                          echo $request->resp6[$i];
                          echo '<br>';
                          echo $request->valor6[$i];
                          echo '<br>';
                         
                          /* if ($request->valor1[$i] === 'correcto'){
                              $var1 = 1;
                              $request->valor1 = $var1;
                          }elseif($request->valor1[$i] === 'incorrecto'){
                              
                              $var11 = 0;
                              $request->valor1 = $var11;
                          }

                          if ($request->valor2[$i] === 'correcto'){
                              $var2 =1;
                            $request->valor2 = $var2;
                        }elseif($request->valor2[$i] === 'incorrecto'){
                            $var22 = 0;
                            $request->valor2 = $var22;
                        }

                        if ($request->valor3[$i] === 'correcto'){
                            $var3 = 1;
                            $request->valor3 = $var3;
                        }elseif($request->valor3[$i] === 'incorrecto'){
                            $var33 = 0;
                            $request->valor3 = $var33;
                        }

                        if ($request->valor4[$i] === 'correcto'){
                            $var4 = 1;
                            $request->valor4 = $var4;;
                        }elseif($request->valor4[$i] === 'incorrecto'){
                            $var44 = 0;
                            $request->valor4 = $var44;
                        }

                        if ($request->valor5[$i] === 'correcto'){
                            $var5 = 1;
                            $request->valor5 = $var5;
                        }elseif($request->valor5[$i] === 'incorrecto'){
                            $var55 = 0;
                            $request->valor5 = $var55;
                        }
 */
                    

                        $value1 = $request->pregunta[$i];
                        $value2 = $request->resp1[$i];
                        $value3 = $request->resp2[$i];
                        $value4 = $request->resp3[$i];

                        $value5 = $request->resp4[$i];
                        
                        $value6 = $request->resp5[$i];
                        
                        $value15 = $request->resp6[$i];
                    

                        $value7 = $request->valor1[$i];
                        $value8 = $request->valor2[$i];
                        $value9 = $request->valor3[$i];

                        $value10 = $request->valor4[$i];
                        $value11 = $request->valor5[$i];
                        
                        $value16 = $request->valor6[$i];

                        $value12 = $request->id_curso;
                        $value13 = $request->id_modulo;
                        $value14 = $request->tiempo;

                        $prueba = new Prueba();
                        Prueba::create([  
                     
                        'pregunta'=>$prueba->pregunta = $value1,
                        'resp1'=>$prueba->resp1 = $value2, 
                        'resp2'=>$prueba->resp2 = $value3,
                        'resp3'=>$prueba->resp3 = $value4,
 
                        'resp4'=>$prueba->resp4 = $value5,
                        'resp5'=>$prueba->resp5 = $value6,
                        'resp6'=>$prueba->resp5 = $value15,

                        'valor1'=>$prueba->valor1 = $value7,
                        'valor2'=>$prueba->valor2 = $value8,
                        'valor3'=>$prueba->valor3 = $value9,

                        'valor4'=>$prueba->valor4 = $value10,
                        'valor5'=>$prueba->valor5 = $value11,
                        'valor6'=>$prueba->valor6 = $value16,

                        'id_curso'=>$prueba->id_curso = $value12,
                        'id_modulo'=>$prueba->id_modulo = $value13,
                        'tiempo'=>$prueba->tiempo = $value14,
                         ]); 

            }       
                       
            
          
                return redirect()->route('cursos.index'); 
        }else
            {
               return redirect()->route('pruebas.create', compact('pruebas')); 
            }
 
    
    }

    public function show(Prueba $prueba, Curso $curso, Modulo $modulo){
        //Consulta los cursos disponibles
        $cursos = Curso::where('id','desc')->get();

        return view('pruebas.index', compact('prueba', 'cursos', 'modulos'));

    } 

    public function edit(Request $request, Prueba $prueba, Curso $curso, Modulo $modulo){

        return view('pruebas.edit', compact('prueba'));

    }

    public function update(Request $request, Prueba $prueba, Curso $curso, Modulo $modulo){

    }
 
    public function destroy(){

    }
}

