<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use App\Http\Controllers\CertificadoController;
use Illuminate\Support\Facades\Storage;  
use App\Models\Curso;
use App\Models\Modulo;
use App\Models\Matricula;
use App\Models\Nota;
use App\Models\User;
use App\Models\Prueba; 
use App\Models\Certificado;
use Carbon\Carbon; 

class lista_cursoController extends Controller
{
    //protegemos las rutas, para evitar daños de terceros
    public function __construct()
    {
        $this->middleware('can:cursos.index')->only('index');
        $this->middleware('can:cursos.create')->only('create', 'store');
        $this->middleware('can:cursos.edit')->only('edit', 'update');
        $this->middleware('can:cursos.destroy')->only('destroy');
    }
    // 
    public function index(Curso $curso, Matricula $matricula){

        //validamos si el perfil es docente o administrador(a)
        $now = Carbon::now();
        $currentDate = $now->format('Y-m-d');
        $usuario =  auth()->user()->cedula;
        $var_doc = 'Docente';
        $var_adm = 'Admin';
        $visitante_UAM = 'Visitante_UAM';
        $consulta_perfil = User::where('cedula', $usuario)->where('perfil', $var_doc)->first();
        $consulta_perfil2 = User::where('cedula', $usuario)->where('perfil', $var_adm)->first();
        $consulta_perfil_UAM = User::where('cedula', $usuario)->where('perfil', $visitante_UAM)->first();
        
        if($consulta_perfil or $consulta_perfil2){
            $cursos = Curso::where('fecha_cierre', '>', $currentDate)
                            ->OrderBy('id', 'desc')
                            ->paginate();
        }
        else{
        //validamos la fecha de cierre del curso, para saber si se muestra o no.
        $now = Carbon::now();
        $currentDate = $now->format('Y-m-d');
        $estudiante_publico = 'Estudiante';
        $estudiante_privado = 'Estudiante_privado';
        $curso_publico = 'Publico';
        $curso_privado = 'Privado';
        $usuario =  auth()->user()->cedula;

        //Consulta si el estudiante es público o privado
        /* $consulta_perfil_estudiante = User::where('cedula', $usuario)->where('perfil', $estudiante_publico)->first();

        if($consulta_perfil_estudiante){ */

            // se utiliza paginate para distribuir en páginas el contenido
            $cursos = Curso::where('fecha_inicio', '<', $currentDate)
                            ->where('fecha_cierre', '>', $currentDate)
                            ->where('categoria', $curso_publico )
                            ->OrderBy('id', 'desc')
                            ->paginate();

           $id_cursos = Curso::select('id')
                             ->OrderBy('id', 'desc')
                             ->first();
            
           //si el usuario que ingresa es de la Universidad Autonoma de Manizales
            if($consulta_perfil_UAM){
                $curso_UAM = 20;
                $cursos = Curso::where('id', '=', $curso_UAM)
                               ->OrderBy('id', 'desc')
                               ->paginate();
            }
            /* $user = User::join('matriculas','cedula', '=', 'matriculas.cedula_estudiante')
            ->where('matriculas.cedula_estudiante', $usuario)
            ->where('id_curso', $id_cursos)
            ->select('users.id','users.name')
            ->get();    
           
            return $user; */
        /* }
        else{

            // se utiliza paginate para distribuir en páginas el contenido
            $lista_cursos = Curso::where('fecha_inicio', '<', $currentDate)
                            ->where('fecha_cierre', '>', $currentDate)
                            ->where('categoria', $curso_publico )
                            ->OrderBy('id', 'desc')
                            ->paginate();
        } */
        
    }
    
        
        return view('lista_cursos.index', compact('cursos'));


    }

    public function create(){
        return view('cursos.create');

    }

    public function store(Request $request){ 
        $curso = new Curso();  
       Curso::create([ 
            
           'titulo_curso'=>$curso->titulo_curso = $request->titulo_curso,
           'slug'=>$curso->slug = $request['slug'] = Str::slug($request->titulo_curso),
           'descripcion'=>$curso->descripcion = $request->descripcion,
           'enlace_video'=>$curso->enlace_video = $request->enlace_video,
           'fecha_inicio'=>$curso->fecha_inicio = $request->fecha_inicio,
           'fecha_cierre'=>$curso->fecha_cierre = $request->fecha_cierre,
           'responsable'=>$curso->responsable = $request->responsable,
           'categoria'=>$curso->categoria = $request->categoria,
       ]); 
 
       return redirect()->route('cursos.index', compact('curso')); 
 
    }
    //////////////////////////////////////

    public function show(Curso $curso, Modulo $modulo, Matricula $matricula, User $user, Prueba $prueba, Request $request){
        
        $usuario =  auth()->user()->cedula;
        $email =  auth()->user()->email;
        
        $codigo_curso = $curso->id;
        $codigo_modulo = $modulo->id;
        $iden_modulo = $request->id_modulo;
        
        //validamos si el perfil es docente
        $var_doc = 'Docente';
        $var_adm = 'Admin';
        $consulta_perfil = User::where('cedula', $usuario)->where('perfil', $var_doc)->first();
        $consulta_perfil2 = User::where('cedula', $usuario)->where('perfil', $var_adm)->first();
        
        if($consulta_perfil or $consulta_perfil2){
            $modulos = Modulo::where('id_curso', $codigo_curso)
                             ->get();
            //Consulta los cursos disponibles
            $cursos = Curso::OrderBy('id', 'desc')->get();

            //Consulta quienes están inscritos en cada curso
            $users = User::join('Matriculas','cedula', '=', 'Matriculas.cedula_estudiante')
                        ->where('id_curso', $codigo_curso)
                        ->select('Users.id','Users.name')
                        ->get();

            //Consulta el nombre del creador del curso
            $docentes = User::join('cursos','cedula', '=', 'cursos.responsable')
                            ->select('Users.id','Users.name')
                            ->where('cursos.id', $codigo_curso)
                            ->get();

            
            //Consulta las pruebas que se han creado para cada uno de los módulos
            $pruebas = Prueba::where('id_curso', $codigo_curso)
               
                ->get();
            return view('cursos.show', compact('modulo','modulos', 'curso', 'users', 'docentes', 'pruebas' )); 
        }
        else{
        
        //Valida si el usuario esta registrado en el curso
       $consulta_inscripcion = Matricula::where('cedula_estudiante', '=', $usuario)
                                          ->where('email_estudiante', '=', $email)
                                          ->where('id_curso', '=', $codigo_curso)
                                          ->get();
                                          
                                         

       if ($consulta_inscripcion)  
       {
            $usuario =  auth()->user()->cedula;
            $email =  auth()->user()->email;
            $codigo_curso = $curso->id;
            echo "Código del Curso: ";
            echo $codigo_curso;
            echo '<br>';
            
            //consulta el código del módulo mayor del curso
            $bandera = Modulo::select('id')->where('id_curso', $codigo_curso)->max('id');
            echo "modulo mayor: ";
            echo $bandera;
            echo '<br>';
            echo "usuario: ";
            echo $usuario;

            //consulta si el estudiante ya presento un examen
            $notas = Nota::select('id_curso', 'id_modulo', 'cedula_estudiante')
                           ->where('id_curso' ,$codigo_curso)
                           ->where('id_modulo', '<', $bandera)
                           ->where('cedula_estudiante' ,$usuario)
                           ->first();
                          
            /* dd($notas);  */ 
            if($notas){
                
                $codigo_curso = $curso->id;
                //consulta el módulo actual del cuál el estudiante ha presentado el examen
                $nota = Nota::select('id_modulo')->where('id_curso', $codigo_curso)->where('cedula_estudiante', $usuario)->max('id_modulo');
                echo '<br>';
                echo "módulo actual: ";
                echo $nota;
                echo '<br>';
                $var= Modulo::where('id_curso', $codigo_curso)->max('id');
                echo "Último módulo: ";
                 echo $var;

                if ($var > $nota) {
                    //se muestra el siguiente módulo y examen
                    $nota = $nota + 1;
                    echo '<br>';
                    echo "bandera: ";
                    echo $nota;
                    $modulos = Modulo::where('id_curso', $codigo_curso)
                                      ->where ('id', $nota)
                                    ->get();
                                    echo '<br>';
                                    echo "Módulo actual: ";  
                                    echo $nota; 
                }
                elseif($var = $nota){ 
                    
                    $modulos = Modulo::where('id_curso', $codigo_curso)
                                      ->get();
                                      
                    echo "<div class='alert alert-success'>
                          <strong>";
                    echo "Ha concluido con el curso, puede descargar el certificado correspondiente.";
                    echo"</strong>
                          </div>";                  
                    
                    $consulta_certificado = Certificado::where('id_curso', $codigo_curso)
                                                        ->where('cedula_estudiante', $usuario)
                                                        ->first();
                    if($consulta_certificado){
                         ////No guarda por más de una vez la validación
                    }
                    else{
                         //insertar en la tabla certificados el ok de aprobación
                    $aprobo = 'aprobo';
                    $now = Carbon::now();
                    $currentDate = $now->format('Y-m-d');
                    $certificado = new Certificado();  
                    Certificado::create([ 
                        
                       'validacion'=>$certificado->validacion = $aprobo,
                       'cedula_estudiante' =>$certificado->cedula_estudiante =$usuario,
                       'email_estudiante' =>$certificado->email_estudiante =$email,
                       'id_curso' => $certificado->id_curso = $codigo_curso,
                       'fecha_aprobacion' => $certificado->fecha_aprobacion = $currentDate,
                  
                   ]); 
                }
                }
               
            }  
            else{

                $codigo_curso = $curso->id;
                /* return $codigo_curso; */
                //consulta el primer módulo de cada curso
                $modulos = Modulo::where('id_curso', $codigo_curso)
                                    ->OrderBy('id', 'asc')
                                    ->latest('id')
                                    ->limit(1)
                                    ->get();

                                    //Consulta los cursos disponibles
                $cursos = Curso::OrderBy('id', 'desc')->get();

                 /* dd($modulos);    */                 
                /* return view('cursoss.show', compact('curso','modulo','modulos','cursos')); */

            }            
            
            //Consulta quienes están inscritos en cada curso
            $users = User::join('Matriculas','cedula', '=', 'Matriculas.cedula_estudiante')
                           ->where('id_curso', $codigo_curso)
                           ->select('Users.id','Users.name')
                           ->get();
            
            //Consulta el nombre del creador del curso
            $docentes = User::join('cursos','cedula', '=', 'cursos.responsable')
                             ->select('Users.id','Users.name')
                             ->where('cursos.id', $codigo_curso)
                             ->get();
             
                             
            //Consulta las pruebas que se han creado para cada uno de los módulos
            $pruebas = Prueba::where('id_curso', $codigo_curso)
                               ->where('id_modulo', $iden_modulo)
                               ->get();

        
            return view('cursos.show', compact('curso','modulos', 'users', 'docentes', 'pruebas'));
                   
                       
       }
       else 
       {
           return redirect()->route('lista_cursos.index')->withFlashMessage('Debe inscribirse primero');
       }
    }
    }

    public function edit(Curso $curso){
        //regla de autorización
        /* $this->authorize('author', $curso); */
        return view('cursos.edit', compact('curso'));

    }

    public function update(Curso $curso, Request $request){
        //regla de autorización
        /* $this->authorize('author', $curso); */
        $curso->titulo_curso = $request->titulo_curso;
        $curso->slug = $request['slug'] = Str::slug($request->titulo_curso);
        $curso->enlace_video = $request->enlace_video;
        $curso->descripcion = $request->descripcion;
        $curso->categoria = $request->categoria;
        $curso->fecha_inicio = $request->fecha_inicio;
        $curso->fecha_cierre = $request->fecha_cierre;
               
            $curso->save();
               
    
            return redirect()->route('cursos.index');

    }

    public function destroy(Curso $curso){
        //regla de autorización
        $this->authorize('author', $curso);
        
        $curso->delete();

        return redirect()->route('cursos.index');

    }
} 