<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller; 
use App\Http\Controllers\ModuloController;
use Illuminate\Support\Facades\Storage;  
use App\Models\Curso;
use App\Models\Modulo;
use App\Models\Matricula; 
use App\Models\Nota;
use App\Models\User;
use App\Models\Prueba;
use App\Models\Certificado; 

class lista_estudiantes_cursoController extends Controller
{
    // 
    public function index(Curso $curso, Request $request){  
        $usuario =  auth()->user()->cedula;

        $var_adm = 'Admin';
        $visitante_UAM = 'Visitante_UAM';
        
        $status = 1;
        $consulta_perfil2 = User::where('cedula', $usuario)->where('perfil', $var_adm)->first();
        $consulta_perfil_UAM = User::where('cedula', $usuario)->where('perfil', $visitante_UAM)->first();

        $constancias = Matricula::OrderBy('id', 'desc')->paginate();

        if($consulta_perfil2){
            $cursos = Curso::OrderBy('id', 'desc')->paginate();
        }
        else{
            //consulta de los cursos registrados
            $cursos = Curso::where('responsable', $usuario)->OrderBy('id', 'desc')->paginate();
        }
        
        //puede listar los estudiantes del curso de UAM
        if($consulta_perfil_UAM){
            $curso_UAM = 20;
            $cursos = Curso::where('id', '=', $curso_UAM)
                           ->OrderBy('id', 'desc')
                           ->paginate();
        }

        $curso=$request->get('curso');
     
        //consulta el nombre del curso consultado
        $nombre_curso = Matricula::join('cursos', 'matriculas.id_curso', '=', 'cursos.id')
                                    ->select('cursos.titulo_curso')
                                    ->where('matriculas.id_curso', '=', $curso )
                                    ->max('cursos.titulo_curso');

        //Consulta los usuarios inscritos en cada uno de los cursos
        $certificados = Matricula::join('cursos','matriculas.id_curso', '=', 'cursos.id')
                                    ->join('users', 'matriculas.cedula_estudiante', '=', 'users.cedula')
                                    
                                    ->select('users.cedula', 'users.lugar_trabajo', 'users.email', 'users.telefono', 'users.ultimo_ingreso', 'users.name', 
                                             'matriculas.created_at', 'matriculas.id_curso')
                                             
                                    ->where('matriculas.id_curso', '=',$curso )
                                    
                                    
                                    
                                    ->orderBy('matriculas.created_at','desc')
                                    
                                    ->distinct()
                                    
                                    ->paginate(200);
                                    
        //consulta si el estudiante ya se certificó y en que fecha
        $consulta_certificados = Certificado::select('users.cedula', 'users.name', 'users.lugar_trabajo', 'users.email', 'users.telefono',
                                                'certificados.created_at', 'certificados.cedula_estudiante', 'certificados.email_estudiante',
                                                'certificados.id_curso')
                                         
                                        
                                                ->join('users', 'certificados.email_estudiante', '=', 'users.email')
                                               
                                                
                                                ->where('certificados.id_curso', '=', $curso )->count();
                                            
         $contador = Matricula::where('id_curso', '=', $curso)->get();
                                                        
        
         $resultado_contador = count($contador);
         

        //dd($consulta_certificados);
        return view('lista_estudiantes_cursos.index', compact('constancias', 'cursos', 'certificados', 'nombre_curso', 'consulta_certificados', 'resultado_contador'));
    }
}
