<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Checklogin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
       if(auth()->check() && (auth()->user()->estado == 0)){
           
           Auth::guest();
 
           $request->session()->invalidate();

           $request->session()->regenerateToken();

           return redirect()->route('login')->with('error' , 'Su cuenta ha sido desactivada.');
       }
        return $next($request);
    }
}
