<?php

namespace App\Policies;

use App\Models\Curso;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class CursoPolicy
{
    use HandlesAuthorization;

    public function responsable(User $user, Curso $curso){
        $usuario =  auth()->user()->cedula;
        
        $var_adm = 'Admin';
        
        $consulta_perfil = User::where('cedula', $usuario)->where('perfil', $var_adm)->first();

        if ($consulta_perfil){
            return true;
        }

        if($user->cedula == $curso->responsable){
            return true;
        }
        else{
            return false;
        }
    }
}
