<?php

namespace App\Policies;


use App\Models\Modulo;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ModuloPolicy
{
    use HandlesAuthorization;

    public function responsable(User $user, Modulo $modulo){
        $usuario =  auth()->user()->cedula;
        
        $var_adm = 'Admin';
        
        $consulta_perfil = User::where('cedula', $usuario)->where('perfil', $var_adm)->first();

        if ($consulta_perfil){
            return true;
        }

        if($user->cedula == $modulo->responsable){
            return true;
        }
        else{
            return false;
        }
    }
}