<?php

namespace Database\Factories;

use App\Models\Curso;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class CursoFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Curso::class;

    /**
     * Define the model's default state.
     * 
     * @return array
     */
    public function definition()
    {
        $titulo_curso = $this->faker->sentence();
        return [
            'titulo_curso'=> $titulo_curso,
            'slug' => Str::slug($titulo_curso, '-'),
            'descripcion'=> $this->faker->paragraph(),
            'enlace_video'=> $this->faker->sentence(),
            'fecha_inicio'=> $this->faker->dateTimeAd(),
            'fecha_cierre'=> $this->faker->dateTimeAd(),
            'responsable'=> $this->faker->sentence(),
        ];
    }
}
