<?php

namespace Database\Factories;

use App\Models\Modulo;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class ModuloFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Modulo::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $titulo_modulo = $this->faker->sentence();
        return [
            'titulo_curso'=> $titulo_modulo,
            'slug' => Str::slug($titulo_modulo, '-'),
            'archivo'=> $this->faker->sentence(),
            'id_curso'=> $this->faker->sentence(),
        ];
    }
}
