<x-guest-layout>
    <x-jet-authentication-card>
        <x-slot name="logo">
            <x-jet-authentication-card-logo />
        </x-slot>

        <div class="mb-4 font-semibold text-xl text-red-600">
            {{ __('¿Olvido su contraseña?') }}
        </div>
        <div class="mb-4 font-semibold text-base text-black">
            {{ __('No hay problema. Simplemente háganos saber su dirección de correo electrónico y le enviaremos un enlace para restablecer la contraseña que le permitirá elegir una nueva.') }}
        </div>

        @if (session('status'))
            <div class="mb-4 font-bold text-2xl text-red-600">
                {{ session('status') }}
            </div>
        @endif

        <x-jet-validation-errors class="mb-4" />

        <form method="POST" action="{{ route('password.email') }}">
            @csrf

            <div class="block">
                <x-jet-label for="email" value="{{ __('Email') }}" />
                <x-jet-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autofocus />
            </div>

            <div class="flex items-center justify-end mt-4">
                <x-jet-button>
                    {{ __('Restablecer contraseña') }}
                </x-jet-button>
            </div>
        </form>
        <center>
            <a href="{{ route('login') }}" class="ml-4 text-sm text-gray-700 underline"><span class="ml-2 text-sm text-gray-600">Iniciar sesión</span></a>
        </center>
    </x-jet-authentication-card>
</x-guest-layout>
