<x-guest-layout>
    <x-jet-authentication-card>
        <x-slot name="logo">
            <x-jet-authentication-card-logo />
        </x-slot>

        <x-jet-validation-errors class="mb-4" />

        @if (session('status'))
            <div class="mb-4 font-bold text-2xl text-red-600">
                {{ session('status') }}
            </div>
        @endif
        
         {{--  Mensaje de cuenta desactivada   --}} 
        @if (session('error'))
            <div class="mb-4 font-bold text-2xl text-red-600">
                {{ session('error') }}
            </div>
        @endif

        <form method="POST" action="{{ route('login') }}">
            @csrf

            <div>
                <x-jet-label for="email" value="{{ __('Email') }}" />
                <x-jet-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autofocus />
            </div>

            <div class="mt-4">
                <x-jet-label for="password" value="{{ __('Contraseña') }}" />
                <x-jet-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="current-password" />
            </div>
            <br>
            <center>
                <x-jet-button class="ml-4">
                    {{ __('Ingresar') }}
                </x-jet-button>
            </center>

            <center>
                <div class="block mt-4">
                    <label for="remember_me" class="flex items-center">
                        <x-jet-checkbox id="remember_me" name="remember" />
                        <span class="ml-2 text-sm text-gray-600">{{ __('Recordarme') }}</span>
                    </label>
                </div>
   
                <div class="flex items-center justify-end mt-4">
                    @if (Route::has('password.request'))
                        <a class="underline text-sm text-gray-600 hover:text-gray-900" href="{{ route('password.request') }}">
                            <span class="ml-2 text-lg font-bold text-red-600"><b><svg class="icon icon-tabler icon-tabler-password-user" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#00b341" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                                              <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                                              <path d="M12 17v4" />
                                                                              <path d="M10 20l4 -2" />
                                                                              <path d="M10 18l4 2" />
                                                                              <path d="M5 17v4" />
                                                                              <path d="M3 20l4 -2" />
                                                                              <path d="M3 18l4 2" />
                                                                              <path d="M19 17v4" />
                                                                              <path d="M17 20l4 -2" />
                                                                              <path d="M17 18l4 2" />
                                                                              <path d="M9 6a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" />
                                                                              <path d="M7 14a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2" />
                                                                            </svg>{{ __('Olvide mi contraseña') }}</b></span>
                        </a>
                        <div>
                        <a href="#" onmouseOver="alert('Para restablecer la contrase&ntilde;a, se recomienda hacerlo desde un port&aacute;til o equipo de mesa.')">
                            <svg class="icon icon-tabler icon-tabler-info-circle" width="35" height="35" viewBox="0 0 24 24" stroke-width="1.5" stroke="#4352D1" fill="none" stroke-linecap="round" stroke-linejoin="round">
                              <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                              <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" />
                              <path d="M12 9h.01" />
                              <path d="M11 12h1v4h1" />
                            </svg>
                        </a>
                    </div>
                    @endif 
                </div>
            </center>
        </form>
        <center>
            <a href="{{ route('register') }}" class="ml-4 text-base font-bold text-gray-600 underline">Registrarse
            <svg class="icon icon-tabler icon-tabler-circle-arrow-up" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#00b341" fill="none" stroke-linecap="round" stroke-linejoin="round">
              <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
              <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" />
              <path d="M12 8l-4 4" />
              <path d="M12 8v8" />
              <path d="M16 12l-4 -4" />
            </svg>
            </a>
        </center>
    </x-jet-authentication-card>
</x-guest-layout>
