<x-guest-layout>
    <x-jet-authentication-card>
        <x-slot name="logo">
            <x-jet-authentication-card-logo />
        </x-slot>
 
        <x-jet-validation-errors class="mb-4" />
        
   
       
        <form method="POST" action="{{ route('register') }}">
            @csrf

            <div>
                <x-jet-label for="name" value="{{ __('Nombre completo') }}" />
                <x-jet-input id="name" placeholder='Nombres y Apellidos' class="block mt-1 w-full" type="text" name="name" :value="old('name')" required autofocus autocomplete="name" />
            </div>
            
            <div>
                <x-jet-label for="tipo_documento" value="{{ __('Tipo de documento') }}" />
                <select id="tipo_documento" class="form-control" type="text" name="tipo_documento" :value="old('tipo_documento')" required autofocus autocomplete="tipo_documento">
                    <option>Seleccione el tipo de documento</option>
                    <option>TI</option>
                    <option>CC</option>
                    <option>PEP</option>
                    <option>CE</option>
                </select>
            </div>

            <div>
                <x-jet-label for="cedula" value="{{ __('Cédula') }}" />
                <x-jet-input id="cedula" placeholder='Número del documento (sin puntos, ni comas)' class="block mt-1 w-full" type="number" name="cedula" :value="old('cedula')" required  />
            </div>

            <div>
                <x-jet-label for="lugar_trabajo" value="{{ __('Lugar de trabajo') }}" />
                <x-jet-input id="lugar_trabajo" placeholder='Entidad donde labora' class="block mt-1 w-full" type="text" name="lugar_trabajo" :value="old('lugar_trabajo')" required autofocus autocomplete="lugar_trabajo" />
            </div>

            <div>
                <x-jet-label for="telefono" value="{{ __('N° teléfono') }}" />
                <x-jet-input id="telefono" placeholder='Número de contacto' class="block mt-1 w-full" type="text" name="telefono" :value="old('telefono')" required autofocus autocomplete="telefono" />
            </div>

            <div>
                <x-jet-label for="perfil" />
                <x-jet-input id="perfil" class="block mt-1 w-full" type="hidden" name="perfil" value="Estudiante" />
            </div>

            <div>
                <x-jet-label for="estado" />
                <x-jet-input id="estado" class="block mt-1 w-full" type="hidden" name="estado" value="1" />
            </div>

            <div class="mt-4">
                <x-jet-label for="email" value="{{ __('Email') }}" />
                <x-jet-input id="email" placeholder='Correo electrónico' class="block mt-1 w-full" type="email" name="email" :value="old('email')" required />
            </div>

            <div class="mt-4">
                <x-jet-label for="password" value="{{ __('Contraseña') }}" />
                <x-jet-input id="password" placeholder='Contraseña' class="block mt-1 w-full" type="password" name="password" required autocomplete="new-password" />
            </div>
 
            <div class="mt-4">
                <x-jet-label for="password_confirmation" value="{{ __('Confirmar contraseña') }}" />
                <x-jet-input id="password_confirmation"  placeholder='Confirmar Contraseña' class="block mt-1 w-full" type="password" name="password_confirmation" required autocomplete="new-password" />
            </div>

            @if (Laravel\Jetstream\Jetstream::hasTermsAndPrivacyPolicyFeature())
                <div class="mt-4">
                    <x-jet-label for="terms">
                        <div class="flex items-center">
                            <x-jet-checkbox name="terms" id="terms"/>

                            <div class="ml-2">
                                {!! __('Acepto las: condiciones de servicio y: política de privacidad', [
                                        'Terminos de servicio' => '<a target="_blank" href="'.route('terms.show').'" class="underline text-sm text-gray-600 hover:text-gray-900">'.__('Terms of Service').'</a>',
                                        'política de privacidad' => '<a target="_blank" href="'.route('policy.show').'" class="underline text-sm text-gray-600 hover:text-gray-900">'.__('Privacy Policy').'</a>',
                                ]) !!}
                            </div>
                        </div> 
                    </x-jet-label>
                </div>
            @endif

            <div class="flex items-center justify-end mt-4">
                <a class="text-sm text-gray-600 hover:text-gray-900" href="{{ route('login') }}">
                    {{ __('Ya estoy registrado(a)') }}
                </a>

                <x-jet-button class="ml-4">
                    {{ __('Registrarse') }}
                </x-jet-button>
            </div>
        </form>
    </x-jet-authentication-card>
</x-guest-layout>
