<x-app-layout>
    
    <div class="container">
        <form name="form" action="{{route('cursos.store')}}" method="POST" enctype="multipart/form-data">
            <!-- token para seguridad, con la directiva de blade -->
            @csrf
            <!--   --> 
            <table class="table w-full border-separate table-bordered">
                <tbody>
                    <h1>Crear cursos SIIS</h1>
                    <tr> 
                        <th colspan="2">
                            <label>
                                Titulo del curso:<br>
                                <input type="text" placeholder="Nombre del curso" size=70 style='text-align: center' style="width:650px" name="titulo_curso" value="{{old('titulo_curso')}}">
                            </label> 
                    
                            @error('titulo_curso')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                            @enderror 
                        </th>
                    </tr>
                    <tr>
                        <th>
                            <label>
                                Descripción:<br>
                                <textarea name="descripcion" id="" placeholder="Descripción general del curso. Ejemplo:(Objetivos)" rows="8" cols="60">{{old('descripcion')}}</textarea>
                            </label>
                    
                            @error('descripcion')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                            @enderror
                        </th>
                        <th>
                            <label>
                                Enlace de video: <a href="https://www.youtube.com/" target="_blank" rel="noopener noreferrer">(YouTube)</a><br>
                                <textarea name="enlace_video" id="enlace_video" placeholder="1) Este campo es opcional. Recordar que el video debe estar alojado en YouTube.com.  2) Debe modificar los siguientes atributos (width='1100' height='600') del video al momento de copiar su enlace en esta caja de texto. Ejemplo: --> (<iframe width='1100' height='600' src='https://www.youtube.com/embed/_0D7MlOz7qQ' title='YouTube video player' frameborder='0' allow='accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture' allowfullscreen></iframe>) <-- " rows="8" cols="60">{{old('enlace_video')}}</textarea>
                            </label>
                    
                            {{-- @error('enlace_video')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                            @enderror --}}
                        </th>
                    </tr>
                    <tr>
                        <th>
                            <label>
                                Fecha de inicio:<br>
                                <input type="date" name="fecha_inicio" value="{{old('fecha_inicio')}}">
                            </label> 
                    
                            @error('fecha_inicio')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                            @enderror
                        </th>
                        <th>
                            <label> 
                                Fecha de cierre:<br>
                                <input type="date" name="fecha_cierre" value="{{old('fecha_cierre')}}">
                            </label>
                    
                            @error('fecha_cierre')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                            @enderror 
                        </th>
                        <input type="hidden" name="responsable" value="{{ auth()->user()->cedula }}">
                        <input type="hidden" name="email_responsable" value="{{ auth()->user()->email }}">
                    </tr>
                    <tr>
                        <th>
                            <h3>Púbico: dirigido a la población en general.
                                Privado: dirigido a una problación especifica, convocada por la Secretaría de Salud.
                            </h3>
                        </th>
                        <th>
                            Categoria:<br>
                            <select name="categoria" value="{{old('categoria')}}">
                                <option></option>
                                <option value="Publico">Público</option>
                                <option value="Privado">Privado</option>
                            </select>
        
                            @error('categoria')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                            @enderror
                        </th>
                    </tr>
                    <tr> 
                        <th>
                            <h3>Tiempo limite que tendrá el estudiante, para desarrollar el curso, después de inscribirse: -></h3>
                        </th>
                        <th>
                            <center>
                                <label>
                                    Tiempo(número de días):<br>
                                    <input type="number" value="" size=120 style='text-align: center' style="width:650px" name="dias" value="{{old('dias')}}">
                                </label> 
                            </center>
                    
                            @error('dias')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                            @enderror
                        </th>
                    </tr>
                    <tr> 
                        <th>
                            <h3>Intensidad horaria del curso: -></h3>
                        </th>
                        <th>
                            <center>
                                <label>
                                    Tiempo(horas):<br>
                                    <input type="number" value="" size=120 style='text-align: center' style="width:650px" name="ih" value="{{old('ih')}}">
                                </label> 
                            </center>
                    
                            @error('ih')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                            @enderror
                        </th>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <label>
                                Circular:  <small>(Campo opcional)</small><br>
                                <input type="file" name='archivo' id="archivo" accept="file/*">
                            </label>
                            <small>(Preferiblemente formato PDF)(Tamaño máximo del archivo: 15 MB)</small>
                            @error('archivo')
                                <br>
                                <small>*{{$message}}</small>
                                <br>
                            @enderror
                        </th>
                    </tr>
                    <tr>
                        <th colspan="2">
                            <x-jet-button class="ml-4" onclick="pregunta(event)">
                                {{ __('Guardar curso') }}
                            </x-jet-button>
                        </th>
                    </tr>
                </tbody>
            </table>
        </form>
    </div>
<!-- Confirmar envio del formulario   -->
<script>
    function pregunta(e){
        if (confirm('¿Esta seguro(a) de crear el curso?')){
           document.form.submit()
        }
        else{
            e.preventDefault();
            }
        
    }
</script>    
</x-app-layout>
