<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Editar módulo') }}
        </h2> 
    </x-slot> 
    <div class="container">
        
            <form  action="{{route('cursos.update', $curso)}}" method="POST" enctype="multipart/form-data" name='inscripcion'>
            @csrf
            <!-- directiva con el metodo put -->
            @method('put')
            <table class='table w-full border-separate table-bordered'>
                <tbody>
                    Fecha creación: {{$curso->created_at}}
                        <tr>  
                            <th>
                                <label>
                                    Titulo del Curso:<br>
                                    <input type="text" name='titulo_curso' id="titulo_curso"  value="{{$curso->titulo_curso}}"  size=70 style='text-align: center' style="width:650px">
                                </label>
                                    @error('titulo_curso')
                                        <br>
                                        <small>*{{$message}}</small>
                                        <br>
                                    @enderror
                            </th>
                            <th>
                                <label>
                                    Enlace de video:<br>
                                    <textarea name="enlace_video" id="enlace_video" rows="10" cols="60">
                                        {{old('enlace_video', $curso->enlace_video)}}
                                    </textarea>
                                </label>
                        
                                @error('enlace_video')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>
                        </tr>
                        <tr>
                           
                            <th>
                                <label>
                                    Descripción:<br>
                                    <textarea name="descripcion" id=""  rows="10" cols="60">
                                        {{old('descripcion', $curso->descripcion)}}
                                    </textarea>
                                </label>
                         
                                @error('descripcion')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>  
                            <th>
                                <label>Categoría del curso</label>
                                <select name="categoria" value="{{old('categoria', $curso->categoria)}}">
                                    <option>{{old('categoria', $curso->categoria)}}</option>
                                    <option value="Publico">Público</option>
                                    <option value="Privado">Privado</option>
                                </select>
                        
                                @error('categoria')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                                @enderror
                            </th>
                            <input type="hidden" name="responsable" value="{{ auth()->user()->cedula }}"> 
                        </tr>
                        <tr>
                            <th>
                                <label>
                                    Fecha de inicio:<br>
                                    <input type="date" name="fecha_inicio" value="{{old('fecha_inicio', $curso->fecha_inicio)}}">
                                </label>
                        
                                @error('fecha_cierre')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror 
                            </th>
                            <th>
                                <label>
                                    Fecha de cierre:<br>
                                    <input type="date" name="fecha_cierre" value="{{old('fecha_cierre', $curso->fecha_cierre)}}">
                                </label>
                        
                                @error('fecha_cierre')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror 
                            </th>
                        </tr>
                        <tr>
                            <th colspan="2">
                                <center>
                                    <label>
                                        Tiempo(número de días):<br>
                                        <input type="number"  size=120 style='text-align: center' style="width:650px" name="dias" value="{{old('dias', $curso->dias)}}">
                                    </label> 
                                </center>
                        
                                @error('dias')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>
                        </tr>
                        <tr>
                            <th colspan="2">
                                <center>
                                    <label>
                                        Intensidad horaria(horas):<br>
                                        <input type="number"  size=120 style='text-align: center' style="width:650px" name="ih" value="{{old('ih', $curso->ih)}}">
                                    </label> 
                                </center>
                        
                                @error('ih')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>
                        </tr>
                        <tr>
                                @if (is_null($curso->archivo))
                                     <th colspan="2">{{'.'}}
                                      Archivo nuevo: <small>(Preferiblemente formato PDF)(Tamaño máximo del archivo: 15 MB)</small>
                                    <input type="file" name='archivo' id="archivo"  accept="file/*" value="{{old('archivo', $curso->archivo)}}">
                                </label>
                                    @error('archivo')
                                        <br>
                                        <small>*{{$message}}</small>
                                        <br>
                                    @enderror
                                    </th> 
                                @else
                                <label>
                                    <th colspan="2">
                                        <h3>
                                            Archivo actual:
                                            <embed src="{{asset($curso->archivo)}}" width="1200" height="400" >
                                        </h3>
                                    
                                               
                                
                                    <br>
                                    Archivo nuevo: <small>(Preferiblemente formato PDF)(Tamaño máximo del archivo: 15 MB)</small>
                                    <input type="file" name='archivo' id="archivo"  accept="file/*" value="{{old('archivo', $curso->archivo)}}">
                                </label>
                                    @error('archivo')
                                        <br>
                                        <small>*{{$message}}</small>
                                        <br>
                                    @enderror
                                    
                            </th>
                            @endif
                        </tr>
                        <tr>
                            <th colspan="2">
                                <center>
                                    <x-jet-button class="ml-4" onclick="pregunta(event)">
                                        {{ __('Guardar actualización') }}
                                    </x-jet-button>
                                </center>
                            </th>
                        </tr>
                        <br>
                </tbody>
            </table>         
        </form>
    </div>
<!-- Confirmar envio del formulario   -->
<script>
    function pregunta(e){
        if (confirm('¿Esta seguro(a) de guardar la actualización del curso?')){
           document.form.submit()
        }
        else{
            e.preventDefault();
            }
        
    }
</script>    
</x-app-layout>