<x-app-layout>
    <x-jet-authentication-card>
        <x-slot name="logo">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Actualizar datos del docente') }}
            </h2>
        </x-slot>
    
    <x-jet-validation-errors class="mb-4" />
    
        <form name="form" action="{{route('docentes.update', $docente)}}" method="POST">
            <!-- token para seguridad, con la directiva de blade -->
            @csrf
            <!-- metódo PUT  -->
            @method('put')
            
            <div>
                <x-jet-label for="name" value="{{ __('Nombre') }}" />
                <x-jet-input id="name" class="block mt-1 w-full" type="text" name="name" value="{{old('name', $docente->name)}}" required autofocus autocomplete="name" />
            </div>

            <div>
                <x-jet-label for="cedula" value="{{ __('Cédula') }}" />
                <x-jet-input id="cedula" class="block mt-1 w-full" type="text" name="cedula" value="{{old('cedula', $docente->cedula)}}" required autofocus autocomplete="cedula" />
            </div>

            <div>
                <x-jet-label for="tipo_documento" value="{{ __('Tipo de documento') }}" />
                <select  name="tipo_documento" value="{{old('tipo_documento', $docente->tipo_documento)}}" >
                    <option>{{old('tipo_documento', $docente->tipo_documento)}}</option>
                    <option>TI</option>
                    <option>CC</option>
                    <option>PEP</option>
                    <option>CE</option>
                </select>
            </div>

            <div>
                <x-jet-label for="lugar_trabajo" value="{{ __('Lugar de trabajo') }}" />
                <x-jet-input id="lugar_trabajo" class="block mt-1 w-full" type="text" name="lugar_trabajo" value="{{old('lugar_trabajo', $docente->lugar_trabajo)}}" required autofocus autocomplete="lugar_trabajo" />
            </div>

            <div>
                <x-jet-label for="telefono" value="{{ __('N° teléfono') }}" />
                <x-jet-input id="telefono" class="block mt-1 w-full" type="text" name="telefono" value="{{old('telefono', $docente->telefono)}}" required autofocus autocomplete="telefono" />
            </div>

            <div>
                <x-jet-label for="perfil" />
                <x-jet-input id="perfil" class="block mt-1 w-full" type="hidden" name="perfil" value="{{old('perfil', $docente->perfil)}}" required autofocus autocomplete="perfil" />
            </div>

            <div>
                <br>
                <small>Activo(a)= 1, Inactivo(a)=0.</small>
                <x-jet-label for="estado" value="{{ __('Estado') }}"/>
                    <select name="estado" value="{{old('estado', $docente->estado)}}">
                        <option>{{old('estado', $docente->estado)}}</option>
                        <option value="1">Activo(a)</option>
                        <option value="0">Inactivo(a)</option>
                    </select>

            </div>

            <div class="mt-4">
                <x-jet-label for="email" value="{{ __('Email') }}" />
                <x-jet-input id="email" class="block mt-1 w-full" type="email" name="email" value="{{old('email', $docente->email)}}" required />
            </div>
            <br>
            <small>Si no se requiere cambiar la contraseña, dejar los siguientes campos vacios.</small>
            <div class="mt-4">
                <x-jet-label for="password" value="{{ __('Contraseña') }}" />
                <x-jet-input id="password"  class="block mt-1 w-full" type="password" name="password" />
            </div>
 
           <div class="mt-4">
                <x-jet-label for="password_confirmation" value="{{ __('Confirmar contraseña') }}" />
                <x-jet-input id="password_confirmation" class="block mt-1 w-full" type="password" name="password_confirmation"/>
            </div>

            @if (Laravel\Jetstream\Jetstream::hasTermsAndPrivacyPolicyFeature())
                <div class="mt-4">
                    <x-jet-label for="terms">
                        <div class="flex items-center">
                            <x-jet-checkbox name="terms" id="terms"/>

                            <div class="ml-2">
                                {!! __('Acepto las: condiciones de servicio y: política de privacidad', [
                                        'Terminos de servicio' => '<a target="_blank" href="'.route('terms.show').'" class="underline text-sm text-gray-600 hover:text-gray-900">'.__('Terms of Service').'</a>',
                                        'política de privacidad' => '<a target="_blank" href="'.route('policy.show').'" class="underline text-sm text-gray-600 hover:text-gray-900">'.__('Privacy Policy').'</a>',
                                ]) !!}
                            </div>
                        </div> 
                    </x-jet-label>
                </div>
            @endif

            <div class="flex items-center justify-end mt-4">
                <x-jet-button class="ml-4" onclick="pregunta(event)">
                    {{ __('Actualizar docente') }}
                </x-jet-button>
            </div>
        </form>
    
  </x-jet-authentication-card>
  
 <!-- Confirmar envio del formulario   -->
<script>
    function pregunta(e){
        if (confirm('¿Esta seguro(a) de guardar la actualización de los datos del funcionario(a)?')){
           document.form.submit()
        }
        else{
            e.preventDefault();
            }
        
    }
</script> 
</x-app-layout>
