<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Listado de docentes') }}
        </h2>
    </x-slot>  
    <style>  
        .img{
             
            height: 220px;
            width: 280px; 
            margin-left: auto; 
            margin-right: auto;
        } 
    </style>
    
    <div class="container">
        <h1>Docentes SIIS</h1>
        <br>
        <!-- Buscador por nombre -->
        <form class="d-flex float-right">
            <h4>
            Buscar por N° de documento:
            <input name="n_cedula"  type="search" placeholder="N° de documento" aria-label="Search">
            <x-jet-button class="ml-4"> 
                {{ __('Buscar') }}
            </x-jet-button>  
        </form>
        <!-- Buscador por nombre -->
        <form class="d-flex float-right">
            <h4>
            Buscar por lugar de trabajo:
            <input name="buscador"  type="search" placeholder="Lugar de trabajo" aria-label="Search">
            <x-jet-button class="ml-4"> 
                {{ __('Buscar') }}
            </x-jet-button>  
        </form>
        </h4>
        <br><br>
        <p class="card-text">Clic sobre cada uno de los perfiles de docentes para editar o eliminarlos:</p>
        <br>
        @if ($docentes->count())
        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4">
            @foreach ($docentes as $docente)
                <div class="bg-blue-100 border-4">
                    <a href="{{route('docentes.show', $docente)}}">
                        <center>{{$docente->name}}</center>
                        <center>{{$docente->lugar_trabajo}}</center>
                    </a> 
                </div>    
            @endforeach
        </div>
        {{$docentes->links()}} 
        @else 
            <div class="card-body">
                <strong>No hay registros.</strong>
            </div>
        @endif
        
    </div> 

</x-app-layout>    