<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Editar firma') }}
        </h2> 
    </x-slot> 
    <div class="container">
        <form  action="{{route('firmas.update', $firma)}}" method="POST" enctype="multipart/form-data" name='inscripcion'>
            <!-- token para seguridad, con la directiva de blade -->
            @csrf 
            <!-- directiva con el metodo put -->
            @method('put')
            <table class='table w-full border-separate table-bordered'>
                <tbody>
                    
                    
                        <tr> 
                            <th colspan="2">
                                Titular de la firma:<br>
                                <select name="titular_firma" id="titular_firma">
                                    <option>{{$firma->titular_firma}}</option>
                                    <option value="Secretario(a)">Secretario(a) del Despacho</option>
                                    <option value="Coordiandor(a)">Coordinador(a)</option>
                                    <option value="Alcalde">Alcalde</option>
                                    <option value="Alcaldesa">Alcaldesa</option>
                                </select>
            
                                @error('titular_firma')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>
                            <th> 
                                <label>
                                    Firma digital:value="{{$firma->archivo}}"<br>
                                    <input type="file" name='archivo' id="archivo"   accept="file/*">
                                </label>
                                @error('archivo')
                                    <br>
                                    <small>*{{$message}}</small>
                                    <br>
                                @enderror
                        
                            </th>
                        </tr>
    
                        
                        <tr>
                            <th colspan="3">
                                <center>
                                    <x-jet-button class="ml-4" onclick="pregunta(event)">
                                        {{ __('Guardar registro') }}
                                    </x-jet-button>
                                </center>
                            </th>
                        </tr>
                        <br>

                </table>         
        </form>
    </div>
<!-- Confirmar envio del formulario   -->
<script>
    function pregunta(e){
        if (confirm('¿Esta seguro(a) de guardar la actualización en la firma digital?')){
           document.inscripcion.submit()
        }
        else{
            e.preventDefault();
            }
        
    }
</script>
</x-app-layout>
