<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Firma Secretaría de Salud') }}
        </h2>
    </x-slot>  
    <style>
        .imagenppl{
            background-image: url("{{asset('imagenes/logo secretaria de salud publica_Mesa de trabajo 1.png')}}");
            height: 20%; 
            width: 70%;
            margin-left: auto; 
            margin-right: auto;
            background-size: 100% 100%;
            background-repeat: no-repeat;
        }  
    </style>
    <style>  
        .img{
             
            height: 50px;
            width: 500px; 
            margin-left: auto; 
            margin-right: auto;
        } 
    </style>
     
    <div class="container">
        <h1>Firmas de la Secretaría de Salud</h1>
        
            <br>

        @if ($firmas->count())
            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4">
                @foreach ($firmas as $firma)
                    <div class="bg-blue-100 border-4">
                        <form action="{{route('firmas.edit', $firma)}}" method="POST">
                            <!-- token para seguridad, con la directiva de blade -->
                            @csrf
                            <!-- metódo PUT  -->
                            @method('get')
                            @foreach ($firmas as $firma)
                               {{$firma->titular_firma}}
                               <img src="{{asset($firma->archivo)}}" alt="" class="img bg-fixed border-2 border-blue-200 bg-clip-content">
                               <input type="hidden" name="id" value="{{$firma->id}}">
                            @endforeach
                                <x-jet-button class="ml-4">
                                    {{ __('Editar') }}
                                </x-jet-button> 
                        </form>
                        <br>
                        <form name="form" action="{{route('firmas.destroy', $firma)}}"" method="post">
                            @csrf
                            @method('delete')
                            <input type="hidden" name="id" value="{{$firma->id}}">
                            <x-jet-danger-button class="ml-4" onclick="pregunta(event)">
                                {{ __('Eliminar') }}
                            </x-jet-danger-button> 
                        </form>       
                    </div>    
                @endforeach
            </div>
            {{$firmas->links()}} 
            @else 
                <div class="card-body">
                    <strong>No hay registros.</strong>
                    <br>
                    <a href="{{route('firmas.create')}}">
                        <button class="btn btn-primary" type="submit">Ingresar firma</button>
                    </a>
                </div>
            @endif


    </div>
<!-- Confirmar envio del formulario   -->
<script>
    function pregunta(e){
        if (confirm('¿Esta seguro(a) de eliminar la firma digital?')){
           document.form.submit()
        }
        else{
            e.preventDefault();
            }
        
    }
</script>
</x-app-layout>