<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Editar manual') }}
        </h2> 
    </x-slot> 
    <div class="container">
        
            <form  action="{{route('manuals.update', $manuals)}}" method="POST" enctype="multipart/form-data" name='inscripcion'>
            @csrf 
            <!-- directiva con el metodo put -->
            @method('put')
            <table class='table w-full border-separate table-bordered'>
                <tbody>
                    Fecha ingreso: {{$manuals->created_at}}
                    <br>
                    <h1>Manual del perfil {{$manuals->perfil}}</h1>
                    <br>
                    <tr> 
                        <th colspan="2"> 
                            Perfil:<br>
                            <select name="perfil" id="perfil" value="{{old('perfil' , $manuals->perfil)}}">
                                <option>{{old('perfil', $manuals->perfil)}}</option>
                                <option value="Admin">Admin</option>
                                <option value="Docente">Docente</option>
                                <option value="Estudiante">Estudiante</option>
                                <option value="Estudiante_privado">Estudiante (cursos privados)</option>
                            </select>
        
                            @error('perfil')
                                <br>
                                    <small>*{{$message}}</small>
                                <br>
                            @enderror
                        </th>
                        <th> 
                            <label>
                                Manual:{{$manuals->archivo}}<br>
                                <input type="file" name='archivo' id="archivo"  value="{{old('archivo' , $manuals->archivo)}}" accept="file/*">
                            </label>
                            @error('archivo')
                                <br>
                                <small>*{{$message}}</small>
                                <br>
                            @enderror
                    
                        </th>

                    <tr>
                        <th colspan="3">
                            <center>
                                <x-jet-button class="ml-4" onclick="pregunta(event)">
                                    {{ __('Guardar registro') }}
                                </x-jet-button>
                            </center>
                        </th>
                    </tr>
                </table>         
        </form>
    </div>
<!-- Confirmar envio del formulario   -->
<script>
    function pregunta(e){
        if (confirm('¿Esta seguro(a) de guardar la actualización del manual de usuario?')){
           document.inscripcion.submit()
        }
        else{
            e.preventDefault();
            }
        
    }
</script>    
</x-app-layout>
