<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Lista de matriculas del estudiante') }}
        </h2>
    </x-slot>  
    <style>
        .imagenppl{
            background-image: url("{{asset('imagenes/logo secretaria de salud publica_Mesa de trabajo 1.png')}}");
            height: 20%; 
            width: 70%;
            margin-left: auto; 
            margin-right: auto;
            background-size: 100% 100%;
            background-repeat: no-repeat;
        }   
    </style>
     
    <div class="container">
        <h1>Editar matriculas SIIS</h1>
        <br>
        <!-- Buscador por número de documento -->
        <form class="d-flex float-left">
            <h4>
            Consultar por N° de documento:
            <input name="n_cedula"  type="search" placeholder="N° de documento" aria-label="Search">
            <x-jet-button class="ml-4"> 
                {{ __('Consultar') }}
            </x-jet-button>  
        </form>
        <br><br>
        @if ($matriculas->count())
        
            <center>
                <div class="parrafo">
                    <table id="parrafo" border="1" cellspacing="1" class="border-2 border-black">
                        <thead> 
                            <tr>
                                <th colspan="4">
                                    <img src="{{asset('imagenes/logo_certificado.jpg')}}" class="imagenppl" alt="">
                                </th> 
                              </tr>
                        </thead>  
                        <tbody> 
                                <tr class="border-black px-4 py-4 border-2">
                                    <th>
                                        <p>Estudiante: {{$estudiantes->name}}</p>
                                    </th>
                                </tr>
                                <tr  class="border-black px-4 py-4 border-2">
                                    <th>
                                        <p>Número de documento: {{number_format($estudiantes->cedula, 0, '.', '.')}}</p>
                                    </th>   
                                </tr>
                                 <tr class="border-black px-4 py-4 border-2 bg-blue-200">
                                     <th class="border-black px-4 py-4 border-2 bg-blue-200"><p>Inscripciones del estudiante</p></th>
                                 </tr>
                                
                                    @foreach ($matriculas as $matricula)
                                        <tr>
                                            <th class="border-black px-4 py-4 border-2">
                                                <a href="{{route('matriculas.show', $matricula)}}"> 
                                                    {{$matricula->titulo_curso}}
                                                </a>
                                            </th>
{{-- 
                                            <th>
                                                {{$matricula->id}}
                                            </th> --}}
                                        </tr>   
                                    @endforeach 
                                    
                                     
                                     
                                
                                
                                <tr>
                                    <td colspan="4">
                                        <img src="{{asset('imagenes/logo_certificado_footer.png')}}" class="imagenppl" alt="">
                                    </td>
                                  </tr>
                            </tbody>
                        </table>
                    </div> 
                </center>  
                <br>
                <center>
                    <table>
                        <tr>
                            <th>
                                <button class="btn btn-info" id="btnImprimir" value="">Descargar o Imprimir</button>
                            </th>
                            <th>
                                <button class="btn btn-success" onclick="exportTableToExcel('parrafo')">Exportar a Excel</button>
                            </th>
                        </tr>
                    </table>
                </center>
            
        
        {{$matriculas->links()}} 
        @else 
            <div class="card-body">
                <strong>No hay registros.</strong>
            </div>
        @endif


    <!--Script para exportar la tabla a excel-->    
    <script language="javascript">
        function exportTableToExcel(tableID, filename = ''){
            var downloadLink;
            var dataType = 'application/vnd.ms-excel';
            var tableSelect = document.getElementById(tableID);
            var tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');
            
            // Specify file name
            filename = filename?filename+'.xls':'excel_data.xls';
            
            // Create download link element
            downloadLink = document.createElement("a");
            
            document.body.appendChild(downloadLink);
            
            if(navigator.msSaveOrOpenBlob){
                var blob = new Blob(['ufeff', tableHTML], {
                    type: dataType
                });
                navigator.msSaveOrOpenBlob( blob, filename);
            }else{
                // Create a link to the file
                downloadLink.href = 'data:' + dataType + ', ' + tableHTML;
            
                // Setting the file name
                downloadLink.download = filename;
                
                //triggering the function
                downloadLink.click();
            }
        }
    </script>

        
 
</x-app-layout>      