<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Editar módulo') }}
        </h2> 
    </x-slot> 
    <div class="container">
        
            <form  action="{{route('modulos.update', $modulo)}}" method="POST" enctype="multipart/form-data" name='inscripcion'>
            @csrf
            <!-- directiva con el metodo put -->
            @method('put')
            <table class='table w-full border-separate table-bordered'>
                <tbody>
                    Fecha creación: {{$modulo->created_at}}
                        <tr>  
                            <th colspan="2">
                                <label>
                                    Titulo del modulo:<br>
                                    <input type="text" name='titulo_modulo' id="titulo_modulo"  value="{{$modulo->titulo_modulo}}"  size=90 style='text-align: center' style="width:650px">
                                </label>
                                    @error('titulo_modulo')
                                        <br>
                                        <small>*{{$message}}</small>
                                        <br>
                                    @enderror
                            </th>
                            </tr>
                            <tr>
                            <th colspan="2"> 
                                <label>
                                    
                                    Archivo actual:
                                    <embed src="{{asset($modulo->archivo)}}" width="1200" height="400" >
                                    <br>
                                    Archivo nuevo: <small>(Preferiblemente formato PDF)(Tamaño máximo del archivo: 15 MB)</small>
                                    <input type="file" name='archivo' id="archivo" value="{{old('archivo' , $modulo->archivo)}}"  accept="file/*">
                                </label>
                                @error('archivo')
                                    <br>
                                    <small>*{{$message}}</small>
                                    <br>
                                @enderror
                        
                            </th>
                        </tr>
                        <tr>
                            <th>
                                <label>
                                    Enlace de video:<br>
                                    <textarea name="enlace_video" id="enlace_video" rows="10" cols="60">
                                        {{old('enlace_video', $modulo->enlace_video)}}
                                    </textarea>
                                </label>
                        
                                @error('enlace_video')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>
                            <th>
                                <label>
                                    Enlace de video 2:<br>
                                    <textarea name="enlace_video2" id="enlace_video2" rows="10" cols="60">
                                        {{old('enlace_video2', $modulo->enlace_video2)}}
                                    </textarea>
                                </label>
                        
                                @error('enlace_video2')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>
                        </tr>
                        <tr>
                            <th>
                                <label>
                                    Enlace de video 3:<br>
                                    <textarea name="enlace_video3" id="enlace_video3" rows="10" cols="60">
                                        {{old('enlace_video3', $modulo->enlace_video3)}}
                                    </textarea>
                                </label>
                        
                                @error('enlace_video3')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>
                            <th>
                                <label>
                                    Enlace de video 4:<br>
                                    <textarea name="enlace_video4" id="enlace_video4" rows="10" cols="60">
                                        {{old('enlace_video4', $modulo->enlace_video4)}}
                                    </textarea>
                                </label>
                        
                                @error('enlace_video4')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>
                        </tr>
                        <tr>
                            
                            <th colspan='2'>
                                <label>
                                    Descripción:<br>
                                    <textarea name="descripcion" id=""  rows="12" cols="120">
                                        {{old('descripcion', $modulo->descripcion)}}
                                    </textarea>
                                </label>
                         
                                @error('descripcion')
                                    <br>
                                        <small>*{{$message}}</small>
                                    <br>
                                @enderror
                            </th>  
                            <input type="hidden" name="responsable" value="{{ auth()->user()->cedula }}"> 
                        </tr>
                        <tr>
                            <th colspan="2">
                                <center>
                                    <x-jet-button class="ml-4" onclick="pregunta(event)">
                                        {{ __('Guardar actualización') }}
                                    </x-jet-button>
                                </center>
                            </th>
                        </tr>
                        <br>
                </tbody>
            </table>         
        </form>
    </div>
<!-- Confirmar envio del formulario   -->
<script>
    function pregunta(e){
        if (confirm('¿Esta seguro(a) de guardar la actualización del modulo?')){
           document.inscripcion.submit()
        }
        else{
            e.preventDefault();
            }
        
    }
</script>    
</x-app-layout>
