<nav x-data="{ open: false }" class="bg-white border-b border-gray-100">
    <!-- Primary Navigation Menu -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="flex-shrink-0 flex items-center">
                    <a href="{{ route('dashboard') }}">
                        <x-jet-application-mark class="block h-9 w-auto" />
                    </a>
                </div>

                <!-- Navigation Links -->
               {{--  <div class="hidden space-x-8 sm:-my-px sm:ml-10 sm:flex">
                    <x-jet-nav-link href="{{ route('dashboard') }}" :active="request()->routeIs('dashboard')">
                        {{ __('Inicio') }}
                    </x-jet-nav-link>
                </div> --}}
                <!-- Cursos  -->
                <div class="hidden sm:flex sm:items-center sm:ml-6">
                   
                        <div class="ml-3 relative">
                            <x-jet-dropdown align="right" width="60">
                                <x-slot name="trigger">
                                    <span class="inline-flex rounded-md">
                                      
                                        <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-2xl leading-4 font-medium rounded-md text-gray-500 bg-white hover:bg-gray-50 hover:text-blue-600 focus:outline-none focus:bg-gray-50 active:bg-gray-50 transition">
                                            {{ 'Cursos' }}
    
                                            <svg class="ml-2 -mr-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                    </span>
                                </x-slot>
    
                                <x-slot name="content">
                                    <div class="w-60"> 
                                        
                                        <div class="block px-4 py-2 text-xs text-gray-400">
                                            {{ __('Administrar Cursos públicos') }}
                                        </div>
    
                                        @can('cursos.create')
                                            <x-jet-dropdown-link href="{{ route('cursos.create') }}">
                                                {{ __('Crear Curso') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('modulos.create')
                                            <x-jet-dropdown-link href="{{ route('modulos.create') }}">
                                                {{ __('Crear módulos') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('modulos.index')
                                            <x-jet-dropdown-link href="{{ route('modulos.index') }}">
                                                {{ __('Lista de módulos') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('pruebas.create')
                                            <x-jet-dropdown-link href="{{ route('pruebas.create') }}">
                                                {{ __('Crear exámenes') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('lista_cursos.index')
                                            <x-jet-dropdown-link href="{{ route('lista_cursos.index') }}">
                                                {{ __('Lista de cursos') }}
                                            </x-jet-dropdown-link>
                                        @endcan
                                        @can('cursos.index')
                                        <x-jet-dropdown-link href="{{ route('cursos.index') }}">
                                            {{ __('Mis cursos') }}
                                        </x-jet-dropdown-link>
                                        @endcan
                                        @can('certificados.index')
                                        <x-jet-dropdown-link href="{{ route('certificados.index') }}">
                                            {{ __('Certificados') }}
                                        </x-jet-dropdown-link>
                                        @endcan
                                        <div class="border-t border-gray    -100"></div>
                                    </div>
                                </x-slot>
                            </x-jet-dropdown>
                        </div>
                   
                </div>
                
                <!-- Docentes Dropdown -->
                <div class="hidden sm:flex sm:items-center sm:ml-6">
                    @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())
                        <div class="ml-3 relative">
                            <x-jet-dropdown align="right" width="60">
                                <x-slot name="trigger">
                                    <span class="inline-flex rounded-md">
                                        @can('docentes.create')
                                        <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-2xl leading-4 font-medium rounded-md text-gray-500 bg-white hover:bg-gray-50 hover:text-yellow-600 focus:outline-none focus:bg-gray-50 active:bg-gray-50 transition">
                                            {{ 'Docentes' }}
    
                                            <svg class="ml-2 -mr-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        @endcan
                                    </span>
                                </x-slot>
    
                                <x-slot name="content">
                                    <div class="w-60"> 
                                        
                                        <div class="block px-4 py-2 text-xs text-gray-400">
                                            {{ __('Administrar Docentes') }}
                                        </div>
                                        
    
                                        @can('docentes.create')
                                            <x-jet-dropdown-link href="{{ route('docentes.create') }}">
                                                {{ __('Ingresar docente') }}
                                            </x-jet-dropdown-link>
                                        @endcan
    
                                        @can('docentes.index')
                                            <x-jet-dropdown-link href="{{ route('docentes.index') }}">
                                                {{ __('Editar docente') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('lista_docentes.index')
                                            <x-jet-dropdown-link href="{{ route('lista_docentes.index') }}">
                                                {{ __('listas de docentes') }}
                                            </x-jet-dropdown-link>
                                        @endcan

    
                                        <div class="border-t border-gray    -100"></div>
                                    </div>
                                </x-slot>
                            </x-jet-dropdown>
                        </div>
                    @endif
                </div>

                <!-- Estudiantes Dropdown -->
                <div class="hidden sm:flex sm:items-center sm:ml-6">
                    @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())
                        <div class="ml-3 relative">
                            <x-jet-dropdown align="right" width="60">
                                <x-slot name="trigger">
                                    <span class="inline-flex rounded-md">
                                        @can('lista_estudiantes_cursos.index')
                                        <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-2xl leading-4 font-medium rounded-md text-gray-500 bg-white hover:bg-gray-50 hover:text-yellow-600 focus:outline-none focus:bg-gray-50 active:bg-gray-50 transition">
                                            {{ 'Estudiantes' }}
    
                                            <svg class="ml-2 -mr-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                        @endcan
                                    </span>
                                </x-slot>
    
                                <x-slot name="content">
                                    <div class="w-60"> 
                                        
                                        <div class="block px-4 py-2 text-xs text-gray-400">
                                            {{ __('Administrar Estudiantes') }}
                                        </div>
                                        
                                        @can('lista_estudiantes_cursos.index')
                                            <x-jet-dropdown-link href="{{ route('lista_usuarios.index') }}">
                                                {{ __('Total registrados') }}
                                            </x-jet-dropdown-link>
                                        @endcan
                                        
                                        @can('lista_estudiantes_cursos.index')
                                            <x-jet-dropdown-link href="{{ route('lista_numero_certificaciones.index') }}">
                                                {{ __('N° de certificaciones por usuario') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('estudiantes.create')
                                            <x-jet-dropdown-link href="{{ route('estudiantes.create') }}">
                                                {{ __('Ingresar estudiantes CP') }}
                                            </x-jet-dropdown-link>
                                        @endcan
     
                                        @can('estudiantes.index')
                                            <x-jet-dropdown-link href="{{ route('estudiantes.index') }}">
                                                {{ __('Editar estudiante') }}
                                            </x-jet-dropdown-link>
                                        @endcan
 
                                        @can('matricula_cursos_privados.index')
                                            <x-jet-dropdown-link href="{{route('matricula_cursos_privados.index')}}">
                                                {{ __('Inscribir a cursos privados') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('matriculas.index')
                                            <x-jet-dropdown-link href="{{route('matriculas.index')}}">
                                                {{ __('Editar matriculas') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('lista_estudiantes_cursos.index')
                                            <x-jet-dropdown-link href="{{ route('lista_estudiantes_cursos.index') }}">
                                                {{ __('Listado de estudiantes por curso') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('constancias.index')
                                            <x-jet-dropdown-link href="{{ route('constancias.index') }}">
                                                {{ __('Listas de estudiantes certificados') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                     
                                            <x-jet-dropdown-link href="{{route('certificos.index')}}">
                                                {{ __('Certificados de estudiantes') }}
                                            </x-jet-dropdown-link>

                                        <div class="border-t border-gray-100"></div>
                                    </div>
                                </x-slot>
                            </x-jet-dropdown>
                        </div>
                    @endif
                </div>

                <!-- Manuales Dropdown -->
                <div class="hidden sm:flex sm:items-center sm:ml-6">
                    @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())
                        <div class="ml-3 relative">
                            <x-jet-dropdown align="right" width="60">
                                <x-slot name="trigger">
                                    <span class="inline-flex rounded-md">
                                       
                                        <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-2xl leading-4 font-medium rounded-md text-gray-500 bg-white hover:bg-gray-50 hover:text-yellow-600 focus:outline-none focus:bg-gray-50 active:bg-gray-50 transition">
                                            {{ 'Instructivo' }}
    
                                            <svg class="ml-2 -mr-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </button>
                                      
                                    </span>
                                </x-slot>
    
                                <x-slot name="content">
                                    <div class="w-60"> 
                                        
                                        <div class="block px-4 py-2 text-xs text-gray-400">
                                            {{ __('Administrar manuales de usuario') }}
                                        </div>
    
                                        @can('manuals.index')
                                            <x-jet-dropdown-link href="{{route('manuals.index')}}">
                                                {{ __('Manuales de usuario') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('manualestudianteprivados.index')
                                            <x-jet-dropdown-link href="{{route('manualestudianteprivados.index')}}">
                                                {{ __('Mi manual') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('manualestudiantes.index')
                                            <x-jet-dropdown-link href="{{route('manualestudiantes.index')}}">
                                                {{ __('Mi manual') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('manualdocentes.index')
                                            <x-jet-dropdown-link href="{{route('manualdocentes.index')}}">
                                                {{ __('Mi manual') }}
                                            </x-jet-dropdown-link>
                                        @endcan

                                        @can('firmas.index')
                                            <x-jet-dropdown-link href="{{route('firmas.index')}}">
                                                {{ __('Firma Secretaría') }}
                                            </x-jet-dropdown-link>
                                        @endcan
    
    

                                        <div class="border-t border-gray    -100"></div>
                                    </div>
                                </x-slot>
                            </x-jet-dropdown>
                        </div>
                    @endif
                </div>

            </div>

            <div class="hidden sm:flex sm:items-center sm:ml-6">
                <!-- Teams Dropdown -->
                {{-- @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())
                    <div class="ml-3 relative">
                        <x-jet-dropdown align="right" width="60">
                            <x-slot name="trigger">
                                <span class="inline-flex rounded-md">
                                    <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:bg-gray-50 hover:text-gray-700 focus:outline-none focus:bg-gray-50 active:bg-gray-50 transition">
                                        {{ Auth::user()->currentTeam->name }}

                                        <svg class="ml-2 -mr-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M10 3a1 1 0 01.707.293l3 3a1 1 0 01-1.414 1.414L10 5.414 7.707 7.707a1 1 0 01-1.414-1.414l3-3A1 1 0 0110 3zm-3.707 9.293a1 1 0 011.414 0L10 14.586l2.293-2.293a1 1 0 011.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                </span>
                            </x-slot>

                            <x-slot name="content">
                                <div class="w-60">
                                    <!-- Team Management -->
                                    <div class="block px-4 py-2 text-xs text-gray-400">
                                        {{ __('Manage Team') }}
                                    </div>

                                    <!-- Team Settings -->
                                    <x-jet-dropdown-link href="{{ route('teams.show', Auth::user()->currentTeam->id) }}">
                                        {{ __('Team Settings') }}
                                    </x-jet-dropdown-link>

                                    @can('create', Laravel\Jetstream\Jetstream::newTeamModel())
                                        <x-jet-dropdown-link href="{{ route('teams.create') }}">
                                            {{ __('Create New Team') }}
                                        </x-jet-dropdown-link>
                                    @endcan

                                    <div class="border-t border-gray-100"></div>

                                    <!-- Team Switcher -->
                                    <div class="block px-4 py-2 text-xs text-gray-400">
                                        {{ __('Switch Teams') }}
                                    </div>

                                    @foreach (Auth::user()->allTeams() as $team)
                                        <x-jet-switchable-team :team="$team" />
                                    @endforeach
                                </div>
                            </x-slot>
                        </x-jet-dropdown>
                    </div>
                @endif --}}

                <!-- Settings Dropdown -->
                <div class="ml-3 relative">
                    <x-jet-dropdown align="right" width="48">
                        <x-slot name="trigger">
                            @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                                <button class="flex text-sm border-2 border-transparent rounded-full focus:outline-none focus:border-gray-300 transition">
                                    <img class="h-8 w-8 rounded-full object-cover" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />
                                </button>
                            @else
                                <span class="inline-flex rounded-md">
                                    <button type="button" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:text-gray-700 focus:outline-none transition">
                                        {{ Auth::user()->name }}

                                        <svg class="ml-2 -mr-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                </span>
                            @endif
                        </x-slot>

                        <x-slot name="content">
                            <!-- Account Management -->
                            <div class="block px-4 py-2 text-xs text-gray-400">
                                {{ __('Administrar cuenta') }}
                            </div>

                            <x-jet-dropdown-link href="{{ route('profile.show') }}">
                                {{ __('Perfil') }}
                            </x-jet-dropdown-link>

                            @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                                <x-jet-dropdown-link href="{{ route('api-tokens.index') }}">
                                    {{ __('API Tokens') }}
                                </x-jet-dropdown-link>
                            @endif

                            <div class="border-t border-gray-100"></div>

                            <!-- Authentication -->
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf

                                <x-jet-dropdown-link href="{{ route('logout') }}"
                                         onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                    {{ __('Cerrar sesión') }}
                                </x-jet-dropdown-link>
                            </form>
                        </x-slot>
                    </x-jet-dropdown>
                </div>
            </div>

            <!-- Hamburger -->
            <div class="-mr-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 focus:text-gray-500 transition">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            @can('manualestudiantes.index')
                <x-jet-responsive-nav-link href="{{route('manualestudiantes.index')}}" class="{{request()->routeIs('manualestudiantes.*') ? 'active' : ''}}">
                    Instructivo
                </x-jet-responsive-nav-link>
            @endcan
            @can('cursos.create')
                <x-jet-responsive-nav-link href="{{route('cursos.create')}}" class="{{request()->routeIs('cursos.*') ? 'active' : ''}}">
                    Crear curso
                </x-jet-responsive-nav-link>
            @endcan
            @can('modulos.create')
                <x-jet-responsive-nav-link href="{{route('modulos.create')}}" class="{{request()->routeIs('modulos.*') ? 'active' : ''}}">
                    Crear módulo
                </x-jet-responsive-nav-link>
            @endcan
            @can('pruebas.create')
                <x-jet-responsive-nav-link href="{{route('pruebas.create')}}" class="{{request()->routeIs('pruebas.*') ? 'active' : ''}}">
                    Crear exámen
                </x-jet-responsive-nav-link> 
            @endcan
            @can('lista_cursos.index')
                <x-jet-responsive-nav-link href="{{route('lista_cursos.index')}}" class="{{request()->routeIs('lista_cursos.*') ? 'active' : ''}}">
                    Lista Cursos
                </x-jet-responsive-nav-link>
            @endcan
            @can('cursos.index')
                <x-jet-responsive-nav-link href="{{route('cursos.index')}}" class="{{request()->routeIs('cursos.*') ? 'active' : ''}}">
                    Cursos
                </x-jet-responsive-nav-link>
            @endcan
            @can('certificados.index')
                <x-jet-responsive-nav-link href="{{route('certificados.index')}}" class="{{request()->routeIs('cursos.*') ? 'active' : ''}}">
                    Certificados
                </x-jet-responsive-nav-link>
            @endcan
            @can('docentes.create')
                <x-jet-responsive-nav-link href="{{route('docentes.create')}}" class="{{request()->routeIs('docentes.*') ? 'active' : ''}}">
                    Ingresar docente
                </x-jet-responsive-nav-link>
            @endcan
            @can('docentes.index')
                <x-jet-responsive-nav-link href="{{route('docentes.index')}}" class="{{request()->routeIs('docentes.*') ? 'active' : ''}}">
                    Docentes
                </x-jet-responsive-nav-link>
            @endcan
            @can('lista_docentes.index')
                <x-jet-responsive-nav-link href="{{route('lista_docentes.index')}}" class="{{request()->routeIs('lista_docentes.*') ? 'active' : ''}}">
                    Listas de docentes
                </x-jet-responsive-nav-link>
            @endcan

            @can('estudiantes.create')
                <x-jet-responsive-nav-link href="{{route('estudiantes.create')}}" class="{{request()->routeIs('estudiantes.*') ? 'active' : ''}}">
                    Ingresar estudiante CP
                </x-jet-responsive-nav-link>
            @endcan

            @can('matricula_cursos_privados.index')
                <x-jet-responsive-nav-link href="{{route('matricula_cursos_privados.index')}}" class="{{request()->routeIs('matricula_cursos_privados.*') ? 'active' : ''}}">
                    Incribir a cursos privados
                </x-jet-responsive-nav-link>
            @endcan

            @can('lista_estudiantes_cursos.index')
                <x-jet-responsive-nav-link href="{{route('lista_estudiantes_cursos.index')}}" class="{{request()->routeIs('lista_estudiantes_cursos.*') ? 'active' : ''}}">
                    Listado de estudiantes por curso
                </x-jet-responsive-nav-link>
            @endcan

            @can('constancias.index')
                <x-jet-responsive-nav-link href="{{route('constancias.index')}}" class="{{request()->routeIs('constancias.*') ? 'active' : ''}}">
                    Lista de estudiantes certificados
                </x-jet-responsive-nav-link>
            @endcan

            @can('estudiantes.index')
                <x-jet-responsive-nav-link href="{{route('estudiantes.index')}}" class="{{request()->routeIs('estudiantes.*') ? 'active' : ''}}">
                    Estudiantes
                </x-jet-responsive-nav-link>
            @endcan

            <x-jet-responsive-nav-link href="{{ route('dashboard') }}" :active="request()->routeIs('dashboard')">
                {{ __('Inicio') }}
            </x-jet-responsive-nav-link>
        </div>

        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-gray-200">
            <div class="flex items-center px-4">
                @if (Laravel\Jetstream\Jetstream::managesProfilePhotos())
                    <div class="flex-shrink-0 mr-3">
                        <img class="h-10 w-10 rounded-full object-cover" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />
                    </div>
                @endif

                <div>
                    <div class="font-medium text-base text-gray-800">{{ Auth::user()->name }}</div>
                    <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
                </div>
            </div>

            <div class="mt-3 space-y-1">
                <!-- Account Management -->
                <x-jet-responsive-nav-link href="{{ route('profile.show') }}" :active="request()->routeIs('profile.show')">
                    {{ __('Perfil') }}
                </x-jet-responsive-nav-link>

                @if (Laravel\Jetstream\Jetstream::hasApiFeatures())
                    <x-jet-responsive-nav-link href="{{ route('api-tokens.index') }}" :active="request()->routeIs('api-tokens.index')">
                        {{ __('API Tokens') }}
                    </x-jet-responsive-nav-link>
                @endif

                <!-- Authentication -->
                <form method="POST" action="{{ route('logout') }}">
                    @csrf

                    <x-jet-responsive-nav-link href="{{ route('logout') }}"
                                   onclick="event.preventDefault();
                                    this.closest('form').submit();">
                        {{ __('Cerrar sesión') }}
                    </x-jet-responsive-nav-link>
                </form>

                <!-- Team Management -->
                {{-- @if (Laravel\Jetstream\Jetstream::hasTeamFeatures())
                    <div class="border-t border-gray-200"></div>

                    <div class="block px-4 py-2 text-xs text-gray-400">
                        {{ __('Manage Team') }}
                    </div>

                    <!-- Team Settings -->
                    <x-jet-responsive-nav-link href="{{ route('teams.show', Auth::user()->currentTeam->id) }}" :active="request()->routeIs('teams.show')">
                        {{ __('Team Settings') }}
                    </x-jet-responsive-nav-link>

                    @can('create', Laravel\Jetstream\Jetstream::newTeamModel())
                        <x-jet-responsive-nav-link href="{{ route('teams.create') }}" :active="request()->routeIs('teams.create')">
                            {{ __('Create New Team') }}
                        </x-jet-responsive-nav-link>
                    @endcan

                    <div class="border-t border-gray-200"></div>

                    <!-- Team Switcher -->
                    <div class="block px-4 py-2 text-xs text-gray-400">
                        {{ __('Switch Teams') }}
                    </div>

                    @foreach (Auth::user()->allTeams() as $team)
                        <x-jet-switchable-team :team="$team" component="jet-responsive-nav-link" />
                    @endforeach
                @endif --}}
            </div>
        </div>
    </div>
</nav>
