<?php

use App\Http\Controllers\CertificadoController;
use App\Http\Controllers\CertificadoUAMController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\http\Controllers\CursoController;
use App\Http\Controllers\ModuloController;
use App\http\Controllers\DocenteController;
use App\Http\Controllers\EstudianteController;
use App\Http\Controllers\MatriculaController;
use App\Http\Controllers\NotaController;
use App\Http\Controllers\PruebaController;
use App\Http\Controllers\ConstanciaController;
use App\Http\Controllers\CertificaController;
use App\Http\Controllers\InformacioneController;
use App\Http\Controllers\CertificoController;
use App\Http\Controllers\CertificoUAMController;
use App\Http\Controllers\lista_cursoController;
use App\Http\Controllers\lista_docenteController;
use App\Http\Controllers\lista_estudiantes_cursoController;
use App\Http\Controllers\Matricula_cursos_privadosController;
use App\Http\Controllers\Auth\NewPasswordController;
use App\Http\Controllers\Editar_matricula_Controller;
use App\Http\Controllers\FirmaController;
use App\Http\Controllers\ManualController;
use App\Http\Controllers\ManualdocenteController;
use App\Http\Controllers\ManualestudianteController;
use App\Http\Controllers\ManualestudianteprivadoController;
use App\Http\Controllers\ManualusuarioController;
use App\Http\Controllers\ContactanosController;
use App\Http\Controllers\Certifica_UAMController;
use App\Http\Controllers\Lista_usuariosController;
use App\Http\Controllers\Lista_numero_certificacioneController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', HomeController::class)->name('inicio');

 
/*1 Ruta para los cursos   */
Route::resource('cursos', App\Http\Controllers\CursoController::class);

/*2 Ruta para los módulos de cada curso   */
Route::resource('modulos', ModuloController::class);

/*3 Ruta para los exámenes de cada módulo   */
Route::resource('pruebas', PruebaController::class);

/*4 Ruta para los docentes   */
Route::resource('docentes', App\Http\Controllers\DocenteController::class);

/*5 Ruta para los estudiantes   */
Route::resource('estudiantes', EstudianteController::class);

/*6 Ruta para las inscripciones */
Route::resource('matriculas', MatriculaController::class);

/*7 Ruta para el ingreso de los resultados de los exámenes y validación para los siguientes módulos */
Route::resource('notas', NotaController::class);

/*8 Ruta para mostrar los certificados de los cursos*/
Route::resource('certificados', CertificadoController::class);

//9 Rutas para que los usuarios puedan descargar sus certificados sin necesidad de acceder  al sistema
Route::resource('certificas', CertificaController::class);

//10 Rutas para que los docentes y admin puedan descargar los certificados de los estudiantes
Route::resource('certificos', CertificoController::class);


/*11 Ruta para mostrar las listas de los estudiantes certificados*/
Route::resource('constancias', ConstanciaController::class);

//12 Ruta para publicar información general de los cursos en la interfaz principal
Route::resource('informaciones', InformacioneController::class);

//13 Ruta para las lista de los estudiantes por curso
Route::resource('lista_estudiantes_cursos', lista_estudiantes_cursoController::class);

//14 Ruta para las listas de los docentes 
Route::resource('lista_docentes', lista_docenteController::class);

//15 Ruta para mostrar la lista de cursos disponibles para inscribirse
Route::get('lista_cursos', [lista_cursoController::class, 'index'])->name('lista_cursos.index');

//16 Ruta para las matriculas a cursos privados
Route::resource('matricula_cursos_privados', Matricula_cursos_privadosController::class);

//27 Ruta para Editar o eliminar las matriculas de cada estudiante
Route::resource('editar_matriculas', Editar_matricula_Controller::class);

//17 Ruta para los manuales de usuario
Route::resource('manuals', ManualController::class);

//18 Ruta para mostrar el manual de estudiante en la interfaz principal
Route::get('manualusuarios', [ManualusuarioController::class, 'index'])->name('manualusuarios.index');

//19 Ruta para mostrar el manual de estudiante de cursos privados
Route::get('manualestudianteprivados', [ManualestudianteprivadoController::class, 'index'])->name('manualestudianteprivados.index');

//20 Ruta para mostrar el manual de estudiante de cursos públicos
Route::get('manualestudiantes', [ManualestudianteController::class, 'index'])->name('manualestudiantes.index');

//21 Ruta para mostrar el manual del docente
Route::get('manualdocentes', [ManualdocenteController::class, 'index'])->name('manualdocentes.index');

//22 Ruta para la firma de Secretaría
Route::resource('firmas', FirmaController::class);

/**23 Ruta del dashboard para los cuatro perfiles*/
Route::middleware(['auth:sanctum', 'verified'])->get('/dashboard', function () {
    return view('dashboard');
})->name('dashboard');

/*24 Ruta para la interfaz de logueo */
Route::middleware(['auth:sanctum', 'verified'])->get('/logueo', function () {
    return view('logueo');
})->name('logueo');

/*25 Ruta para solicitar el reseteo de la contraseña  */
Route::get('/reset-password/{token}', [NewPasswordController::class, 'create'])->name('password.reset'); 

/*26 Ruta encargada de resetear las contraseñas */
 Route::post('/reset-password', [NewPasswordController::class, 'store'])->name('password.update');
 
 //27 Rutas para que los docentes y admin puedan descargar los certificados de los estudiantes de los cursos de la UAM
Route::resource('certifico_UAM_s', CertificoUAMController::class);

 //27 Rutas para que los estudiantes puedan descargar los certificados de los cursos de la UAM
Route::resource('certificado_UAM_s', CertificadoUAMController::class);

//28 Ruta para que los estudiantes contacten al tutor del curso
Route::get('contactanos', [ContactanosController::class, 'index'])->name('contactanos.index');

Route::post('contactanos', [ContactanosController::class, 'store'])->name('contactanos.store');

 //29 Rutas para que los docentes y admin puedan descargar los certificados de los estudiantes de los cursos de la UAM
Route::resource('certifica_UAM_s', Certifica_UAMController::class);

//30 Rutas para el listado de las personas registradas en el sistema
Route::resource('lista_usuarios', Lista_usuariosController::class);

//31 Rutas para el listado de las personas registradas con el número de certificaciones obtenidas
Route::resource('lista_numero_certificaciones', Lista_numero_certificacioneController::class);

Route::get('storage-link', function(){
     Artisan::call('storage:link');
 });

