<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        
        <title><?php echo e(config('app.name', 'Laravel')); ?></title>
        <!--  favicon --> 
        <link rel="shortcut icon" type="image/jpg" href="<?php echo e(asset('/imagenes/cropped-Logo-siis-2-32x32.png')); ?>">
        <link rel="shortcut icon" sizes="192x192" href="<?php echo e(asset('/imagenes/cropped-Logo-siis-2-32x32.png')); ?>">
            <!-- Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">

        <!-- Styles -->
        <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
        
        <!--Botón ir arriba-->
        <style>
            #button-up{
                width: 60px;
                height: 60px;
                background: #46a2fd;
                display: flex;
                justify-content: center;
                align-items: center;
                color: aliceblue;
                border-radius: 50%;
                font-size: 20px;
                position: fixed;
                bottom: 50px;
                right: 50px;
                cursor: pointer;
                border: 4px solid transparent;
                transition: all 300ms ease;
                transform: scale(0);
                }
                #button-up:hover{
                    transform: scale(1.1);
                    border-color: rgba(0, 0, 0, 0, 1);

                }
        </style>
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.2.4/jquery.min.js"></script>
        
        <style>
            /* OV PRELOADER */
            .ov-preloader {
               position: fixed;
               top: 0;
               left: 0;
               right: 0;
               bottom: 0;
               background-color: #fefefe;
               z-index: 999999;
               height: 100%;
               width: 100%;
               overflow: hidden !important;
            }
            .ov-preloader .ov-icon {
               position: fixed;
                left: 0px;
                top: 0px;
                width: 100%;
                height: 100%;
                z-index: 9999;
                background: url("<?php echo e(asset('imagenes/cargando.gif')); ?>") 50% 50% no-repeat rgb(249,249,249);
                opacity: .8;
            }
        </style>

         
    </head>
    <body bgcolor='#FFFFFF'>
        <!-- Boton hacia arriba -->
        <div id="button-up">
            <i class="fas fa-chevron-up"></i>
        </div>
        
        <div class="ov-preloader">
            <div class="ov-icon"></div>
        </div>
        
        <div class="font-sans text-gray-900 antialiased">
            <?php echo e($slot); ?>

            
        </div>

        <!-- footer -->
       <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
       

        <!-- Scripts -->
        <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
        <script type="text/javascript" src="<?php echo e(asset('js/tiempo.js')); ?>" defer></script>
        <script type="text/javascript" src="<?php echo e(asset('js/imprimir.js')); ?>" defer></script>
        <script type="text/javascript" src="<?php echo e(asset('js/ficheroexcel.js')); ?>" defer></script>
        <script src="https://kit.fontawesome.com/41bcea2ae3.js" crossorigin="anonymous"></script>
        <script>
            document.getElementById("button-up").addEventListener("click", scrollUp);

            function scrollUp(){
                var currentScroll = document.documentElement.scrollTop;
                if(currentScroll > 0){
                    window.requestAnimationFrame(scrollUp);
                    window.scrollTo(0, currentScroll - (currentScroll / 10));
                    buttonUp.style.transform = "scale(0)";
                }
            }

            buttonUp = document.getElementById("button-up");
            window.onscroll = function(){
                var scroll = document.documentElement.scrollTop;
                if(scroll > 200){
                    buttonUp.style.transform = "scale(1)";
                }else if(scroll < 200){
                    buttonUp.style.transform = "scale(0)";
                }
            }
        </script>
        <!-- script para el precargador -->          
            <script type="text/javascript">
                // Asegurarse que todo el sitio est cargado
                jQuery(window).load(function () {
                    "use strict";
                    // Se desvanece la animacin con el icono
            	    if(jQuery( '.et-bfb' ).length <= 0 && jQuery( '.et-fb' ).length <= 0  ){
            			jQuery(".ov-icon").fadeOut();
            			// Posteriormente se desvanece todo el contenedor que cubre la pantalla completa
            			jQuery(".ov-preloader").delay(1000).fadeOut("slow");
            		}else{
            			jQuery(".ov-preloader").css('display','none');
            		}
                });
            </script>
    </body> 
</html>
<?php /**PATH /home/manisiis/public_html/cursos/resources/views/layouts/guest.blade.php ENDPATH**/ ?>