<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "usuarioinfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$usuario_add = NULL; // Initialize page object first

class cusuario_add extends cusuario {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = "{2EA57C9C-F73A-4222-85E6-F200C8B4A251}";

	// Table name
	var $TableName = 'usuario';

	// Page object name
	var $PageObjName = 'usuario_add';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (usuario)
		if (!isset($GLOBALS["usuario"]) || get_class($GLOBALS["usuario"]) == "cusuario") {
			$GLOBALS["usuario"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["usuario"];
		}

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'usuario', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// User table object (usuario)
		if (!isset($UserTable)) {
			$UserTable = new cusuario();
			$UserTableConn = Conn($UserTable->DBID);
		}
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanAdd()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("usuariolist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}
		if ($Security->IsLoggedIn()) {
			$Security->UserID_Loading();
			$Security->LoadUserID();
			$Security->UserID_Loaded();
			if (strval($Security->CurrentUserID()) == "") {
				$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
				$this->Page_Terminate(ew_GetUrl("usuariolist.php"));
			}
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $usuario;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($usuario);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewAddForm";
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
			$this->CopyRecord = $this->LoadOldRecord(); // Load old recordset
			$this->LoadFormValues(); // Load form values
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["Id_Usuario"] != "") {
				$this->Id_Usuario->setQueryStringValue($_GET["Id_Usuario"]);
				$this->setKey("Id_Usuario", $this->Id_Usuario->CurrentValue); // Set up key
			} else {
				$this->setKey("Id_Usuario", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
			}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		} else {
			if ($this->CurrentAction == "I") // Load default values for blank record
				$this->LoadDefaultValues();
		}

		// Perform action based on action code
		switch ($this->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "C": // Copy an existing record
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("usuariolist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "usuariolist.php")
						$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to list page with correct master key if necessary
					elseif (ew_GetPageName($sReturnUrl) == "usuarioview.php")
						$sReturnUrl = $this->GetViewUrl(); // View page, return to view page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD; // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load default values
	function LoadDefaultValues() {
		$this->Nombres->CurrentValue = NULL;
		$this->Nombres->OldValue = $this->Nombres->CurrentValue;
		$this->Apellidos->CurrentValue = NULL;
		$this->Apellidos->OldValue = $this->Apellidos->CurrentValue;
		$this->Cedula_Identificacion->CurrentValue = NULL;
		$this->Cedula_Identificacion->OldValue = $this->Cedula_Identificacion->CurrentValue;
		$this->Correo->CurrentValue = NULL;
		$this->Correo->OldValue = $this->Correo->CurrentValue;
		$this->Entidad->CurrentValue = NULL;
		$this->Entidad->OldValue = $this->Entidad->CurrentValue;
		$this->Clave->CurrentValue = NULL;
		$this->Clave->OldValue = $this->Clave->CurrentValue;
		$this->Usuario->CurrentValue = NULL;
		$this->Usuario->OldValue = $this->Usuario->CurrentValue;
		$this->Nivel->CurrentValue = NULL;
		$this->Nivel->OldValue = $this->Nivel->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->Nombres->FldIsDetailKey) {
			$this->Nombres->setFormValue($objForm->GetValue("x_Nombres"));
		}
		if (!$this->Apellidos->FldIsDetailKey) {
			$this->Apellidos->setFormValue($objForm->GetValue("x_Apellidos"));
		}
		if (!$this->Cedula_Identificacion->FldIsDetailKey) {
			$this->Cedula_Identificacion->setFormValue($objForm->GetValue("x_Cedula_Identificacion"));
		}
		if (!$this->Correo->FldIsDetailKey) {
			$this->Correo->setFormValue($objForm->GetValue("x_Correo"));
		}
		if (!$this->Entidad->FldIsDetailKey) {
			$this->Entidad->setFormValue($objForm->GetValue("x_Entidad"));
		}
		if (!$this->Clave->FldIsDetailKey) {
			$this->Clave->setFormValue($objForm->GetValue("x_Clave"));
		}
		if (!$this->Usuario->FldIsDetailKey) {
			$this->Usuario->setFormValue($objForm->GetValue("x_Usuario"));
		}
		if (!$this->Nivel->FldIsDetailKey) {
			$this->Nivel->setFormValue($objForm->GetValue("x_Nivel"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadOldRecord();
		$this->Nombres->CurrentValue = $this->Nombres->FormValue;
		$this->Apellidos->CurrentValue = $this->Apellidos->FormValue;
		$this->Cedula_Identificacion->CurrentValue = $this->Cedula_Identificacion->FormValue;
		$this->Correo->CurrentValue = $this->Correo->FormValue;
		$this->Entidad->CurrentValue = $this->Entidad->FormValue;
		$this->Clave->CurrentValue = $this->Clave->FormValue;
		$this->Usuario->CurrentValue = $this->Usuario->FormValue;
		$this->Nivel->CurrentValue = $this->Nivel->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}

		// Check if valid user id
		if ($res) {
			$res = $this->ShowOptionLink('add');
			if (!$res) {
				$sUserIdMsg = ew_DeniedMsg();
				$this->setFailureMessage($sUserIdMsg);
			}
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Id_Usuario->setDbValue($rs->fields('Id_Usuario'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Cedula_Identificacion->setDbValue($rs->fields('Cedula_Identificacion'));
		$this->Correo->setDbValue($rs->fields('Correo'));
		$this->Entidad->setDbValue($rs->fields('Entidad'));
		$this->Clave->setDbValue($rs->fields('Clave'));
		$this->Usuario->setDbValue($rs->fields('Usuario'));
		$this->Nivel->setDbValue($rs->fields('Nivel'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Id_Usuario->DbValue = $row['Id_Usuario'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Cedula_Identificacion->DbValue = $row['Cedula_Identificacion'];
		$this->Correo->DbValue = $row['Correo'];
		$this->Entidad->DbValue = $row['Entidad'];
		$this->Clave->DbValue = $row['Clave'];
		$this->Usuario->DbValue = $row['Usuario'];
		$this->Nivel->DbValue = $row['Nivel'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("Id_Usuario")) <> "")
			$this->Id_Usuario->CurrentValue = $this->getKey("Id_Usuario"); // Id_Usuario
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Id_Usuario
		// Nombres
		// Apellidos
		// Cedula_Identificacion
		// Correo
		// Entidad
		// Clave
		// Usuario
		// Nivel

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Id_Usuario
		$this->Id_Usuario->ViewValue = $this->Id_Usuario->CurrentValue;
		$this->Id_Usuario->ViewCustomAttributes = "";

		// Nombres
		$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
		$this->Nombres->ViewCustomAttributes = "";

		// Apellidos
		$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
		$this->Apellidos->ViewCustomAttributes = "";

		// Cedula_Identificacion
		$this->Cedula_Identificacion->ViewValue = $this->Cedula_Identificacion->CurrentValue;
		$this->Cedula_Identificacion->ViewCustomAttributes = "";

		// Correo
		$this->Correo->ViewValue = $this->Correo->CurrentValue;
		$this->Correo->ViewCustomAttributes = "";

		// Entidad
		if (strval($this->Entidad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Entidad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Entidad->ViewValue = $this->Entidad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Entidad->ViewValue = $this->Entidad->CurrentValue;
			}
		} else {
			$this->Entidad->ViewValue = NULL;
		}
		$this->Entidad->ViewCustomAttributes = "";

		// Clave
		$this->Clave->ViewValue = $this->Clave->CurrentValue;
		$this->Clave->ViewCustomAttributes = "";

		// Usuario
		$this->Usuario->ViewValue = $this->Usuario->CurrentValue;
		$this->Usuario->ViewCustomAttributes = "";

		// Nivel
		if ($Security->CanAdmin()) { // System admin
		if (strval($this->Nivel->CurrentValue) <> "") {
			$sFilterWrk = "`userlevelid`" . ew_SearchString("=", $this->Nivel->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `userlevelid`, `userlevelname` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `userlevels`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Nivel, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Nivel->ViewValue = $this->Nivel->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Nivel->ViewValue = $this->Nivel->CurrentValue;
			}
		} else {
			$this->Nivel->ViewValue = NULL;
		}
		} else {
			$this->Nivel->ViewValue = $Language->Phrase("PasswordMask");
		}
		$this->Nivel->ViewCustomAttributes = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// Cedula_Identificacion
			$this->Cedula_Identificacion->LinkCustomAttributes = "";
			$this->Cedula_Identificacion->HrefValue = "";
			$this->Cedula_Identificacion->TooltipValue = "";

			// Correo
			$this->Correo->LinkCustomAttributes = "";
			$this->Correo->HrefValue = "";
			$this->Correo->TooltipValue = "";

			// Entidad
			$this->Entidad->LinkCustomAttributes = "";
			$this->Entidad->HrefValue = "";
			$this->Entidad->TooltipValue = "";

			// Clave
			$this->Clave->LinkCustomAttributes = "";
			$this->Clave->HrefValue = "";
			$this->Clave->TooltipValue = "";

			// Usuario
			$this->Usuario->LinkCustomAttributes = "";
			$this->Usuario->HrefValue = "";
			$this->Usuario->TooltipValue = "";

			// Nivel
			$this->Nivel->LinkCustomAttributes = "";
			$this->Nivel->HrefValue = "";
			$this->Nivel->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// Nombres
			$this->Nombres->EditAttrs["class"] = "form-control";
			$this->Nombres->EditCustomAttributes = "";
			$this->Nombres->EditValue = ew_HtmlEncode($this->Nombres->CurrentValue);
			$this->Nombres->PlaceHolder = ew_RemoveHtml($this->Nombres->FldCaption());

			// Apellidos
			$this->Apellidos->EditAttrs["class"] = "form-control";
			$this->Apellidos->EditCustomAttributes = "";
			$this->Apellidos->EditValue = ew_HtmlEncode($this->Apellidos->CurrentValue);
			$this->Apellidos->PlaceHolder = ew_RemoveHtml($this->Apellidos->FldCaption());

			// Cedula_Identificacion
			$this->Cedula_Identificacion->EditAttrs["class"] = "form-control";
			$this->Cedula_Identificacion->EditCustomAttributes = "";
			$this->Cedula_Identificacion->EditValue = ew_HtmlEncode($this->Cedula_Identificacion->CurrentValue);
			$this->Cedula_Identificacion->PlaceHolder = ew_RemoveHtml($this->Cedula_Identificacion->FldCaption());

			// Correo
			$this->Correo->EditAttrs["class"] = "form-control";
			$this->Correo->EditCustomAttributes = "";
			$this->Correo->EditValue = ew_HtmlEncode($this->Correo->CurrentValue);
			$this->Correo->PlaceHolder = ew_RemoveHtml($this->Correo->FldCaption());

			// Entidad
			$this->Entidad->EditAttrs["class"] = "form-control";
			$this->Entidad->EditCustomAttributes = "";
			if (!$Security->IsAdmin() && $Security->IsLoggedIn() && !$this->UserIDAllow("add")) { // Non system admin
				$this->Entidad->CurrentValue = CurrentUserID();
			if (strval($this->Entidad->CurrentValue) <> "") {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad->CurrentValue, EW_DATATYPE_NUMBER, "");
			$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Entidad, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = Conn()->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('DispFld');
					$this->Entidad->EditValue = $this->Entidad->DisplayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Entidad->EditValue = $this->Entidad->CurrentValue;
				}
			} else {
				$this->Entidad->EditValue = NULL;
			}
			$this->Entidad->ViewCustomAttributes = "";
			} else {
			if (trim(strval($this->Entidad->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `entidad`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Entidad, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Entidad->EditValue = $arwrk;
			}

			// Clave
			$this->Clave->EditAttrs["class"] = "form-control ewPasswordStrength";
			$this->Clave->EditCustomAttributes = "";
			$this->Clave->EditValue = ew_HtmlEncode($this->Clave->CurrentValue);
			$this->Clave->PlaceHolder = ew_RemoveHtml($this->Clave->FldCaption());

			// Usuario
			$this->Usuario->EditAttrs["class"] = "form-control";
			$this->Usuario->EditCustomAttributes = "";
			$this->Usuario->EditValue = ew_HtmlEncode($this->Usuario->CurrentValue);
			$this->Usuario->PlaceHolder = ew_RemoveHtml($this->Usuario->FldCaption());

			// Nivel
			$this->Nivel->EditAttrs["class"] = "form-control";
			$this->Nivel->EditCustomAttributes = "";
			if (!$Security->CanAdmin()) { // System admin
				$this->Nivel->EditValue = $Language->Phrase("PasswordMask");
			} else {
			if (trim(strval($this->Nivel->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`userlevelid`" . ew_SearchString("=", $this->Nivel->CurrentValue, EW_DATATYPE_NUMBER, "");
			}
			$sSqlWrk = "SELECT `userlevelid`, `userlevelname` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `userlevels`";
			$sWhereWrk = "";
			ew_AddFilter($sWhereWrk, $sFilterWrk);
			$this->Lookup_Selecting($this->Nivel, $sWhereWrk); // Call Lookup selecting
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->Nivel->EditValue = $arwrk;
			}

			// Add refer script
			// Nombres

			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";

			// Cedula_Identificacion
			$this->Cedula_Identificacion->LinkCustomAttributes = "";
			$this->Cedula_Identificacion->HrefValue = "";

			// Correo
			$this->Correo->LinkCustomAttributes = "";
			$this->Correo->HrefValue = "";

			// Entidad
			$this->Entidad->LinkCustomAttributes = "";
			$this->Entidad->HrefValue = "";

			// Clave
			$this->Clave->LinkCustomAttributes = "";
			$this->Clave->HrefValue = "";

			// Usuario
			$this->Usuario->LinkCustomAttributes = "";
			$this->Usuario->HrefValue = "";

			// Nivel
			$this->Nivel->LinkCustomAttributes = "";
			$this->Nivel->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->Nombres->FldIsDetailKey && !is_null($this->Nombres->FormValue) && $this->Nombres->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Nombres->FldCaption(), $this->Nombres->ReqErrMsg));
		}
		if (!$this->Apellidos->FldIsDetailKey && !is_null($this->Apellidos->FormValue) && $this->Apellidos->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Apellidos->FldCaption(), $this->Apellidos->ReqErrMsg));
		}
		if (!$this->Cedula_Identificacion->FldIsDetailKey && !is_null($this->Cedula_Identificacion->FormValue) && $this->Cedula_Identificacion->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Cedula_Identificacion->FldCaption(), $this->Cedula_Identificacion->ReqErrMsg));
		}
		if (!$this->Correo->FldIsDetailKey && !is_null($this->Correo->FormValue) && $this->Correo->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Correo->FldCaption(), $this->Correo->ReqErrMsg));
		}
		if (!$this->Entidad->FldIsDetailKey && !is_null($this->Entidad->FormValue) && $this->Entidad->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Entidad->FldCaption(), $this->Entidad->ReqErrMsg));
		}
		if (!$this->Clave->FldIsDetailKey && !is_null($this->Clave->FormValue) && $this->Clave->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Clave->FldCaption(), $this->Clave->ReqErrMsg));
		}
		if (!$this->Usuario->FldIsDetailKey && !is_null($this->Usuario->FormValue) && $this->Usuario->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Usuario->FldCaption(), $this->Usuario->ReqErrMsg));
		}
		if (!$this->Nivel->FldIsDetailKey && !is_null($this->Nivel->FormValue) && $this->Nivel->FormValue == "") {
			ew_AddMessage($gsFormError, str_replace("%s", $this->Nivel->FldCaption(), $this->Nivel->ReqErrMsg));
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;

		// Check if valid User ID
		$bValidUser = FALSE;
		if ($Security->CurrentUserID() <> "" && !ew_Empty($this->Entidad->CurrentValue) && !$Security->IsAdmin()) { // Non system admin
			$bValidUser = $Security->IsValidUserID($this->Entidad->CurrentValue);
			if (!$bValidUser) {
				$sUserIdMsg = str_replace("%c", CurrentUserID(), $Language->Phrase("UnAuthorizedUserID"));
				$sUserIdMsg = str_replace("%u", $this->Entidad->CurrentValue, $sUserIdMsg);
				$this->setFailureMessage($sUserIdMsg);
				return FALSE;
			}
		}
		$conn = &$this->Connection();

		// Load db values from rsold
		if ($rsold) {
			$this->LoadDbValues($rsold);
		}
		$rsnew = array();

		// Nombres
		$this->Nombres->SetDbValueDef($rsnew, $this->Nombres->CurrentValue, "", FALSE);

		// Apellidos
		$this->Apellidos->SetDbValueDef($rsnew, $this->Apellidos->CurrentValue, "", FALSE);

		// Cedula_Identificacion
		$this->Cedula_Identificacion->SetDbValueDef($rsnew, $this->Cedula_Identificacion->CurrentValue, "", FALSE);

		// Correo
		$this->Correo->SetDbValueDef($rsnew, $this->Correo->CurrentValue, "", FALSE);

		// Entidad
		$this->Entidad->SetDbValueDef($rsnew, $this->Entidad->CurrentValue, 0, FALSE);

		// Clave
		$this->Clave->SetDbValueDef($rsnew, $this->Clave->CurrentValue, "", FALSE);

		// Usuario
		$this->Usuario->SetDbValueDef($rsnew, $this->Usuario->CurrentValue, "", FALSE);

		// Nivel
		if ($Security->CanAdmin()) { // System admin
		$this->Nivel->SetDbValueDef($rsnew, $this->Nivel->CurrentValue, 0, FALSE);
		}

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {

				// Get insert id if necessary
				$this->Id_Usuario->setDbValue($conn->Insert_ID());
				$rsnew['Id_Usuario'] = $this->Id_Usuario->DbValue;
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}
		return $AddRow;
	}

	// Show link optionally based on User ID
	function ShowOptionLink($id = "") {
		global $Security;
		if ($Security->IsLoggedIn() && !$Security->IsAdmin() && !$this->UserIDAllow($id))
			return $Security->IsValidUserID($this->Entidad->CurrentValue);
		return TRUE;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("usuariolist.php"), "", $this->TableVar, TRUE);
		$PageId = ($this->CurrentAction == "C") ? "Copy" : "Add";
		$Breadcrumb->Add("add", $PageId, $url);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($usuario_add)) $usuario_add = new cusuario_add();

// Page init
$usuario_add->Page_Init();

// Page main
$usuario_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$usuario_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "add";
var CurrentForm = fusuarioadd = new ew_Form("fusuarioadd", "add");

// Validate form
fusuarioadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_Nombres");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $usuario->Nombres->FldCaption(), $usuario->Nombres->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Apellidos");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $usuario->Apellidos->FldCaption(), $usuario->Apellidos->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Cedula_Identificacion");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $usuario->Cedula_Identificacion->FldCaption(), $usuario->Cedula_Identificacion->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Correo");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $usuario->Correo->FldCaption(), $usuario->Correo->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Entidad");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $usuario->Entidad->FldCaption(), $usuario->Entidad->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Clave");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $usuario->Clave->FldCaption(), $usuario->Clave->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Clave");
			if (elm && $(elm).hasClass("ewPasswordStrength") && !$(elm).data("validated"))
				return this.OnError(elm, ewLanguage.Phrase("PasswordTooSimple"));
			elm = this.GetElements("x" + infix + "_Usuario");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $usuario->Usuario->FldCaption(), $usuario->Usuario->ReqErrMsg)) ?>");
			elm = this.GetElements("x" + infix + "_Nivel");
			if (elm && !ew_IsHidden(elm) && !ew_HasValue(elm))
				return this.OnError(elm, "<?php echo ew_JsEncode2(str_replace("%s", $usuario->Nivel->FldCaption(), $usuario->Nivel->ReqErrMsg)) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fusuarioadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fusuarioadd.ValidateRequired = true;
<?php } else { ?>
fusuarioadd.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fusuarioadd.Lists["x_Entidad"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Entidad","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
fusuarioadd.Lists["x_Nivel"] = {"LinkField":"x_userlevelid","Ajax":true,"AutoFill":false,"DisplayFields":["x_userlevelname","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php $usuario_add->ShowPageHeader(); ?>
<?php
$usuario_add->ShowMessage();
?>
<form name="fusuarioadd" id="fusuarioadd" class="<?php echo $usuario_add->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($usuario_add->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $usuario_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="usuario">
<input type="hidden" name="a_add" id="a_add" value="A">
<!-- Fields to prevent google autofill -->
<input class="hidden" type="text" name="<?php echo ew_Encrypt(ew_Random()) ?>">
<input class="hidden" type="password" name="<?php echo ew_Encrypt(ew_Random()) ?>">
<div>
<?php if ($usuario->Nombres->Visible) { // Nombres ?>
	<div id="r_Nombres" class="form-group">
		<label id="elh_usuario_Nombres" for="x_Nombres" class="col-sm-2 control-label ewLabel"><?php echo $usuario->Nombres->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $usuario->Nombres->CellAttributes() ?>>
<span id="el_usuario_Nombres">
<input type="text" data-table="usuario" data-field="x_Nombres" name="x_Nombres" id="x_Nombres" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($usuario->Nombres->getPlaceHolder()) ?>" value="<?php echo $usuario->Nombres->EditValue ?>"<?php echo $usuario->Nombres->EditAttributes() ?>>
</span>
<?php echo $usuario->Nombres->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($usuario->Apellidos->Visible) { // Apellidos ?>
	<div id="r_Apellidos" class="form-group">
		<label id="elh_usuario_Apellidos" for="x_Apellidos" class="col-sm-2 control-label ewLabel"><?php echo $usuario->Apellidos->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $usuario->Apellidos->CellAttributes() ?>>
<span id="el_usuario_Apellidos">
<input type="text" data-table="usuario" data-field="x_Apellidos" name="x_Apellidos" id="x_Apellidos" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($usuario->Apellidos->getPlaceHolder()) ?>" value="<?php echo $usuario->Apellidos->EditValue ?>"<?php echo $usuario->Apellidos->EditAttributes() ?>>
</span>
<?php echo $usuario->Apellidos->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($usuario->Cedula_Identificacion->Visible) { // Cedula_Identificacion ?>
	<div id="r_Cedula_Identificacion" class="form-group">
		<label id="elh_usuario_Cedula_Identificacion" for="x_Cedula_Identificacion" class="col-sm-2 control-label ewLabel"><?php echo $usuario->Cedula_Identificacion->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $usuario->Cedula_Identificacion->CellAttributes() ?>>
<span id="el_usuario_Cedula_Identificacion">
<input type="text" data-table="usuario" data-field="x_Cedula_Identificacion" name="x_Cedula_Identificacion" id="x_Cedula_Identificacion" size="30" maxlength="30" placeholder="<?php echo ew_HtmlEncode($usuario->Cedula_Identificacion->getPlaceHolder()) ?>" value="<?php echo $usuario->Cedula_Identificacion->EditValue ?>"<?php echo $usuario->Cedula_Identificacion->EditAttributes() ?>>
</span>
<?php echo $usuario->Cedula_Identificacion->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($usuario->Correo->Visible) { // Correo ?>
	<div id="r_Correo" class="form-group">
		<label id="elh_usuario_Correo" for="x_Correo" class="col-sm-2 control-label ewLabel"><?php echo $usuario->Correo->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $usuario->Correo->CellAttributes() ?>>
<span id="el_usuario_Correo">
<input type="text" data-table="usuario" data-field="x_Correo" name="x_Correo" id="x_Correo" size="30" maxlength="120" placeholder="<?php echo ew_HtmlEncode($usuario->Correo->getPlaceHolder()) ?>" value="<?php echo $usuario->Correo->EditValue ?>"<?php echo $usuario->Correo->EditAttributes() ?>>
</span>
<?php echo $usuario->Correo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($usuario->Entidad->Visible) { // Entidad ?>
	<div id="r_Entidad" class="form-group">
		<label id="elh_usuario_Entidad" for="x_Entidad" class="col-sm-2 control-label ewLabel"><?php echo $usuario->Entidad->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $usuario->Entidad->CellAttributes() ?>>
<?php if (!$Security->IsAdmin() && $Security->IsLoggedIn() && !$usuario->UserIDAllow("add")) { // Non system admin ?>
<span id="el_usuario_Entidad">
<span<?php echo $usuario->Entidad->ViewAttributes() ?>>
<p class="form-control-static"><?php echo $usuario->Entidad->EditValue ?></p></span>
</span>
<input type="hidden" data-table="usuario" data-field="x_Entidad" name="x_Entidad" id="x_Entidad" value="<?php echo ew_HtmlEncode($usuario->Entidad->CurrentValue) ?>">
<?php } else { ?>
<span id="el_usuario_Entidad">
<select data-table="usuario" data-field="x_Entidad" data-value-separator="<?php echo ew_HtmlEncode(is_array($usuario->Entidad->DisplayValueSeparator) ? json_encode($usuario->Entidad->DisplayValueSeparator) : $usuario->Entidad->DisplayValueSeparator) ?>" id="x_Entidad" name="x_Entidad"<?php echo $usuario->Entidad->EditAttributes() ?>>
<?php
if (is_array($usuario->Entidad->EditValue)) {
	$arwrk = $usuario->Entidad->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = ew_SameStr($usuario->Entidad->CurrentValue, $arwrk[$rowcntwrk][0]) ? " selected" : "";
		if ($selwrk <> "") $emptywrk = FALSE;		
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $usuario->Entidad->DisplayValue($arwrk[$rowcntwrk]) ?>
</option>
<?php
	}
	if ($emptywrk && strval($usuario->Entidad->CurrentValue) <> "") {
?>
<option value="<?php echo ew_HtmlEncode($usuario->Entidad->CurrentValue) ?>" selected><?php echo $usuario->Entidad->CurrentValue ?></option>
<?php
    }
}
?>
</select>
<?php
$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad`";
$sWhereWrk = "";
$usuario->Entidad->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$usuario->Entidad->LookupFilters += array("f0" => "`Id` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$usuario->Lookup_Selecting($usuario->Entidad, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $usuario->Entidad->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Entidad" id="s_x_Entidad" value="<?php echo $usuario->Entidad->LookupFilterQuery() ?>">
</span>
<?php } ?>
<?php echo $usuario->Entidad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($usuario->Clave->Visible) { // Clave ?>
	<div id="r_Clave" class="form-group">
		<label id="elh_usuario_Clave" for="x_Clave" class="col-sm-2 control-label ewLabel"><?php echo $usuario->Clave->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $usuario->Clave->CellAttributes() ?>>
<span id="el_usuario_Clave">
<div class="input-group" id="ig_Clave">
<input type="text" data-password-strength="pst_Clave" data-password-generated="pgt_Clave" data-table="usuario" data-field="x_Clave" name="x_Clave" id="x_Clave" value="<?php echo $usuario->Clave->EditValue ?>" size="30" maxlength="20" placeholder="<?php echo ew_HtmlEncode($usuario->Clave->getPlaceHolder()) ?>"<?php echo $usuario->Clave->EditAttributes() ?>>
<span class="input-group-btn">
	<button type="button" class="btn btn-default ewPasswordGenerator" title="<?php echo ew_HtmlTitle($Language->Phrase("GeneratePassword")) ?>" data-password-field="x_Clave" data-password-confirm="c_Clave" data-password-strength="pst_Clave" data-password-generated="pgt_Clave"><?php echo $Language->Phrase("GeneratePassword") ?></button>
</span>
</div>
<span class="help-block" id="pgt_Clave" style="display: none;"></span>
<div class="progress ewPasswordStrengthBar" id="pst_Clave" style="display: none;">
	<div class="progress-bar" role="progressbar"></div>
</div>
</span>
<?php echo $usuario->Clave->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($usuario->Usuario->Visible) { // Usuario ?>
	<div id="r_Usuario" class="form-group">
		<label id="elh_usuario_Usuario" for="x_Usuario" class="col-sm-2 control-label ewLabel"><?php echo $usuario->Usuario->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $usuario->Usuario->CellAttributes() ?>>
<span id="el_usuario_Usuario">
<input type="text" data-table="usuario" data-field="x_Usuario" name="x_Usuario" id="x_Usuario" size="30" maxlength="20" placeholder="<?php echo ew_HtmlEncode($usuario->Usuario->getPlaceHolder()) ?>" value="<?php echo $usuario->Usuario->EditValue ?>"<?php echo $usuario->Usuario->EditAttributes() ?>>
</span>
<?php echo $usuario->Usuario->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($usuario->Nivel->Visible) { // Nivel ?>
	<div id="r_Nivel" class="form-group">
		<label id="elh_usuario_Nivel" for="x_Nivel" class="col-sm-2 control-label ewLabel"><?php echo $usuario->Nivel->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></label>
		<div class="col-sm-10"><div<?php echo $usuario->Nivel->CellAttributes() ?>>
<?php if (!$Security->IsAdmin() && $Security->IsLoggedIn()) { // Non system admin ?>
<span id="el_usuario_Nivel">
<p class="form-control-static"><?php echo $usuario->Nivel->EditValue ?></p>
</span>
<?php } else { ?>
<span id="el_usuario_Nivel">
<select data-table="usuario" data-field="x_Nivel" data-value-separator="<?php echo ew_HtmlEncode(is_array($usuario->Nivel->DisplayValueSeparator) ? json_encode($usuario->Nivel->DisplayValueSeparator) : $usuario->Nivel->DisplayValueSeparator) ?>" id="x_Nivel" name="x_Nivel"<?php echo $usuario->Nivel->EditAttributes() ?>>
<?php
if (is_array($usuario->Nivel->EditValue)) {
	$arwrk = $usuario->Nivel->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = ew_SameStr($usuario->Nivel->CurrentValue, $arwrk[$rowcntwrk][0]) ? " selected" : "";
		if ($selwrk <> "") $emptywrk = FALSE;		
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $usuario->Nivel->DisplayValue($arwrk[$rowcntwrk]) ?>
</option>
<?php
	}
	if ($emptywrk && strval($usuario->Nivel->CurrentValue) <> "") {
?>
<option value="<?php echo ew_HtmlEncode($usuario->Nivel->CurrentValue) ?>" selected><?php echo $usuario->Nivel->CurrentValue ?></option>
<?php
    }
}
?>
</select>
<?php
$sSqlWrk = "SELECT `userlevelid`, `userlevelname` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `userlevels`";
$sWhereWrk = "";
$usuario->Nivel->LookupFilters = array("s" => $sSqlWrk, "d" => "");
$usuario->Nivel->LookupFilters += array("f0" => "`userlevelid` = {filter_value}", "t0" => "3", "fn0" => "");
$sSqlWrk = "";
$usuario->Lookup_Selecting($usuario->Nivel, $sWhereWrk); // Call Lookup selecting
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
if ($sSqlWrk <> "") $usuario->Nivel->LookupFilters["s"] .= $sSqlWrk;
?>
<input type="hidden" name="s_x_Nivel" id="s_x_Nivel" value="<?php echo $usuario->Nivel->LookupFilterQuery() ?>">
</span>
<?php } ?>
<?php echo $usuario->Nivel->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div>
<div class="form-group">
	<div class="col-sm-offset-2 col-sm-10">
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $usuario_add->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div>
</div>
</form>
<script type="text/javascript">
fusuarioadd.Init();
</script>
<?php
$usuario_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$usuario_add->Page_Terminate();
?>
