<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "licenciasinfo.php" ?>
<?php include_once "usuarioinfo.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$licencias_view = NULL; // Initialize page object first

class clicencias_view extends clicencias {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = "{2C10691D-1A6E-4ED4-86F3-F3EE71B5418C}";

	// Table name
	var $TableName = 'licencias';

	// Page object name
	var $PageObjName = 'licencias_view';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = TRUE;
	var $ExportWordCustom = TRUE;
	var $ExportPdfCustom = TRUE;
	var $ExportEmailCustom = TRUE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		global $UserTable, $UserTableConn;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (licencias)
		if (!isset($GLOBALS["licencias"]) || get_class($GLOBALS["licencias"]) == "clicencias") {
			$GLOBALS["licencias"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["licencias"];
		}
		$KeyUrl = "";
		if (@$_GET["Id"] <> "") {
			$this->RecKey["Id"] = $_GET["Id"];
			$KeyUrl .= "&amp;Id=" . urlencode($this->RecKey["Id"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Table object (usuario)
		if (!isset($GLOBALS['usuario'])) $GLOBALS['usuario'] = new cusuario();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'licencias', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// User table object (usuario)
		if (!isset($UserTable)) {
			$UserTable = new cusuario();
			$UserTableConn = Conn($UserTable->DBID);
		}

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loading();
		$Security->LoadCurrentUserLevel($this->ProjectID . $this->TableName);
		if ($Security->IsLoggedIn()) $Security->TablePermission_Loaded();
		if (!$Security->CanView()) {
			$Security->SaveLastUrl();
			$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
			if ($Security->CanList())
				$this->Page_Terminate(ew_GetUrl("licenciaslist.php"));
			else
				$this->Page_Terminate(ew_GetUrl("login.php"));
		}
		if ($Security->IsLoggedIn()) {
			$Security->UserID_Loading();
			$Security->LoadUserID();
			$Security->UserID_Loaded();
			if (strval($Security->CurrentUserID()) == "") {
				$this->setFailureMessage(ew_DeniedMsg()); // Set no permission
				$this->Page_Terminate(ew_GetUrl("licenciaslist.php"));
			}
		}

		// Get export parameters
		$custom = "";
		if (@$_GET["export"] <> "") {
			$this->Export = $_GET["export"];
			$custom = @$_GET["custom"];
		} elseif (@$_POST["export"] <> "") {
			$this->Export = $_POST["export"];
			$custom = @$_POST["custom"];
		} elseif (ew_IsHttpPost()) {
			if (@$_POST["exporttype"] <> "")
				$this->Export = $_POST["exporttype"];
			$custom = @$_POST["custom"];
		} else {
			$this->setExportReturnUrl(ew_CurrentUrl());
		}
		$gsExportFile = $this->TableVar; // Get export file, used in header
		if (@$_GET["Id"] <> "") {
			if ($gsExportFile <> "") $gsExportFile .= "_";
			$gsExportFile .= ew_StripSlashes($_GET["Id"]);
		}

		// Get custom export parameters
		if ($this->Export <> "" && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$gsCustomExport = $this->CustomExport;
		$gsExport = $this->Export; // Get export parameter, used in header

		// Custom export (post back from ew_ApplyTemplate), export and terminate page
		if (@$_POST["customexport"] <> "") {
			$this->CustomExport = $_POST["customexport"];
			$this->Export = $this->CustomExport;
			$this->Page_Terminate();
			exit();
		}

		// Update Export URLs
		if (defined("EW_USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined("EW_USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Setup export options
		$this->SetupExportOptions();

		// Set up multi page object
		$this->SetupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;
		if (@$_POST["customexport"] == "") {

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		}

		// Export
		global $EW_EXPORT, $licencias;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
			if (is_array(@$_SESSION[EW_SESSION_TEMP_IMAGES])) // Restore temp images
				$gTmpImages = @$_SESSION[EW_SESSION_TEMP_IMAGES];
			if (@$_POST["data"] <> "")
				$sContent = $_POST["data"];
			$gsExportFile = @$_POST["filename"];
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($licencias);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
	if ($this->CustomExport <> "") { // Save temp images array for custom export
		if (is_array($gTmpImages))
			$_SESSION[EW_SESSION_TEMP_IMAGES] = $gTmpImages;
	}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $DbMasterFilter;
	var $DbDetailFilter;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;
	var $MultiPages; // Multi pages object

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["Id"] <> "") {
				$this->Id->setQueryStringValue($_GET["Id"]);
				$this->RecKey["Id"] = $this->Id->QueryStringValue;
			} elseif (@$_POST["Id"] <> "") {
				$this->Id->setFormValue($_POST["Id"]);
				$this->RecKey["Id"] = $this->Id->FormValue;
			} else {
				$sReturnUrl = "licenciaslist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					if (!$this->LoadRow()) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "licenciaslist.php"; // No matching record, return to list
					}
			}

			// Export data only
			if ($this->CustomExport == "" && in_array($this->Export, array("html","word","excel","xml","csv","email","pdf"))) {
				$this->ExportData();
				$this->Page_Terminate(); // Terminate response
				exit();
			}
		} else {
			$sReturnUrl = "licenciaslist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAction ewAdd\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageAddLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageAddLink")) . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->CanAdd());

		// Edit
		$item = &$option->Add("edit");
		$item->Body = "<a class=\"ewAction ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageEditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageEditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->CanEdit()&& $this->ShowOptionLink('edit'));

		// Delete
		$item = &$option->Add("delete");
		$item->Body = "<a class=\"ewAction ewDelete\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewPageDeleteLink")) . "\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->CanDelete() && $this->ShowOptionLink('delete'));

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
		$option->UseImageAndText = TRUE;
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->Add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Id->setDbValue($rs->fields('Id'));
		$this->Entidad->setDbValue($rs->fields('Entidad'));
		$this->IPS2FMEDICO->setDbValue($rs->fields('IPS/MEDICO'));
		$this->Entidad_dirige_licencia->setDbValue($rs->fields('Entidad_dirige_licencia'));
		$this->Logo->setDbValue($rs->fields('Logo'));
		$this->Fecha_expedicion->setDbValue($rs->fields('Fecha_expedicion'));
		$this->Dpto_expedicion->setDbValue($rs->fields('Dpto_expedicion'));
		$this->Mun_expedicion->setDbValue($rs->fields('Mun_expedicion'));
		$this->Nombre_solicitante->setDbValue($rs->fields('Nombre_solicitante'));
		$this->tipo_muerte->setDbValue($rs->fields('tipo_muerte'));
		$this->Nombres->setDbValue($rs->fields('Nombres'));
		$this->Apellidos->setDbValue($rs->fields('Apellidos'));
		$this->Genero->setDbValue($rs->fields('Genero'));
		$this->Fecha_Fallecimiento->setDbValue($rs->fields('Fecha_Fallecimiento'));
		$this->p_manera_muerte->setDbValue($rs->fields('p_manera_muerte'));
		$this->No_certificado->setDbValue($rs->fields('No_certificado'));
		$this->Tipo_doc->setDbValue($rs->fields('Tipo_doc'));
		$this->Documento->setDbValue($rs->fields('Documento'));
		$this->Tipo_edad->setDbValue($rs->fields('Tipo_edad'));
		$this->Edad->setDbValue($rs->fields('Edad'));
		$this->Funcionario_expide->setDbValue($rs->fields('Funcionario_expide'));
		$this->Permiso_inhumar->setDbValue($rs->fields('Permiso_inhumar'));
		$this->Permiso_cremar->setDbValue($rs->fields('Permiso_cremar'));
		$this->Firma_funcionario->setDbValue($rs->fields('Firma_funcionario'));
		$this->Codigo_qr->setDbValue($rs->fields('Codigo_qr'));
		$this->Verificacion_codigo_qr->setDbValue($rs->fields('Verificacion_codigo_qr'));
		$this->Registrado_por->setDbValue($rs->fields('Registrado_por'));
		$this->Fecha_registro->setDbValue($rs->fields('Fecha_registro'));
		$this->Mensaje_manual->setDbValue($rs->fields('Mensaje_manual'));
		$this->estado_licencia->setDbValue($rs->fields('estado_licencia'));
		$this->observaciones->setDbValue($rs->fields('observaciones'));
		$this->fecha_edicion->setDbValue($rs->fields('fecha_edicion'));
		$this->usuario_edita->setDbValue($rs->fields('usuario_edita'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Id->DbValue = $row['Id'];
		$this->Entidad->DbValue = $row['Entidad'];
		$this->IPS2FMEDICO->DbValue = $row['IPS/MEDICO'];
		$this->Entidad_dirige_licencia->DbValue = $row['Entidad_dirige_licencia'];
		$this->Logo->DbValue = $row['Logo'];
		$this->Fecha_expedicion->DbValue = $row['Fecha_expedicion'];
		$this->Dpto_expedicion->DbValue = $row['Dpto_expedicion'];
		$this->Mun_expedicion->DbValue = $row['Mun_expedicion'];
		$this->Nombre_solicitante->DbValue = $row['Nombre_solicitante'];
		$this->tipo_muerte->DbValue = $row['tipo_muerte'];
		$this->Nombres->DbValue = $row['Nombres'];
		$this->Apellidos->DbValue = $row['Apellidos'];
		$this->Genero->DbValue = $row['Genero'];
		$this->Fecha_Fallecimiento->DbValue = $row['Fecha_Fallecimiento'];
		$this->p_manera_muerte->DbValue = $row['p_manera_muerte'];
		$this->No_certificado->DbValue = $row['No_certificado'];
		$this->Tipo_doc->DbValue = $row['Tipo_doc'];
		$this->Documento->DbValue = $row['Documento'];
		$this->Tipo_edad->DbValue = $row['Tipo_edad'];
		$this->Edad->DbValue = $row['Edad'];
		$this->Funcionario_expide->DbValue = $row['Funcionario_expide'];
		$this->Permiso_inhumar->DbValue = $row['Permiso_inhumar'];
		$this->Permiso_cremar->DbValue = $row['Permiso_cremar'];
		$this->Firma_funcionario->DbValue = $row['Firma_funcionario'];
		$this->Codigo_qr->DbValue = $row['Codigo_qr'];
		$this->Verificacion_codigo_qr->DbValue = $row['Verificacion_codigo_qr'];
		$this->Registrado_por->DbValue = $row['Registrado_por'];
		$this->Fecha_registro->DbValue = $row['Fecha_registro'];
		$this->Mensaje_manual->DbValue = $row['Mensaje_manual'];
		$this->estado_licencia->DbValue = $row['estado_licencia'];
		$this->observaciones->DbValue = $row['observaciones'];
		$this->fecha_edicion->DbValue = $row['fecha_edicion'];
		$this->usuario_edita->DbValue = $row['usuario_edita'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Id
		// Entidad
		// IPS/MEDICO
		// Entidad_dirige_licencia
		// Logo
		// Fecha_expedicion
		// Dpto_expedicion
		// Mun_expedicion
		// Nombre_solicitante
		// tipo_muerte
		// Nombres
		// Apellidos
		// Genero
		// Fecha_Fallecimiento
		// p_manera_muerte
		// No_certificado
		// Tipo_doc
		// Documento
		// Tipo_edad
		// Edad
		// Funcionario_expide
		// Permiso_inhumar
		// Permiso_cremar
		// Firma_funcionario
		// Codigo_qr
		// Verificacion_codigo_qr
		// Registrado_por
		// Fecha_registro
		// Mensaje_manual
		// estado_licencia
		// observaciones
		// fecha_edicion
		// usuario_edita

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Id
		$this->Id->ViewValue = $this->Id->CurrentValue;
		$this->Id->ViewCustomAttributes = "";

		// Entidad
		if (strval($this->Entidad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Entidad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Entidad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `entidad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Entidad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Entidad->ViewValue = $this->Entidad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Entidad->ViewValue = $this->Entidad->CurrentValue;
			}
		} else {
			$this->Entidad->ViewValue = NULL;
		}
		$this->Entidad->ViewCustomAttributes = "";

		// IPS/MEDICO
		$this->IPS2FMEDICO->ViewValue = $this->IPS2FMEDICO->CurrentValue;
		$this->IPS2FMEDICO->ViewCustomAttributes = "";

		// Entidad_dirige_licencia
		$this->Entidad_dirige_licencia->ViewValue = $this->Entidad_dirige_licencia->CurrentValue;
		$this->Entidad_dirige_licencia->ViewCustomAttributes = "";

		// Logo
		$this->Logo->ViewValue = $this->Logo->CurrentValue;
		$this->Logo->ViewCustomAttributes = "";

		// Fecha_expedicion
		$this->Fecha_expedicion->ViewValue = $this->Fecha_expedicion->CurrentValue;
		$this->Fecha_expedicion->ViewValue = ew_FormatDateTime($this->Fecha_expedicion->ViewValue, 5);
		$this->Fecha_expedicion->ViewCustomAttributes = "";

		// Dpto_expedicion
		$this->Dpto_expedicion->ViewValue = $this->Dpto_expedicion->CurrentValue;
		$this->Dpto_expedicion->ViewCustomAttributes = "";

		// Mun_expedicion
		$this->Mun_expedicion->ViewValue = $this->Mun_expedicion->CurrentValue;
		$this->Mun_expedicion->ViewCustomAttributes = "";

		// Nombre_solicitante
		$this->Nombre_solicitante->ViewValue = $this->Nombre_solicitante->CurrentValue;
		$this->Nombre_solicitante->ViewCustomAttributes = "";

		// tipo_muerte
		if (strval($this->tipo_muerte->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->tipo_muerte->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Tipo_muerte` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_muerte`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->tipo_muerte, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->tipo_muerte->ViewValue = $this->tipo_muerte->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->tipo_muerte->ViewValue = $this->tipo_muerte->CurrentValue;
			}
		} else {
			$this->tipo_muerte->ViewValue = NULL;
		}
		$this->tipo_muerte->ViewCustomAttributes = "";

		// Nombres
		$this->Nombres->ViewValue = $this->Nombres->CurrentValue;
		$this->Nombres->ViewCustomAttributes = "";

		// Apellidos
		$this->Apellidos->ViewValue = $this->Apellidos->CurrentValue;
		$this->Apellidos->ViewCustomAttributes = "";

		// Genero
		if (strval($this->Genero->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Genero->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Genero` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `genero`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Genero, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Genero->ViewValue = $this->Genero->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Genero->ViewValue = $this->Genero->CurrentValue;
			}
		} else {
			$this->Genero->ViewValue = NULL;
		}
		$this->Genero->ViewCustomAttributes = "";

		// Fecha_Fallecimiento
		$this->Fecha_Fallecimiento->ViewValue = $this->Fecha_Fallecimiento->CurrentValue;
		$this->Fecha_Fallecimiento->ViewValue = ew_FormatDateTime($this->Fecha_Fallecimiento->ViewValue, 5);
		$this->Fecha_Fallecimiento->ViewCustomAttributes = "";

		// p_manera_muerte
		if (strval($this->p_manera_muerte->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->p_manera_muerte->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `probable_manera` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `p_manera_muerte`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->p_manera_muerte, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->p_manera_muerte->ViewValue = $this->p_manera_muerte->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->p_manera_muerte->ViewValue = $this->p_manera_muerte->CurrentValue;
			}
		} else {
			$this->p_manera_muerte->ViewValue = NULL;
		}
		$this->p_manera_muerte->ViewCustomAttributes = "";

		// No_certificado
		$this->No_certificado->ViewValue = $this->No_certificado->CurrentValue;
		$this->No_certificado->ViewCustomAttributes = "";

		// Tipo_doc
		if (strval($this->Tipo_doc->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Tipo_doc->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `tipo_documento` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_documento`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_doc, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_doc->ViewValue = $this->Tipo_doc->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_doc->ViewValue = $this->Tipo_doc->CurrentValue;
			}
		} else {
			$this->Tipo_doc->ViewValue = NULL;
		}
		$this->Tipo_doc->ViewCustomAttributes = "";

		// Documento
		$this->Documento->ViewValue = $this->Documento->CurrentValue;
		$this->Documento->ViewCustomAttributes = "";

		// Tipo_edad
		if (strval($this->Tipo_edad->CurrentValue) <> "") {
			$sFilterWrk = "`Id`" . ew_SearchString("=", $this->Tipo_edad->CurrentValue, EW_DATATYPE_NUMBER, "");
		$sSqlWrk = "SELECT `Id`, `Tipo_edad` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `tipo_edad`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Tipo_edad, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Tipo_edad->ViewValue = $this->Tipo_edad->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Tipo_edad->ViewValue = $this->Tipo_edad->CurrentValue;
			}
		} else {
			$this->Tipo_edad->ViewValue = NULL;
		}
		$this->Tipo_edad->ViewCustomAttributes = "";

		// Edad
		$this->Edad->ViewValue = $this->Edad->CurrentValue;
		$this->Edad->ViewCustomAttributes = "";

		// Funcionario_expide
		$this->Funcionario_expide->ViewValue = $this->Funcionario_expide->CurrentValue;
		$this->Funcionario_expide->ViewCustomAttributes = "";

		// Permiso_inhumar
		$this->Permiso_inhumar->ViewValue = $this->Permiso_inhumar->CurrentValue;
		$this->Permiso_inhumar->ViewCustomAttributes = "";

		// Permiso_cremar
		$this->Permiso_cremar->ViewValue = $this->Permiso_cremar->CurrentValue;
		$this->Permiso_cremar->ViewCustomAttributes = "";

		// Firma_funcionario
		$this->Firma_funcionario->ViewValue = $this->Firma_funcionario->CurrentValue;
		$this->Firma_funcionario->ViewCustomAttributes = "";

		// Codigo_qr
		$this->Codigo_qr->ViewValue = $this->Codigo_qr->CurrentValue;
		$this->Codigo_qr->ViewCustomAttributes = "";

		// Verificacion_codigo_qr
		$this->Verificacion_codigo_qr->ViewValue = $this->Verificacion_codigo_qr->CurrentValue;
		$this->Verificacion_codigo_qr->ViewCustomAttributes = "";

		// Registrado_por
		if (strval($this->Registrado_por->CurrentValue) <> "") {
			$sFilterWrk = "`Usuario`" . ew_SearchString("=", $this->Registrado_por->CurrentValue, EW_DATATYPE_STRING, "");
		$sSqlWrk = "SELECT `Usuario`, `Usuario` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `usuario`";
		$sWhereWrk = "";
		ew_AddFilter($sWhereWrk, $sFilterWrk);
		$this->Lookup_Selecting($this->Registrado_por, $sWhereWrk); // Call Lookup selecting
		if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = Conn()->Execute($sSqlWrk);
			if ($rswrk && !$rswrk->EOF) { // Lookup values found
				$arwrk = array();
				$arwrk[1] = $rswrk->fields('DispFld');
				$this->Registrado_por->ViewValue = $this->Registrado_por->DisplayValue($arwrk);
				$rswrk->Close();
			} else {
				$this->Registrado_por->ViewValue = $this->Registrado_por->CurrentValue;
			}
		} else {
			$this->Registrado_por->ViewValue = NULL;
		}
		$this->Registrado_por->ViewCustomAttributes = "";

		// Fecha_registro
		$this->Fecha_registro->ViewValue = $this->Fecha_registro->CurrentValue;
		$this->Fecha_registro->ViewValue = ew_FormatDateTime($this->Fecha_registro->ViewValue, 5);
		$this->Fecha_registro->ViewCustomAttributes = "";

		// observaciones
		$this->observaciones->ViewValue = $this->observaciones->CurrentValue;
		$this->observaciones->ViewCustomAttributes = "";

		// fecha_edicion
		$this->fecha_edicion->ViewValue = $this->fecha_edicion->CurrentValue;
		$this->fecha_edicion->ViewValue = ew_FormatDateTime($this->fecha_edicion->ViewValue, 5);
		$this->fecha_edicion->ViewCustomAttributes = "";

		// usuario_edita
		$this->usuario_edita->ViewValue = $this->usuario_edita->CurrentValue;
		$this->usuario_edita->ViewCustomAttributes = "";

			// Id
			$this->Id->LinkCustomAttributes = "";
			$this->Id->HrefValue = "";
			$this->Id->TooltipValue = "";

			// IPS/MEDICO
			$this->IPS2FMEDICO->LinkCustomAttributes = "";
			$this->IPS2FMEDICO->HrefValue = "";
			$this->IPS2FMEDICO->TooltipValue = "";

			// Logo
			$this->Logo->LinkCustomAttributes = "";
			$this->Logo->HrefValue = "";
			$this->Logo->TooltipValue = "";

			// Fecha_expedicion
			$this->Fecha_expedicion->LinkCustomAttributes = "";
			$this->Fecha_expedicion->HrefValue = "";
			$this->Fecha_expedicion->TooltipValue = "";

			// Dpto_expedicion
			$this->Dpto_expedicion->LinkCustomAttributes = "";
			$this->Dpto_expedicion->HrefValue = "";
			$this->Dpto_expedicion->TooltipValue = "";

			// Mun_expedicion
			$this->Mun_expedicion->LinkCustomAttributes = "";
			$this->Mun_expedicion->HrefValue = "";
			$this->Mun_expedicion->TooltipValue = "";

			// Nombre_solicitante
			$this->Nombre_solicitante->LinkCustomAttributes = "";
			$this->Nombre_solicitante->HrefValue = "";
			$this->Nombre_solicitante->TooltipValue = "";

			// tipo_muerte
			$this->tipo_muerte->LinkCustomAttributes = "";
			$this->tipo_muerte->HrefValue = "";
			$this->tipo_muerte->TooltipValue = "";

			// Nombres
			$this->Nombres->LinkCustomAttributes = "";
			$this->Nombres->HrefValue = "";
			$this->Nombres->TooltipValue = "";

			// Apellidos
			$this->Apellidos->LinkCustomAttributes = "";
			$this->Apellidos->HrefValue = "";
			$this->Apellidos->TooltipValue = "";

			// Genero
			$this->Genero->LinkCustomAttributes = "";
			$this->Genero->HrefValue = "";
			$this->Genero->TooltipValue = "";

			// Fecha_Fallecimiento
			$this->Fecha_Fallecimiento->LinkCustomAttributes = "";
			$this->Fecha_Fallecimiento->HrefValue = "";
			$this->Fecha_Fallecimiento->TooltipValue = "";

			// p_manera_muerte
			$this->p_manera_muerte->LinkCustomAttributes = "";
			$this->p_manera_muerte->HrefValue = "";
			$this->p_manera_muerte->TooltipValue = "";

			// No_certificado
			$this->No_certificado->LinkCustomAttributes = "";
			$this->No_certificado->HrefValue = "";
			$this->No_certificado->TooltipValue = "";

			// Tipo_doc
			$this->Tipo_doc->LinkCustomAttributes = "";
			$this->Tipo_doc->HrefValue = "";
			$this->Tipo_doc->TooltipValue = "";

			// Documento
			$this->Documento->LinkCustomAttributes = "";
			$this->Documento->HrefValue = "";
			$this->Documento->TooltipValue = "";

			// Tipo_edad
			$this->Tipo_edad->LinkCustomAttributes = "";
			$this->Tipo_edad->HrefValue = "";
			$this->Tipo_edad->TooltipValue = "";

			// Edad
			$this->Edad->LinkCustomAttributes = "";
			$this->Edad->HrefValue = "";
			$this->Edad->TooltipValue = "";

			// Funcionario_expide
			$this->Funcionario_expide->LinkCustomAttributes = "";
			$this->Funcionario_expide->HrefValue = "";
			$this->Funcionario_expide->TooltipValue = "";

			// Permiso_inhumar
			$this->Permiso_inhumar->LinkCustomAttributes = "";
			$this->Permiso_inhumar->HrefValue = "";
			$this->Permiso_inhumar->TooltipValue = "";

			// Permiso_cremar
			$this->Permiso_cremar->LinkCustomAttributes = "";
			$this->Permiso_cremar->HrefValue = "";
			$this->Permiso_cremar->TooltipValue = "";

			// Firma_funcionario
			$this->Firma_funcionario->LinkCustomAttributes = "";
			$this->Firma_funcionario->HrefValue = "";
			$this->Firma_funcionario->TooltipValue = "";

			// Codigo_qr
			$this->Codigo_qr->LinkCustomAttributes = "";
			$this->Codigo_qr->HrefValue = "";
			$this->Codigo_qr->HrefValue2 = array("exportfn" => "ew_BarCodeImageTag", "barcode" => $this->Documento->CurrentValue, "encode" => 'QRCODE', "height" => 60);
			$this->Codigo_qr->TooltipValue = "";

			// Verificacion_codigo_qr
			$this->Verificacion_codigo_qr->LinkCustomAttributes = "";
			$this->Verificacion_codigo_qr->HrefValue = "";
			$this->Verificacion_codigo_qr->TooltipValue = "";

			// Registrado_por
			$this->Registrado_por->LinkCustomAttributes = "";
			$this->Registrado_por->HrefValue = "";
			$this->Registrado_por->TooltipValue = "";

			// Fecha_registro
			$this->Fecha_registro->LinkCustomAttributes = "";
			$this->Fecha_registro->HrefValue = "";
			$this->Fecha_registro->TooltipValue = "";

			// observaciones
			$this->observaciones->LinkCustomAttributes = "";
			$this->observaciones->HrefValue = "";
			$this->observaciones->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up export options
	function SetupExportOptions() {
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ewExportLink ewPrint\" title=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("PrinterFriendlyText")) . "\">" . $Language->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		if ($this->ExportExcelCustom)
			$item->Body = "<a href=\"javascript:void(0);\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" onclick=\"ew_Export(document.flicenciasview,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->Phrase("ExportToExcel") . "</a>";
		else
			$item->Body = "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ewExportLink ewExcel\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToExcelText")) . "\">" . $Language->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		if ($this->ExportWordCustom)
			$item->Body = "<a href=\"javascript:void(0);\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" onclick=\"ew_Export(document.flicenciasview,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->Phrase("ExportToWord") . "</a>";
		else
			$item->Body = "<a href=\"" . $this->ExportWordUrl . "\" class=\"ewExportLink ewWord\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToWordText")) . "\">" . $Language->Phrase("ExportToWord") . "</a>";
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->Add("html");
		$item->Body = "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ewExportLink ewHtml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToHtmlText")) . "\">" . $Language->Phrase("ExportToHtml") . "</a>";
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->Add("xml");
		$item->Body = "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ewExportLink ewXml\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToXmlText")) . "\">" . $Language->Phrase("ExportToXml") . "</a>";
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->Add("csv");
		$item->Body = "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ewExportLink ewCsv\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToCsvText")) . "\">" . $Language->Phrase("ExportToCsv") . "</a>";
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		if ($this->ExportPdfCustom)
			$item->Body = "<a href=\"javascript:void(0);\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" onclick=\"ew_Export(document.flicenciasview,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->Phrase("ExportToPDF") . "</a>";
		else
			$item->Body = "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ewExportLink ewPdf\" title=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\" data-caption=\"" . ew_HtmlEncode($Language->Phrase("ExportToPDFText")) . "\">" . $Language->Phrase("ExportToPDF") . "</a>";
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->Add("email");
		$url = $this->ExportEmailCustom ? ",url:'" . $this->PageUrl() . "export=email&amp;custom=1'" : "";
		$item->Body = "<button id=\"emf_licencias\" class=\"ewExportLink ewEmail\" title=\"" . $Language->Phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->Phrase("ExportToEmailText") . "\" onclick=\"ew_EmailDialogShow({lnk:'emf_licencias',hdr:ewLanguage.Phrase('ExportToEmailText'),f:document.flicenciasview,key:" . ew_ArrayToJsonAttr($this->RecKey) . ",sel:false" . $url . "});\">" . $Language->Phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && ew_IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide options for export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();
	}

	// Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	function ExportData() {
		$utf8 = (strtolower(EW_CHARSET) == "utf-8");
		$bSelectLimit = FALSE;

		// Load recordset
		if ($bSelectLimit) {
			$this->TotalRecs = $this->SelectRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->LoadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;
		$this->SetUpStartRec(); // Set up start record position

		// Set the last record to display
		if ($this->DisplayRecs <= 0) {
			$this->StopRec = $this->TotalRecs;
		} else {
			$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
		}
		if (!$rs) {
			header("Content-Type:"); // Remove header
			header("Content-Disposition:");
			$this->ShowMessage();
			return;
		}
		$this->ExportDoc = ew_ExportDocument($this, "v");
		$Doc = &$this->ExportDoc;
		if ($bSelectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		} else {

			//$this->StartRec = $this->StartRec;
			//$this->StopRec = $this->StopRec;

		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$ParentTable = "";
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		$Doc->Text .= $sHeader;
		$this->ExportDocument($Doc, $rs, $this->StartRec, $this->StopRec, "view");
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		$Doc->Text .= $sFooter;

		// Close recordset
		$rs->Close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$Doc->ExportHeaderAndFooter();

		// Clean output buffer
		if (!EW_DEBUG_ENABLED && ob_get_length())
			ob_end_clean();

		// Write debug message if enabled
		if (EW_DEBUG_ENABLED && $this->Export <> "pdf")
			echo ew_DebugMsg();

		// Output data
		$Doc->Export();
	}

	// Show link optionally based on User ID
	function ShowOptionLink($id = "") {
		global $Security;
		if ($Security->IsLoggedIn() && !$Security->IsAdmin() && !$this->UserIDAllow($id))
			return $Security->IsValidUserID($this->Entidad->CurrentValue);
		return TRUE;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("licenciaslist.php"), "", $this->TableVar, TRUE);
		$PageId = "view";
		$Breadcrumb->Add("view", $PageId, $url);
	}

	// Set up multi pages
	function SetupMultiPages() {
		$pages = new cSubPages();
		$pages->Style = "tabs";
		$pages->Add(0);
		$pages->Add(1);
		$pages->Add(2);
		$this->MultiPages = $pages;
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($licencias_view)) $licencias_view = new clicencias_view();

// Page init
$licencias_view->Page_Init();

// Page main
$licencias_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$licencias_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if ($licencias->Export == "") { ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "view";
var CurrentForm = flicenciasview = new ew_Form("flicenciasview", "view");

// Form_CustomValidate event
flicenciasview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
flicenciasview.ValidateRequired = true;
<?php } else { ?>
flicenciasview.ValidateRequired = false; 
<?php } ?>

// Multi-Page
flicenciasview.MultiPage = new ew_MultiPage("flicenciasview");

// Dynamic selection lists
flicenciasview.Lists["x_tipo_muerte"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Tipo_muerte","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasview.Lists["x_Genero"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Genero","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasview.Lists["x_p_manera_muerte"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_probable_manera","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasview.Lists["x_Tipo_doc"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_tipo_documento","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasview.Lists["x_Tipo_edad"] = {"LinkField":"x_Id","Ajax":true,"AutoFill":false,"DisplayFields":["x_Tipo_edad","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};
flicenciasview.Lists["x_Registrado_por"] = {"LinkField":"x_Usuario","Ajax":true,"AutoFill":false,"DisplayFields":["x_Usuario","","",""],"ParentFields":[],"ChildFields":[],"FilterFields":[],"Options":[],"Template":""};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($licencias->Export == "") { ?>
<div class="ewToolbar">
<?php if ($licencias->Export == "") { ?>
<?php $Breadcrumb->Render(); ?>
<?php } ?>
<?php $licencias_view->ExportOptions->Render("body") ?>
<?php
	foreach ($licencias_view->OtherOptions as &$option)
		$option->Render("body");
?>
<?php if ($licencias->Export == "") { ?>
<?php echo $Language->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $licencias_view->ShowPageHeader(); ?>
<?php
$licencias_view->ShowMessage();
?>
<form name="flicenciasview" id="flicenciasview" class="form-inline ewForm ewViewForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($licencias_view->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $licencias_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="licencias">
<div id="tpd_licenciasview" class="ewCustomTemplate"></div>
<script id="tpm_licenciasview" type="text/html">
<div id="ct_licencias_view"><table style="width: 718px; height: 400px;"
 class="table table-bordered table-striped" border="0">
  <tbody>
	<tr align="center">
	  <td style="width: 232px; height: 18px;" colspan="3"
 rowspan="1"><span style="font-weight: bold;"><small><small>EL</small>
	  <small>PRESENTE FORMULARIO ES
GRATUITO, POR LO TANTO ESTA PROHIBIDA SU VENTA</small></small></span></td>
	</tr>
	<tr align="center">
	  <td
 style="font-weight: bold; width: 258px; height: 39px; vertical-align: bottom;"
 colspan="1" rowspan="1">{{include tmpl="#tpx_licencias_Logo"/}}<br>
	  <big><span style="font-weight: bold;"><br>
	  </span></big></td>
	  <td
 style="font-weight: bold; width: 232px; vertical-align: bottom; text-align: left; height: 39px;"
 rowspan="1" colspan="2"><big>LICENCIA
DE INHUMACION</big></td>
	</tr>
	<tr>
	  <td colspan="1" rowspan="1"
 style="font-weight: bold; width: 208px; height: 40px;">
	  <div style="text-align: center;"><br>
	  </div>
	  <div style="text-align: center;">
No.<big><big><span style="text-decoration: underline;">{{include tmpl="#tpx_licencias_Id"/}}</span></big></big>&nbsp;
	  </div>
	  </td>
	  <td style="text-align: right; height: 40px;" colspan="2"
 rowspan="1"><small>
	  </small>
	  <div style="text-align: center;"><small><span
 style="font-weight: bold;"><?php echo $licencias->Fecha_expedicion->FldCaption() ?></span><br>
	  <span style="font-weight: bold;">{{include tmpl="#tpx_licencias_Fecha_expedicion"/}}</span></small></div>
	  </td>
	</tr>
	<tr>
	  <td style="font-weight: bold; width: 254px; height: 86px;"><small>LUGAR
DE EXPEDICION</small><br>
<?php echo $licencias->Dpto_expedicion->FldCaption() ?><span style="font-weight: normal;">{{include tmpl="#tpx_licencias_Dpto_expedicion"/}}</span><br>
<?php echo $licencias->Mun_expedicion->FldCaption() ?><span style="font-weight: normal;">{{include tmpl="#tpx_licencias_Mun_expedicion"/}}</span><br>
	  </td>
	  <td style="width: 208px; height: 86px;"><span
 style="font-weight: bold;"><?php echo $licencias->Nombre_solicitante->FldCaption() ?></span><br>
	  <small>{{include tmpl="#tpx_licencias_Nombre_solicitante"/}}</small><br>
	  <span style="color: white;">aaa</span><br>
	  </td>
	  <td style="width: 232px; height: 86px;"><small><span
 style="font-weight: bold;">TIPO MUERTE</span></small><br>
	  <small><span style="font-weight: normal;">{{include tmpl="#tpx_licencias_tipo_muerte"/}}</span></small><br>
	  </td>
	</tr>
	<tr>
	  <td rowspan="1" colspan="2"
 style="font-weight: bold; width: 254px; vertical-align: top; height: 46px;"><small><span
 style="font-weight: bold;">NOMBRE
DEL FALLECIDO<br>
	  </span></small><span style="font-weight: normal;">{{include tmpl="#tpx_licencias_Nombres"/}}</span> &nbsp; <span
 style="font-weight: normal;">{{include tmpl="#tpx_licencias_Apellidos"/}}</span><span style="font-weight: normal;">
	  </span></td>
	  <td style="width: 232px; height: 46px;" colspan="1"
 rowspan="1"><span style="font-weight: bold;"><?php echo $licencias->Genero->FldCaption() ?></span><br>
	  <small>{{include tmpl="#tpx_licencias_Genero"/}}</small><br>
	  </td>
	</tr>
	<tr>
	  <td style="width: 208px; height: 47px;"><small
 style="font-weight: bold;"><?php echo $licencias->Fecha_Fallecimiento->FldCaption() ?></small><br>
	  <span style="font-weight: normal;">{{include tmpl="#tpx_licencias_Fecha_Fallecimiento"/}}</span><span style="color: white;">aaaa</span><br>
	  </td>
	  <td style="width: 208px; height: 47px;"><small><span
 style="font-weight: bold;">PROBABLE MANERA MUERTE</span></small><br>
	  <small>{{include tmpl="#tpx_licencias_p_manera_muerte"/}}</small>
	  </td>
	  <td style="width: 232px; height: 47px;"><span
 style="font-weight: bold;"><small>CERTIFICADO DE
DEFUNCION</small><br>
No.</span>{{include tmpl="#tpx_licencias_No_certificado"/}}
	  </td>
	</tr>
	<tr>
	  <td style="width: 254px; height: 46px;" colspan="1"
 rowspan="1"><small><span style="font-weight: bold;">DOCUMENTO
DE IDENTIFICACION</span></small><br>
	  <small>{{include tmpl="#tpx_licencias_Documento"/}}</small><br>
	  </td>
	  <td style="width: 208px; height: 46px;"><small><span
 style="font-weight: bold;">TIPO DOCUMENTO</span></small><br>
	  <small>{{include tmpl="#tpx_licencias_Tipo_doc"/}}</small><br>
	  </td>
	  <td style="width: 208px; height: 46px;"><small><span
 style="font-weight: bold;">EDAD:&nbsp;</span></small><span
 style="font-weight: normal;">{{include tmpl="#tpx_licencias_Edad"/}}</span><small><span
 style="font-weight: bold;"> &nbsp;
&nbsp; &nbsp; &nbsp; &nbsp;</span></small><br>
	  <small><span style="font-weight: bold;">Tipo
Edad:</span><span style="font-weight: normal;">{{include tmpl="#tpx_licencias_Tipo_edad"/}}</span></small><br>
	  </td>
	</tr>
	<tr>
	  <td colspan="2" rowspan="1"
 style="font-weight: bold; width: 254px; height: 49px;"><small><small>
PERMISO PARA INHUMAR
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
&nbsp; &nbsp; PERMISO PARA CREMAR</small>&nbsp;</small><br>
	  <small><span style="font-weight: normal;"></span></small><span
 style="color: white;"></span><span
 style="color: white;"></span><small><span
 style="font-weight: normal;">{{include tmpl="#tpx_licencias_Permiso_inhumar"/}}</span></small><span
 style="font-weight: normal;"><span style="color: white;">aa</span><span
 style="color: white;"> &nbsp; &nbsp;&nbsp;
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
&nbsp; &nbsp; &nbsp; &nbsp; </span></span><small><span
 style="font-weight: normal;">{{include tmpl="#tpx_licencias_Permiso_cremar"/}}</span></small><span
 style="color: white;"><small>a</small>a</span><span
 style="font-weight: normal;"><span style="color: white;">a</span><span
 style="color: white;"></span></span><span
 style="color: white;">aaa</span><br>
	  <small>{{include tmpl="#tpx_licencias_observaciones"/}}</small><br>
	  </td>
	  <td style="font-weight: bold; width: 232px; height: 49px;"><small>
FUNCIONARIO EXPIDE LICENCIA</small><br>
{{include tmpl="#tpx_licencias_Funcionario_expide"/}}<br>
{{include tmpl="#tpx_licencias_Firma_funcionario"/}}<span style="color: white;">aa</span><span
 style="font-weight: normal;">
	  </span></td>
	</tr>
	<tr>
	  <td style="font-weight: bold; width: 208px; height: 53px;"
 colspan="2" rowspan="1"><big>{{include tmpl="#tpx_licencias_Verificacion_codigo_qr"/}}</big></td>
	  <td style="width: 232px; height: 53px;">{{include tmpl="#tpx_licencias_Codigo_qr"/}}</td>
	</tr>
  </tbody>
</table>
</div>
</script>
<?php if ($licencias->Export == "") { ?>
<div class="ewMultiPage" style="display: none">
<div class="tabbable" id="licencias_view">
	<ul class="nav<?php echo $licencias_view->MultiPages->NavStyle() ?>">
		<li<?php echo $licencias_view->MultiPages->TabStyle("1") ?>><a href="#tab_licencias1" data-toggle="tab"><?php echo $licencias->PageCaption(1) ?></a></li>
		<li<?php echo $licencias_view->MultiPages->TabStyle("2") ?>><a href="#tab_licencias2" data-toggle="tab"><?php echo $licencias->PageCaption(2) ?></a></li>
	</ul>
	<div class="tab-content">
<?php } ?>
<?php if ($licencias->Export == "") { ?>
		<div class="tab-pane<?php echo $licencias_view->MultiPages->PageStyle("1") ?>" id="tab_licencias1">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable" style="display: none">
<?php if ($licencias->Id->Visible) { // Id ?>
	<tr id="r_Id">
		<td><span id="elh_licencias_Id"><script id="tpc_licencias_Id" class="licenciasview" type="text/html"><span><?php echo $licencias->Id->FldCaption() ?></span></script></span></td>
		<td data-name="Id"<?php echo $licencias->Id->CellAttributes() ?>>
<script id="tpx_licencias_Id" class="licenciasview" type="text/html">
<span id="el_licencias_Id" data-page="1">
<span<?php echo $licencias->Id->ViewAttributes() ?>>
<?php echo $licencias->Id->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->IPS2FMEDICO->Visible) { // IPS/MEDICO ?>
	<tr id="r_IPS2FMEDICO">
		<td><span id="elh_licencias_IPS2FMEDICO"><script id="tpc_licencias_IPS2FMEDICO" class="licenciasview" type="text/html"><span><?php echo $licencias->IPS2FMEDICO->FldCaption() ?></span></script></span></td>
		<td data-name="IPS2FMEDICO"<?php echo $licencias->IPS2FMEDICO->CellAttributes() ?>>
<script id="tpx_licencias_IPS2FMEDICO" class="licenciasview" type="text/html">
<span id="el_licencias_IPS2FMEDICO" data-page="1">
<span<?php echo $licencias->IPS2FMEDICO->ViewAttributes() ?>>
<?php echo $licencias->IPS2FMEDICO->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Fecha_expedicion->Visible) { // Fecha_expedicion ?>
	<tr id="r_Fecha_expedicion">
		<td><span id="elh_licencias_Fecha_expedicion"><script id="tpc_licencias_Fecha_expedicion" class="licenciasview" type="text/html"><span><?php echo $licencias->Fecha_expedicion->FldCaption() ?></span></script></span></td>
		<td data-name="Fecha_expedicion"<?php echo $licencias->Fecha_expedicion->CellAttributes() ?>>
<script id="tpx_licencias_Fecha_expedicion" class="licenciasview" type="text/html">
<span id="el_licencias_Fecha_expedicion" data-page="1">
<span<?php echo $licencias->Fecha_expedicion->ViewAttributes() ?>>
<?php echo $licencias->Fecha_expedicion->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Nombre_solicitante->Visible) { // Nombre_solicitante ?>
	<tr id="r_Nombre_solicitante">
		<td><span id="elh_licencias_Nombre_solicitante"><script id="tpc_licencias_Nombre_solicitante" class="licenciasview" type="text/html"><span><?php echo $licencias->Nombre_solicitante->FldCaption() ?></span></script></span></td>
		<td data-name="Nombre_solicitante"<?php echo $licencias->Nombre_solicitante->CellAttributes() ?>>
<script id="tpx_licencias_Nombre_solicitante" class="licenciasview" type="text/html">
<span id="el_licencias_Nombre_solicitante" data-page="1">
<span<?php echo $licencias->Nombre_solicitante->ViewAttributes() ?>>
<?php echo $licencias->Nombre_solicitante->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->tipo_muerte->Visible) { // tipo_muerte ?>
	<tr id="r_tipo_muerte">
		<td><span id="elh_licencias_tipo_muerte"><script id="tpc_licencias_tipo_muerte" class="licenciasview" type="text/html"><span><?php echo $licencias->tipo_muerte->FldCaption() ?></span></script></span></td>
		<td data-name="tipo_muerte"<?php echo $licencias->tipo_muerte->CellAttributes() ?>>
<script id="tpx_licencias_tipo_muerte" class="licenciasview" type="text/html">
<span id="el_licencias_tipo_muerte" data-page="1">
<span<?php echo $licencias->tipo_muerte->ViewAttributes() ?>>
<?php echo $licencias->tipo_muerte->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Nombres->Visible) { // Nombres ?>
	<tr id="r_Nombres">
		<td><span id="elh_licencias_Nombres"><script id="tpc_licencias_Nombres" class="licenciasview" type="text/html"><span><?php echo $licencias->Nombres->FldCaption() ?></span></script></span></td>
		<td data-name="Nombres"<?php echo $licencias->Nombres->CellAttributes() ?>>
<script id="tpx_licencias_Nombres" class="licenciasview" type="text/html">
<span id="el_licencias_Nombres" data-page="1">
<span<?php echo $licencias->Nombres->ViewAttributes() ?>>
<?php echo $licencias->Nombres->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Apellidos->Visible) { // Apellidos ?>
	<tr id="r_Apellidos">
		<td><span id="elh_licencias_Apellidos"><script id="tpc_licencias_Apellidos" class="licenciasview" type="text/html"><span><?php echo $licencias->Apellidos->FldCaption() ?></span></script></span></td>
		<td data-name="Apellidos"<?php echo $licencias->Apellidos->CellAttributes() ?>>
<script id="tpx_licencias_Apellidos" class="licenciasview" type="text/html">
<span id="el_licencias_Apellidos" data-page="1">
<span<?php echo $licencias->Apellidos->ViewAttributes() ?>>
<?php echo $licencias->Apellidos->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Genero->Visible) { // Genero ?>
	<tr id="r_Genero">
		<td><span id="elh_licencias_Genero"><script id="tpc_licencias_Genero" class="licenciasview" type="text/html"><span><?php echo $licencias->Genero->FldCaption() ?></span></script></span></td>
		<td data-name="Genero"<?php echo $licencias->Genero->CellAttributes() ?>>
<script id="tpx_licencias_Genero" class="licenciasview" type="text/html">
<span id="el_licencias_Genero" data-page="1">
<span<?php echo $licencias->Genero->ViewAttributes() ?>>
<?php echo $licencias->Genero->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Fecha_Fallecimiento->Visible) { // Fecha_Fallecimiento ?>
	<tr id="r_Fecha_Fallecimiento">
		<td><span id="elh_licencias_Fecha_Fallecimiento"><script id="tpc_licencias_Fecha_Fallecimiento" class="licenciasview" type="text/html"><span><?php echo $licencias->Fecha_Fallecimiento->FldCaption() ?></span></script></span></td>
		<td data-name="Fecha_Fallecimiento"<?php echo $licencias->Fecha_Fallecimiento->CellAttributes() ?>>
<script id="tpx_licencias_Fecha_Fallecimiento" class="licenciasview" type="text/html">
<span id="el_licencias_Fecha_Fallecimiento" data-page="1">
<span<?php echo $licencias->Fecha_Fallecimiento->ViewAttributes() ?>>
<?php echo $licencias->Fecha_Fallecimiento->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->p_manera_muerte->Visible) { // p_manera_muerte ?>
	<tr id="r_p_manera_muerte">
		<td><span id="elh_licencias_p_manera_muerte"><script id="tpc_licencias_p_manera_muerte" class="licenciasview" type="text/html"><span><?php echo $licencias->p_manera_muerte->FldCaption() ?></span></script></span></td>
		<td data-name="p_manera_muerte"<?php echo $licencias->p_manera_muerte->CellAttributes() ?>>
<script id="tpx_licencias_p_manera_muerte" class="licenciasview" type="text/html">
<span id="el_licencias_p_manera_muerte" data-page="1">
<span<?php echo $licencias->p_manera_muerte->ViewAttributes() ?>>
<?php echo $licencias->p_manera_muerte->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->No_certificado->Visible) { // No_certificado ?>
	<tr id="r_No_certificado">
		<td><span id="elh_licencias_No_certificado"><script id="tpc_licencias_No_certificado" class="licenciasview" type="text/html"><span><?php echo $licencias->No_certificado->FldCaption() ?></span></script></span></td>
		<td data-name="No_certificado"<?php echo $licencias->No_certificado->CellAttributes() ?>>
<script id="tpx_licencias_No_certificado" class="licenciasview" type="text/html">
<span id="el_licencias_No_certificado" data-page="1">
<span<?php echo $licencias->No_certificado->ViewAttributes() ?>>
<?php echo $licencias->No_certificado->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Tipo_doc->Visible) { // Tipo_doc ?>
	<tr id="r_Tipo_doc">
		<td><span id="elh_licencias_Tipo_doc"><script id="tpc_licencias_Tipo_doc" class="licenciasview" type="text/html"><span><?php echo $licencias->Tipo_doc->FldCaption() ?></span></script></span></td>
		<td data-name="Tipo_doc"<?php echo $licencias->Tipo_doc->CellAttributes() ?>>
<script id="tpx_licencias_Tipo_doc" class="licenciasview" type="text/html">
<span id="el_licencias_Tipo_doc" data-page="1">
<span<?php echo $licencias->Tipo_doc->ViewAttributes() ?>>
<?php echo $licencias->Tipo_doc->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Documento->Visible) { // Documento ?>
	<tr id="r_Documento">
		<td><span id="elh_licencias_Documento"><script id="tpc_licencias_Documento" class="licenciasview" type="text/html"><span><?php echo $licencias->Documento->FldCaption() ?></span></script></span></td>
		<td data-name="Documento"<?php echo $licencias->Documento->CellAttributes() ?>>
<script id="tpx_licencias_Documento" class="licenciasview" type="text/html">
<span id="el_licencias_Documento" data-page="1">
<span<?php echo $licencias->Documento->ViewAttributes() ?>>
<?php echo $licencias->Documento->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Tipo_edad->Visible) { // Tipo_edad ?>
	<tr id="r_Tipo_edad">
		<td><span id="elh_licencias_Tipo_edad"><script id="tpc_licencias_Tipo_edad" class="licenciasview" type="text/html"><span><?php echo $licencias->Tipo_edad->FldCaption() ?></span></script></span></td>
		<td data-name="Tipo_edad"<?php echo $licencias->Tipo_edad->CellAttributes() ?>>
<script id="tpx_licencias_Tipo_edad" class="licenciasview" type="text/html">
<span id="el_licencias_Tipo_edad" data-page="1">
<span<?php echo $licencias->Tipo_edad->ViewAttributes() ?>>
<?php echo $licencias->Tipo_edad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Edad->Visible) { // Edad ?>
	<tr id="r_Edad">
		<td><span id="elh_licencias_Edad"><script id="tpc_licencias_Edad" class="licenciasview" type="text/html"><span><?php echo $licencias->Edad->FldCaption() ?></span></script></span></td>
		<td data-name="Edad"<?php echo $licencias->Edad->CellAttributes() ?>>
<script id="tpx_licencias_Edad" class="licenciasview" type="text/html">
<span id="el_licencias_Edad" data-page="1">
<span<?php echo $licencias->Edad->ViewAttributes() ?>>
<?php echo $licencias->Edad->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Funcionario_expide->Visible) { // Funcionario_expide ?>
	<tr id="r_Funcionario_expide">
		<td><span id="elh_licencias_Funcionario_expide"><script id="tpc_licencias_Funcionario_expide" class="licenciasview" type="text/html"><span><?php echo $licencias->Funcionario_expide->FldCaption() ?></span></script></span></td>
		<td data-name="Funcionario_expide"<?php echo $licencias->Funcionario_expide->CellAttributes() ?>>
<script id="tpx_licencias_Funcionario_expide" class="licenciasview" type="text/html">
<span id="el_licencias_Funcionario_expide" data-page="1">
<span<?php echo $licencias->Funcionario_expide->ViewAttributes() ?>>
<?php echo $licencias->Funcionario_expide->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Permiso_inhumar->Visible) { // Permiso_inhumar ?>
	<tr id="r_Permiso_inhumar">
		<td><span id="elh_licencias_Permiso_inhumar"><script id="tpc_licencias_Permiso_inhumar" class="licenciasview" type="text/html"><span><?php echo $licencias->Permiso_inhumar->FldCaption() ?></span></script></span></td>
		<td data-name="Permiso_inhumar"<?php echo $licencias->Permiso_inhumar->CellAttributes() ?>>
<script id="tpx_licencias_Permiso_inhumar" class="licenciasview" type="text/html">
<span id="el_licencias_Permiso_inhumar" data-page="1">
<span<?php echo $licencias->Permiso_inhumar->ViewAttributes() ?>>
<?php echo $licencias->Permiso_inhumar->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Permiso_cremar->Visible) { // Permiso_cremar ?>
	<tr id="r_Permiso_cremar">
		<td><span id="elh_licencias_Permiso_cremar"><script id="tpc_licencias_Permiso_cremar" class="licenciasview" type="text/html"><span><?php echo $licencias->Permiso_cremar->FldCaption() ?></span></script></span></td>
		<td data-name="Permiso_cremar"<?php echo $licencias->Permiso_cremar->CellAttributes() ?>>
<script id="tpx_licencias_Permiso_cremar" class="licenciasview" type="text/html">
<span id="el_licencias_Permiso_cremar" data-page="1">
<span<?php echo $licencias->Permiso_cremar->ViewAttributes() ?>>
<?php echo $licencias->Permiso_cremar->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->observaciones->Visible) { // observaciones ?>
	<tr id="r_observaciones">
		<td><span id="elh_licencias_observaciones"><script id="tpc_licencias_observaciones" class="licenciasview" type="text/html"><span><?php echo $licencias->observaciones->FldCaption() ?></span></script></span></td>
		<td data-name="observaciones"<?php echo $licencias->observaciones->CellAttributes() ?>>
<script id="tpx_licencias_observaciones" class="licenciasview" type="text/html">
<span id="el_licencias_observaciones" data-page="1">
<span<?php echo $licencias->observaciones->ViewAttributes() ?>>
<?php echo $licencias->observaciones->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($licencias->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($licencias->Export == "") { ?>
		<div class="tab-pane<?php echo $licencias_view->MultiPages->PageStyle("2") ?>" id="tab_licencias2">
<?php } ?>
<table class="table table-bordered table-striped ewViewTable" style="display: none">
<?php if ($licencias->Logo->Visible) { // Logo ?>
	<tr id="r_Logo">
		<td><span id="elh_licencias_Logo"><script id="tpc_licencias_Logo" class="licenciasview" type="text/html"><span><?php echo $licencias->Logo->FldCaption() ?></span></script></span></td>
		<td data-name="Logo"<?php echo $licencias->Logo->CellAttributes() ?>>
<script id="tpx_licencias_Logo" class="licenciasview" type="text/html">
<span id="el_licencias_Logo" data-page="2">
<span>
<?php if (!ew_EmptyStr($licencias->Logo->ViewValue)) { ?><img src="<?php echo $licencias->Logo->ViewValue ?>" alt=""<?php echo $licencias->Logo->ViewAttributes() ?>><?php } ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Dpto_expedicion->Visible) { // Dpto_expedicion ?>
	<tr id="r_Dpto_expedicion">
		<td><span id="elh_licencias_Dpto_expedicion"><script id="tpc_licencias_Dpto_expedicion" class="licenciasview" type="text/html"><span><?php echo $licencias->Dpto_expedicion->FldCaption() ?></span></script></span></td>
		<td data-name="Dpto_expedicion"<?php echo $licencias->Dpto_expedicion->CellAttributes() ?>>
<script id="tpx_licencias_Dpto_expedicion" class="licenciasview" type="text/html">
<span id="el_licencias_Dpto_expedicion" data-page="2">
<span<?php echo $licencias->Dpto_expedicion->ViewAttributes() ?>>
<?php echo $licencias->Dpto_expedicion->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Mun_expedicion->Visible) { // Mun_expedicion ?>
	<tr id="r_Mun_expedicion">
		<td><span id="elh_licencias_Mun_expedicion"><script id="tpc_licencias_Mun_expedicion" class="licenciasview" type="text/html"><span><?php echo $licencias->Mun_expedicion->FldCaption() ?></span></script></span></td>
		<td data-name="Mun_expedicion"<?php echo $licencias->Mun_expedicion->CellAttributes() ?>>
<script id="tpx_licencias_Mun_expedicion" class="licenciasview" type="text/html">
<span id="el_licencias_Mun_expedicion" data-page="2">
<span<?php echo $licencias->Mun_expedicion->ViewAttributes() ?>>
<?php echo $licencias->Mun_expedicion->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Firma_funcionario->Visible) { // Firma_funcionario ?>
	<tr id="r_Firma_funcionario">
		<td><span id="elh_licencias_Firma_funcionario"><script id="tpc_licencias_Firma_funcionario" class="licenciasview" type="text/html"><span><?php echo $licencias->Firma_funcionario->FldCaption() ?></span></script></span></td>
		<td data-name="Firma_funcionario"<?php echo $licencias->Firma_funcionario->CellAttributes() ?>>
<script id="tpx_licencias_Firma_funcionario" class="licenciasview" type="text/html">
<span id="el_licencias_Firma_funcionario" data-page="2">
<span>
<?php if (!ew_EmptyStr($licencias->Firma_funcionario->ViewValue)) { ?><img src="<?php echo $licencias->Firma_funcionario->ViewValue ?>" alt=""<?php echo $licencias->Firma_funcionario->ViewAttributes() ?>><?php } ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Codigo_qr->Visible) { // Codigo_qr ?>
	<tr id="r_Codigo_qr">
		<td><span id="elh_licencias_Codigo_qr"><script id="tpc_licencias_Codigo_qr" class="licenciasview" type="text/html"><span><?php echo $licencias->Codigo_qr->FldCaption() ?></span></script></span></td>
		<td data-name="Codigo_qr"<?php echo $licencias->Codigo_qr->CellAttributes() ?>>
<div id="orig_licencias_Codigo_qr" class="hide">
<span id="el_licencias_Codigo_qr" data-page="2">
<span<?php echo $licencias->Codigo_qr->ViewAttributes() ?>>
<?php echo $licencias->Codigo_qr->ViewValue ?></span>
</span>
</div>
<script id="tpx_licencias_Codigo_qr" class="licenciasview" type="text/html">
<span id="cvt_licencias_Codigo_qr"><?php echo ew_ShowBarCode($licencias->Documento->CurrentValue, 'QRCODE', 60) ?></span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Verificacion_codigo_qr->Visible) { // Verificacion_codigo_qr ?>
	<tr id="r_Verificacion_codigo_qr">
		<td><span id="elh_licencias_Verificacion_codigo_qr"><script id="tpc_licencias_Verificacion_codigo_qr" class="licenciasview" type="text/html"><span><?php echo $licencias->Verificacion_codigo_qr->FldCaption() ?></span></script></span></td>
		<td data-name="Verificacion_codigo_qr"<?php echo $licencias->Verificacion_codigo_qr->CellAttributes() ?>>
<script id="tpx_licencias_Verificacion_codigo_qr" class="licenciasview" type="text/html">
<span id="el_licencias_Verificacion_codigo_qr" data-page="2">
<span<?php echo $licencias->Verificacion_codigo_qr->ViewAttributes() ?>>
<?php echo $licencias->Verificacion_codigo_qr->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Registrado_por->Visible) { // Registrado_por ?>
	<tr id="r_Registrado_por">
		<td><span id="elh_licencias_Registrado_por"><script id="tpc_licencias_Registrado_por" class="licenciasview" type="text/html"><span><?php echo $licencias->Registrado_por->FldCaption() ?></span></script></span></td>
		<td data-name="Registrado_por"<?php echo $licencias->Registrado_por->CellAttributes() ?>>
<script id="tpx_licencias_Registrado_por" class="licenciasview" type="text/html">
<span id="el_licencias_Registrado_por" data-page="2">
<span<?php echo $licencias->Registrado_por->ViewAttributes() ?>>
<?php echo $licencias->Registrado_por->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
<?php if ($licencias->Fecha_registro->Visible) { // Fecha_registro ?>
	<tr id="r_Fecha_registro">
		<td><span id="elh_licencias_Fecha_registro"><script id="tpc_licencias_Fecha_registro" class="licenciasview" type="text/html"><span><?php echo $licencias->Fecha_registro->FldCaption() ?></span></script></span></td>
		<td data-name="Fecha_registro"<?php echo $licencias->Fecha_registro->CellAttributes() ?>>
<script id="tpx_licencias_Fecha_registro" class="licenciasview" type="text/html">
<span id="el_licencias_Fecha_registro" data-page="2">
<span<?php echo $licencias->Fecha_registro->ViewAttributes() ?>>
<?php echo $licencias->Fecha_registro->ViewValue ?></span>
</span>
</script>
</td>
	</tr>
<?php } ?>
</table>
<?php if ($licencias->Export == "") { ?>
		</div>
<?php } ?>
<?php if ($licencias->Export == "") { ?>
	</div>
</div>
</div>
<?php } ?>
</form>
<script type="text/javascript">
ew_ApplyTemplate("tpd_licenciasview", "tpm_licenciasview", "licenciasview", "<?php echo $licencias->CustomExport ?>");
jQuery("script.licenciasview_js").each(function(){ew_AddScript(this.text);});
</script>
<?php if ($licencias->Export == "") { ?>
<script type="text/javascript">
flicenciasview.Init();
</script>
<?php } ?>
<?php
$licencias_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<?php if ($licencias->Export == "") { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$licencias_view->Page_Terminate();
?>
