<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start();
?>
<?php include_once "phprptinc/ewrcfg8.php" ?>
<?php include_once "phprptinc/ewmysql.php" ?>
<?php include_once "phprptinc/ewrfn8.php" ?>
<?php include_once "phprptinc/ewrusrfn8.php" ?>
<?php include_once "CIE10rptinfo.php" ?>
<?php

//
// Page class
//

$CIE10_rpt = NULL; // Initialize page object first

class crCIE10_rpt extends crCIE10 {

	// Page ID
	var $PageID = 'rpt';

	// Project ID
	var $ProjectID = "{84B0927F-5257-4D61-BA82-F177D7F30F4F}";

	// Page object name
	var $PageObjName = 'CIE10_rpt';

	// Page name
	function PageName() {
		return ewr_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ewr_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Export URLs
	var $ExportPrintUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportPdfUrl;
	var $ReportTableClass;
	var $ReportTableStyle = "";

	// Custom export
	var $ExportPrintCustom = FALSE;
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Message
	function getMessage() {
		return @$_SESSION[EWR_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EWR_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EWR_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EWR_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_WARNING_MESSAGE], $v);
	}

		// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EWR_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EWR_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EWR_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EWR_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog ewDisplayTable\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") // Header exists, display
			echo $sHeader;
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") // Fotoer exists, display
			echo $sFooter;
	}

	// Validate page request
	function IsPageRequest() {
		if ($this->UseTokenInUrl) {
			if (ewr_IsHttpPost())
				return ($this->TableVar == @$_POST("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == @$_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $CheckToken = EWR_CHECK_TOKEN;
	var $CheckTokenFn = "ewr_CheckToken";
	var $CreateTokenFn = "ewr_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ewr_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EWR_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EWR_TOKEN_NAME]);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $ReportLanguage;

		// Language object
		$ReportLanguage = new crLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (CIE10)
		if (!isset($GLOBALS["CIE10"])) {
			$GLOBALS["CIE10"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["CIE10"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";

		// Page ID
		if (!defined("EWR_PAGE_ID"))
			define("EWR_PAGE_ID", 'rpt', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EWR_TABLE_NAME"))
			define("EWR_TABLE_NAME", 'CIE10', TRUE);

		// Start timer
		$GLOBALS["gsTimer"] = new crTimer();

		// Open connection
		$conn = ewr_Connect();

		// Export options
		$this->ExportOptions = new crListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Search options
		$this->SearchOptions = new crListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Filter options
		$this->FilterOptions = new crListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fCIE10rpt";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $gsEmailContentType, $ReportLanguage, $Security;
		global $gsCustomExport;

		// Get export parameters
		if (@$_GET["export"] <> "")
			$this->Export = strtolower($_GET["export"]);
		elseif (@$_POST["export"] <> "")
			$this->Export = strtolower($_POST["export"]);
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$gsEmailContentType = @$_POST["contenttype"]; // Get email content type

		// Setup placeholder
		// Setup export options

		$this->SetupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $ReportLanguage->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	// Set up export options
	function SetupExportOptions() {
		global $ReportLanguage;
		$exportid = session_id();

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->Phrase("ExportToWord") . "</a>";

		//$item->Visible = TRUE;
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Uncomment codes below to show export to Pdf link
//		$item->Visible = TRUE;
		// Export to Email

		$item = &$this->ExportOptions->Add("email");
		$url = $this->PageUrl() . "export=email";
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" id=\"emf_CIE10\" href=\"javascript:void(0);\" onclick=\"ewr_EmailDialogShow({lnk:'emf_CIE10',hdr:ewLanguage.Phrase('ExportToEmail'),url:'$url',exportid:'$exportid',el:this});\">" . $ReportLanguage->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter panel button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fCIE10rpt\">" . $ReportLanguage->Phrase("SearchBtn") . "</button>";
		$item->Visible = FALSE;

		// Reset filter
		$item = &$this->SearchOptions->Add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . ewr_CurrentPage() . "?cmd=reset'\">" . $ReportLanguage->Phrase("ResetAllFilter") . "</button>";
		$item->Visible = FALSE;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fCIE10rpt\" href=\"#\">" . $ReportLanguage->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fCIE10rpt\" href=\"#\">" . $ReportLanguage->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up options (extended)
		$this->SetupExportOptionsExt();

		// Hide options for export
		if ($this->Export <> "") {
			$this->ExportOptions->HideAllOptions();
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Set up table class
		if ($this->Export == "word" || $this->Export == "excel" || $this->Export == "pdf")
			$this->ReportTableClass = "ewTable";
		else
			$this->ReportTableClass = "table ewTable";
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn, $ReportLanguage, $EWR_EXPORT, $gsExportFile;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->Export <> "" && array_key_exists($this->Export, $EWR_EXPORT)) {
			$sContent = ob_get_contents();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $sContent, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$sContent = str_replace($divmatch[0], '', $sContent);
				}
			}
			$fn = $EWR_EXPORT[$this->Export];
			if ($this->Export == "email") { // Email
				ob_end_clean();
				echo $this->$fn($sContent);
				$conn->Close(); // Close connection
				exit();
			} else {
				$this->$fn($sContent);
			}
		}

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EWR_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Initialize common variables
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $FilterOptions; // Filter options

	// Paging variables
	var $RecIndex = 0; // Record index
	var $RecCount = 0; // Record count
	var $StartGrp = 0; // Start group
	var $StopGrp = 0; // Stop group
	var $TotalGrps = 0; // Total groups
	var $GrpCount = 0; // Group count
	var $GrpCounter = array(); // Group counter
	var $DisplayGrps = 30; // Groups per page
	var $GrpRange = 10;
	var $Sort = "";
	var $Filter = "";
	var $PageFirstGroupFilter = "";
	var $UserIDFilter = "";
	var $DrillDown = FALSE;
	var $DrillDownInPanel = FALSE;
	var $DrillDownList = "";

	// Clear field for ext filter
	var $ClearExtFilter = "";
	var $PopupName = "";
	var $PopupValue = "";
	var $FilterApplied;
	var $SearchCommand = FALSE;
	var $ShowHeader;
	var $GrpFldCount = 0;
	var $SubGrpFldCount = 0;
	var $DtlFldCount = 0;
	var $Cnt, $Col, $Val, $Smry, $Mn, $Mx, $GrandCnt, $GrandSmry, $GrandMn, $GrandMx;
	var $TotCount;
	var $GrandSummarySetup = FALSE;
	var $GrpIdx;

	//
	// Page main
	//
	function Page_Main() {
		global $rs;
		global $rsgrp;
		global $gsFormError;
		global $gbDrillDownInPanel;
		global $ReportBreadcrumb;

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$nDtls = 13;
		$nGrps = 1;
		$this->Val = &ewr_InitArray($nDtls, 0);
		$this->Cnt = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Smry = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Mn = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->Mx = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->GrandCnt = &ewr_InitArray($nDtls, 0);
		$this->GrandSmry = &ewr_InitArray($nDtls, 0);
		$this->GrandMn = &ewr_InitArray($nDtls, NULL);
		$this->GrandMx = &ewr_InitArray($nDtls, NULL);

		// Set up array if accumulation required: array(Accum, SkipNullOrZero)
		$this->Col = array(array(FALSE, FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE));

		// Set up groups per page dynamically
		$this->SetUpDisplayGrps();

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->SetupPopup();

		// Load group db values if necessary
		$this->LoadGroupDbValues();

		// Handle Ajax popup
		$this->ProcessAjaxPopup();

		// Extended filter
		$sExtendedFilter = "";

		// Build popup filter
		$sPopupFilter = $this->GetPopupFilter();

		//ewr_SetDebugMsg("popup filter: " . $sPopupFilter);
		ewr_AddFilter($this->Filter, $sPopupFilter);

		// No filter
		$this->FilterApplied = FALSE;
		$this->FilterOptions->GetItem("savecurrentfilter")->Visible = FALSE;
		$this->FilterOptions->GetItem("deletefilter")->Visible = FALSE;

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);
		$this->SearchOptions->GetItem("resetfilter")->Visible = $this->FilterApplied;

		// Get sort
		$this->Sort = $this->GetSort();

		// Get total count
		$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $this->Filter, $this->Sort);
		$this->TotalGrps = $this->GetCnt($sSql);
		if ($this->DisplayGrps <= 0 || $this->DrillDown) // Display all groups
			$this->DisplayGrps = $this->TotalGrps;
		$this->StartGrp = 1;

		// Show header
		$this->ShowHeader = ($this->TotalGrps > 0);

		// Set up start position if not export all
		if ($this->ExportAll && $this->Export <> "")
		    $this->DisplayGrps = $this->TotalGrps;
		else
			$this->SetUpStartGroup(); 

		// Hide export options if export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();

		// Hide search/filter options if export/drilldown
		if ($this->Export <> "" || $this->DrillDown) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Get current page records
		$rs = $this->GetRs($sSql, $this->StartGrp, $this->DisplayGrps);
		$this->SetupFieldCount();
	}

	// Accummulate summary
	function AccumulateSummary() {
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Col[$iy][0]) { // Accumulate required
					$valwrk = $this->Val[$iy];
					if (is_null($valwrk)) {
						if (!$this->Col[$iy][1])
							$this->Cnt[$ix][$iy]++;
					} else {
						$accum = (!$this->Col[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Cnt[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Smry[$ix][$iy] += $valwrk;
								if (is_null($this->Mn[$ix][$iy])) {
									$this->Mn[$ix][$iy] = $valwrk;
									$this->Mx[$ix][$iy] = $valwrk;
								} else {
									if ($this->Mn[$ix][$iy] > $valwrk) $this->Mn[$ix][$iy] = $valwrk;
									if ($this->Mx[$ix][$iy] < $valwrk) $this->Mx[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0]++;
		}
	}

	// Reset level summary
	function ResetLevelSummary($lvl) {

		// Clear summary values
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Cnt[$ix][$iy] = 0;
				if ($this->Col[$iy][0]) {
					$this->Smry[$ix][$iy] = 0;
					$this->Mn[$ix][$iy] = NULL;
					$this->Mx[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0] = 0;
		}

		// Reset record count
		$this->RecCount = 0;
	}

	// Accummulate grand summary
	function AccumulateGrandSummary() {
		$this->TotCount++;
		$cntgs = count($this->GrandSmry);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Col[$iy][0]) {
				$valwrk = $this->Val[$iy];
				if (is_null($valwrk) || !is_numeric($valwrk)) {
					if (!$this->Col[$iy][1])
						$this->GrandCnt[$iy]++;
				} else {
					if (!$this->Col[$iy][1] || $valwrk <> 0) {
						$this->GrandCnt[$iy]++;
						$this->GrandSmry[$iy] += $valwrk;
						if (is_null($this->GrandMn[$iy])) {
							$this->GrandMn[$iy] = $valwrk;
							$this->GrandMx[$iy] = $valwrk;
						} else {
							if ($this->GrandMn[$iy] > $valwrk) $this->GrandMn[$iy] = $valwrk;
							if ($this->GrandMx[$iy] < $valwrk) $this->GrandMx[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Get count
	function GetCnt($sql) {
		global $conn;
		$rscnt = $conn->Execute($sql);
		$cnt = ($rscnt) ? $rscnt->RecordCount() : 0;
		if ($rscnt) $rscnt->Close();
		return $cnt;
	}

	// Get recordset
	function GetRs($wrksql, $start, $grps) {
		global $conn;
		$conn->raiseErrorFn = $GLOBALS["EWR_ERROR_FN"];
		$rswrk = $conn->SelectLimit($wrksql, $grps, $start - 1);
		$conn->raiseErrorFn = '';
		return $rswrk;
	}

	// Get row values
	function GetRow($opt) {
		global $rs;
		if (!$rs)
			return;
		if ($opt == 1) { // Get first row

	//		$rs->MoveFirst(); // NOTE: no need to move position
				$this->FirstRowData = array();
				$this->FirstRowData['Id'] = ewr_Conv($rs->fields('Id'),3);
				$this->FirstRowData['Codigo'] = ewr_Conv($rs->fields('Codigo'),200);
				$this->FirstRowData['Causa_Completa'] = ewr_Conv($rs->fields('Causa_Completa'),200);
				$this->FirstRowData['Letra'] = ewr_Conv($rs->fields('Letra'),200);
				$this->FirstRowData['Numero'] = ewr_Conv($rs->fields('Numero'),3);
				$this->FirstRowData['monitoreado'] = ewr_Conv($rs->fields('monitoreado'),3);
				$this->FirstRowData['Grupo_Mortalidad'] = ewr_Conv($rs->fields('Grupo_Mortalidad'),200);
				$this->FirstRowData['Nombre_Subgrupo'] = ewr_Conv($rs->fields('Nombre_Subgrupo'),200);
				$this->FirstRowData['Grupo_General'] = ewr_Conv($rs->fields('Grupo_General'),200);
				$this->FirstRowData['Nombre'] = ewr_Conv($rs->fields('Nombre'),200);
				$this->FirstRowData['Codigo_tres'] = ewr_Conv($rs->fields('Codigo_tres'),200);
				$this->FirstRowData['Nombre_codigo_tres'] = ewr_Conv($rs->fields('Nombre_codigo_tres'),200);
		} else { // Get next row
			$rs->MoveNext();
		}
		if (!$rs->EOF) {
			$this->Id->setDbValue($rs->fields('Id'));
			$this->Codigo->setDbValue($rs->fields('Codigo'));
			$this->Causa_Completa->setDbValue($rs->fields('Causa_Completa'));
			$this->Causa->setDbValue($rs->fields('Causa'));
			$this->Letra->setDbValue($rs->fields('Letra'));
			$this->Numero->setDbValue($rs->fields('Numero'));
			$this->monitoreado->setDbValue($rs->fields('monitoreado'));
			$this->Grupo_Mortalidad->setDbValue($rs->fields('Grupo_Mortalidad'));
			$this->Nombre_Subgrupo->setDbValue($rs->fields('Nombre_Subgrupo'));
			$this->Grupo_General->setDbValue($rs->fields('Grupo_General'));
			$this->Nombre->setDbValue($rs->fields('Nombre'));
			$this->Codigo_tres->setDbValue($rs->fields('Codigo_tres'));
			$this->Nombre_codigo_tres->setDbValue($rs->fields('Nombre_codigo_tres'));
			$this->Val[1] = $this->Id->CurrentValue;
			$this->Val[2] = $this->Codigo->CurrentValue;
			$this->Val[3] = $this->Causa_Completa->CurrentValue;
			$this->Val[4] = $this->Letra->CurrentValue;
			$this->Val[5] = $this->Numero->CurrentValue;
			$this->Val[6] = $this->monitoreado->CurrentValue;
			$this->Val[7] = $this->Grupo_Mortalidad->CurrentValue;
			$this->Val[8] = $this->Nombre_Subgrupo->CurrentValue;
			$this->Val[9] = $this->Grupo_General->CurrentValue;
			$this->Val[10] = $this->Nombre->CurrentValue;
			$this->Val[11] = $this->Codigo_tres->CurrentValue;
			$this->Val[12] = $this->Nombre_codigo_tres->CurrentValue;
		} else {
			$this->Id->setDbValue("");
			$this->Codigo->setDbValue("");
			$this->Causa_Completa->setDbValue("");
			$this->Causa->setDbValue("");
			$this->Letra->setDbValue("");
			$this->Numero->setDbValue("");
			$this->monitoreado->setDbValue("");
			$this->Grupo_Mortalidad->setDbValue("");
			$this->Nombre_Subgrupo->setDbValue("");
			$this->Grupo_General->setDbValue("");
			$this->Nombre->setDbValue("");
			$this->Codigo_tres->setDbValue("");
			$this->Nombre_codigo_tres->setDbValue("");
		}
	}

	//  Set up starting group
	function SetUpStartGroup() {

		// Exit if no groups
		if ($this->DisplayGrps == 0)
			return;

		// Check for a 'start' parameter
		if (@$_GET[EWR_TABLE_START_GROUP] != "") {
			$this->StartGrp = $_GET[EWR_TABLE_START_GROUP];
			$this->setStartGroup($this->StartGrp);
		} elseif (@$_GET["pageno"] != "") {
			$nPageNo = $_GET["pageno"];
			if (is_numeric($nPageNo)) {
				$this->StartGrp = ($nPageNo-1)*$this->DisplayGrps+1;
				if ($this->StartGrp <= 0) {
					$this->StartGrp = 1;
				} elseif ($this->StartGrp >= intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1) {
					$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1;
				}
				$this->setStartGroup($this->StartGrp);
			} else {
				$this->StartGrp = $this->getStartGroup();
			}
		} else {
			$this->StartGrp = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGrp) || $this->StartGrp == "") { // Avoid invalid start group counter
			$this->StartGrp = 1; // Reset start group counter
			$this->setStartGroup($this->StartGrp);
		} elseif (intval($this->StartGrp) > intval($this->TotalGrps)) { // Avoid starting group > total groups
			$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to last page first group
			$this->setStartGroup($this->StartGrp);
		} elseif (($this->StartGrp-1) % $this->DisplayGrps <> 0) {
			$this->StartGrp = intval(($this->StartGrp-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to page boundary
			$this->setStartGroup($this->StartGrp);
		}
	}

	// Load group db values if necessary
	function LoadGroupDbValues() {
		global $conn;
	}

	// Process Ajax popup
	function ProcessAjaxPopup() {
		global $conn, $ReportLanguage;
		$fld = NULL;
		if (@$_GET["popup"] <> "") {
			$popupname = $_GET["popup"];

			// Check popup name
			// Output data as Json

			if (!is_null($fld)) {
				$jsdb = ewr_GetJsDb($fld, $fld->FldType);
				ob_end_clean();
				echo $jsdb;
				exit();
			}
		}
	}

	// Set up popup
	function SetupPopup() {
		global $conn, $ReportLanguage;
		if ($this->DrillDown)
			return;

		// Process post back form
		if (ewr_IsHttpPost()) {
			$sName = @$_POST["popup"]; // Get popup form name
			if ($sName <> "") {
				$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
				if ($cntValues > 0) {
					$arValues = ewr_StripSlashes($_POST["sel_$sName"]);
					if (trim($arValues[0]) == "") // Select all
						$arValues = EWR_INIT_VALUE;
					$_SESSION["sel_$sName"] = $arValues;
					$_SESSION["rf_$sName"] = ewr_StripSlashes(@$_POST["rf_$sName"]);
					$_SESSION["rt_$sName"] = ewr_StripSlashes(@$_POST["rt_$sName"]);
					$this->ResetPager();
				}
			}

		// Get 'reset' command
		} elseif (@$_GET["cmd"] <> "") {
			$sCmd = $_GET["cmd"];
			if (strtolower($sCmd) == "reset") {
				$this->ResetPager();
			}
		}

		// Load selection criteria to array
	}

	// Reset pager
	function ResetPager() {

		// Reset start position (reset command)
		$this->StartGrp = 1;
		$this->setStartGroup($this->StartGrp);
	}

	// Set up number of groups displayed per page
	function SetUpDisplayGrps() {
		$sWrk = @$_GET[EWR_TABLE_GROUP_PER_PAGE];
		if ($sWrk <> "") {
			if (is_numeric($sWrk)) {
				$this->DisplayGrps = intval($sWrk);
			} else {
				if (strtoupper($sWrk) == "ALL") { // Display all groups
					$this->DisplayGrps = -1;
				} else {
					$this->DisplayGrps = 30; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGrps); // Save to session

			// Reset start position (reset command)
			$this->StartGrp = 1;
			$this->setStartGroup($this->StartGrp);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGrps = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGrps = 30; // Load default
			}
		}
	}

	// Render row
	function RenderRow() {
		global $conn, $rs, $Security, $ReportLanguage;
		if ($this->RowTotalType == EWR_ROWTOTAL_GRAND && !$this->GrandSummarySetup) { // Grand total
			$bGotCount = FALSE;
			$bGotSummary = FALSE;

			// Get total count from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->Execute($sSql);
			if ($rstot) {
				$this->TotCount = ($rstot->RecordCount()>1) ? $rstot->RecordCount() : $rstot->fields[0];
				$rstot->Close();
				$bGotCount = TRUE;
			} else {
				$this->TotCount = 0;
			}
		$bGotSummary = TRUE;

			// Accumulate grand summary from detail records
			if (!$bGotCount || !$bGotSummary) {
				$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$rs = $conn->Execute($sSql);
				if ($rs) {
					$this->GetRow(1);
					while (!$rs->EOF) {
						$this->AccumulateGrandSummary();
						$this->GetRow(2);
					}
					$rs->Close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();

		//
		// Render view codes
		//

		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row

			// Id
			$this->Id->HrefValue = "";

			// Codigo
			$this->Codigo->HrefValue = "";

			// Causa_Completa
			$this->Causa_Completa->HrefValue = "";

			// Letra
			$this->Letra->HrefValue = "";

			// Numero
			$this->Numero->HrefValue = "";

			// monitoreado
			$this->monitoreado->HrefValue = "";

			// Grupo_Mortalidad
			$this->Grupo_Mortalidad->HrefValue = "";

			// Nombre_Subgrupo
			$this->Nombre_Subgrupo->HrefValue = "";

			// Grupo_General
			$this->Grupo_General->HrefValue = "";

			// Nombre
			$this->Nombre->HrefValue = "";

			// Codigo_tres
			$this->Codigo_tres->HrefValue = "";

			// Nombre_codigo_tres
			$this->Nombre_codigo_tres->HrefValue = "";
		} else {

			// Id
			$this->Id->ViewValue = $this->Id->CurrentValue;
			$this->Id->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Codigo
			$this->Codigo->ViewValue = $this->Codigo->CurrentValue;
			$this->Codigo->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Causa_Completa
			$this->Causa_Completa->ViewValue = $this->Causa_Completa->CurrentValue;
			$this->Causa_Completa->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Letra
			$this->Letra->ViewValue = $this->Letra->CurrentValue;
			$this->Letra->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Numero
			$this->Numero->ViewValue = $this->Numero->CurrentValue;
			$this->Numero->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// monitoreado
			$this->monitoreado->ViewValue = $this->monitoreado->CurrentValue;
			$this->monitoreado->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Grupo_Mortalidad
			$this->Grupo_Mortalidad->ViewValue = $this->Grupo_Mortalidad->CurrentValue;
			$this->Grupo_Mortalidad->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Nombre_Subgrupo
			$this->Nombre_Subgrupo->ViewValue = $this->Nombre_Subgrupo->CurrentValue;
			$this->Nombre_Subgrupo->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Grupo_General
			$this->Grupo_General->ViewValue = $this->Grupo_General->CurrentValue;
			$this->Grupo_General->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Nombre
			$this->Nombre->ViewValue = $this->Nombre->CurrentValue;
			$this->Nombre->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Codigo_tres
			$this->Codigo_tres->ViewValue = $this->Codigo_tres->CurrentValue;
			$this->Codigo_tres->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Nombre_codigo_tres
			$this->Nombre_codigo_tres->ViewValue = $this->Nombre_codigo_tres->CurrentValue;
			$this->Nombre_codigo_tres->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Id
			$this->Id->HrefValue = "";

			// Codigo
			$this->Codigo->HrefValue = "";

			// Causa_Completa
			$this->Causa_Completa->HrefValue = "";

			// Letra
			$this->Letra->HrefValue = "";

			// Numero
			$this->Numero->HrefValue = "";

			// monitoreado
			$this->monitoreado->HrefValue = "";

			// Grupo_Mortalidad
			$this->Grupo_Mortalidad->HrefValue = "";

			// Nombre_Subgrupo
			$this->Nombre_Subgrupo->HrefValue = "";

			// Grupo_General
			$this->Grupo_General->HrefValue = "";

			// Nombre
			$this->Nombre->HrefValue = "";

			// Codigo_tres
			$this->Codigo_tres->HrefValue = "";

			// Nombre_codigo_tres
			$this->Nombre_codigo_tres->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row
		} else {

			// Id
			$CurrentValue = $this->Id->CurrentValue;
			$ViewValue = &$this->Id->ViewValue;
			$ViewAttrs = &$this->Id->ViewAttrs;
			$CellAttrs = &$this->Id->CellAttrs;
			$HrefValue = &$this->Id->HrefValue;
			$LinkAttrs = &$this->Id->LinkAttrs;
			$this->Cell_Rendered($this->Id, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Codigo
			$CurrentValue = $this->Codigo->CurrentValue;
			$ViewValue = &$this->Codigo->ViewValue;
			$ViewAttrs = &$this->Codigo->ViewAttrs;
			$CellAttrs = &$this->Codigo->CellAttrs;
			$HrefValue = &$this->Codigo->HrefValue;
			$LinkAttrs = &$this->Codigo->LinkAttrs;
			$this->Cell_Rendered($this->Codigo, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Causa_Completa
			$CurrentValue = $this->Causa_Completa->CurrentValue;
			$ViewValue = &$this->Causa_Completa->ViewValue;
			$ViewAttrs = &$this->Causa_Completa->ViewAttrs;
			$CellAttrs = &$this->Causa_Completa->CellAttrs;
			$HrefValue = &$this->Causa_Completa->HrefValue;
			$LinkAttrs = &$this->Causa_Completa->LinkAttrs;
			$this->Cell_Rendered($this->Causa_Completa, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Letra
			$CurrentValue = $this->Letra->CurrentValue;
			$ViewValue = &$this->Letra->ViewValue;
			$ViewAttrs = &$this->Letra->ViewAttrs;
			$CellAttrs = &$this->Letra->CellAttrs;
			$HrefValue = &$this->Letra->HrefValue;
			$LinkAttrs = &$this->Letra->LinkAttrs;
			$this->Cell_Rendered($this->Letra, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Numero
			$CurrentValue = $this->Numero->CurrentValue;
			$ViewValue = &$this->Numero->ViewValue;
			$ViewAttrs = &$this->Numero->ViewAttrs;
			$CellAttrs = &$this->Numero->CellAttrs;
			$HrefValue = &$this->Numero->HrefValue;
			$LinkAttrs = &$this->Numero->LinkAttrs;
			$this->Cell_Rendered($this->Numero, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// monitoreado
			$CurrentValue = $this->monitoreado->CurrentValue;
			$ViewValue = &$this->monitoreado->ViewValue;
			$ViewAttrs = &$this->monitoreado->ViewAttrs;
			$CellAttrs = &$this->monitoreado->CellAttrs;
			$HrefValue = &$this->monitoreado->HrefValue;
			$LinkAttrs = &$this->monitoreado->LinkAttrs;
			$this->Cell_Rendered($this->monitoreado, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Grupo_Mortalidad
			$CurrentValue = $this->Grupo_Mortalidad->CurrentValue;
			$ViewValue = &$this->Grupo_Mortalidad->ViewValue;
			$ViewAttrs = &$this->Grupo_Mortalidad->ViewAttrs;
			$CellAttrs = &$this->Grupo_Mortalidad->CellAttrs;
			$HrefValue = &$this->Grupo_Mortalidad->HrefValue;
			$LinkAttrs = &$this->Grupo_Mortalidad->LinkAttrs;
			$this->Cell_Rendered($this->Grupo_Mortalidad, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Nombre_Subgrupo
			$CurrentValue = $this->Nombre_Subgrupo->CurrentValue;
			$ViewValue = &$this->Nombre_Subgrupo->ViewValue;
			$ViewAttrs = &$this->Nombre_Subgrupo->ViewAttrs;
			$CellAttrs = &$this->Nombre_Subgrupo->CellAttrs;
			$HrefValue = &$this->Nombre_Subgrupo->HrefValue;
			$LinkAttrs = &$this->Nombre_Subgrupo->LinkAttrs;
			$this->Cell_Rendered($this->Nombre_Subgrupo, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Grupo_General
			$CurrentValue = $this->Grupo_General->CurrentValue;
			$ViewValue = &$this->Grupo_General->ViewValue;
			$ViewAttrs = &$this->Grupo_General->ViewAttrs;
			$CellAttrs = &$this->Grupo_General->CellAttrs;
			$HrefValue = &$this->Grupo_General->HrefValue;
			$LinkAttrs = &$this->Grupo_General->LinkAttrs;
			$this->Cell_Rendered($this->Grupo_General, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Nombre
			$CurrentValue = $this->Nombre->CurrentValue;
			$ViewValue = &$this->Nombre->ViewValue;
			$ViewAttrs = &$this->Nombre->ViewAttrs;
			$CellAttrs = &$this->Nombre->CellAttrs;
			$HrefValue = &$this->Nombre->HrefValue;
			$LinkAttrs = &$this->Nombre->LinkAttrs;
			$this->Cell_Rendered($this->Nombre, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Codigo_tres
			$CurrentValue = $this->Codigo_tres->CurrentValue;
			$ViewValue = &$this->Codigo_tres->ViewValue;
			$ViewAttrs = &$this->Codigo_tres->ViewAttrs;
			$CellAttrs = &$this->Codigo_tres->CellAttrs;
			$HrefValue = &$this->Codigo_tres->HrefValue;
			$LinkAttrs = &$this->Codigo_tres->LinkAttrs;
			$this->Cell_Rendered($this->Codigo_tres, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Nombre_codigo_tres
			$CurrentValue = $this->Nombre_codigo_tres->CurrentValue;
			$ViewValue = &$this->Nombre_codigo_tres->ViewValue;
			$ViewAttrs = &$this->Nombre_codigo_tres->ViewAttrs;
			$CellAttrs = &$this->Nombre_codigo_tres->CellAttrs;
			$HrefValue = &$this->Nombre_codigo_tres->HrefValue;
			$LinkAttrs = &$this->Nombre_codigo_tres->LinkAttrs;
			$this->Cell_Rendered($this->Nombre_codigo_tres, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->SetupFieldCount();
	}

	// Setup field count
	function SetupFieldCount() {
		$this->GrpFldCount = 0;
		$this->SubGrpFldCount = 0;
		$this->DtlFldCount = 0;
		if ($this->Id->Visible) $this->DtlFldCount += 1;
		if ($this->Codigo->Visible) $this->DtlFldCount += 1;
		if ($this->Causa_Completa->Visible) $this->DtlFldCount += 1;
		if ($this->Letra->Visible) $this->DtlFldCount += 1;
		if ($this->Numero->Visible) $this->DtlFldCount += 1;
		if ($this->monitoreado->Visible) $this->DtlFldCount += 1;
		if ($this->Grupo_Mortalidad->Visible) $this->DtlFldCount += 1;
		if ($this->Nombre_Subgrupo->Visible) $this->DtlFldCount += 1;
		if ($this->Grupo_General->Visible) $this->DtlFldCount += 1;
		if ($this->Nombre->Visible) $this->DtlFldCount += 1;
		if ($this->Codigo_tres->Visible) $this->DtlFldCount += 1;
		if ($this->Nombre_codigo_tres->Visible) $this->DtlFldCount += 1;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $ReportBreadcrumb;
		$ReportBreadcrumb = new crBreadcrumb();
		$url = substr(ewr_CurrentUrl(), strrpos(ewr_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$ReportBreadcrumb->Add("rpt", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	function SetupExportOptionsExt() {
		global $ReportLanguage;
		$item =& $this->ExportOptions->GetItem("pdf");
		$item->Visible = TRUE;
		$exportid = session_id();
		$url = $this->ExportPdfUrl;
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ewr_ExportCharts(this, '" . $url . "', '" . $exportid . "');\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
	}

	// Return popup filter
	function GetPopupFilter() {
		$sWrk = "";
		if ($this->DrillDown)
			return "";
		return $sWrk;
	}

	//-------------------------------------------------------------------------------
	// Function GetSort
	// - Return Sort parameters based on Sort Links clicked
	// - Variables setup: Session[EWR_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
	function GetSort() {
		if ($this->DrillDown)
			return "";

		// Check for a resetsort command
		if (strlen(@$_GET["cmd"]) > 0) {
			$sCmd = @$_GET["cmd"];
			if ($sCmd == "resetsort") {
				$this->setOrderBy("");
				$this->setStartGroup(1);
				$this->Id->setSort("");
				$this->Codigo->setSort("");
				$this->Causa_Completa->setSort("");
				$this->Letra->setSort("");
				$this->Numero->setSort("");
				$this->monitoreado->setSort("");
				$this->Grupo_Mortalidad->setSort("");
				$this->Nombre_Subgrupo->setSort("");
				$this->Grupo_General->setSort("");
				$this->Nombre->setSort("");
				$this->Codigo_tres->setSort("");
				$this->Nombre_codigo_tres->setSort("");
			}

		// Check for an Order parameter
		} elseif (@$_GET["order"] <> "") {
			$this->CurrentOrder = ewr_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$sSortSql = $this->SortSql();
			$this->setOrderBy($sSortSql);
			$this->setStartGroup(1);
		}
		return $this->getOrderBy();
	}

	// Export to WORD
	function ExportWord($html) {
		global $gsExportFile;
		header('Content-Type: application/vnd.ms-word' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		header('Content-Disposition: attachment; filename=' . $gsExportFile . '.doc');
		echo $html;
	}

	// Export to EXCEL
	function ExportExcel($html) {
		global $gsExportFile;
		header('Content-Type: application/vnd.ms-excel' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		header('Content-Disposition: attachment; filename=' . $gsExportFile . '.xls');
		echo $html;
	}

	// Export PDF
	function ExportPDF($html) {
		global $gsExportFile;
		include_once "dompdf061/dompdf_config.inc.php";
		@ini_set("memory_limit", EWR_PDF_MEMORY_LIMIT);
		set_time_limit(EWR_PDF_TIME_LIMIT);
		$dompdf = new DOMPDF();
		$dompdf->load_html($html);
		ob_end_clean();
		$dompdf->set_paper("a4", "portrait");
		$dompdf->render();
		ewr_DeleteTmpImages($html);
		$dompdf->stream($gsExportFile . ".pdf", array("Attachment" => 1)); // 0 to open in browser, 1 to download

//		exit();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ewr_Header(FALSE) ?>
<?php

// Create page object
if (!isset($CIE10_rpt)) $CIE10_rpt = new crCIE10_rpt();
if (isset($Page)) $OldPage = $Page;
$Page = &$CIE10_rpt;

// Page init
$Page->Page_Init();

// Page main
$Page->Page_Main();

// Global Page Rendering event (in ewrusrfn*.php)
Page_Rendering();

// Page Rendering event
$Page->Page_Render();
?>
<?php include_once "phprptinc/header.php" ?>
<?php if ($Page->Export == "") { ?>
<script type="text/javascript">

// Create page object
var CIE10_rpt = new ewr_Page("CIE10_rpt");

// Page properties
CIE10_rpt.PageID = "rpt"; // Page ID
var EWR_PAGE_ID = CIE10_rpt.PageID;

// Extend page with Chart_Rendering function
CIE10_rpt.Chart_Rendering = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }

// Extend page with Chart_Rendered function
CIE10_rpt.Chart_Rendered = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($Page->Export == "") { ?>
<!-- container (begin) -->
<div id="ewContainer" class="ewContainer">
<!-- top container (begin) -->
<div id="ewTop" class="ewTop">
<a id="top"></a>
<?php } ?>
<!-- top slot -->
<div class="ewToolbar">
<?php if ($Page->Export == "" && (!$Page->DrillDown || !$Page->DrillDownInPanel)) { ?>
<?php if ($ReportBreadcrumb) $ReportBreadcrumb->Render(); ?>
<?php } ?>
<?php
if (!$Page->DrillDownInPanel) {
	$Page->ExportOptions->Render("body");
	$Page->SearchOptions->Render("body");
	$Page->FilterOptions->Render("body");
}
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php echo $ReportLanguage->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php $Page->ShowPageHeader(); ?>
<?php $Page->ShowMessage(); ?>
<?php if ($Page->Export == "") { ?>
</div>
<!-- top container (end) -->
	<!-- left container (begin) -->
	<div id="ewLeft" class="ewLeft">
<?php } ?>
	<!-- Left slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- left container (end) -->
	<!-- center container - report (begin) -->
	<div id="ewCenter" class="ewCenter">
<?php } ?>
	<!-- center slot -->
<!-- summary report starts -->
<?php if ($Page->Export <> "pdf") { ?>
<div id="report_summary">
<?php } ?>
<?php

// Set the last group to display if not export all
if ($Page->ExportAll && $Page->Export <> "") {
	$Page->StopGrp = $Page->TotalGrps;
} else {
	$Page->StopGrp = $Page->StartGrp + $Page->DisplayGrps - 1;
}

// Stop group <= total number of groups
if (intval($Page->StopGrp) > intval($Page->TotalGrps))
	$Page->StopGrp = $Page->TotalGrps;
$Page->RecCount = 0;
$Page->RecIndex = 0;

// Get first row
if ($Page->TotalGrps > 0) {
	$Page->GetRow(1);
	$Page->GrpCount = 1;
}
$Page->GrpIdx = ewr_InitArray(2, -1);
$Page->GrpIdx[0] = -1;
$Page->GrpIdx[1] = $Page->StopGrp - $Page->StartGrp + 1;
while ($rs && !$rs->EOF && $Page->GrpCount <= $Page->DisplayGrps || $Page->ShowHeader) {

	// Show dummy header for custom template
	// Show header

	if ($Page->ShowHeader) {
?>
<?php if ($Page->Export <> "pdf") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<thead>
	<!-- Table header -->
	<tr class="ewTableHeader">
<?php if ($Page->Id->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Id"><div class="CIE10_Id"><span class="ewTableHeaderCaption"><?php echo $Page->Id->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Id">
<?php if ($Page->SortUrl($Page->Id) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Id">
			<span class="ewTableHeaderCaption"><?php echo $Page->Id->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Id" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Id) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Id->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Codigo->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Codigo"><div class="CIE10_Codigo"><span class="ewTableHeaderCaption"><?php echo $Page->Codigo->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Codigo">
<?php if ($Page->SortUrl($Page->Codigo) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Codigo">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Codigo" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Codigo) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Codigo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Codigo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Causa_Completa->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Causa_Completa"><div class="CIE10_Causa_Completa"><span class="ewTableHeaderCaption"><?php echo $Page->Causa_Completa->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Causa_Completa">
<?php if ($Page->SortUrl($Page->Causa_Completa) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Causa_Completa">
			<span class="ewTableHeaderCaption"><?php echo $Page->Causa_Completa->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Causa_Completa" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Causa_Completa) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Causa_Completa->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Causa_Completa->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Causa_Completa->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Letra->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Letra"><div class="CIE10_Letra"><span class="ewTableHeaderCaption"><?php echo $Page->Letra->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Letra">
<?php if ($Page->SortUrl($Page->Letra) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Letra">
			<span class="ewTableHeaderCaption"><?php echo $Page->Letra->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Letra" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Letra) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Letra->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Letra->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Letra->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Numero->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Numero"><div class="CIE10_Numero"><span class="ewTableHeaderCaption"><?php echo $Page->Numero->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Numero">
<?php if ($Page->SortUrl($Page->Numero) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Numero">
			<span class="ewTableHeaderCaption"><?php echo $Page->Numero->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Numero" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Numero) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Numero->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Numero->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Numero->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->monitoreado->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="monitoreado"><div class="CIE10_monitoreado"><span class="ewTableHeaderCaption"><?php echo $Page->monitoreado->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="monitoreado">
<?php if ($Page->SortUrl($Page->monitoreado) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_monitoreado">
			<span class="ewTableHeaderCaption"><?php echo $Page->monitoreado->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_monitoreado" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->monitoreado) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->monitoreado->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->monitoreado->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->monitoreado->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Grupo_Mortalidad->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Grupo_Mortalidad"><div class="CIE10_Grupo_Mortalidad"><span class="ewTableHeaderCaption"><?php echo $Page->Grupo_Mortalidad->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Grupo_Mortalidad">
<?php if ($Page->SortUrl($Page->Grupo_Mortalidad) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Grupo_Mortalidad">
			<span class="ewTableHeaderCaption"><?php echo $Page->Grupo_Mortalidad->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Grupo_Mortalidad" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Grupo_Mortalidad) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Grupo_Mortalidad->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Grupo_Mortalidad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Grupo_Mortalidad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Nombre_Subgrupo->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Nombre_Subgrupo"><div class="CIE10_Nombre_Subgrupo"><span class="ewTableHeaderCaption"><?php echo $Page->Nombre_Subgrupo->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Nombre_Subgrupo">
<?php if ($Page->SortUrl($Page->Nombre_Subgrupo) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Nombre_Subgrupo">
			<span class="ewTableHeaderCaption"><?php echo $Page->Nombre_Subgrupo->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Nombre_Subgrupo" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Nombre_Subgrupo) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Nombre_Subgrupo->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Nombre_Subgrupo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Nombre_Subgrupo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Grupo_General->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Grupo_General"><div class="CIE10_Grupo_General"><span class="ewTableHeaderCaption"><?php echo $Page->Grupo_General->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Grupo_General">
<?php if ($Page->SortUrl($Page->Grupo_General) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Grupo_General">
			<span class="ewTableHeaderCaption"><?php echo $Page->Grupo_General->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Grupo_General" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Grupo_General) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Grupo_General->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Grupo_General->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Grupo_General->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Nombre->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Nombre"><div class="CIE10_Nombre"><span class="ewTableHeaderCaption"><?php echo $Page->Nombre->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Nombre">
<?php if ($Page->SortUrl($Page->Nombre) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Nombre">
			<span class="ewTableHeaderCaption"><?php echo $Page->Nombre->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Nombre" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Nombre) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Nombre->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Nombre->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Nombre->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Codigo_tres->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Codigo_tres"><div class="CIE10_Codigo_tres"><span class="ewTableHeaderCaption"><?php echo $Page->Codigo_tres->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Codigo_tres">
<?php if ($Page->SortUrl($Page->Codigo_tres) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Codigo_tres">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_tres->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Codigo_tres" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Codigo_tres) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_tres->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Codigo_tres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Codigo_tres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Nombre_codigo_tres->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Nombre_codigo_tres"><div class="CIE10_Nombre_codigo_tres"><span class="ewTableHeaderCaption"><?php echo $Page->Nombre_codigo_tres->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Nombre_codigo_tres">
<?php if ($Page->SortUrl($Page->Nombre_codigo_tres) == "") { ?>
		<div class="ewTableHeaderBtn CIE10_Nombre_codigo_tres">
			<span class="ewTableHeaderCaption"><?php echo $Page->Nombre_codigo_tres->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer CIE10_Nombre_codigo_tres" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Nombre_codigo_tres) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Nombre_codigo_tres->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Nombre_codigo_tres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Nombre_codigo_tres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
	</tr>
</thead>
<tbody>
<?php
		if ($Page->TotalGrps == 0) break; // Show header only
		$Page->ShowHeader = FALSE;
	}
	$Page->RecCount++;
	$Page->RecIndex++;

		// Render detail row
		$Page->ResetAttrs();
		$Page->RowType = EWR_ROWTYPE_DETAIL;
		$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->Id->Visible) { ?>
		<td data-field="Id"<?php echo $Page->Id->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Id"<?php echo $Page->Id->ViewAttributes() ?>><?php echo $Page->Id->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Codigo->Visible) { ?>
		<td data-field="Codigo"<?php echo $Page->Codigo->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Codigo"<?php echo $Page->Codigo->ViewAttributes() ?>><?php echo $Page->Codigo->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Causa_Completa->Visible) { ?>
		<td data-field="Causa_Completa"<?php echo $Page->Causa_Completa->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Causa_Completa"<?php echo $Page->Causa_Completa->ViewAttributes() ?>><?php echo $Page->Causa_Completa->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Letra->Visible) { ?>
		<td data-field="Letra"<?php echo $Page->Letra->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Letra"<?php echo $Page->Letra->ViewAttributes() ?>><?php echo $Page->Letra->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Numero->Visible) { ?>
		<td data-field="Numero"<?php echo $Page->Numero->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Numero"<?php echo $Page->Numero->ViewAttributes() ?>><?php echo $Page->Numero->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->monitoreado->Visible) { ?>
		<td data-field="monitoreado"<?php echo $Page->monitoreado->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_monitoreado"<?php echo $Page->monitoreado->ViewAttributes() ?>><?php echo $Page->monitoreado->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Grupo_Mortalidad->Visible) { ?>
		<td data-field="Grupo_Mortalidad"<?php echo $Page->Grupo_Mortalidad->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Grupo_Mortalidad"<?php echo $Page->Grupo_Mortalidad->ViewAttributes() ?>><?php echo $Page->Grupo_Mortalidad->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Nombre_Subgrupo->Visible) { ?>
		<td data-field="Nombre_Subgrupo"<?php echo $Page->Nombre_Subgrupo->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Nombre_Subgrupo"<?php echo $Page->Nombre_Subgrupo->ViewAttributes() ?>><?php echo $Page->Nombre_Subgrupo->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Grupo_General->Visible) { ?>
		<td data-field="Grupo_General"<?php echo $Page->Grupo_General->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Grupo_General"<?php echo $Page->Grupo_General->ViewAttributes() ?>><?php echo $Page->Grupo_General->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Nombre->Visible) { ?>
		<td data-field="Nombre"<?php echo $Page->Nombre->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Nombre"<?php echo $Page->Nombre->ViewAttributes() ?>><?php echo $Page->Nombre->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Codigo_tres->Visible) { ?>
		<td data-field="Codigo_tres"<?php echo $Page->Codigo_tres->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Codigo_tres"<?php echo $Page->Codigo_tres->ViewAttributes() ?>><?php echo $Page->Codigo_tres->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Nombre_codigo_tres->Visible) { ?>
		<td data-field="Nombre_codigo_tres"<?php echo $Page->Nombre_codigo_tres->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_CIE10_Nombre_codigo_tres"<?php echo $Page->Nombre_codigo_tres->ViewAttributes() ?>><?php echo $Page->Nombre_codigo_tres->ListViewValue() ?></span></td>
<?php } ?>
	</tr>
<?php

		// Accumulate page summary
		$Page->AccumulateSummary();

		// Get next record
		$Page->GetRow(2);
	$Page->GrpCount++;
} // End while
?>
<?php if ($Page->TotalGrps > 0) { ?>
</tbody>
<tfoot>
	</tfoot>
<?php } elseif (!$Page->ShowHeader) { // No header displayed ?>
<?php if ($Page->Export <> "pdf") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<?php } ?>
</table>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export == "" && !($Page->DrillDown && $Page->TotalGrps > 0)) { ?>
<div class="ewGridLowerPanel">
<?php include "CIE10rptpager.php" ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<!-- Summary Report Ends -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- center container - report (end) -->
	<!-- right container (begin) -->
	<div id="ewRight" class="ewRight">
<?php } ?>
	<!-- Right slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- right container (end) -->
<div class="clearfix"></div>
<!-- bottom container (begin) -->
<div id="ewBottom" class="ewBottom">
<?php } ?>
	<!-- Bottom slot -->
<?php if ($Page->Export == "") { ?>
	</div>
<!-- Bottom Container (End) -->
</div>
<!-- Table Container (End) -->
<?php } ?>
<?php $Page->ShowPageFooter(); ?>
<?php if (EWR_DEBUG_ENABLED) echo ewr_DebugMsg(); ?>
<?php

// Close recordsets
if ($rsgrp) $rsgrp->Close();
if ($rs) $rs->Close();
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "phprptinc/footer.php" ?>
<?php
$Page->Page_Terminate();
if (isset($OldPage)) $Page = $OldPage;
?>
