<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start();
?>
<?php include_once "phprptinc/ewrcfg8.php" ?>
<?php include_once "phprptinc/ewmysql.php" ?>
<?php include_once "phprptinc/ewrfn8.php" ?>
<?php include_once "phprptinc/ewrusrfn8.php" ?>
<?php include_once "Hospitalizacionrptinfo.php" ?>
<?php

//
// Page class
//

$Hospitalizacion_rpt = NULL; // Initialize page object first

class crHospitalizacion_rpt extends crHospitalizacion {

	// Page ID
	var $PageID = 'rpt';

	// Project ID
	var $ProjectID = "{84B0927F-5257-4D61-BA82-F177D7F30F4F}";

	// Page object name
	var $PageObjName = 'Hospitalizacion_rpt';

	// Page name
	function PageName() {
		return ewr_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ewr_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Export URLs
	var $ExportPrintUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportPdfUrl;
	var $ReportTableClass;
	var $ReportTableStyle = "";

	// Custom export
	var $ExportPrintCustom = FALSE;
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Message
	function getMessage() {
		return @$_SESSION[EWR_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EWR_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EWR_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EWR_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_WARNING_MESSAGE], $v);
	}

		// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EWR_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EWR_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EWR_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EWR_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog ewDisplayTable\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") // Header exists, display
			echo $sHeader;
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") // Fotoer exists, display
			echo $sFooter;
	}

	// Validate page request
	function IsPageRequest() {
		if ($this->UseTokenInUrl) {
			if (ewr_IsHttpPost())
				return ($this->TableVar == @$_POST("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == @$_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $CheckToken = EWR_CHECK_TOKEN;
	var $CheckTokenFn = "ewr_CheckToken";
	var $CreateTokenFn = "ewr_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ewr_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EWR_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EWR_TOKEN_NAME]);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $ReportLanguage;

		// Language object
		$ReportLanguage = new crLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (Hospitalizacion)
		if (!isset($GLOBALS["Hospitalizacion"])) {
			$GLOBALS["Hospitalizacion"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Hospitalizacion"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";

		// Page ID
		if (!defined("EWR_PAGE_ID"))
			define("EWR_PAGE_ID", 'rpt', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EWR_TABLE_NAME"))
			define("EWR_TABLE_NAME", 'Hospitalizacion', TRUE);

		// Start timer
		$GLOBALS["gsTimer"] = new crTimer();

		// Open connection
		$conn = ewr_Connect();

		// Export options
		$this->ExportOptions = new crListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Search options
		$this->SearchOptions = new crListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Filter options
		$this->FilterOptions = new crListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fHospitalizacionrpt";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $gsEmailContentType, $ReportLanguage, $Security;
		global $gsCustomExport;

		// Get export parameters
		if (@$_GET["export"] <> "")
			$this->Export = strtolower($_GET["export"]);
		elseif (@$_POST["export"] <> "")
			$this->Export = strtolower($_POST["export"]);
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$gsEmailContentType = @$_POST["contenttype"]; // Get email content type

		// Setup placeholder
		// Setup export options

		$this->SetupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $ReportLanguage->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	// Set up export options
	function SetupExportOptions() {
		global $ReportLanguage;
		$exportid = session_id();

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->Phrase("ExportToWord") . "</a>";

		//$item->Visible = TRUE;
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Uncomment codes below to show export to Pdf link
//		$item->Visible = TRUE;
		// Export to Email

		$item = &$this->ExportOptions->Add("email");
		$url = $this->PageUrl() . "export=email";
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" id=\"emf_Hospitalizacion\" href=\"javascript:void(0);\" onclick=\"ewr_EmailDialogShow({lnk:'emf_Hospitalizacion',hdr:ewLanguage.Phrase('ExportToEmail'),url:'$url',exportid:'$exportid',el:this});\">" . $ReportLanguage->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter panel button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fHospitalizacionrpt\">" . $ReportLanguage->Phrase("SearchBtn") . "</button>";
		$item->Visible = FALSE;

		// Reset filter
		$item = &$this->SearchOptions->Add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . ewr_CurrentPage() . "?cmd=reset'\">" . $ReportLanguage->Phrase("ResetAllFilter") . "</button>";
		$item->Visible = FALSE;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fHospitalizacionrpt\" href=\"#\">" . $ReportLanguage->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fHospitalizacionrpt\" href=\"#\">" . $ReportLanguage->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up options (extended)
		$this->SetupExportOptionsExt();

		// Hide options for export
		if ($this->Export <> "") {
			$this->ExportOptions->HideAllOptions();
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Set up table class
		if ($this->Export == "word" || $this->Export == "excel" || $this->Export == "pdf")
			$this->ReportTableClass = "ewTable";
		else
			$this->ReportTableClass = "table ewTable";
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn, $ReportLanguage, $EWR_EXPORT, $gsExportFile;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->Export <> "" && array_key_exists($this->Export, $EWR_EXPORT)) {
			$sContent = ob_get_contents();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $sContent, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$sContent = str_replace($divmatch[0], '', $sContent);
				}
			}
			$fn = $EWR_EXPORT[$this->Export];
			if ($this->Export == "email") { // Email
				ob_end_clean();
				echo $this->$fn($sContent);
				$conn->Close(); // Close connection
				exit();
			} else {
				$this->$fn($sContent);
			}
		}

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EWR_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Initialize common variables
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $FilterOptions; // Filter options

	// Paging variables
	var $RecIndex = 0; // Record index
	var $RecCount = 0; // Record count
	var $StartGrp = 0; // Start group
	var $StopGrp = 0; // Stop group
	var $TotalGrps = 0; // Total groups
	var $GrpCount = 0; // Group count
	var $GrpCounter = array(); // Group counter
	var $DisplayGrps = 30; // Groups per page
	var $GrpRange = 10;
	var $Sort = "";
	var $Filter = "";
	var $PageFirstGroupFilter = "";
	var $UserIDFilter = "";
	var $DrillDown = FALSE;
	var $DrillDownInPanel = FALSE;
	var $DrillDownList = "";

	// Clear field for ext filter
	var $ClearExtFilter = "";
	var $PopupName = "";
	var $PopupValue = "";
	var $FilterApplied;
	var $SearchCommand = FALSE;
	var $ShowHeader;
	var $GrpFldCount = 0;
	var $SubGrpFldCount = 0;
	var $DtlFldCount = 0;
	var $Cnt, $Col, $Val, $Smry, $Mn, $Mx, $GrandCnt, $GrandSmry, $GrandMn, $GrandMx;
	var $TotCount;
	var $GrandSummarySetup = FALSE;
	var $GrpIdx;

	//
	// Page main
	//
	function Page_Main() {
		global $rs;
		global $rsgrp;
		global $gsFormError;
		global $gbDrillDownInPanel;
		global $ReportBreadcrumb;

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$nDtls = 20;
		$nGrps = 1;
		$this->Val = &ewr_InitArray($nDtls, 0);
		$this->Cnt = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Smry = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Mn = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->Mx = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->GrandCnt = &ewr_InitArray($nDtls, 0);
		$this->GrandSmry = &ewr_InitArray($nDtls, 0);
		$this->GrandMn = &ewr_InitArray($nDtls, NULL);
		$this->GrandMx = &ewr_InitArray($nDtls, NULL);

		// Set up array if accumulation required: array(Accum, SkipNullOrZero)
		$this->Col = array(array(FALSE, FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE));

		// Set up groups per page dynamically
		$this->SetUpDisplayGrps();

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->SetupPopup();

		// Load group db values if necessary
		$this->LoadGroupDbValues();

		// Handle Ajax popup
		$this->ProcessAjaxPopup();

		// Extended filter
		$sExtendedFilter = "";

		// Build popup filter
		$sPopupFilter = $this->GetPopupFilter();

		//ewr_SetDebugMsg("popup filter: " . $sPopupFilter);
		ewr_AddFilter($this->Filter, $sPopupFilter);

		// No filter
		$this->FilterApplied = FALSE;
		$this->FilterOptions->GetItem("savecurrentfilter")->Visible = FALSE;
		$this->FilterOptions->GetItem("deletefilter")->Visible = FALSE;

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);
		$this->SearchOptions->GetItem("resetfilter")->Visible = $this->FilterApplied;

		// Get sort
		$this->Sort = $this->GetSort();

		// Get total count
		$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $this->Filter, $this->Sort);
		$this->TotalGrps = $this->GetCnt($sSql);
		if ($this->DisplayGrps <= 0 || $this->DrillDown) // Display all groups
			$this->DisplayGrps = $this->TotalGrps;
		$this->StartGrp = 1;

		// Show header
		$this->ShowHeader = ($this->TotalGrps > 0);

		// Set up start position if not export all
		if ($this->ExportAll && $this->Export <> "")
		    $this->DisplayGrps = $this->TotalGrps;
		else
			$this->SetUpStartGroup(); 

		// Hide export options if export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();

		// Hide search/filter options if export/drilldown
		if ($this->Export <> "" || $this->DrillDown) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Get current page records
		$rs = $this->GetRs($sSql, $this->StartGrp, $this->DisplayGrps);
		$this->SetupFieldCount();
	}

	// Accummulate summary
	function AccumulateSummary() {
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Col[$iy][0]) { // Accumulate required
					$valwrk = $this->Val[$iy];
					if (is_null($valwrk)) {
						if (!$this->Col[$iy][1])
							$this->Cnt[$ix][$iy]++;
					} else {
						$accum = (!$this->Col[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Cnt[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Smry[$ix][$iy] += $valwrk;
								if (is_null($this->Mn[$ix][$iy])) {
									$this->Mn[$ix][$iy] = $valwrk;
									$this->Mx[$ix][$iy] = $valwrk;
								} else {
									if ($this->Mn[$ix][$iy] > $valwrk) $this->Mn[$ix][$iy] = $valwrk;
									if ($this->Mx[$ix][$iy] < $valwrk) $this->Mx[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0]++;
		}
	}

	// Reset level summary
	function ResetLevelSummary($lvl) {

		// Clear summary values
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Cnt[$ix][$iy] = 0;
				if ($this->Col[$iy][0]) {
					$this->Smry[$ix][$iy] = 0;
					$this->Mn[$ix][$iy] = NULL;
					$this->Mx[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0] = 0;
		}

		// Reset record count
		$this->RecCount = 0;
	}

	// Accummulate grand summary
	function AccumulateGrandSummary() {
		$this->TotCount++;
		$cntgs = count($this->GrandSmry);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Col[$iy][0]) {
				$valwrk = $this->Val[$iy];
				if (is_null($valwrk) || !is_numeric($valwrk)) {
					if (!$this->Col[$iy][1])
						$this->GrandCnt[$iy]++;
				} else {
					if (!$this->Col[$iy][1] || $valwrk <> 0) {
						$this->GrandCnt[$iy]++;
						$this->GrandSmry[$iy] += $valwrk;
						if (is_null($this->GrandMn[$iy])) {
							$this->GrandMn[$iy] = $valwrk;
							$this->GrandMx[$iy] = $valwrk;
						} else {
							if ($this->GrandMn[$iy] > $valwrk) $this->GrandMn[$iy] = $valwrk;
							if ($this->GrandMx[$iy] < $valwrk) $this->GrandMx[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Get count
	function GetCnt($sql) {
		global $conn;
		$rscnt = $conn->Execute($sql);
		$cnt = ($rscnt) ? $rscnt->RecordCount() : 0;
		if ($rscnt) $rscnt->Close();
		return $cnt;
	}

	// Get recordset
	function GetRs($wrksql, $start, $grps) {
		global $conn;
		$conn->raiseErrorFn = $GLOBALS["EWR_ERROR_FN"];
		$rswrk = $conn->SelectLimit($wrksql, $grps, $start - 1);
		$conn->raiseErrorFn = '';
		return $rswrk;
	}

	// Get row values
	function GetRow($opt) {
		global $rs;
		if (!$rs)
			return;
		if ($opt == 1) { // Get first row

	//		$rs->MoveFirst(); // NOTE: no need to move position
				$this->FirstRowData = array();
				$this->FirstRowData['Numero_factura'] = ewr_Conv($rs->fields('Numero_factura'),200);
				$this->FirstRowData['Codigo_prestador'] = ewr_Conv($rs->fields('Codigo_prestador'),200);
				$this->FirstRowData['Tipo_id'] = ewr_Conv($rs->fields('Tipo_id'),200);
				$this->FirstRowData['Numero_id'] = ewr_Conv($rs->fields('Numero_id'),200);
				$this->FirstRowData['Via_ingreso_ins'] = ewr_Conv($rs->fields('Via_ingreso_ins'),3);
				$this->FirstRowData['Fecha_ingreso_usuario'] = ewr_Conv($rs->fields('Fecha_ingreso_usuario'),200);
				$this->FirstRowData['Hora_ingreso'] = ewr_Conv($rs->fields('Hora_ingreso'),200);
				$this->FirstRowData['Numero_autorizacion'] = ewr_Conv($rs->fields('Numero_autorizacion'),200);
				$this->FirstRowData['Causa_externa'] = ewr_Conv($rs->fields('Causa_externa'),3);
				$this->FirstRowData['Diagnostico_principal_ingreso'] = ewr_Conv($rs->fields('Diagnostico_principal_ingreso'),200);
				$this->FirstRowData['Diagnostico_principal_egreso'] = ewr_Conv($rs->fields('Diagnostico_principal_egreso'),200);
				$this->FirstRowData['Diagnostico_rel_1'] = ewr_Conv($rs->fields('Diagnostico_rel_1'),200);
				$this->FirstRowData['Diagnostico_rel_2'] = ewr_Conv($rs->fields('Diagnostico_rel_2'),200);
				$this->FirstRowData['Diagnostico_rel_3'] = ewr_Conv($rs->fields('Diagnostico_rel_3'),200);
				$this->FirstRowData['Diagnostico_complicacion'] = ewr_Conv($rs->fields('Diagnostico_complicacion'),200);
				$this->FirstRowData['Estado_salida'] = ewr_Conv($rs->fields('Estado_salida'),3);
				$this->FirstRowData['Diagnostico_causa_muerte'] = ewr_Conv($rs->fields('Diagnostico_causa_muerte'),200);
				$this->FirstRowData['Fecha_egreso'] = ewr_Conv($rs->fields('Fecha_egreso'),200);
				$this->FirstRowData['Hora__egreso'] = ewr_Conv($rs->fields('Hora _egreso'),200);
		} else { // Get next row
			$rs->MoveNext();
		}
		if (!$rs->EOF) {
			$this->Numero_factura->setDbValue($rs->fields('Numero_factura'));
			$this->Codigo_prestador->setDbValue($rs->fields('Codigo_prestador'));
			$this->Tipo_id->setDbValue($rs->fields('Tipo_id'));
			$this->Numero_id->setDbValue($rs->fields('Numero_id'));
			$this->Via_ingreso_ins->setDbValue($rs->fields('Via_ingreso_ins'));
			$this->Fecha_ingreso_usuario->setDbValue($rs->fields('Fecha_ingreso_usuario'));
			$this->Hora_ingreso->setDbValue($rs->fields('Hora_ingreso'));
			$this->Numero_autorizacion->setDbValue($rs->fields('Numero_autorizacion'));
			$this->Causa_externa->setDbValue($rs->fields('Causa_externa'));
			$this->Diagnostico_principal_ingreso->setDbValue($rs->fields('Diagnostico_principal_ingreso'));
			$this->Diagnostico_principal_egreso->setDbValue($rs->fields('Diagnostico_principal_egreso'));
			$this->Diagnostico_rel_1->setDbValue($rs->fields('Diagnostico_rel_1'));
			$this->Diagnostico_rel_2->setDbValue($rs->fields('Diagnostico_rel_2'));
			$this->Diagnostico_rel_3->setDbValue($rs->fields('Diagnostico_rel_3'));
			$this->Diagnostico_complicacion->setDbValue($rs->fields('Diagnostico_complicacion'));
			$this->Estado_salida->setDbValue($rs->fields('Estado_salida'));
			$this->Diagnostico_causa_muerte->setDbValue($rs->fields('Diagnostico_causa_muerte'));
			$this->Fecha_egreso->setDbValue($rs->fields('Fecha_egreso'));
			$this->Hora__egreso->setDbValue($rs->fields('Hora _egreso'));
			$this->Val[1] = $this->Numero_factura->CurrentValue;
			$this->Val[2] = $this->Codigo_prestador->CurrentValue;
			$this->Val[3] = $this->Tipo_id->CurrentValue;
			$this->Val[4] = $this->Numero_id->CurrentValue;
			$this->Val[5] = $this->Via_ingreso_ins->CurrentValue;
			$this->Val[6] = $this->Fecha_ingreso_usuario->CurrentValue;
			$this->Val[7] = $this->Hora_ingreso->CurrentValue;
			$this->Val[8] = $this->Numero_autorizacion->CurrentValue;
			$this->Val[9] = $this->Causa_externa->CurrentValue;
			$this->Val[10] = $this->Diagnostico_principal_ingreso->CurrentValue;
			$this->Val[11] = $this->Diagnostico_principal_egreso->CurrentValue;
			$this->Val[12] = $this->Diagnostico_rel_1->CurrentValue;
			$this->Val[13] = $this->Diagnostico_rel_2->CurrentValue;
			$this->Val[14] = $this->Diagnostico_rel_3->CurrentValue;
			$this->Val[15] = $this->Diagnostico_complicacion->CurrentValue;
			$this->Val[16] = $this->Estado_salida->CurrentValue;
			$this->Val[17] = $this->Diagnostico_causa_muerte->CurrentValue;
			$this->Val[18] = $this->Fecha_egreso->CurrentValue;
			$this->Val[19] = $this->Hora__egreso->CurrentValue;
		} else {
			$this->Numero_factura->setDbValue("");
			$this->Codigo_prestador->setDbValue("");
			$this->Tipo_id->setDbValue("");
			$this->Numero_id->setDbValue("");
			$this->Via_ingreso_ins->setDbValue("");
			$this->Fecha_ingreso_usuario->setDbValue("");
			$this->Hora_ingreso->setDbValue("");
			$this->Numero_autorizacion->setDbValue("");
			$this->Causa_externa->setDbValue("");
			$this->Diagnostico_principal_ingreso->setDbValue("");
			$this->Diagnostico_principal_egreso->setDbValue("");
			$this->Diagnostico_rel_1->setDbValue("");
			$this->Diagnostico_rel_2->setDbValue("");
			$this->Diagnostico_rel_3->setDbValue("");
			$this->Diagnostico_complicacion->setDbValue("");
			$this->Estado_salida->setDbValue("");
			$this->Diagnostico_causa_muerte->setDbValue("");
			$this->Fecha_egreso->setDbValue("");
			$this->Hora__egreso->setDbValue("");
		}
	}

	//  Set up starting group
	function SetUpStartGroup() {

		// Exit if no groups
		if ($this->DisplayGrps == 0)
			return;

		// Check for a 'start' parameter
		if (@$_GET[EWR_TABLE_START_GROUP] != "") {
			$this->StartGrp = $_GET[EWR_TABLE_START_GROUP];
			$this->setStartGroup($this->StartGrp);
		} elseif (@$_GET["pageno"] != "") {
			$nPageNo = $_GET["pageno"];
			if (is_numeric($nPageNo)) {
				$this->StartGrp = ($nPageNo-1)*$this->DisplayGrps+1;
				if ($this->StartGrp <= 0) {
					$this->StartGrp = 1;
				} elseif ($this->StartGrp >= intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1) {
					$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1;
				}
				$this->setStartGroup($this->StartGrp);
			} else {
				$this->StartGrp = $this->getStartGroup();
			}
		} else {
			$this->StartGrp = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGrp) || $this->StartGrp == "") { // Avoid invalid start group counter
			$this->StartGrp = 1; // Reset start group counter
			$this->setStartGroup($this->StartGrp);
		} elseif (intval($this->StartGrp) > intval($this->TotalGrps)) { // Avoid starting group > total groups
			$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to last page first group
			$this->setStartGroup($this->StartGrp);
		} elseif (($this->StartGrp-1) % $this->DisplayGrps <> 0) {
			$this->StartGrp = intval(($this->StartGrp-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to page boundary
			$this->setStartGroup($this->StartGrp);
		}
	}

	// Load group db values if necessary
	function LoadGroupDbValues() {
		global $conn;
	}

	// Process Ajax popup
	function ProcessAjaxPopup() {
		global $conn, $ReportLanguage;
		$fld = NULL;
		if (@$_GET["popup"] <> "") {
			$popupname = $_GET["popup"];

			// Check popup name
			// Output data as Json

			if (!is_null($fld)) {
				$jsdb = ewr_GetJsDb($fld, $fld->FldType);
				ob_end_clean();
				echo $jsdb;
				exit();
			}
		}
	}

	// Set up popup
	function SetupPopup() {
		global $conn, $ReportLanguage;
		if ($this->DrillDown)
			return;

		// Process post back form
		if (ewr_IsHttpPost()) {
			$sName = @$_POST["popup"]; // Get popup form name
			if ($sName <> "") {
				$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
				if ($cntValues > 0) {
					$arValues = ewr_StripSlashes($_POST["sel_$sName"]);
					if (trim($arValues[0]) == "") // Select all
						$arValues = EWR_INIT_VALUE;
					$_SESSION["sel_$sName"] = $arValues;
					$_SESSION["rf_$sName"] = ewr_StripSlashes(@$_POST["rf_$sName"]);
					$_SESSION["rt_$sName"] = ewr_StripSlashes(@$_POST["rt_$sName"]);
					$this->ResetPager();
				}
			}

		// Get 'reset' command
		} elseif (@$_GET["cmd"] <> "") {
			$sCmd = $_GET["cmd"];
			if (strtolower($sCmd) == "reset") {
				$this->ResetPager();
			}
		}

		// Load selection criteria to array
	}

	// Reset pager
	function ResetPager() {

		// Reset start position (reset command)
		$this->StartGrp = 1;
		$this->setStartGroup($this->StartGrp);
	}

	// Set up number of groups displayed per page
	function SetUpDisplayGrps() {
		$sWrk = @$_GET[EWR_TABLE_GROUP_PER_PAGE];
		if ($sWrk <> "") {
			if (is_numeric($sWrk)) {
				$this->DisplayGrps = intval($sWrk);
			} else {
				if (strtoupper($sWrk) == "ALL") { // Display all groups
					$this->DisplayGrps = -1;
				} else {
					$this->DisplayGrps = 30; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGrps); // Save to session

			// Reset start position (reset command)
			$this->StartGrp = 1;
			$this->setStartGroup($this->StartGrp);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGrps = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGrps = 30; // Load default
			}
		}
	}

	// Render row
	function RenderRow() {
		global $conn, $rs, $Security, $ReportLanguage;
		if ($this->RowTotalType == EWR_ROWTOTAL_GRAND && !$this->GrandSummarySetup) { // Grand total
			$bGotCount = FALSE;
			$bGotSummary = FALSE;

			// Get total count from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->Execute($sSql);
			if ($rstot) {
				$this->TotCount = ($rstot->RecordCount()>1) ? $rstot->RecordCount() : $rstot->fields[0];
				$rstot->Close();
				$bGotCount = TRUE;
			} else {
				$this->TotCount = 0;
			}
		$bGotSummary = TRUE;

			// Accumulate grand summary from detail records
			if (!$bGotCount || !$bGotSummary) {
				$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$rs = $conn->Execute($sSql);
				if ($rs) {
					$this->GetRow(1);
					while (!$rs->EOF) {
						$this->AccumulateGrandSummary();
						$this->GetRow(2);
					}
					$rs->Close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();

		//
		// Render view codes
		//

		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row

			// Numero_factura
			$this->Numero_factura->HrefValue = "";

			// Codigo_prestador
			$this->Codigo_prestador->HrefValue = "";

			// Tipo_id
			$this->Tipo_id->HrefValue = "";

			// Numero_id
			$this->Numero_id->HrefValue = "";

			// Via_ingreso_ins
			$this->Via_ingreso_ins->HrefValue = "";

			// Fecha_ingreso_usuario
			$this->Fecha_ingreso_usuario->HrefValue = "";

			// Hora_ingreso
			$this->Hora_ingreso->HrefValue = "";

			// Numero_autorizacion
			$this->Numero_autorizacion->HrefValue = "";

			// Causa_externa
			$this->Causa_externa->HrefValue = "";

			// Diagnostico_principal_ingreso
			$this->Diagnostico_principal_ingreso->HrefValue = "";

			// Diagnostico_principal_egreso
			$this->Diagnostico_principal_egreso->HrefValue = "";

			// Diagnostico_rel_1
			$this->Diagnostico_rel_1->HrefValue = "";

			// Diagnostico_rel_2
			$this->Diagnostico_rel_2->HrefValue = "";

			// Diagnostico_rel_3
			$this->Diagnostico_rel_3->HrefValue = "";

			// Diagnostico_complicacion
			$this->Diagnostico_complicacion->HrefValue = "";

			// Estado_salida
			$this->Estado_salida->HrefValue = "";

			// Diagnostico_causa_muerte
			$this->Diagnostico_causa_muerte->HrefValue = "";

			// Fecha_egreso
			$this->Fecha_egreso->HrefValue = "";

			// Hora _egreso
			$this->Hora__egreso->HrefValue = "";
		} else {

			// Numero_factura
			$this->Numero_factura->ViewValue = $this->Numero_factura->CurrentValue;
			$this->Numero_factura->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Codigo_prestador
			$this->Codigo_prestador->ViewValue = $this->Codigo_prestador->CurrentValue;
			$this->Codigo_prestador->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Tipo_id
			$this->Tipo_id->ViewValue = $this->Tipo_id->CurrentValue;
			$this->Tipo_id->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Numero_id
			$this->Numero_id->ViewValue = $this->Numero_id->CurrentValue;
			$this->Numero_id->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Via_ingreso_ins
			$this->Via_ingreso_ins->ViewValue = $this->Via_ingreso_ins->CurrentValue;
			$this->Via_ingreso_ins->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Fecha_ingreso_usuario
			$this->Fecha_ingreso_usuario->ViewValue = $this->Fecha_ingreso_usuario->CurrentValue;
			$this->Fecha_ingreso_usuario->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Hora_ingreso
			$this->Hora_ingreso->ViewValue = $this->Hora_ingreso->CurrentValue;
			$this->Hora_ingreso->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Numero_autorizacion
			$this->Numero_autorizacion->ViewValue = $this->Numero_autorizacion->CurrentValue;
			$this->Numero_autorizacion->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Causa_externa
			$this->Causa_externa->ViewValue = $this->Causa_externa->CurrentValue;
			$this->Causa_externa->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Diagnostico_principal_ingreso
			$this->Diagnostico_principal_ingreso->ViewValue = $this->Diagnostico_principal_ingreso->CurrentValue;
			$this->Diagnostico_principal_ingreso->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Diagnostico_principal_egreso
			$this->Diagnostico_principal_egreso->ViewValue = $this->Diagnostico_principal_egreso->CurrentValue;
			$this->Diagnostico_principal_egreso->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Diagnostico_rel_1
			$this->Diagnostico_rel_1->ViewValue = $this->Diagnostico_rel_1->CurrentValue;
			$this->Diagnostico_rel_1->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Diagnostico_rel_2
			$this->Diagnostico_rel_2->ViewValue = $this->Diagnostico_rel_2->CurrentValue;
			$this->Diagnostico_rel_2->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Diagnostico_rel_3
			$this->Diagnostico_rel_3->ViewValue = $this->Diagnostico_rel_3->CurrentValue;
			$this->Diagnostico_rel_3->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Diagnostico_complicacion
			$this->Diagnostico_complicacion->ViewValue = $this->Diagnostico_complicacion->CurrentValue;
			$this->Diagnostico_complicacion->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Estado_salida
			$this->Estado_salida->ViewValue = $this->Estado_salida->CurrentValue;
			$this->Estado_salida->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Diagnostico_causa_muerte
			$this->Diagnostico_causa_muerte->ViewValue = $this->Diagnostico_causa_muerte->CurrentValue;
			$this->Diagnostico_causa_muerte->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Fecha_egreso
			$this->Fecha_egreso->ViewValue = $this->Fecha_egreso->CurrentValue;
			$this->Fecha_egreso->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Hora _egreso
			$this->Hora__egreso->ViewValue = $this->Hora__egreso->CurrentValue;
			$this->Hora__egreso->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Numero_factura
			$this->Numero_factura->HrefValue = "";

			// Codigo_prestador
			$this->Codigo_prestador->HrefValue = "";

			// Tipo_id
			$this->Tipo_id->HrefValue = "";

			// Numero_id
			$this->Numero_id->HrefValue = "";

			// Via_ingreso_ins
			$this->Via_ingreso_ins->HrefValue = "";

			// Fecha_ingreso_usuario
			$this->Fecha_ingreso_usuario->HrefValue = "";

			// Hora_ingreso
			$this->Hora_ingreso->HrefValue = "";

			// Numero_autorizacion
			$this->Numero_autorizacion->HrefValue = "";

			// Causa_externa
			$this->Causa_externa->HrefValue = "";

			// Diagnostico_principal_ingreso
			$this->Diagnostico_principal_ingreso->HrefValue = "";

			// Diagnostico_principal_egreso
			$this->Diagnostico_principal_egreso->HrefValue = "";

			// Diagnostico_rel_1
			$this->Diagnostico_rel_1->HrefValue = "";

			// Diagnostico_rel_2
			$this->Diagnostico_rel_2->HrefValue = "";

			// Diagnostico_rel_3
			$this->Diagnostico_rel_3->HrefValue = "";

			// Diagnostico_complicacion
			$this->Diagnostico_complicacion->HrefValue = "";

			// Estado_salida
			$this->Estado_salida->HrefValue = "";

			// Diagnostico_causa_muerte
			$this->Diagnostico_causa_muerte->HrefValue = "";

			// Fecha_egreso
			$this->Fecha_egreso->HrefValue = "";

			// Hora _egreso
			$this->Hora__egreso->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row
		} else {

			// Numero_factura
			$CurrentValue = $this->Numero_factura->CurrentValue;
			$ViewValue = &$this->Numero_factura->ViewValue;
			$ViewAttrs = &$this->Numero_factura->ViewAttrs;
			$CellAttrs = &$this->Numero_factura->CellAttrs;
			$HrefValue = &$this->Numero_factura->HrefValue;
			$LinkAttrs = &$this->Numero_factura->LinkAttrs;
			$this->Cell_Rendered($this->Numero_factura, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Codigo_prestador
			$CurrentValue = $this->Codigo_prestador->CurrentValue;
			$ViewValue = &$this->Codigo_prestador->ViewValue;
			$ViewAttrs = &$this->Codigo_prestador->ViewAttrs;
			$CellAttrs = &$this->Codigo_prestador->CellAttrs;
			$HrefValue = &$this->Codigo_prestador->HrefValue;
			$LinkAttrs = &$this->Codigo_prestador->LinkAttrs;
			$this->Cell_Rendered($this->Codigo_prestador, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Tipo_id
			$CurrentValue = $this->Tipo_id->CurrentValue;
			$ViewValue = &$this->Tipo_id->ViewValue;
			$ViewAttrs = &$this->Tipo_id->ViewAttrs;
			$CellAttrs = &$this->Tipo_id->CellAttrs;
			$HrefValue = &$this->Tipo_id->HrefValue;
			$LinkAttrs = &$this->Tipo_id->LinkAttrs;
			$this->Cell_Rendered($this->Tipo_id, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Numero_id
			$CurrentValue = $this->Numero_id->CurrentValue;
			$ViewValue = &$this->Numero_id->ViewValue;
			$ViewAttrs = &$this->Numero_id->ViewAttrs;
			$CellAttrs = &$this->Numero_id->CellAttrs;
			$HrefValue = &$this->Numero_id->HrefValue;
			$LinkAttrs = &$this->Numero_id->LinkAttrs;
			$this->Cell_Rendered($this->Numero_id, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Via_ingreso_ins
			$CurrentValue = $this->Via_ingreso_ins->CurrentValue;
			$ViewValue = &$this->Via_ingreso_ins->ViewValue;
			$ViewAttrs = &$this->Via_ingreso_ins->ViewAttrs;
			$CellAttrs = &$this->Via_ingreso_ins->CellAttrs;
			$HrefValue = &$this->Via_ingreso_ins->HrefValue;
			$LinkAttrs = &$this->Via_ingreso_ins->LinkAttrs;
			$this->Cell_Rendered($this->Via_ingreso_ins, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Fecha_ingreso_usuario
			$CurrentValue = $this->Fecha_ingreso_usuario->CurrentValue;
			$ViewValue = &$this->Fecha_ingreso_usuario->ViewValue;
			$ViewAttrs = &$this->Fecha_ingreso_usuario->ViewAttrs;
			$CellAttrs = &$this->Fecha_ingreso_usuario->CellAttrs;
			$HrefValue = &$this->Fecha_ingreso_usuario->HrefValue;
			$LinkAttrs = &$this->Fecha_ingreso_usuario->LinkAttrs;
			$this->Cell_Rendered($this->Fecha_ingreso_usuario, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Hora_ingreso
			$CurrentValue = $this->Hora_ingreso->CurrentValue;
			$ViewValue = &$this->Hora_ingreso->ViewValue;
			$ViewAttrs = &$this->Hora_ingreso->ViewAttrs;
			$CellAttrs = &$this->Hora_ingreso->CellAttrs;
			$HrefValue = &$this->Hora_ingreso->HrefValue;
			$LinkAttrs = &$this->Hora_ingreso->LinkAttrs;
			$this->Cell_Rendered($this->Hora_ingreso, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Numero_autorizacion
			$CurrentValue = $this->Numero_autorizacion->CurrentValue;
			$ViewValue = &$this->Numero_autorizacion->ViewValue;
			$ViewAttrs = &$this->Numero_autorizacion->ViewAttrs;
			$CellAttrs = &$this->Numero_autorizacion->CellAttrs;
			$HrefValue = &$this->Numero_autorizacion->HrefValue;
			$LinkAttrs = &$this->Numero_autorizacion->LinkAttrs;
			$this->Cell_Rendered($this->Numero_autorizacion, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Causa_externa
			$CurrentValue = $this->Causa_externa->CurrentValue;
			$ViewValue = &$this->Causa_externa->ViewValue;
			$ViewAttrs = &$this->Causa_externa->ViewAttrs;
			$CellAttrs = &$this->Causa_externa->CellAttrs;
			$HrefValue = &$this->Causa_externa->HrefValue;
			$LinkAttrs = &$this->Causa_externa->LinkAttrs;
			$this->Cell_Rendered($this->Causa_externa, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Diagnostico_principal_ingreso
			$CurrentValue = $this->Diagnostico_principal_ingreso->CurrentValue;
			$ViewValue = &$this->Diagnostico_principal_ingreso->ViewValue;
			$ViewAttrs = &$this->Diagnostico_principal_ingreso->ViewAttrs;
			$CellAttrs = &$this->Diagnostico_principal_ingreso->CellAttrs;
			$HrefValue = &$this->Diagnostico_principal_ingreso->HrefValue;
			$LinkAttrs = &$this->Diagnostico_principal_ingreso->LinkAttrs;
			$this->Cell_Rendered($this->Diagnostico_principal_ingreso, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Diagnostico_principal_egreso
			$CurrentValue = $this->Diagnostico_principal_egreso->CurrentValue;
			$ViewValue = &$this->Diagnostico_principal_egreso->ViewValue;
			$ViewAttrs = &$this->Diagnostico_principal_egreso->ViewAttrs;
			$CellAttrs = &$this->Diagnostico_principal_egreso->CellAttrs;
			$HrefValue = &$this->Diagnostico_principal_egreso->HrefValue;
			$LinkAttrs = &$this->Diagnostico_principal_egreso->LinkAttrs;
			$this->Cell_Rendered($this->Diagnostico_principal_egreso, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Diagnostico_rel_1
			$CurrentValue = $this->Diagnostico_rel_1->CurrentValue;
			$ViewValue = &$this->Diagnostico_rel_1->ViewValue;
			$ViewAttrs = &$this->Diagnostico_rel_1->ViewAttrs;
			$CellAttrs = &$this->Diagnostico_rel_1->CellAttrs;
			$HrefValue = &$this->Diagnostico_rel_1->HrefValue;
			$LinkAttrs = &$this->Diagnostico_rel_1->LinkAttrs;
			$this->Cell_Rendered($this->Diagnostico_rel_1, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Diagnostico_rel_2
			$CurrentValue = $this->Diagnostico_rel_2->CurrentValue;
			$ViewValue = &$this->Diagnostico_rel_2->ViewValue;
			$ViewAttrs = &$this->Diagnostico_rel_2->ViewAttrs;
			$CellAttrs = &$this->Diagnostico_rel_2->CellAttrs;
			$HrefValue = &$this->Diagnostico_rel_2->HrefValue;
			$LinkAttrs = &$this->Diagnostico_rel_2->LinkAttrs;
			$this->Cell_Rendered($this->Diagnostico_rel_2, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Diagnostico_rel_3
			$CurrentValue = $this->Diagnostico_rel_3->CurrentValue;
			$ViewValue = &$this->Diagnostico_rel_3->ViewValue;
			$ViewAttrs = &$this->Diagnostico_rel_3->ViewAttrs;
			$CellAttrs = &$this->Diagnostico_rel_3->CellAttrs;
			$HrefValue = &$this->Diagnostico_rel_3->HrefValue;
			$LinkAttrs = &$this->Diagnostico_rel_3->LinkAttrs;
			$this->Cell_Rendered($this->Diagnostico_rel_3, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Diagnostico_complicacion
			$CurrentValue = $this->Diagnostico_complicacion->CurrentValue;
			$ViewValue = &$this->Diagnostico_complicacion->ViewValue;
			$ViewAttrs = &$this->Diagnostico_complicacion->ViewAttrs;
			$CellAttrs = &$this->Diagnostico_complicacion->CellAttrs;
			$HrefValue = &$this->Diagnostico_complicacion->HrefValue;
			$LinkAttrs = &$this->Diagnostico_complicacion->LinkAttrs;
			$this->Cell_Rendered($this->Diagnostico_complicacion, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Estado_salida
			$CurrentValue = $this->Estado_salida->CurrentValue;
			$ViewValue = &$this->Estado_salida->ViewValue;
			$ViewAttrs = &$this->Estado_salida->ViewAttrs;
			$CellAttrs = &$this->Estado_salida->CellAttrs;
			$HrefValue = &$this->Estado_salida->HrefValue;
			$LinkAttrs = &$this->Estado_salida->LinkAttrs;
			$this->Cell_Rendered($this->Estado_salida, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Diagnostico_causa_muerte
			$CurrentValue = $this->Diagnostico_causa_muerte->CurrentValue;
			$ViewValue = &$this->Diagnostico_causa_muerte->ViewValue;
			$ViewAttrs = &$this->Diagnostico_causa_muerte->ViewAttrs;
			$CellAttrs = &$this->Diagnostico_causa_muerte->CellAttrs;
			$HrefValue = &$this->Diagnostico_causa_muerte->HrefValue;
			$LinkAttrs = &$this->Diagnostico_causa_muerte->LinkAttrs;
			$this->Cell_Rendered($this->Diagnostico_causa_muerte, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Fecha_egreso
			$CurrentValue = $this->Fecha_egreso->CurrentValue;
			$ViewValue = &$this->Fecha_egreso->ViewValue;
			$ViewAttrs = &$this->Fecha_egreso->ViewAttrs;
			$CellAttrs = &$this->Fecha_egreso->CellAttrs;
			$HrefValue = &$this->Fecha_egreso->HrefValue;
			$LinkAttrs = &$this->Fecha_egreso->LinkAttrs;
			$this->Cell_Rendered($this->Fecha_egreso, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Hora _egreso
			$CurrentValue = $this->Hora__egreso->CurrentValue;
			$ViewValue = &$this->Hora__egreso->ViewValue;
			$ViewAttrs = &$this->Hora__egreso->ViewAttrs;
			$CellAttrs = &$this->Hora__egreso->CellAttrs;
			$HrefValue = &$this->Hora__egreso->HrefValue;
			$LinkAttrs = &$this->Hora__egreso->LinkAttrs;
			$this->Cell_Rendered($this->Hora__egreso, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->SetupFieldCount();
	}

	// Setup field count
	function SetupFieldCount() {
		$this->GrpFldCount = 0;
		$this->SubGrpFldCount = 0;
		$this->DtlFldCount = 0;
		if ($this->Numero_factura->Visible) $this->DtlFldCount += 1;
		if ($this->Codigo_prestador->Visible) $this->DtlFldCount += 1;
		if ($this->Tipo_id->Visible) $this->DtlFldCount += 1;
		if ($this->Numero_id->Visible) $this->DtlFldCount += 1;
		if ($this->Via_ingreso_ins->Visible) $this->DtlFldCount += 1;
		if ($this->Fecha_ingreso_usuario->Visible) $this->DtlFldCount += 1;
		if ($this->Hora_ingreso->Visible) $this->DtlFldCount += 1;
		if ($this->Numero_autorizacion->Visible) $this->DtlFldCount += 1;
		if ($this->Causa_externa->Visible) $this->DtlFldCount += 1;
		if ($this->Diagnostico_principal_ingreso->Visible) $this->DtlFldCount += 1;
		if ($this->Diagnostico_principal_egreso->Visible) $this->DtlFldCount += 1;
		if ($this->Diagnostico_rel_1->Visible) $this->DtlFldCount += 1;
		if ($this->Diagnostico_rel_2->Visible) $this->DtlFldCount += 1;
		if ($this->Diagnostico_rel_3->Visible) $this->DtlFldCount += 1;
		if ($this->Diagnostico_complicacion->Visible) $this->DtlFldCount += 1;
		if ($this->Estado_salida->Visible) $this->DtlFldCount += 1;
		if ($this->Diagnostico_causa_muerte->Visible) $this->DtlFldCount += 1;
		if ($this->Fecha_egreso->Visible) $this->DtlFldCount += 1;
		if ($this->Hora__egreso->Visible) $this->DtlFldCount += 1;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $ReportBreadcrumb;
		$ReportBreadcrumb = new crBreadcrumb();
		$url = substr(ewr_CurrentUrl(), strrpos(ewr_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$ReportBreadcrumb->Add("rpt", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	function SetupExportOptionsExt() {
		global $ReportLanguage;
		$item =& $this->ExportOptions->GetItem("pdf");
		$item->Visible = TRUE;
		$exportid = session_id();
		$url = $this->ExportPdfUrl;
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ewr_ExportCharts(this, '" . $url . "', '" . $exportid . "');\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
	}

	// Return popup filter
	function GetPopupFilter() {
		$sWrk = "";
		if ($this->DrillDown)
			return "";
		return $sWrk;
	}

	//-------------------------------------------------------------------------------
	// Function GetSort
	// - Return Sort parameters based on Sort Links clicked
	// - Variables setup: Session[EWR_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
	function GetSort() {
		if ($this->DrillDown)
			return "";

		// Check for a resetsort command
		if (strlen(@$_GET["cmd"]) > 0) {
			$sCmd = @$_GET["cmd"];
			if ($sCmd == "resetsort") {
				$this->setOrderBy("");
				$this->setStartGroup(1);
				$this->Numero_factura->setSort("");
				$this->Codigo_prestador->setSort("");
				$this->Tipo_id->setSort("");
				$this->Numero_id->setSort("");
				$this->Via_ingreso_ins->setSort("");
				$this->Fecha_ingreso_usuario->setSort("");
				$this->Hora_ingreso->setSort("");
				$this->Numero_autorizacion->setSort("");
				$this->Causa_externa->setSort("");
				$this->Diagnostico_principal_ingreso->setSort("");
				$this->Diagnostico_principal_egreso->setSort("");
				$this->Diagnostico_rel_1->setSort("");
				$this->Diagnostico_rel_2->setSort("");
				$this->Diagnostico_rel_3->setSort("");
				$this->Diagnostico_complicacion->setSort("");
				$this->Estado_salida->setSort("");
				$this->Diagnostico_causa_muerte->setSort("");
				$this->Fecha_egreso->setSort("");
				$this->Hora__egreso->setSort("");
			}

		// Check for an Order parameter
		} elseif (@$_GET["order"] <> "") {
			$this->CurrentOrder = ewr_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$sSortSql = $this->SortSql();
			$this->setOrderBy($sSortSql);
			$this->setStartGroup(1);
		}
		return $this->getOrderBy();
	}

	// Export to WORD
	function ExportWord($html) {
		global $gsExportFile;
		header('Content-Type: application/vnd.ms-word' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		header('Content-Disposition: attachment; filename=' . $gsExportFile . '.doc');
		echo $html;
	}

	// Export to EXCEL
	function ExportExcel($html) {
		global $gsExportFile;
		header('Content-Type: application/vnd.ms-excel' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		header('Content-Disposition: attachment; filename=' . $gsExportFile . '.xls');
		echo $html;
	}

	// Export PDF
	function ExportPDF($html) {
		global $gsExportFile;
		include_once "dompdf061/dompdf_config.inc.php";
		@ini_set("memory_limit", EWR_PDF_MEMORY_LIMIT);
		set_time_limit(EWR_PDF_TIME_LIMIT);
		$dompdf = new DOMPDF();
		$dompdf->load_html($html);
		ob_end_clean();
		$dompdf->set_paper("a4", "portrait");
		$dompdf->render();
		ewr_DeleteTmpImages($html);
		$dompdf->stream($gsExportFile . ".pdf", array("Attachment" => 1)); // 0 to open in browser, 1 to download

//		exit();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ewr_Header(FALSE) ?>
<?php

// Create page object
if (!isset($Hospitalizacion_rpt)) $Hospitalizacion_rpt = new crHospitalizacion_rpt();
if (isset($Page)) $OldPage = $Page;
$Page = &$Hospitalizacion_rpt;

// Page init
$Page->Page_Init();

// Page main
$Page->Page_Main();

// Global Page Rendering event (in ewrusrfn*.php)
Page_Rendering();

// Page Rendering event
$Page->Page_Render();
?>
<?php include_once "phprptinc/header.php" ?>
<?php if ($Page->Export == "") { ?>
<script type="text/javascript">

// Create page object
var Hospitalizacion_rpt = new ewr_Page("Hospitalizacion_rpt");

// Page properties
Hospitalizacion_rpt.PageID = "rpt"; // Page ID
var EWR_PAGE_ID = Hospitalizacion_rpt.PageID;

// Extend page with Chart_Rendering function
Hospitalizacion_rpt.Chart_Rendering = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }

// Extend page with Chart_Rendered function
Hospitalizacion_rpt.Chart_Rendered = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($Page->Export == "") { ?>
<!-- container (begin) -->
<div id="ewContainer" class="ewContainer">
<!-- top container (begin) -->
<div id="ewTop" class="ewTop">
<a id="top"></a>
<?php } ?>
<!-- top slot -->
<div class="ewToolbar">
<?php if ($Page->Export == "" && (!$Page->DrillDown || !$Page->DrillDownInPanel)) { ?>
<?php if ($ReportBreadcrumb) $ReportBreadcrumb->Render(); ?>
<?php } ?>
<?php
if (!$Page->DrillDownInPanel) {
	$Page->ExportOptions->Render("body");
	$Page->SearchOptions->Render("body");
	$Page->FilterOptions->Render("body");
}
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php echo $ReportLanguage->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php $Page->ShowPageHeader(); ?>
<?php $Page->ShowMessage(); ?>
<?php if ($Page->Export == "") { ?>
</div>
<!-- top container (end) -->
	<!-- left container (begin) -->
	<div id="ewLeft" class="ewLeft">
<?php } ?>
	<!-- Left slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- left container (end) -->
	<!-- center container - report (begin) -->
	<div id="ewCenter" class="ewCenter">
<?php } ?>
	<!-- center slot -->
<!-- summary report starts -->
<?php if ($Page->Export <> "pdf") { ?>
<div id="report_summary">
<?php } ?>
<?php

// Set the last group to display if not export all
if ($Page->ExportAll && $Page->Export <> "") {
	$Page->StopGrp = $Page->TotalGrps;
} else {
	$Page->StopGrp = $Page->StartGrp + $Page->DisplayGrps - 1;
}

// Stop group <= total number of groups
if (intval($Page->StopGrp) > intval($Page->TotalGrps))
	$Page->StopGrp = $Page->TotalGrps;
$Page->RecCount = 0;
$Page->RecIndex = 0;

// Get first row
if ($Page->TotalGrps > 0) {
	$Page->GetRow(1);
	$Page->GrpCount = 1;
}
$Page->GrpIdx = ewr_InitArray(2, -1);
$Page->GrpIdx[0] = -1;
$Page->GrpIdx[1] = $Page->StopGrp - $Page->StartGrp + 1;
while ($rs && !$rs->EOF && $Page->GrpCount <= $Page->DisplayGrps || $Page->ShowHeader) {

	// Show dummy header for custom template
	// Show header

	if ($Page->ShowHeader) {
?>
<?php if ($Page->Export <> "pdf") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<thead>
	<!-- Table header -->
	<tr class="ewTableHeader">
<?php if ($Page->Numero_factura->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Numero_factura"><div class="Hospitalizacion_Numero_factura"><span class="ewTableHeaderCaption"><?php echo $Page->Numero_factura->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Numero_factura">
<?php if ($Page->SortUrl($Page->Numero_factura) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Numero_factura">
			<span class="ewTableHeaderCaption"><?php echo $Page->Numero_factura->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Numero_factura" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Numero_factura) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Numero_factura->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Numero_factura->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Numero_factura->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Codigo_prestador->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Codigo_prestador"><div class="Hospitalizacion_Codigo_prestador"><span class="ewTableHeaderCaption"><?php echo $Page->Codigo_prestador->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Codigo_prestador">
<?php if ($Page->SortUrl($Page->Codigo_prestador) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Codigo_prestador">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_prestador->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Codigo_prestador" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Codigo_prestador) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_prestador->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Codigo_prestador->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Codigo_prestador->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Tipo_id->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Tipo_id"><div class="Hospitalizacion_Tipo_id"><span class="ewTableHeaderCaption"><?php echo $Page->Tipo_id->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Tipo_id">
<?php if ($Page->SortUrl($Page->Tipo_id) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Tipo_id">
			<span class="ewTableHeaderCaption"><?php echo $Page->Tipo_id->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Tipo_id" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Tipo_id) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Tipo_id->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Tipo_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Tipo_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Numero_id->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Numero_id"><div class="Hospitalizacion_Numero_id"><span class="ewTableHeaderCaption"><?php echo $Page->Numero_id->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Numero_id">
<?php if ($Page->SortUrl($Page->Numero_id) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Numero_id">
			<span class="ewTableHeaderCaption"><?php echo $Page->Numero_id->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Numero_id" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Numero_id) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Numero_id->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Numero_id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Numero_id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Via_ingreso_ins->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Via_ingreso_ins"><div class="Hospitalizacion_Via_ingreso_ins"><span class="ewTableHeaderCaption"><?php echo $Page->Via_ingreso_ins->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Via_ingreso_ins">
<?php if ($Page->SortUrl($Page->Via_ingreso_ins) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Via_ingreso_ins">
			<span class="ewTableHeaderCaption"><?php echo $Page->Via_ingreso_ins->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Via_ingreso_ins" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Via_ingreso_ins) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Via_ingreso_ins->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Via_ingreso_ins->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Via_ingreso_ins->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Fecha_ingreso_usuario->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Fecha_ingreso_usuario"><div class="Hospitalizacion_Fecha_ingreso_usuario"><span class="ewTableHeaderCaption"><?php echo $Page->Fecha_ingreso_usuario->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Fecha_ingreso_usuario">
<?php if ($Page->SortUrl($Page->Fecha_ingreso_usuario) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Fecha_ingreso_usuario">
			<span class="ewTableHeaderCaption"><?php echo $Page->Fecha_ingreso_usuario->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Fecha_ingreso_usuario" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Fecha_ingreso_usuario) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Fecha_ingreso_usuario->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Fecha_ingreso_usuario->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Fecha_ingreso_usuario->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Hora_ingreso->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Hora_ingreso"><div class="Hospitalizacion_Hora_ingreso"><span class="ewTableHeaderCaption"><?php echo $Page->Hora_ingreso->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Hora_ingreso">
<?php if ($Page->SortUrl($Page->Hora_ingreso) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Hora_ingreso">
			<span class="ewTableHeaderCaption"><?php echo $Page->Hora_ingreso->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Hora_ingreso" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Hora_ingreso) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Hora_ingreso->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Hora_ingreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Hora_ingreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Numero_autorizacion->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Numero_autorizacion"><div class="Hospitalizacion_Numero_autorizacion"><span class="ewTableHeaderCaption"><?php echo $Page->Numero_autorizacion->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Numero_autorizacion">
<?php if ($Page->SortUrl($Page->Numero_autorizacion) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Numero_autorizacion">
			<span class="ewTableHeaderCaption"><?php echo $Page->Numero_autorizacion->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Numero_autorizacion" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Numero_autorizacion) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Numero_autorizacion->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Numero_autorizacion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Numero_autorizacion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Causa_externa->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Causa_externa"><div class="Hospitalizacion_Causa_externa"><span class="ewTableHeaderCaption"><?php echo $Page->Causa_externa->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Causa_externa">
<?php if ($Page->SortUrl($Page->Causa_externa) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Causa_externa">
			<span class="ewTableHeaderCaption"><?php echo $Page->Causa_externa->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Causa_externa" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Causa_externa) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Causa_externa->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Causa_externa->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Causa_externa->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Diagnostico_principal_ingreso->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Diagnostico_principal_ingreso"><div class="Hospitalizacion_Diagnostico_principal_ingreso"><span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_principal_ingreso->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Diagnostico_principal_ingreso">
<?php if ($Page->SortUrl($Page->Diagnostico_principal_ingreso) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Diagnostico_principal_ingreso">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_principal_ingreso->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Diagnostico_principal_ingreso" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Diagnostico_principal_ingreso) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_principal_ingreso->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Diagnostico_principal_ingreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Diagnostico_principal_ingreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Diagnostico_principal_egreso->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Diagnostico_principal_egreso"><div class="Hospitalizacion_Diagnostico_principal_egreso"><span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_principal_egreso->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Diagnostico_principal_egreso">
<?php if ($Page->SortUrl($Page->Diagnostico_principal_egreso) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Diagnostico_principal_egreso">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_principal_egreso->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Diagnostico_principal_egreso" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Diagnostico_principal_egreso) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_principal_egreso->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Diagnostico_principal_egreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Diagnostico_principal_egreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Diagnostico_rel_1->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Diagnostico_rel_1"><div class="Hospitalizacion_Diagnostico_rel_1"><span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_rel_1->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Diagnostico_rel_1">
<?php if ($Page->SortUrl($Page->Diagnostico_rel_1) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Diagnostico_rel_1">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_rel_1->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Diagnostico_rel_1" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Diagnostico_rel_1) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_rel_1->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Diagnostico_rel_1->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Diagnostico_rel_1->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Diagnostico_rel_2->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Diagnostico_rel_2"><div class="Hospitalizacion_Diagnostico_rel_2"><span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_rel_2->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Diagnostico_rel_2">
<?php if ($Page->SortUrl($Page->Diagnostico_rel_2) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Diagnostico_rel_2">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_rel_2->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Diagnostico_rel_2" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Diagnostico_rel_2) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_rel_2->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Diagnostico_rel_2->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Diagnostico_rel_2->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Diagnostico_rel_3->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Diagnostico_rel_3"><div class="Hospitalizacion_Diagnostico_rel_3"><span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_rel_3->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Diagnostico_rel_3">
<?php if ($Page->SortUrl($Page->Diagnostico_rel_3) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Diagnostico_rel_3">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_rel_3->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Diagnostico_rel_3" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Diagnostico_rel_3) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_rel_3->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Diagnostico_rel_3->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Diagnostico_rel_3->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Diagnostico_complicacion->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Diagnostico_complicacion"><div class="Hospitalizacion_Diagnostico_complicacion"><span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_complicacion->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Diagnostico_complicacion">
<?php if ($Page->SortUrl($Page->Diagnostico_complicacion) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Diagnostico_complicacion">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_complicacion->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Diagnostico_complicacion" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Diagnostico_complicacion) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_complicacion->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Diagnostico_complicacion->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Diagnostico_complicacion->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Estado_salida->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Estado_salida"><div class="Hospitalizacion_Estado_salida"><span class="ewTableHeaderCaption"><?php echo $Page->Estado_salida->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Estado_salida">
<?php if ($Page->SortUrl($Page->Estado_salida) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Estado_salida">
			<span class="ewTableHeaderCaption"><?php echo $Page->Estado_salida->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Estado_salida" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Estado_salida) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Estado_salida->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Estado_salida->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Estado_salida->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Diagnostico_causa_muerte->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Diagnostico_causa_muerte"><div class="Hospitalizacion_Diagnostico_causa_muerte"><span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_causa_muerte->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Diagnostico_causa_muerte">
<?php if ($Page->SortUrl($Page->Diagnostico_causa_muerte) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Diagnostico_causa_muerte">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_causa_muerte->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Diagnostico_causa_muerte" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Diagnostico_causa_muerte) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Diagnostico_causa_muerte->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Diagnostico_causa_muerte->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Diagnostico_causa_muerte->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Fecha_egreso->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Fecha_egreso"><div class="Hospitalizacion_Fecha_egreso"><span class="ewTableHeaderCaption"><?php echo $Page->Fecha_egreso->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Fecha_egreso">
<?php if ($Page->SortUrl($Page->Fecha_egreso) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Fecha_egreso">
			<span class="ewTableHeaderCaption"><?php echo $Page->Fecha_egreso->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Fecha_egreso" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Fecha_egreso) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Fecha_egreso->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Fecha_egreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Fecha_egreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Hora__egreso->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Hora__egreso"><div class="Hospitalizacion_Hora__egreso"><span class="ewTableHeaderCaption"><?php echo $Page->Hora__egreso->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Hora__egreso">
<?php if ($Page->SortUrl($Page->Hora__egreso) == "") { ?>
		<div class="ewTableHeaderBtn Hospitalizacion_Hora__egreso">
			<span class="ewTableHeaderCaption"><?php echo $Page->Hora__egreso->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Hospitalizacion_Hora__egreso" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Hora__egreso) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Hora__egreso->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Hora__egreso->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Hora__egreso->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
	</tr>
</thead>
<tbody>
<?php
		if ($Page->TotalGrps == 0) break; // Show header only
		$Page->ShowHeader = FALSE;
	}
	$Page->RecCount++;
	$Page->RecIndex++;

		// Render detail row
		$Page->ResetAttrs();
		$Page->RowType = EWR_ROWTYPE_DETAIL;
		$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->Numero_factura->Visible) { ?>
		<td data-field="Numero_factura"<?php echo $Page->Numero_factura->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Numero_factura"<?php echo $Page->Numero_factura->ViewAttributes() ?>><?php echo $Page->Numero_factura->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Codigo_prestador->Visible) { ?>
		<td data-field="Codigo_prestador"<?php echo $Page->Codigo_prestador->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Codigo_prestador"<?php echo $Page->Codigo_prestador->ViewAttributes() ?>><?php echo $Page->Codigo_prestador->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Tipo_id->Visible) { ?>
		<td data-field="Tipo_id"<?php echo $Page->Tipo_id->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Tipo_id"<?php echo $Page->Tipo_id->ViewAttributes() ?>><?php echo $Page->Tipo_id->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Numero_id->Visible) { ?>
		<td data-field="Numero_id"<?php echo $Page->Numero_id->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Numero_id"<?php echo $Page->Numero_id->ViewAttributes() ?>><?php echo $Page->Numero_id->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Via_ingreso_ins->Visible) { ?>
		<td data-field="Via_ingreso_ins"<?php echo $Page->Via_ingreso_ins->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Via_ingreso_ins"<?php echo $Page->Via_ingreso_ins->ViewAttributes() ?>><?php echo $Page->Via_ingreso_ins->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Fecha_ingreso_usuario->Visible) { ?>
		<td data-field="Fecha_ingreso_usuario"<?php echo $Page->Fecha_ingreso_usuario->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Fecha_ingreso_usuario"<?php echo $Page->Fecha_ingreso_usuario->ViewAttributes() ?>><?php echo $Page->Fecha_ingreso_usuario->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Hora_ingreso->Visible) { ?>
		<td data-field="Hora_ingreso"<?php echo $Page->Hora_ingreso->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Hora_ingreso"<?php echo $Page->Hora_ingreso->ViewAttributes() ?>><?php echo $Page->Hora_ingreso->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Numero_autorizacion->Visible) { ?>
		<td data-field="Numero_autorizacion"<?php echo $Page->Numero_autorizacion->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Numero_autorizacion"<?php echo $Page->Numero_autorizacion->ViewAttributes() ?>><?php echo $Page->Numero_autorizacion->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Causa_externa->Visible) { ?>
		<td data-field="Causa_externa"<?php echo $Page->Causa_externa->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Causa_externa"<?php echo $Page->Causa_externa->ViewAttributes() ?>><?php echo $Page->Causa_externa->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Diagnostico_principal_ingreso->Visible) { ?>
		<td data-field="Diagnostico_principal_ingreso"<?php echo $Page->Diagnostico_principal_ingreso->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Diagnostico_principal_ingreso"<?php echo $Page->Diagnostico_principal_ingreso->ViewAttributes() ?>><?php echo $Page->Diagnostico_principal_ingreso->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Diagnostico_principal_egreso->Visible) { ?>
		<td data-field="Diagnostico_principal_egreso"<?php echo $Page->Diagnostico_principal_egreso->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Diagnostico_principal_egreso"<?php echo $Page->Diagnostico_principal_egreso->ViewAttributes() ?>><?php echo $Page->Diagnostico_principal_egreso->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Diagnostico_rel_1->Visible) { ?>
		<td data-field="Diagnostico_rel_1"<?php echo $Page->Diagnostico_rel_1->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Diagnostico_rel_1"<?php echo $Page->Diagnostico_rel_1->ViewAttributes() ?>><?php echo $Page->Diagnostico_rel_1->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Diagnostico_rel_2->Visible) { ?>
		<td data-field="Diagnostico_rel_2"<?php echo $Page->Diagnostico_rel_2->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Diagnostico_rel_2"<?php echo $Page->Diagnostico_rel_2->ViewAttributes() ?>><?php echo $Page->Diagnostico_rel_2->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Diagnostico_rel_3->Visible) { ?>
		<td data-field="Diagnostico_rel_3"<?php echo $Page->Diagnostico_rel_3->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Diagnostico_rel_3"<?php echo $Page->Diagnostico_rel_3->ViewAttributes() ?>><?php echo $Page->Diagnostico_rel_3->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Diagnostico_complicacion->Visible) { ?>
		<td data-field="Diagnostico_complicacion"<?php echo $Page->Diagnostico_complicacion->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Diagnostico_complicacion"<?php echo $Page->Diagnostico_complicacion->ViewAttributes() ?>><?php echo $Page->Diagnostico_complicacion->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Estado_salida->Visible) { ?>
		<td data-field="Estado_salida"<?php echo $Page->Estado_salida->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Estado_salida"<?php echo $Page->Estado_salida->ViewAttributes() ?>><?php echo $Page->Estado_salida->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Diagnostico_causa_muerte->Visible) { ?>
		<td data-field="Diagnostico_causa_muerte"<?php echo $Page->Diagnostico_causa_muerte->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Diagnostico_causa_muerte"<?php echo $Page->Diagnostico_causa_muerte->ViewAttributes() ?>><?php echo $Page->Diagnostico_causa_muerte->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Fecha_egreso->Visible) { ?>
		<td data-field="Fecha_egreso"<?php echo $Page->Fecha_egreso->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Fecha_egreso"<?php echo $Page->Fecha_egreso->ViewAttributes() ?>><?php echo $Page->Fecha_egreso->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Hora__egreso->Visible) { ?>
		<td data-field="Hora__egreso"<?php echo $Page->Hora__egreso->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Hospitalizacion_Hora__egreso"<?php echo $Page->Hora__egreso->ViewAttributes() ?>><?php echo $Page->Hora__egreso->ListViewValue() ?></span></td>
<?php } ?>
	</tr>
<?php

		// Accumulate page summary
		$Page->AccumulateSummary();

		// Get next record
		$Page->GetRow(2);
	$Page->GrpCount++;
} // End while
?>
<?php if ($Page->TotalGrps > 0) { ?>
</tbody>
<tfoot>
	</tfoot>
<?php } elseif (!$Page->ShowHeader) { // No header displayed ?>
<?php if ($Page->Export <> "pdf") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<?php } ?>
</table>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export == "" && !($Page->DrillDown && $Page->TotalGrps > 0)) { ?>
<div class="ewGridLowerPanel">
<?php include "Hospitalizacionrptpager.php" ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<!-- Summary Report Ends -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- center container - report (end) -->
	<!-- right container (begin) -->
	<div id="ewRight" class="ewRight">
<?php } ?>
	<!-- Right slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- right container (end) -->
<div class="clearfix"></div>
<!-- bottom container (begin) -->
<div id="ewBottom" class="ewBottom">
<?php } ?>
	<!-- Bottom slot -->
<?php if ($Page->Export == "") { ?>
	</div>
<!-- Bottom Container (End) -->
</div>
<!-- Table Container (End) -->
<?php } ?>
<?php $Page->ShowPageFooter(); ?>
<?php if (EWR_DEBUG_ENABLED) echo ewr_DebugMsg(); ?>
<?php

// Close recordsets
if ($rsgrp) $rsgrp->Close();
if ($rs) $rs->Close();
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "phprptinc/footer.php" ?>
<?php
$Page->Page_Terminate();
if (isset($OldPage)) $Page = $OldPage;
?>
