<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start();
?>
<?php include_once "phprptinc/ewrcfg8.php" ?>
<?php include_once "phprptinc/ewmysql.php" ?>
<?php include_once "phprptinc/ewrfn8.php" ?>
<?php include_once "phprptinc/ewrusrfn8.php" ?>
<?php include_once "Usuariorptinfo.php" ?>
<?php

//
// Page class
//

$Usuario_rpt = NULL; // Initialize page object first

class crUsuario_rpt extends crUsuario {

	// Page ID
	var $PageID = 'rpt';

	// Project ID
	var $ProjectID = "{84B0927F-5257-4D61-BA82-F177D7F30F4F}";

	// Page object name
	var $PageObjName = 'Usuario_rpt';

	// Page name
	function PageName() {
		return ewr_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ewr_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Export URLs
	var $ExportPrintUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportPdfUrl;
	var $ReportTableClass;
	var $ReportTableStyle = "";

	// Custom export
	var $ExportPrintCustom = FALSE;
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Message
	function getMessage() {
		return @$_SESSION[EWR_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EWR_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EWR_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EWR_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_WARNING_MESSAGE], $v);
	}

		// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EWR_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EWR_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EWR_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EWR_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog ewDisplayTable\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") // Header exists, display
			echo $sHeader;
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") // Fotoer exists, display
			echo $sFooter;
	}

	// Validate page request
	function IsPageRequest() {
		if ($this->UseTokenInUrl) {
			if (ewr_IsHttpPost())
				return ($this->TableVar == @$_POST("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == @$_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $CheckToken = EWR_CHECK_TOKEN;
	var $CheckTokenFn = "ewr_CheckToken";
	var $CreateTokenFn = "ewr_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ewr_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EWR_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EWR_TOKEN_NAME]);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $ReportLanguage;

		// Language object
		$ReportLanguage = new crLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (Usuario)
		if (!isset($GLOBALS["Usuario"])) {
			$GLOBALS["Usuario"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["Usuario"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";

		// Page ID
		if (!defined("EWR_PAGE_ID"))
			define("EWR_PAGE_ID", 'rpt', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EWR_TABLE_NAME"))
			define("EWR_TABLE_NAME", 'Usuario', TRUE);

		// Start timer
		$GLOBALS["gsTimer"] = new crTimer();

		// Open connection
		$conn = ewr_Connect();

		// Export options
		$this->ExportOptions = new crListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Search options
		$this->SearchOptions = new crListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Filter options
		$this->FilterOptions = new crListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fUsuariorpt";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $gsEmailContentType, $ReportLanguage, $Security;
		global $gsCustomExport;

		// Get export parameters
		if (@$_GET["export"] <> "")
			$this->Export = strtolower($_GET["export"]);
		elseif (@$_POST["export"] <> "")
			$this->Export = strtolower($_POST["export"]);
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$gsEmailContentType = @$_POST["contenttype"]; // Get email content type

		// Setup placeholder
		// Setup export options

		$this->SetupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $ReportLanguage->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	// Set up export options
	function SetupExportOptions() {
		global $ReportLanguage;
		$exportid = session_id();

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->Phrase("ExportToWord") . "</a>";

		//$item->Visible = TRUE;
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Uncomment codes below to show export to Pdf link
//		$item->Visible = TRUE;
		// Export to Email

		$item = &$this->ExportOptions->Add("email");
		$url = $this->PageUrl() . "export=email";
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" id=\"emf_Usuario\" href=\"javascript:void(0);\" onclick=\"ewr_EmailDialogShow({lnk:'emf_Usuario',hdr:ewLanguage.Phrase('ExportToEmail'),url:'$url',exportid:'$exportid',el:this});\">" . $ReportLanguage->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter panel button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"fUsuariorpt\">" . $ReportLanguage->Phrase("SearchBtn") . "</button>";
		$item->Visible = FALSE;

		// Reset filter
		$item = &$this->SearchOptions->Add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . ewr_CurrentPage() . "?cmd=reset'\">" . $ReportLanguage->Phrase("ResetAllFilter") . "</button>";
		$item->Visible = FALSE;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fUsuariorpt\" href=\"#\">" . $ReportLanguage->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fUsuariorpt\" href=\"#\">" . $ReportLanguage->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up options (extended)
		$this->SetupExportOptionsExt();

		// Hide options for export
		if ($this->Export <> "") {
			$this->ExportOptions->HideAllOptions();
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Set up table class
		if ($this->Export == "word" || $this->Export == "excel" || $this->Export == "pdf")
			$this->ReportTableClass = "ewTable";
		else
			$this->ReportTableClass = "table ewTable";
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn, $ReportLanguage, $EWR_EXPORT, $gsExportFile;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->Export <> "" && array_key_exists($this->Export, $EWR_EXPORT)) {
			$sContent = ob_get_contents();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $sContent, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$sContent = str_replace($divmatch[0], '', $sContent);
				}
			}
			$fn = $EWR_EXPORT[$this->Export];
			if ($this->Export == "email") { // Email
				ob_end_clean();
				echo $this->$fn($sContent);
				$conn->Close(); // Close connection
				exit();
			} else {
				$this->$fn($sContent);
			}
		}

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EWR_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Initialize common variables
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $FilterOptions; // Filter options

	// Paging variables
	var $RecIndex = 0; // Record index
	var $RecCount = 0; // Record count
	var $StartGrp = 0; // Start group
	var $StopGrp = 0; // Stop group
	var $TotalGrps = 0; // Total groups
	var $GrpCount = 0; // Group count
	var $GrpCounter = array(); // Group counter
	var $DisplayGrps = 30; // Groups per page
	var $GrpRange = 10;
	var $Sort = "";
	var $Filter = "";
	var $PageFirstGroupFilter = "";
	var $UserIDFilter = "";
	var $DrillDown = FALSE;
	var $DrillDownInPanel = FALSE;
	var $DrillDownList = "";

	// Clear field for ext filter
	var $ClearExtFilter = "";
	var $PopupName = "";
	var $PopupValue = "";
	var $FilterApplied;
	var $SearchCommand = FALSE;
	var $ShowHeader;
	var $GrpFldCount = 0;
	var $SubGrpFldCount = 0;
	var $DtlFldCount = 0;
	var $Cnt, $Col, $Val, $Smry, $Mn, $Mx, $GrandCnt, $GrandSmry, $GrandMn, $GrandMx;
	var $TotCount;
	var $GrandSummarySetup = FALSE;
	var $GrpIdx;

	//
	// Page main
	//
	function Page_Main() {
		global $rs;
		global $rsgrp;
		global $gsFormError;
		global $gbDrillDownInPanel;
		global $ReportBreadcrumb;

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$nDtls = 15;
		$nGrps = 1;
		$this->Val = &ewr_InitArray($nDtls, 0);
		$this->Cnt = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Smry = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Mn = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->Mx = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->GrandCnt = &ewr_InitArray($nDtls, 0);
		$this->GrandSmry = &ewr_InitArray($nDtls, 0);
		$this->GrandMn = &ewr_InitArray($nDtls, NULL);
		$this->GrandMx = &ewr_InitArray($nDtls, NULL);

		// Set up array if accumulation required: array(Accum, SkipNullOrZero)
		$this->Col = array(array(FALSE, FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE));

		// Set up groups per page dynamically
		$this->SetUpDisplayGrps();

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->SetupPopup();

		// Load group db values if necessary
		$this->LoadGroupDbValues();

		// Handle Ajax popup
		$this->ProcessAjaxPopup();

		// Extended filter
		$sExtendedFilter = "";

		// Build popup filter
		$sPopupFilter = $this->GetPopupFilter();

		//ewr_SetDebugMsg("popup filter: " . $sPopupFilter);
		ewr_AddFilter($this->Filter, $sPopupFilter);

		// No filter
		$this->FilterApplied = FALSE;
		$this->FilterOptions->GetItem("savecurrentfilter")->Visible = FALSE;
		$this->FilterOptions->GetItem("deletefilter")->Visible = FALSE;

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);
		$this->SearchOptions->GetItem("resetfilter")->Visible = $this->FilterApplied;

		// Get sort
		$this->Sort = $this->GetSort();

		// Get total count
		$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $this->Filter, $this->Sort);
		$this->TotalGrps = $this->GetCnt($sSql);
		if ($this->DisplayGrps <= 0 || $this->DrillDown) // Display all groups
			$this->DisplayGrps = $this->TotalGrps;
		$this->StartGrp = 1;

		// Show header
		$this->ShowHeader = ($this->TotalGrps > 0);

		// Set up start position if not export all
		if ($this->ExportAll && $this->Export <> "")
		    $this->DisplayGrps = $this->TotalGrps;
		else
			$this->SetUpStartGroup(); 

		// Hide export options if export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();

		// Hide search/filter options if export/drilldown
		if ($this->Export <> "" || $this->DrillDown) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Get current page records
		$rs = $this->GetRs($sSql, $this->StartGrp, $this->DisplayGrps);
		$this->SetupFieldCount();
	}

	// Accummulate summary
	function AccumulateSummary() {
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Col[$iy][0]) { // Accumulate required
					$valwrk = $this->Val[$iy];
					if (is_null($valwrk)) {
						if (!$this->Col[$iy][1])
							$this->Cnt[$ix][$iy]++;
					} else {
						$accum = (!$this->Col[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Cnt[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Smry[$ix][$iy] += $valwrk;
								if (is_null($this->Mn[$ix][$iy])) {
									$this->Mn[$ix][$iy] = $valwrk;
									$this->Mx[$ix][$iy] = $valwrk;
								} else {
									if ($this->Mn[$ix][$iy] > $valwrk) $this->Mn[$ix][$iy] = $valwrk;
									if ($this->Mx[$ix][$iy] < $valwrk) $this->Mx[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0]++;
		}
	}

	// Reset level summary
	function ResetLevelSummary($lvl) {

		// Clear summary values
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Cnt[$ix][$iy] = 0;
				if ($this->Col[$iy][0]) {
					$this->Smry[$ix][$iy] = 0;
					$this->Mn[$ix][$iy] = NULL;
					$this->Mx[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0] = 0;
		}

		// Reset record count
		$this->RecCount = 0;
	}

	// Accummulate grand summary
	function AccumulateGrandSummary() {
		$this->TotCount++;
		$cntgs = count($this->GrandSmry);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Col[$iy][0]) {
				$valwrk = $this->Val[$iy];
				if (is_null($valwrk) || !is_numeric($valwrk)) {
					if (!$this->Col[$iy][1])
						$this->GrandCnt[$iy]++;
				} else {
					if (!$this->Col[$iy][1] || $valwrk <> 0) {
						$this->GrandCnt[$iy]++;
						$this->GrandSmry[$iy] += $valwrk;
						if (is_null($this->GrandMn[$iy])) {
							$this->GrandMn[$iy] = $valwrk;
							$this->GrandMx[$iy] = $valwrk;
						} else {
							if ($this->GrandMn[$iy] > $valwrk) $this->GrandMn[$iy] = $valwrk;
							if ($this->GrandMx[$iy] < $valwrk) $this->GrandMx[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Get count
	function GetCnt($sql) {
		global $conn;
		$rscnt = $conn->Execute($sql);
		$cnt = ($rscnt) ? $rscnt->RecordCount() : 0;
		if ($rscnt) $rscnt->Close();
		return $cnt;
	}

	// Get recordset
	function GetRs($wrksql, $start, $grps) {
		global $conn;
		$conn->raiseErrorFn = $GLOBALS["EWR_ERROR_FN"];
		$rswrk = $conn->SelectLimit($wrksql, $grps, $start - 1);
		$conn->raiseErrorFn = '';
		return $rswrk;
	}

	// Get row values
	function GetRow($opt) {
		global $rs;
		if (!$rs)
			return;
		if ($opt == 1) { // Get first row

	//		$rs->MoveFirst(); // NOTE: no need to move position
				$this->FirstRowData = array();
				$this->FirstRowData['Tipo_doc'] = ewr_Conv($rs->fields('Tipo_doc'),200);
				$this->FirstRowData['Documento'] = ewr_Conv($rs->fields('Documento'),200);
				$this->FirstRowData['Codigo_eps'] = ewr_Conv($rs->fields('Codigo_eps'),200);
				$this->FirstRowData['Tipo_Usuario'] = ewr_Conv($rs->fields('Tipo_Usuario'),3);
				$this->FirstRowData['Primer_ap'] = ewr_Conv($rs->fields('Primer_ap'),200);
				$this->FirstRowData['Segundo_ap'] = ewr_Conv($rs->fields('Segundo_ap'),200);
				$this->FirstRowData['Primer_nom'] = ewr_Conv($rs->fields('Primer_nom'),200);
				$this->FirstRowData['Segundo_nom'] = ewr_Conv($rs->fields('Segundo_nom'),200);
				$this->FirstRowData['Edad'] = ewr_Conv($rs->fields('Edad'),3);
				$this->FirstRowData['Unidad_edad'] = ewr_Conv($rs->fields('Unidad_edad'),3);
				$this->FirstRowData['Sexo'] = ewr_Conv($rs->fields('Sexo'),200);
				$this->FirstRowData['Codigo_dpto'] = ewr_Conv($rs->fields('Codigo_dpto'),3);
				$this->FirstRowData['Cod_municipio'] = ewr_Conv($rs->fields('Cod_municipio'),3);
				$this->FirstRowData['Zona_residencia'] = ewr_Conv($rs->fields('Zona_residencia'),200);
		} else { // Get next row
			$rs->MoveNext();
		}
		if (!$rs->EOF) {
			$this->Tipo_doc->setDbValue($rs->fields('Tipo_doc'));
			$this->Documento->setDbValue($rs->fields('Documento'));
			$this->Codigo_eps->setDbValue($rs->fields('Codigo_eps'));
			$this->Tipo_Usuario->setDbValue($rs->fields('Tipo_Usuario'));
			$this->Primer_ap->setDbValue($rs->fields('Primer_ap'));
			$this->Segundo_ap->setDbValue($rs->fields('Segundo_ap'));
			$this->Primer_nom->setDbValue($rs->fields('Primer_nom'));
			$this->Segundo_nom->setDbValue($rs->fields('Segundo_nom'));
			$this->Edad->setDbValue($rs->fields('Edad'));
			$this->Unidad_edad->setDbValue($rs->fields('Unidad_edad'));
			$this->Sexo->setDbValue($rs->fields('Sexo'));
			$this->Codigo_dpto->setDbValue($rs->fields('Codigo_dpto'));
			$this->Cod_municipio->setDbValue($rs->fields('Cod_municipio'));
			$this->Zona_residencia->setDbValue($rs->fields('Zona_residencia'));
			$this->Val[1] = $this->Tipo_doc->CurrentValue;
			$this->Val[2] = $this->Documento->CurrentValue;
			$this->Val[3] = $this->Codigo_eps->CurrentValue;
			$this->Val[4] = $this->Tipo_Usuario->CurrentValue;
			$this->Val[5] = $this->Primer_ap->CurrentValue;
			$this->Val[6] = $this->Segundo_ap->CurrentValue;
			$this->Val[7] = $this->Primer_nom->CurrentValue;
			$this->Val[8] = $this->Segundo_nom->CurrentValue;
			$this->Val[9] = $this->Edad->CurrentValue;
			$this->Val[10] = $this->Unidad_edad->CurrentValue;
			$this->Val[11] = $this->Sexo->CurrentValue;
			$this->Val[12] = $this->Codigo_dpto->CurrentValue;
			$this->Val[13] = $this->Cod_municipio->CurrentValue;
			$this->Val[14] = $this->Zona_residencia->CurrentValue;
		} else {
			$this->Tipo_doc->setDbValue("");
			$this->Documento->setDbValue("");
			$this->Codigo_eps->setDbValue("");
			$this->Tipo_Usuario->setDbValue("");
			$this->Primer_ap->setDbValue("");
			$this->Segundo_ap->setDbValue("");
			$this->Primer_nom->setDbValue("");
			$this->Segundo_nom->setDbValue("");
			$this->Edad->setDbValue("");
			$this->Unidad_edad->setDbValue("");
			$this->Sexo->setDbValue("");
			$this->Codigo_dpto->setDbValue("");
			$this->Cod_municipio->setDbValue("");
			$this->Zona_residencia->setDbValue("");
		}
	}

	//  Set up starting group
	function SetUpStartGroup() {

		// Exit if no groups
		if ($this->DisplayGrps == 0)
			return;

		// Check for a 'start' parameter
		if (@$_GET[EWR_TABLE_START_GROUP] != "") {
			$this->StartGrp = $_GET[EWR_TABLE_START_GROUP];
			$this->setStartGroup($this->StartGrp);
		} elseif (@$_GET["pageno"] != "") {
			$nPageNo = $_GET["pageno"];
			if (is_numeric($nPageNo)) {
				$this->StartGrp = ($nPageNo-1)*$this->DisplayGrps+1;
				if ($this->StartGrp <= 0) {
					$this->StartGrp = 1;
				} elseif ($this->StartGrp >= intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1) {
					$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1;
				}
				$this->setStartGroup($this->StartGrp);
			} else {
				$this->StartGrp = $this->getStartGroup();
			}
		} else {
			$this->StartGrp = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGrp) || $this->StartGrp == "") { // Avoid invalid start group counter
			$this->StartGrp = 1; // Reset start group counter
			$this->setStartGroup($this->StartGrp);
		} elseif (intval($this->StartGrp) > intval($this->TotalGrps)) { // Avoid starting group > total groups
			$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to last page first group
			$this->setStartGroup($this->StartGrp);
		} elseif (($this->StartGrp-1) % $this->DisplayGrps <> 0) {
			$this->StartGrp = intval(($this->StartGrp-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to page boundary
			$this->setStartGroup($this->StartGrp);
		}
	}

	// Load group db values if necessary
	function LoadGroupDbValues() {
		global $conn;
	}

	// Process Ajax popup
	function ProcessAjaxPopup() {
		global $conn, $ReportLanguage;
		$fld = NULL;
		if (@$_GET["popup"] <> "") {
			$popupname = $_GET["popup"];

			// Check popup name
			// Output data as Json

			if (!is_null($fld)) {
				$jsdb = ewr_GetJsDb($fld, $fld->FldType);
				ob_end_clean();
				echo $jsdb;
				exit();
			}
		}
	}

	// Set up popup
	function SetupPopup() {
		global $conn, $ReportLanguage;
		if ($this->DrillDown)
			return;

		// Process post back form
		if (ewr_IsHttpPost()) {
			$sName = @$_POST["popup"]; // Get popup form name
			if ($sName <> "") {
				$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
				if ($cntValues > 0) {
					$arValues = ewr_StripSlashes($_POST["sel_$sName"]);
					if (trim($arValues[0]) == "") // Select all
						$arValues = EWR_INIT_VALUE;
					$_SESSION["sel_$sName"] = $arValues;
					$_SESSION["rf_$sName"] = ewr_StripSlashes(@$_POST["rf_$sName"]);
					$_SESSION["rt_$sName"] = ewr_StripSlashes(@$_POST["rt_$sName"]);
					$this->ResetPager();
				}
			}

		// Get 'reset' command
		} elseif (@$_GET["cmd"] <> "") {
			$sCmd = $_GET["cmd"];
			if (strtolower($sCmd) == "reset") {
				$this->ResetPager();
			}
		}

		// Load selection criteria to array
	}

	// Reset pager
	function ResetPager() {

		// Reset start position (reset command)
		$this->StartGrp = 1;
		$this->setStartGroup($this->StartGrp);
	}

	// Set up number of groups displayed per page
	function SetUpDisplayGrps() {
		$sWrk = @$_GET[EWR_TABLE_GROUP_PER_PAGE];
		if ($sWrk <> "") {
			if (is_numeric($sWrk)) {
				$this->DisplayGrps = intval($sWrk);
			} else {
				if (strtoupper($sWrk) == "ALL") { // Display all groups
					$this->DisplayGrps = -1;
				} else {
					$this->DisplayGrps = 30; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGrps); // Save to session

			// Reset start position (reset command)
			$this->StartGrp = 1;
			$this->setStartGroup($this->StartGrp);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGrps = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGrps = 30; // Load default
			}
		}
	}

	// Render row
	function RenderRow() {
		global $conn, $rs, $Security, $ReportLanguage;
		if ($this->RowTotalType == EWR_ROWTOTAL_GRAND && !$this->GrandSummarySetup) { // Grand total
			$bGotCount = FALSE;
			$bGotSummary = FALSE;

			// Get total count from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->Execute($sSql);
			if ($rstot) {
				$this->TotCount = ($rstot->RecordCount()>1) ? $rstot->RecordCount() : $rstot->fields[0];
				$rstot->Close();
				$bGotCount = TRUE;
			} else {
				$this->TotCount = 0;
			}
		$bGotSummary = TRUE;

			// Accumulate grand summary from detail records
			if (!$bGotCount || !$bGotSummary) {
				$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$rs = $conn->Execute($sSql);
				if ($rs) {
					$this->GetRow(1);
					while (!$rs->EOF) {
						$this->AccumulateGrandSummary();
						$this->GetRow(2);
					}
					$rs->Close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();

		//
		// Render view codes
		//

		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row

			// Tipo_doc
			$this->Tipo_doc->HrefValue = "";

			// Documento
			$this->Documento->HrefValue = "";

			// Codigo_eps
			$this->Codigo_eps->HrefValue = "";

			// Tipo_Usuario
			$this->Tipo_Usuario->HrefValue = "";

			// Primer_ap
			$this->Primer_ap->HrefValue = "";

			// Segundo_ap
			$this->Segundo_ap->HrefValue = "";

			// Primer_nom
			$this->Primer_nom->HrefValue = "";

			// Segundo_nom
			$this->Segundo_nom->HrefValue = "";

			// Edad
			$this->Edad->HrefValue = "";

			// Unidad_edad
			$this->Unidad_edad->HrefValue = "";

			// Sexo
			$this->Sexo->HrefValue = "";

			// Codigo_dpto
			$this->Codigo_dpto->HrefValue = "";

			// Cod_municipio
			$this->Cod_municipio->HrefValue = "";

			// Zona_residencia
			$this->Zona_residencia->HrefValue = "";
		} else {

			// Tipo_doc
			$this->Tipo_doc->ViewValue = $this->Tipo_doc->CurrentValue;
			$this->Tipo_doc->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Documento
			$this->Documento->ViewValue = $this->Documento->CurrentValue;
			$this->Documento->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Codigo_eps
			$this->Codigo_eps->ViewValue = $this->Codigo_eps->CurrentValue;
			$this->Codigo_eps->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Tipo_Usuario
			$this->Tipo_Usuario->ViewValue = $this->Tipo_Usuario->CurrentValue;
			$this->Tipo_Usuario->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Primer_ap
			$this->Primer_ap->ViewValue = $this->Primer_ap->CurrentValue;
			$this->Primer_ap->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Segundo_ap
			$this->Segundo_ap->ViewValue = $this->Segundo_ap->CurrentValue;
			$this->Segundo_ap->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Primer_nom
			$this->Primer_nom->ViewValue = $this->Primer_nom->CurrentValue;
			$this->Primer_nom->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Segundo_nom
			$this->Segundo_nom->ViewValue = $this->Segundo_nom->CurrentValue;
			$this->Segundo_nom->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Edad
			$this->Edad->ViewValue = $this->Edad->CurrentValue;
			$this->Edad->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Unidad_edad
			$this->Unidad_edad->ViewValue = $this->Unidad_edad->CurrentValue;
			$this->Unidad_edad->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Sexo
			$this->Sexo->ViewValue = $this->Sexo->CurrentValue;
			$this->Sexo->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Codigo_dpto
			$this->Codigo_dpto->ViewValue = $this->Codigo_dpto->CurrentValue;
			$this->Codigo_dpto->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Cod_municipio
			$this->Cod_municipio->ViewValue = $this->Cod_municipio->CurrentValue;
			$this->Cod_municipio->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Zona_residencia
			$this->Zona_residencia->ViewValue = $this->Zona_residencia->CurrentValue;
			$this->Zona_residencia->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Tipo_doc
			$this->Tipo_doc->HrefValue = "";

			// Documento
			$this->Documento->HrefValue = "";

			// Codigo_eps
			$this->Codigo_eps->HrefValue = "";

			// Tipo_Usuario
			$this->Tipo_Usuario->HrefValue = "";

			// Primer_ap
			$this->Primer_ap->HrefValue = "";

			// Segundo_ap
			$this->Segundo_ap->HrefValue = "";

			// Primer_nom
			$this->Primer_nom->HrefValue = "";

			// Segundo_nom
			$this->Segundo_nom->HrefValue = "";

			// Edad
			$this->Edad->HrefValue = "";

			// Unidad_edad
			$this->Unidad_edad->HrefValue = "";

			// Sexo
			$this->Sexo->HrefValue = "";

			// Codigo_dpto
			$this->Codigo_dpto->HrefValue = "";

			// Cod_municipio
			$this->Cod_municipio->HrefValue = "";

			// Zona_residencia
			$this->Zona_residencia->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row
		} else {

			// Tipo_doc
			$CurrentValue = $this->Tipo_doc->CurrentValue;
			$ViewValue = &$this->Tipo_doc->ViewValue;
			$ViewAttrs = &$this->Tipo_doc->ViewAttrs;
			$CellAttrs = &$this->Tipo_doc->CellAttrs;
			$HrefValue = &$this->Tipo_doc->HrefValue;
			$LinkAttrs = &$this->Tipo_doc->LinkAttrs;
			$this->Cell_Rendered($this->Tipo_doc, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Documento
			$CurrentValue = $this->Documento->CurrentValue;
			$ViewValue = &$this->Documento->ViewValue;
			$ViewAttrs = &$this->Documento->ViewAttrs;
			$CellAttrs = &$this->Documento->CellAttrs;
			$HrefValue = &$this->Documento->HrefValue;
			$LinkAttrs = &$this->Documento->LinkAttrs;
			$this->Cell_Rendered($this->Documento, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Codigo_eps
			$CurrentValue = $this->Codigo_eps->CurrentValue;
			$ViewValue = &$this->Codigo_eps->ViewValue;
			$ViewAttrs = &$this->Codigo_eps->ViewAttrs;
			$CellAttrs = &$this->Codigo_eps->CellAttrs;
			$HrefValue = &$this->Codigo_eps->HrefValue;
			$LinkAttrs = &$this->Codigo_eps->LinkAttrs;
			$this->Cell_Rendered($this->Codigo_eps, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Tipo_Usuario
			$CurrentValue = $this->Tipo_Usuario->CurrentValue;
			$ViewValue = &$this->Tipo_Usuario->ViewValue;
			$ViewAttrs = &$this->Tipo_Usuario->ViewAttrs;
			$CellAttrs = &$this->Tipo_Usuario->CellAttrs;
			$HrefValue = &$this->Tipo_Usuario->HrefValue;
			$LinkAttrs = &$this->Tipo_Usuario->LinkAttrs;
			$this->Cell_Rendered($this->Tipo_Usuario, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Primer_ap
			$CurrentValue = $this->Primer_ap->CurrentValue;
			$ViewValue = &$this->Primer_ap->ViewValue;
			$ViewAttrs = &$this->Primer_ap->ViewAttrs;
			$CellAttrs = &$this->Primer_ap->CellAttrs;
			$HrefValue = &$this->Primer_ap->HrefValue;
			$LinkAttrs = &$this->Primer_ap->LinkAttrs;
			$this->Cell_Rendered($this->Primer_ap, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Segundo_ap
			$CurrentValue = $this->Segundo_ap->CurrentValue;
			$ViewValue = &$this->Segundo_ap->ViewValue;
			$ViewAttrs = &$this->Segundo_ap->ViewAttrs;
			$CellAttrs = &$this->Segundo_ap->CellAttrs;
			$HrefValue = &$this->Segundo_ap->HrefValue;
			$LinkAttrs = &$this->Segundo_ap->LinkAttrs;
			$this->Cell_Rendered($this->Segundo_ap, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Primer_nom
			$CurrentValue = $this->Primer_nom->CurrentValue;
			$ViewValue = &$this->Primer_nom->ViewValue;
			$ViewAttrs = &$this->Primer_nom->ViewAttrs;
			$CellAttrs = &$this->Primer_nom->CellAttrs;
			$HrefValue = &$this->Primer_nom->HrefValue;
			$LinkAttrs = &$this->Primer_nom->LinkAttrs;
			$this->Cell_Rendered($this->Primer_nom, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Segundo_nom
			$CurrentValue = $this->Segundo_nom->CurrentValue;
			$ViewValue = &$this->Segundo_nom->ViewValue;
			$ViewAttrs = &$this->Segundo_nom->ViewAttrs;
			$CellAttrs = &$this->Segundo_nom->CellAttrs;
			$HrefValue = &$this->Segundo_nom->HrefValue;
			$LinkAttrs = &$this->Segundo_nom->LinkAttrs;
			$this->Cell_Rendered($this->Segundo_nom, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Edad
			$CurrentValue = $this->Edad->CurrentValue;
			$ViewValue = &$this->Edad->ViewValue;
			$ViewAttrs = &$this->Edad->ViewAttrs;
			$CellAttrs = &$this->Edad->CellAttrs;
			$HrefValue = &$this->Edad->HrefValue;
			$LinkAttrs = &$this->Edad->LinkAttrs;
			$this->Cell_Rendered($this->Edad, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Unidad_edad
			$CurrentValue = $this->Unidad_edad->CurrentValue;
			$ViewValue = &$this->Unidad_edad->ViewValue;
			$ViewAttrs = &$this->Unidad_edad->ViewAttrs;
			$CellAttrs = &$this->Unidad_edad->CellAttrs;
			$HrefValue = &$this->Unidad_edad->HrefValue;
			$LinkAttrs = &$this->Unidad_edad->LinkAttrs;
			$this->Cell_Rendered($this->Unidad_edad, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Sexo
			$CurrentValue = $this->Sexo->CurrentValue;
			$ViewValue = &$this->Sexo->ViewValue;
			$ViewAttrs = &$this->Sexo->ViewAttrs;
			$CellAttrs = &$this->Sexo->CellAttrs;
			$HrefValue = &$this->Sexo->HrefValue;
			$LinkAttrs = &$this->Sexo->LinkAttrs;
			$this->Cell_Rendered($this->Sexo, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Codigo_dpto
			$CurrentValue = $this->Codigo_dpto->CurrentValue;
			$ViewValue = &$this->Codigo_dpto->ViewValue;
			$ViewAttrs = &$this->Codigo_dpto->ViewAttrs;
			$CellAttrs = &$this->Codigo_dpto->CellAttrs;
			$HrefValue = &$this->Codigo_dpto->HrefValue;
			$LinkAttrs = &$this->Codigo_dpto->LinkAttrs;
			$this->Cell_Rendered($this->Codigo_dpto, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Cod_municipio
			$CurrentValue = $this->Cod_municipio->CurrentValue;
			$ViewValue = &$this->Cod_municipio->ViewValue;
			$ViewAttrs = &$this->Cod_municipio->ViewAttrs;
			$CellAttrs = &$this->Cod_municipio->CellAttrs;
			$HrefValue = &$this->Cod_municipio->HrefValue;
			$LinkAttrs = &$this->Cod_municipio->LinkAttrs;
			$this->Cell_Rendered($this->Cod_municipio, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Zona_residencia
			$CurrentValue = $this->Zona_residencia->CurrentValue;
			$ViewValue = &$this->Zona_residencia->ViewValue;
			$ViewAttrs = &$this->Zona_residencia->ViewAttrs;
			$CellAttrs = &$this->Zona_residencia->CellAttrs;
			$HrefValue = &$this->Zona_residencia->HrefValue;
			$LinkAttrs = &$this->Zona_residencia->LinkAttrs;
			$this->Cell_Rendered($this->Zona_residencia, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->SetupFieldCount();
	}

	// Setup field count
	function SetupFieldCount() {
		$this->GrpFldCount = 0;
		$this->SubGrpFldCount = 0;
		$this->DtlFldCount = 0;
		if ($this->Tipo_doc->Visible) $this->DtlFldCount += 1;
		if ($this->Documento->Visible) $this->DtlFldCount += 1;
		if ($this->Codigo_eps->Visible) $this->DtlFldCount += 1;
		if ($this->Tipo_Usuario->Visible) $this->DtlFldCount += 1;
		if ($this->Primer_ap->Visible) $this->DtlFldCount += 1;
		if ($this->Segundo_ap->Visible) $this->DtlFldCount += 1;
		if ($this->Primer_nom->Visible) $this->DtlFldCount += 1;
		if ($this->Segundo_nom->Visible) $this->DtlFldCount += 1;
		if ($this->Edad->Visible) $this->DtlFldCount += 1;
		if ($this->Unidad_edad->Visible) $this->DtlFldCount += 1;
		if ($this->Sexo->Visible) $this->DtlFldCount += 1;
		if ($this->Codigo_dpto->Visible) $this->DtlFldCount += 1;
		if ($this->Cod_municipio->Visible) $this->DtlFldCount += 1;
		if ($this->Zona_residencia->Visible) $this->DtlFldCount += 1;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $ReportBreadcrumb;
		$ReportBreadcrumb = new crBreadcrumb();
		$url = substr(ewr_CurrentUrl(), strrpos(ewr_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$ReportBreadcrumb->Add("rpt", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	function SetupExportOptionsExt() {
		global $ReportLanguage;
		$item =& $this->ExportOptions->GetItem("pdf");
		$item->Visible = TRUE;
		$exportid = session_id();
		$url = $this->ExportPdfUrl;
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ewr_ExportCharts(this, '" . $url . "', '" . $exportid . "');\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
	}

	// Return popup filter
	function GetPopupFilter() {
		$sWrk = "";
		if ($this->DrillDown)
			return "";
		return $sWrk;
	}

	//-------------------------------------------------------------------------------
	// Function GetSort
	// - Return Sort parameters based on Sort Links clicked
	// - Variables setup: Session[EWR_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
	function GetSort() {
		if ($this->DrillDown)
			return "";

		// Check for a resetsort command
		if (strlen(@$_GET["cmd"]) > 0) {
			$sCmd = @$_GET["cmd"];
			if ($sCmd == "resetsort") {
				$this->setOrderBy("");
				$this->setStartGroup(1);
				$this->Tipo_doc->setSort("");
				$this->Documento->setSort("");
				$this->Codigo_eps->setSort("");
				$this->Tipo_Usuario->setSort("");
				$this->Primer_ap->setSort("");
				$this->Segundo_ap->setSort("");
				$this->Primer_nom->setSort("");
				$this->Segundo_nom->setSort("");
				$this->Edad->setSort("");
				$this->Unidad_edad->setSort("");
				$this->Sexo->setSort("");
				$this->Codigo_dpto->setSort("");
				$this->Cod_municipio->setSort("");
				$this->Zona_residencia->setSort("");
			}

		// Check for an Order parameter
		} elseif (@$_GET["order"] <> "") {
			$this->CurrentOrder = ewr_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$sSortSql = $this->SortSql();
			$this->setOrderBy($sSortSql);
			$this->setStartGroup(1);
		}
		return $this->getOrderBy();
	}

	// Export to WORD
	function ExportWord($html) {
		global $gsExportFile;
		header('Content-Type: application/vnd.ms-word' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		header('Content-Disposition: attachment; filename=' . $gsExportFile . '.doc');
		echo $html;
	}

	// Export to EXCEL
	function ExportExcel($html) {
		global $gsExportFile;
		header('Content-Type: application/vnd.ms-excel' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		header('Content-Disposition: attachment; filename=' . $gsExportFile . '.xls');
		echo $html;
	}

	// Export PDF
	function ExportPDF($html) {
		global $gsExportFile;
		include_once "dompdf061/dompdf_config.inc.php";
		@ini_set("memory_limit", EWR_PDF_MEMORY_LIMIT);
		set_time_limit(EWR_PDF_TIME_LIMIT);
		$dompdf = new DOMPDF();
		$dompdf->load_html($html);
		ob_end_clean();
		$dompdf->set_paper("a4", "portrait");
		$dompdf->render();
		ewr_DeleteTmpImages($html);
		$dompdf->stream($gsExportFile . ".pdf", array("Attachment" => 1)); // 0 to open in browser, 1 to download

//		exit();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ewr_Header(FALSE) ?>
<?php

// Create page object
if (!isset($Usuario_rpt)) $Usuario_rpt = new crUsuario_rpt();
if (isset($Page)) $OldPage = $Page;
$Page = &$Usuario_rpt;

// Page init
$Page->Page_Init();

// Page main
$Page->Page_Main();

// Global Page Rendering event (in ewrusrfn*.php)
Page_Rendering();

// Page Rendering event
$Page->Page_Render();
?>
<?php include_once "phprptinc/header.php" ?>
<?php if ($Page->Export == "") { ?>
<script type="text/javascript">

// Create page object
var Usuario_rpt = new ewr_Page("Usuario_rpt");

// Page properties
Usuario_rpt.PageID = "rpt"; // Page ID
var EWR_PAGE_ID = Usuario_rpt.PageID;

// Extend page with Chart_Rendering function
Usuario_rpt.Chart_Rendering = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }

// Extend page with Chart_Rendered function
Usuario_rpt.Chart_Rendered = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($Page->Export == "") { ?>
<!-- container (begin) -->
<div id="ewContainer" class="ewContainer">
<!-- top container (begin) -->
<div id="ewTop" class="ewTop">
<a id="top"></a>
<?php } ?>
<!-- top slot -->
<div class="ewToolbar">
<?php if ($Page->Export == "" && (!$Page->DrillDown || !$Page->DrillDownInPanel)) { ?>
<?php if ($ReportBreadcrumb) $ReportBreadcrumb->Render(); ?>
<?php } ?>
<?php
if (!$Page->DrillDownInPanel) {
	$Page->ExportOptions->Render("body");
	$Page->SearchOptions->Render("body");
	$Page->FilterOptions->Render("body");
}
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php echo $ReportLanguage->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php $Page->ShowPageHeader(); ?>
<?php $Page->ShowMessage(); ?>
<?php if ($Page->Export == "") { ?>
</div>
<!-- top container (end) -->
	<!-- left container (begin) -->
	<div id="ewLeft" class="ewLeft">
<?php } ?>
	<!-- Left slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- left container (end) -->
	<!-- center container - report (begin) -->
	<div id="ewCenter" class="ewCenter">
<?php } ?>
	<!-- center slot -->
<!-- summary report starts -->
<?php if ($Page->Export <> "pdf") { ?>
<div id="report_summary">
<?php } ?>
<?php

// Set the last group to display if not export all
if ($Page->ExportAll && $Page->Export <> "") {
	$Page->StopGrp = $Page->TotalGrps;
} else {
	$Page->StopGrp = $Page->StartGrp + $Page->DisplayGrps - 1;
}

// Stop group <= total number of groups
if (intval($Page->StopGrp) > intval($Page->TotalGrps))
	$Page->StopGrp = $Page->TotalGrps;
$Page->RecCount = 0;
$Page->RecIndex = 0;

// Get first row
if ($Page->TotalGrps > 0) {
	$Page->GetRow(1);
	$Page->GrpCount = 1;
}
$Page->GrpIdx = ewr_InitArray(2, -1);
$Page->GrpIdx[0] = -1;
$Page->GrpIdx[1] = $Page->StopGrp - $Page->StartGrp + 1;
while ($rs && !$rs->EOF && $Page->GrpCount <= $Page->DisplayGrps || $Page->ShowHeader) {

	// Show dummy header for custom template
	// Show header

	if ($Page->ShowHeader) {
?>
<?php if ($Page->Export <> "pdf") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<thead>
	<!-- Table header -->
	<tr class="ewTableHeader">
<?php if ($Page->Tipo_doc->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Tipo_doc"><div class="Usuario_Tipo_doc"><span class="ewTableHeaderCaption"><?php echo $Page->Tipo_doc->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Tipo_doc">
<?php if ($Page->SortUrl($Page->Tipo_doc) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Tipo_doc">
			<span class="ewTableHeaderCaption"><?php echo $Page->Tipo_doc->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Tipo_doc" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Tipo_doc) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Tipo_doc->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Tipo_doc->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Tipo_doc->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Documento->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Documento"><div class="Usuario_Documento"><span class="ewTableHeaderCaption"><?php echo $Page->Documento->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Documento">
<?php if ($Page->SortUrl($Page->Documento) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Documento">
			<span class="ewTableHeaderCaption"><?php echo $Page->Documento->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Documento" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Documento) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Documento->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Documento->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Documento->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Codigo_eps->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Codigo_eps"><div class="Usuario_Codigo_eps"><span class="ewTableHeaderCaption"><?php echo $Page->Codigo_eps->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Codigo_eps">
<?php if ($Page->SortUrl($Page->Codigo_eps) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Codigo_eps">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_eps->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Codigo_eps" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Codigo_eps) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_eps->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Codigo_eps->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Codigo_eps->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Tipo_Usuario->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Tipo_Usuario"><div class="Usuario_Tipo_Usuario"><span class="ewTableHeaderCaption"><?php echo $Page->Tipo_Usuario->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Tipo_Usuario">
<?php if ($Page->SortUrl($Page->Tipo_Usuario) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Tipo_Usuario">
			<span class="ewTableHeaderCaption"><?php echo $Page->Tipo_Usuario->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Tipo_Usuario" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Tipo_Usuario) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Tipo_Usuario->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Tipo_Usuario->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Tipo_Usuario->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Primer_ap->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Primer_ap"><div class="Usuario_Primer_ap"><span class="ewTableHeaderCaption"><?php echo $Page->Primer_ap->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Primer_ap">
<?php if ($Page->SortUrl($Page->Primer_ap) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Primer_ap">
			<span class="ewTableHeaderCaption"><?php echo $Page->Primer_ap->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Primer_ap" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Primer_ap) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Primer_ap->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Primer_ap->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Primer_ap->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Segundo_ap->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Segundo_ap"><div class="Usuario_Segundo_ap"><span class="ewTableHeaderCaption"><?php echo $Page->Segundo_ap->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Segundo_ap">
<?php if ($Page->SortUrl($Page->Segundo_ap) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Segundo_ap">
			<span class="ewTableHeaderCaption"><?php echo $Page->Segundo_ap->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Segundo_ap" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Segundo_ap) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Segundo_ap->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Segundo_ap->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Segundo_ap->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Primer_nom->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Primer_nom"><div class="Usuario_Primer_nom"><span class="ewTableHeaderCaption"><?php echo $Page->Primer_nom->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Primer_nom">
<?php if ($Page->SortUrl($Page->Primer_nom) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Primer_nom">
			<span class="ewTableHeaderCaption"><?php echo $Page->Primer_nom->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Primer_nom" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Primer_nom) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Primer_nom->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Primer_nom->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Primer_nom->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Segundo_nom->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Segundo_nom"><div class="Usuario_Segundo_nom"><span class="ewTableHeaderCaption"><?php echo $Page->Segundo_nom->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Segundo_nom">
<?php if ($Page->SortUrl($Page->Segundo_nom) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Segundo_nom">
			<span class="ewTableHeaderCaption"><?php echo $Page->Segundo_nom->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Segundo_nom" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Segundo_nom) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Segundo_nom->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Segundo_nom->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Segundo_nom->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Edad->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Edad"><div class="Usuario_Edad"><span class="ewTableHeaderCaption"><?php echo $Page->Edad->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Edad">
<?php if ($Page->SortUrl($Page->Edad) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Edad">
			<span class="ewTableHeaderCaption"><?php echo $Page->Edad->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Edad" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Edad) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Edad->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Unidad_edad->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Unidad_edad"><div class="Usuario_Unidad_edad"><span class="ewTableHeaderCaption"><?php echo $Page->Unidad_edad->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Unidad_edad">
<?php if ($Page->SortUrl($Page->Unidad_edad) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Unidad_edad">
			<span class="ewTableHeaderCaption"><?php echo $Page->Unidad_edad->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Unidad_edad" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Unidad_edad) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Unidad_edad->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Unidad_edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Unidad_edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Sexo->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Sexo"><div class="Usuario_Sexo"><span class="ewTableHeaderCaption"><?php echo $Page->Sexo->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Sexo">
<?php if ($Page->SortUrl($Page->Sexo) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Sexo">
			<span class="ewTableHeaderCaption"><?php echo $Page->Sexo->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Sexo" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Sexo) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Sexo->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Sexo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Sexo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Codigo_dpto->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Codigo_dpto"><div class="Usuario_Codigo_dpto"><span class="ewTableHeaderCaption"><?php echo $Page->Codigo_dpto->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Codigo_dpto">
<?php if ($Page->SortUrl($Page->Codigo_dpto) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Codigo_dpto">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_dpto->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Codigo_dpto" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Codigo_dpto) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_dpto->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Codigo_dpto->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Codigo_dpto->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Cod_municipio->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Cod_municipio"><div class="Usuario_Cod_municipio"><span class="ewTableHeaderCaption"><?php echo $Page->Cod_municipio->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Cod_municipio">
<?php if ($Page->SortUrl($Page->Cod_municipio) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Cod_municipio">
			<span class="ewTableHeaderCaption"><?php echo $Page->Cod_municipio->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Cod_municipio" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Cod_municipio) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Cod_municipio->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Cod_municipio->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Cod_municipio->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Zona_residencia->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Zona_residencia"><div class="Usuario_Zona_residencia"><span class="ewTableHeaderCaption"><?php echo $Page->Zona_residencia->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Zona_residencia">
<?php if ($Page->SortUrl($Page->Zona_residencia) == "") { ?>
		<div class="ewTableHeaderBtn Usuario_Zona_residencia">
			<span class="ewTableHeaderCaption"><?php echo $Page->Zona_residencia->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer Usuario_Zona_residencia" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Zona_residencia) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Zona_residencia->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Zona_residencia->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Zona_residencia->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
	</tr>
</thead>
<tbody>
<?php
		if ($Page->TotalGrps == 0) break; // Show header only
		$Page->ShowHeader = FALSE;
	}
	$Page->RecCount++;
	$Page->RecIndex++;

		// Render detail row
		$Page->ResetAttrs();
		$Page->RowType = EWR_ROWTYPE_DETAIL;
		$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->Tipo_doc->Visible) { ?>
		<td data-field="Tipo_doc"<?php echo $Page->Tipo_doc->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Tipo_doc"<?php echo $Page->Tipo_doc->ViewAttributes() ?>><?php echo $Page->Tipo_doc->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Documento->Visible) { ?>
		<td data-field="Documento"<?php echo $Page->Documento->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Documento"<?php echo $Page->Documento->ViewAttributes() ?>><?php echo $Page->Documento->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Codigo_eps->Visible) { ?>
		<td data-field="Codigo_eps"<?php echo $Page->Codigo_eps->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Codigo_eps"<?php echo $Page->Codigo_eps->ViewAttributes() ?>><?php echo $Page->Codigo_eps->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Tipo_Usuario->Visible) { ?>
		<td data-field="Tipo_Usuario"<?php echo $Page->Tipo_Usuario->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Tipo_Usuario"<?php echo $Page->Tipo_Usuario->ViewAttributes() ?>><?php echo $Page->Tipo_Usuario->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Primer_ap->Visible) { ?>
		<td data-field="Primer_ap"<?php echo $Page->Primer_ap->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Primer_ap"<?php echo $Page->Primer_ap->ViewAttributes() ?>><?php echo $Page->Primer_ap->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Segundo_ap->Visible) { ?>
		<td data-field="Segundo_ap"<?php echo $Page->Segundo_ap->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Segundo_ap"<?php echo $Page->Segundo_ap->ViewAttributes() ?>><?php echo $Page->Segundo_ap->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Primer_nom->Visible) { ?>
		<td data-field="Primer_nom"<?php echo $Page->Primer_nom->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Primer_nom"<?php echo $Page->Primer_nom->ViewAttributes() ?>><?php echo $Page->Primer_nom->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Segundo_nom->Visible) { ?>
		<td data-field="Segundo_nom"<?php echo $Page->Segundo_nom->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Segundo_nom"<?php echo $Page->Segundo_nom->ViewAttributes() ?>><?php echo $Page->Segundo_nom->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Edad->Visible) { ?>
		<td data-field="Edad"<?php echo $Page->Edad->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Edad"<?php echo $Page->Edad->ViewAttributes() ?>><?php echo $Page->Edad->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Unidad_edad->Visible) { ?>
		<td data-field="Unidad_edad"<?php echo $Page->Unidad_edad->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Unidad_edad"<?php echo $Page->Unidad_edad->ViewAttributes() ?>><?php echo $Page->Unidad_edad->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Sexo->Visible) { ?>
		<td data-field="Sexo"<?php echo $Page->Sexo->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Sexo"<?php echo $Page->Sexo->ViewAttributes() ?>><?php echo $Page->Sexo->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Codigo_dpto->Visible) { ?>
		<td data-field="Codigo_dpto"<?php echo $Page->Codigo_dpto->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Codigo_dpto"<?php echo $Page->Codigo_dpto->ViewAttributes() ?>><?php echo $Page->Codigo_dpto->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Cod_municipio->Visible) { ?>
		<td data-field="Cod_municipio"<?php echo $Page->Cod_municipio->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Cod_municipio"<?php echo $Page->Cod_municipio->ViewAttributes() ?>><?php echo $Page->Cod_municipio->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Zona_residencia->Visible) { ?>
		<td data-field="Zona_residencia"<?php echo $Page->Zona_residencia->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_Usuario_Zona_residencia"<?php echo $Page->Zona_residencia->ViewAttributes() ?>><?php echo $Page->Zona_residencia->ListViewValue() ?></span></td>
<?php } ?>
	</tr>
<?php

		// Accumulate page summary
		$Page->AccumulateSummary();

		// Get next record
		$Page->GetRow(2);
	$Page->GrpCount++;
} // End while
?>
<?php if ($Page->TotalGrps > 0) { ?>
</tbody>
<tfoot>
	</tfoot>
<?php } elseif (!$Page->ShowHeader) { // No header displayed ?>
<?php if ($Page->Export <> "pdf") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<?php } ?>
</table>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export == "" && !($Page->DrillDown && $Page->TotalGrps > 0)) { ?>
<div class="ewGridLowerPanel">
<?php include "Usuariorptpager.php" ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<!-- Summary Report Ends -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- center container - report (end) -->
	<!-- right container (begin) -->
	<div id="ewRight" class="ewRight">
<?php } ?>
	<!-- Right slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- right container (end) -->
<div class="clearfix"></div>
<!-- bottom container (begin) -->
<div id="ewBottom" class="ewBottom">
<?php } ?>
	<!-- Bottom slot -->
<?php if ($Page->Export == "") { ?>
	</div>
<!-- Bottom Container (End) -->
</div>
<!-- Table Container (End) -->
<?php } ?>
<?php $Page->ShowPageFooter(); ?>
<?php if (EWR_DEBUG_ENABLED) echo ewr_DebugMsg(); ?>
<?php

// Close recordsets
if ($rsgrp) $rsgrp->Close();
if ($rs) $rs->Close();
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "phprptinc/footer.php" ?>
<?php
$Page->Page_Terminate();
if (isset($OldPage)) $Page = $OldPage;
?>
