<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start();
?>
<?php include_once "phprptinc/ewrcfg8.php" ?>
<?php include_once "phprptinc/ewmysql.php" ?>
<?php include_once "phprptinc/ewrfn8.php" ?>
<?php include_once "phprptinc/ewrusrfn8.php" ?>
<?php include_once "filtro_2019_consultarptinfo.php" ?>
<?php

//
// Page class
//

$filtro_2019_consulta_rpt = NULL; // Initialize page object first

class crfiltro_2019_consulta_rpt extends crfiltro_2019_consulta {

	// Page ID
	var $PageID = 'rpt';

	// Project ID
	var $ProjectID = "{84B0927F-5257-4D61-BA82-F177D7F30F4F}";

	// Page object name
	var $PageObjName = 'filtro_2019_consulta_rpt';

	// Page name
	function PageName() {
		return ewr_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ewr_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Export URLs
	var $ExportPrintUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportPdfUrl;
	var $ReportTableClass;
	var $ReportTableStyle = "";

	// Custom export
	var $ExportPrintCustom = FALSE;
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Message
	function getMessage() {
		return @$_SESSION[EWR_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EWR_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EWR_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EWR_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ewr_AddMessage($_SESSION[EWR_SESSION_WARNING_MESSAGE], $v);
	}

		// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EWR_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EWR_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EWR_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EWR_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog ewDisplayTable\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") // Header exists, display
			echo $sHeader;
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") // Fotoer exists, display
			echo $sFooter;
	}

	// Validate page request
	function IsPageRequest() {
		if ($this->UseTokenInUrl) {
			if (ewr_IsHttpPost())
				return ($this->TableVar == @$_POST("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == @$_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $CheckToken = EWR_CHECK_TOKEN;
	var $CheckTokenFn = "ewr_CheckToken";
	var $CreateTokenFn = "ewr_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ewr_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EWR_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EWR_TOKEN_NAME]);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $ReportLanguage;

		// Language object
		$ReportLanguage = new crLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (filtro_2019_consulta)
		if (!isset($GLOBALS["filtro_2019_consulta"])) {
			$GLOBALS["filtro_2019_consulta"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["filtro_2019_consulta"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";

		// Page ID
		if (!defined("EWR_PAGE_ID"))
			define("EWR_PAGE_ID", 'rpt', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EWR_TABLE_NAME"))
			define("EWR_TABLE_NAME", 'filtro_2019_consulta', TRUE);

		// Start timer
		$GLOBALS["gsTimer"] = new crTimer();

		// Open connection
		$conn = ewr_Connect();

		// Export options
		$this->ExportOptions = new crListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Search options
		$this->SearchOptions = new crListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Filter options
		$this->FilterOptions = new crListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption ffiltro_2019_consultarpt";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $gsEmailContentType, $ReportLanguage, $Security;
		global $gsCustomExport;

		// Get export parameters
		if (@$_GET["export"] <> "")
			$this->Export = strtolower($_GET["export"]);
		elseif (@$_POST["export"] <> "")
			$this->Export = strtolower($_POST["export"]);
		$gsExport = $this->Export; // Get export parameter, used in header
		$gsExportFile = $this->TableVar; // Get export file, used in header
		$gsEmailContentType = @$_POST["contenttype"]; // Get email content type

		// Setup placeholder
		$this->Codigo_tres->PlaceHolder = $this->Codigo_tres->FldCaption();
		$this->Edad->PlaceHolder = $this->Edad->FldCaption();

		// Setup export options
		$this->SetupExportOptions();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $ReportLanguage->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Create Token
		$this->CreateToken();
	}

	// Set up export options
	function SetupExportOptions() {
		global $ReportLanguage;
		$exportid = session_id();

		// Printer friendly
		$item = &$this->ExportOptions->Add("print");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("PrinterFriendly", TRUE)) . "\" href=\"" . $this->ExportPrintUrl . "\">" . $ReportLanguage->Phrase("PrinterFriendly") . "</a>";
		$item->Visible = FALSE;

		// Export to Excel
		$item = &$this->ExportOptions->Add("excel");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToExcel", TRUE)) . "\" href=\"" . $this->ExportExcelUrl . "\">" . $ReportLanguage->Phrase("ExportToExcel") . "</a>";
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->Add("word");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToWord", TRUE)) . "\" href=\"" . $this->ExportWordUrl . "\">" . $ReportLanguage->Phrase("ExportToWord") . "</a>";

		//$item->Visible = TRUE;
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->Add("pdf");
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"" . $this->ExportPdfUrl . "\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
		$item->Visible = FALSE;

		// Uncomment codes below to show export to Pdf link
//		$item->Visible = TRUE;
		// Export to Email

		$item = &$this->ExportOptions->Add("email");
		$url = $this->PageUrl() . "export=email";
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToEmail", TRUE)) . "\" id=\"emf_filtro_2019_consulta\" href=\"javascript:void(0);\" onclick=\"ewr_EmailDialogShow({lnk:'emf_filtro_2019_consulta',hdr:ewLanguage.Phrase('ExportToEmail'),url:'$url',exportid:'$exportid',el:this});\">" . $ReportLanguage->Phrase("ExportToEmail") . "</a>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseDropDownButton = FALSE;
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseImageAndText = $this->ExportOptions->UseDropDownButton;
		$this->ExportOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->Add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter panel button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-caption=\"" . $ReportLanguage->Phrase("SearchBtn", TRUE) . "\" data-toggle=\"button\" data-form=\"ffiltro_2019_consultarpt\">" . $ReportLanguage->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Reset filter
		$item = &$this->SearchOptions->Add("resetfilter");
		$item->Body = "<button type=\"button\" class=\"btn btn-default\" title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ResetAllFilter", TRUE)) . "\" onclick=\"location='" . ewr_CurrentPage() . "?cmd=reset'\">" . $ReportLanguage->Phrase("ResetAllFilter") . "</button>";
		$item->Visible = TRUE;

		// Button group for reset filter
		$this->SearchOptions->UseButtonGroup = TRUE;

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"ffiltro_2019_consultarpt\" href=\"#\">" . $ReportLanguage->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"ffiltro_2019_consultarpt\" href=\"#\">" . $ReportLanguage->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton; // v8
		$this->FilterOptions->DropDownButtonPhrase = $ReportLanguage->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up options (extended)
		$this->SetupExportOptionsExt();

		// Hide options for export
		if ($this->Export <> "") {
			$this->ExportOptions->HideAllOptions();
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Set up table class
		if ($this->Export == "word" || $this->Export == "excel" || $this->Export == "pdf")
			$this->ReportTableClass = "ewTable";
		else
			$this->ReportTableClass = "table ewTable";
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn, $ReportLanguage, $EWR_EXPORT, $gsExportFile;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		if ($this->Export <> "" && array_key_exists($this->Export, $EWR_EXPORT)) {
			$sContent = ob_get_contents();

			// Remove all <div data-tagid="..." id="orig..." class="hide">...</div> (for customviewtag export, except "googlemaps")
			if (preg_match_all('/<div\s+data-tagid=[\'"]([\s\S]*?)[\'"]\s+id=[\'"]orig([\s\S]*?)[\'"]\s+class\s*=\s*[\'"]hide[\'"]>([\s\S]*?)<\/div\s*>/i', $sContent, $divmatches, PREG_SET_ORDER)) {
				foreach ($divmatches as $divmatch) {
					if ($divmatch[1] <> "googlemaps")
						$sContent = str_replace($divmatch[0], '', $sContent);
				}
			}
			$fn = $EWR_EXPORT[$this->Export];
			if ($this->Export == "email") { // Email
				ob_end_clean();
				echo $this->$fn($sContent);
				$conn->Close(); // Close connection
				exit();
			} else {
				$this->$fn($sContent);
			}
		}

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EWR_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Initialize common variables
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $FilterOptions; // Filter options

	// Paging variables
	var $RecIndex = 0; // Record index
	var $RecCount = 0; // Record count
	var $StartGrp = 0; // Start group
	var $StopGrp = 0; // Stop group
	var $TotalGrps = 0; // Total groups
	var $GrpCount = 0; // Group count
	var $GrpCounter = array(); // Group counter
	var $DisplayGrps = 30; // Groups per page
	var $GrpRange = 10;
	var $Sort = "";
	var $Filter = "";
	var $PageFirstGroupFilter = "";
	var $UserIDFilter = "";
	var $DrillDown = FALSE;
	var $DrillDownInPanel = FALSE;
	var $DrillDownList = "";

	// Clear field for ext filter
	var $ClearExtFilter = "";
	var $PopupName = "";
	var $PopupValue = "";
	var $FilterApplied;
	var $SearchCommand = FALSE;
	var $ShowHeader;
	var $GrpFldCount = 0;
	var $SubGrpFldCount = 0;
	var $DtlFldCount = 0;
	var $Cnt, $Col, $Val, $Smry, $Mn, $Mx, $GrandCnt, $GrandSmry, $GrandMn, $GrandMx;
	var $TotCount;
	var $GrandSummarySetup = FALSE;
	var $GrpIdx;

	//
	// Page main
	//
	function Page_Main() {
		global $rs;
		global $rsgrp;
		global $gsFormError;
		global $gbDrillDownInPanel;
		global $ReportBreadcrumb;

		// Aggregate variables
		// 1st dimension = no of groups (level 0 used for grand total)
		// 2nd dimension = no of fields

		$nDtls = 8;
		$nGrps = 1;
		$this->Val = &ewr_InitArray($nDtls, 0);
		$this->Cnt = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Smry = &ewr_Init2DArray($nGrps, $nDtls, 0);
		$this->Mn = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->Mx = &ewr_Init2DArray($nGrps, $nDtls, NULL);
		$this->GrandCnt = &ewr_InitArray($nDtls, 0);
		$this->GrandSmry = &ewr_InitArray($nDtls, 0);
		$this->GrandMn = &ewr_InitArray($nDtls, NULL);
		$this->GrandMx = &ewr_InitArray($nDtls, NULL);

		// Set up array if accumulation required: array(Accum, SkipNullOrZero)
		$this->Col = array(array(FALSE, FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE), array(FALSE,FALSE));

		// Set up groups per page dynamically
		$this->SetUpDisplayGrps();

		// Set up Breadcrumb
		if ($this->Export == "")
			$this->SetupBreadcrumb();

		// Check if search command
		$this->SearchCommand = (@$_GET["cmd"] == "search");

		// Load default filter values
		$this->LoadDefaultFilters();

		// Load custom filters
		$this->Page_FilterLoad();

		// Set up popup filter
		$this->SetupPopup();

		// Load group db values if necessary
		$this->LoadGroupDbValues();

		// Handle Ajax popup
		$this->ProcessAjaxPopup();

		// Extended filter
		$sExtendedFilter = "";

		// Restore filter list
		$this->RestoreFilterList();

		// Build extended filter
		$sExtendedFilter = $this->GetExtendedFilter();
		ewr_AddFilter($this->Filter, $sExtendedFilter);

		// Build popup filter
		$sPopupFilter = $this->GetPopupFilter();

		//ewr_SetDebugMsg("popup filter: " . $sPopupFilter);
		ewr_AddFilter($this->Filter, $sPopupFilter);

		// Check if filter applied
		$this->FilterApplied = $this->CheckFilter();

		// Call Page Selecting event
		$this->Page_Selecting($this->Filter);

		// Requires search criteria
		if (($this->Filter == $this->UserIDFilter || $gsFormError != "") && !$this->DrillDown)
			$this->Filter = "0=101";
		$this->SearchOptions->GetItem("resetfilter")->Visible = $this->FilterApplied;

		// Get sort
		$this->Sort = $this->GetSort();

		// Get total count
		$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $this->Filter, $this->Sort);
		$this->TotalGrps = $this->GetCnt($sSql);
		if ($this->DisplayGrps <= 0 || $this->DrillDown) // Display all groups
			$this->DisplayGrps = $this->TotalGrps;
		$this->StartGrp = 1;

		// Show header
		$this->ShowHeader = ($this->TotalGrps > 0);

		// Set up start position if not export all
		if ($this->ExportAll && $this->Export <> "")
		    $this->DisplayGrps = $this->TotalGrps;
		else
			$this->SetUpStartGroup(); 

		// Hide export options if export
		if ($this->Export <> "")
			$this->ExportOptions->HideAllOptions();

		// Hide search/filter options if export/drilldown
		if ($this->Export <> "" || $this->DrillDown) {
			$this->SearchOptions->HideAllOptions();
			$this->FilterOptions->HideAllOptions();
		}

		// Get current page records
		$rs = $this->GetRs($sSql, $this->StartGrp, $this->DisplayGrps);
		$this->SetupFieldCount();
	}

	// Accummulate summary
	function AccumulateSummary() {
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				if ($this->Col[$iy][0]) { // Accumulate required
					$valwrk = $this->Val[$iy];
					if (is_null($valwrk)) {
						if (!$this->Col[$iy][1])
							$this->Cnt[$ix][$iy]++;
					} else {
						$accum = (!$this->Col[$iy][1] || !is_numeric($valwrk) || $valwrk <> 0);
						if ($accum) {
							$this->Cnt[$ix][$iy]++;
							if (is_numeric($valwrk)) {
								$this->Smry[$ix][$iy] += $valwrk;
								if (is_null($this->Mn[$ix][$iy])) {
									$this->Mn[$ix][$iy] = $valwrk;
									$this->Mx[$ix][$iy] = $valwrk;
								} else {
									if ($this->Mn[$ix][$iy] > $valwrk) $this->Mn[$ix][$iy] = $valwrk;
									if ($this->Mx[$ix][$iy] < $valwrk) $this->Mx[$ix][$iy] = $valwrk;
								}
							}
						}
					}
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = 0; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0]++;
		}
	}

	// Reset level summary
	function ResetLevelSummary($lvl) {

		// Clear summary values
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$cnty = count($this->Smry[$ix]);
			for ($iy = 1; $iy < $cnty; $iy++) {
				$this->Cnt[$ix][$iy] = 0;
				if ($this->Col[$iy][0]) {
					$this->Smry[$ix][$iy] = 0;
					$this->Mn[$ix][$iy] = NULL;
					$this->Mx[$ix][$iy] = NULL;
				}
			}
		}
		$cntx = count($this->Smry);
		for ($ix = $lvl; $ix < $cntx; $ix++) {
			$this->Cnt[$ix][0] = 0;
		}

		// Reset record count
		$this->RecCount = 0;
	}

	// Accummulate grand summary
	function AccumulateGrandSummary() {
		$this->TotCount++;
		$cntgs = count($this->GrandSmry);
		for ($iy = 1; $iy < $cntgs; $iy++) {
			if ($this->Col[$iy][0]) {
				$valwrk = $this->Val[$iy];
				if (is_null($valwrk) || !is_numeric($valwrk)) {
					if (!$this->Col[$iy][1])
						$this->GrandCnt[$iy]++;
				} else {
					if (!$this->Col[$iy][1] || $valwrk <> 0) {
						$this->GrandCnt[$iy]++;
						$this->GrandSmry[$iy] += $valwrk;
						if (is_null($this->GrandMn[$iy])) {
							$this->GrandMn[$iy] = $valwrk;
							$this->GrandMx[$iy] = $valwrk;
						} else {
							if ($this->GrandMn[$iy] > $valwrk) $this->GrandMn[$iy] = $valwrk;
							if ($this->GrandMx[$iy] < $valwrk) $this->GrandMx[$iy] = $valwrk;
						}
					}
				}
			}
		}
	}

	// Get count
	function GetCnt($sql) {
		global $conn;
		$rscnt = $conn->Execute($sql);
		$cnt = ($rscnt) ? $rscnt->RecordCount() : 0;
		if ($rscnt) $rscnt->Close();
		return $cnt;
	}

	// Get recordset
	function GetRs($wrksql, $start, $grps) {
		global $conn;
		$conn->raiseErrorFn = $GLOBALS["EWR_ERROR_FN"];
		$rswrk = $conn->SelectLimit($wrksql, $grps, $start - 1);
		$conn->raiseErrorFn = '';
		return $rswrk;
	}

	// Get row values
	function GetRow($opt) {
		global $rs;
		if (!$rs)
			return;
		if ($opt == 1) { // Get first row

	//		$rs->MoveFirst(); // NOTE: no need to move position
				$this->FirstRowData = array();
				$this->FirstRowData['Count28consulta_final_2020_Codigo_diagnostico29'] = ewr_Conv($rs->fields('Count(consulta_final_2020.Codigo_diagnostico)'),20);
				$this->FirstRowData['Codigo_tres'] = ewr_Conv($rs->fields('Codigo_tres'),200);
				$this->FirstRowData['Contador'] = ewr_Conv($rs->fields('Contador'),3);
				$this->FirstRowData['Titulo_codigo_tres'] = ewr_Conv($rs->fields('Titulo_codigo_tres'),200);
				$this->FirstRowData['Sexo'] = ewr_Conv($rs->fields('Sexo'),200);
				$this->FirstRowData['Edad'] = ewr_Conv($rs->fields('Edad'),16);
				$this->FirstRowData['Unidad_edad'] = ewr_Conv($rs->fields('Unidad_edad'),16);
				$this->FirstRowData['Zona_residencia'] = ewr_Conv($rs->fields('Zona_residencia'),200);
		} else { // Get next row
			$rs->MoveNext();
		}
		if (!$rs->EOF) {
			$this->Count28consulta_final_2020_Codigo_diagnostico29->setDbValue($rs->fields('Count(consulta_final_2020.Codigo_diagnostico)'));
			$this->Codigo_tres->setDbValue($rs->fields('Codigo_tres'));
			$this->Contador->setDbValue($rs->fields('Contador'));
			$this->Titulo_codigo_tres->setDbValue($rs->fields('Titulo_codigo_tres'));
			$this->Sexo->setDbValue($rs->fields('Sexo'));
			$this->Edad->setDbValue($rs->fields('Edad'));
			$this->Unidad_edad->setDbValue($rs->fields('Unidad_edad'));
			$this->Zona_residencia->setDbValue($rs->fields('Zona_residencia'));
			$this->Val[1] = $this->Count28consulta_final_2020_Codigo_diagnostico29->CurrentValue;
			$this->Val[2] = $this->Codigo_tres->CurrentValue;
			$this->Val[3] = $this->Titulo_codigo_tres->CurrentValue;
			$this->Val[4] = $this->Sexo->CurrentValue;
			$this->Val[5] = $this->Edad->CurrentValue;
			$this->Val[6] = $this->Unidad_edad->CurrentValue;
			$this->Val[7] = $this->Zona_residencia->CurrentValue;
		} else {
			$this->Count28consulta_final_2020_Codigo_diagnostico29->setDbValue("");
			$this->Codigo_tres->setDbValue("");
			$this->Contador->setDbValue("");
			$this->Titulo_codigo_tres->setDbValue("");
			$this->Sexo->setDbValue("");
			$this->Edad->setDbValue("");
			$this->Unidad_edad->setDbValue("");
			$this->Zona_residencia->setDbValue("");
		}
	}

	//  Set up starting group
	function SetUpStartGroup() {

		// Exit if no groups
		if ($this->DisplayGrps == 0)
			return;

		// Check for a 'start' parameter
		if (@$_GET[EWR_TABLE_START_GROUP] != "") {
			$this->StartGrp = $_GET[EWR_TABLE_START_GROUP];
			$this->setStartGroup($this->StartGrp);
		} elseif (@$_GET["pageno"] != "") {
			$nPageNo = $_GET["pageno"];
			if (is_numeric($nPageNo)) {
				$this->StartGrp = ($nPageNo-1)*$this->DisplayGrps+1;
				if ($this->StartGrp <= 0) {
					$this->StartGrp = 1;
				} elseif ($this->StartGrp >= intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1) {
					$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps)*$this->DisplayGrps+1;
				}
				$this->setStartGroup($this->StartGrp);
			} else {
				$this->StartGrp = $this->getStartGroup();
			}
		} else {
			$this->StartGrp = $this->getStartGroup();
		}

		// Check if correct start group counter
		if (!is_numeric($this->StartGrp) || $this->StartGrp == "") { // Avoid invalid start group counter
			$this->StartGrp = 1; // Reset start group counter
			$this->setStartGroup($this->StartGrp);
		} elseif (intval($this->StartGrp) > intval($this->TotalGrps)) { // Avoid starting group > total groups
			$this->StartGrp = intval(($this->TotalGrps-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to last page first group
			$this->setStartGroup($this->StartGrp);
		} elseif (($this->StartGrp-1) % $this->DisplayGrps <> 0) {
			$this->StartGrp = intval(($this->StartGrp-1)/$this->DisplayGrps) * $this->DisplayGrps + 1; // Point to page boundary
			$this->setStartGroup($this->StartGrp);
		}
	}

	// Load group db values if necessary
	function LoadGroupDbValues() {
		global $conn;
	}

	// Process Ajax popup
	function ProcessAjaxPopup() {
		global $conn, $ReportLanguage;
		$fld = NULL;
		if (@$_GET["popup"] <> "") {
			$popupname = $_GET["popup"];

			// Check popup name
			// Output data as Json

			if (!is_null($fld)) {
				$jsdb = ewr_GetJsDb($fld, $fld->FldType);
				ob_end_clean();
				echo $jsdb;
				exit();
			}
		}
	}

	// Set up popup
	function SetupPopup() {
		global $conn, $ReportLanguage;
		if ($this->DrillDown)
			return;

		// Process post back form
		if (ewr_IsHttpPost()) {
			$sName = @$_POST["popup"]; // Get popup form name
			if ($sName <> "") {
				$cntValues = (is_array(@$_POST["sel_$sName"])) ? count($_POST["sel_$sName"]) : 0;
				if ($cntValues > 0) {
					$arValues = ewr_StripSlashes($_POST["sel_$sName"]);
					if (trim($arValues[0]) == "") // Select all
						$arValues = EWR_INIT_VALUE;
					$this->PopupName = $sName;
					if (ewr_IsAdvancedFilterValue($arValues) || $arValues == EWR_INIT_VALUE)
						$this->PopupValue = $arValues;
					if (!ewr_MatchedArray($arValues, $_SESSION["sel_$sName"])) {
						if ($this->HasSessionFilterValues($sName))
							$this->ClearExtFilter = $sName; // Clear extended filter for this field
					}
					$_SESSION["sel_$sName"] = $arValues;
					$_SESSION["rf_$sName"] = ewr_StripSlashes(@$_POST["rf_$sName"]);
					$_SESSION["rt_$sName"] = ewr_StripSlashes(@$_POST["rt_$sName"]);
					$this->ResetPager();
				}
			}

		// Get 'reset' command
		} elseif (@$_GET["cmd"] <> "") {
			$sCmd = $_GET["cmd"];
			if (strtolower($sCmd) == "reset") {
				$this->ResetPager();
			}
		}

		// Load selection criteria to array
	}

	// Reset pager
	function ResetPager() {

		// Reset start position (reset command)
		$this->StartGrp = 1;
		$this->setStartGroup($this->StartGrp);
	}

	// Set up number of groups displayed per page
	function SetUpDisplayGrps() {
		$sWrk = @$_GET[EWR_TABLE_GROUP_PER_PAGE];
		if ($sWrk <> "") {
			if (is_numeric($sWrk)) {
				$this->DisplayGrps = intval($sWrk);
			} else {
				if (strtoupper($sWrk) == "ALL") { // Display all groups
					$this->DisplayGrps = -1;
				} else {
					$this->DisplayGrps = 30; // Non-numeric, load default
				}
			}
			$this->setGroupPerPage($this->DisplayGrps); // Save to session

			// Reset start position (reset command)
			$this->StartGrp = 1;
			$this->setStartGroup($this->StartGrp);
		} else {
			if ($this->getGroupPerPage() <> "") {
				$this->DisplayGrps = $this->getGroupPerPage(); // Restore from session
			} else {
				$this->DisplayGrps = 30; // Load default
			}
		}
	}

	// Render row
	function RenderRow() {
		global $conn, $rs, $Security, $ReportLanguage;
		if ($this->RowTotalType == EWR_ROWTOTAL_GRAND && !$this->GrandSummarySetup) { // Grand total
			$bGotCount = FALSE;
			$bGotSummary = FALSE;

			// Get total count from sql directly
			$sSql = ewr_BuildReportSql($this->getSqlSelectCount(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
			$rstot = $conn->Execute($sSql);
			if ($rstot) {
				$this->TotCount = ($rstot->RecordCount()>1) ? $rstot->RecordCount() : $rstot->fields[0];
				$rstot->Close();
				$bGotCount = TRUE;
			} else {
				$this->TotCount = 0;
			}
		$bGotSummary = TRUE;

			// Accumulate grand summary from detail records
			if (!$bGotCount || !$bGotSummary) {
				$sSql = ewr_BuildReportSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
				$rs = $conn->Execute($sSql);
				if ($rs) {
					$this->GetRow(1);
					while (!$rs->EOF) {
						$this->AccumulateGrandSummary();
						$this->GetRow(2);
					}
					$rs->Close();
				}
			}
			$this->GrandSummarySetup = TRUE; // No need to set up again
		}

		// Call Row_Rendering event
		$this->Row_Rendering();

		//
		// Render view codes
		//

		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row

			// Count(consulta_final_2020.Codigo_diagnostico)
			$this->Count28consulta_final_2020_Codigo_diagnostico29->HrefValue = "";

			// Codigo_tres
			$this->Codigo_tres->HrefValue = "";

			// Titulo_codigo_tres
			$this->Titulo_codigo_tres->HrefValue = "";

			// Sexo
			$this->Sexo->HrefValue = "";

			// Edad
			$this->Edad->HrefValue = "";

			// Unidad_edad
			$this->Unidad_edad->HrefValue = "";

			// Zona_residencia
			$this->Zona_residencia->HrefValue = "";
		} else {

			// Count(consulta_final_2020.Codigo_diagnostico)
			$this->Count28consulta_final_2020_Codigo_diagnostico29->ViewValue = $this->Count28consulta_final_2020_Codigo_diagnostico29->CurrentValue;
			$this->Count28consulta_final_2020_Codigo_diagnostico29->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Codigo_tres
			$this->Codigo_tres->ViewValue = $this->Codigo_tres->CurrentValue;
			$this->Codigo_tres->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Titulo_codigo_tres
			$this->Titulo_codigo_tres->ViewValue = $this->Titulo_codigo_tres->CurrentValue;
			$this->Titulo_codigo_tres->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Sexo
			$this->Sexo->ViewValue = $this->Sexo->CurrentValue;
			$this->Sexo->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Edad
			$this->Edad->ViewValue = $this->Edad->CurrentValue;
			$this->Edad->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Unidad_edad
			$this->Unidad_edad->ViewValue = $this->Unidad_edad->CurrentValue;
			$this->Unidad_edad->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Zona_residencia
			$this->Zona_residencia->ViewValue = $this->Zona_residencia->CurrentValue;
			$this->Zona_residencia->CellAttrs["class"] = ($this->RecCount % 2 <> 1) ? "ewTableAltRow" : "ewTableRow";

			// Count(consulta_final_2020.Codigo_diagnostico)
			$this->Count28consulta_final_2020_Codigo_diagnostico29->HrefValue = "";

			// Codigo_tres
			$this->Codigo_tres->HrefValue = "";

			// Titulo_codigo_tres
			$this->Titulo_codigo_tres->HrefValue = "";

			// Sexo
			$this->Sexo->HrefValue = "";

			// Edad
			$this->Edad->HrefValue = "";

			// Unidad_edad
			$this->Unidad_edad->HrefValue = "";

			// Zona_residencia
			$this->Zona_residencia->HrefValue = "";
		}

		// Call Cell_Rendered event
		if ($this->RowType == EWR_ROWTYPE_TOTAL) { // Summary row
		} else {

			// Count(consulta_final_2020.Codigo_diagnostico)
			$CurrentValue = $this->Count28consulta_final_2020_Codigo_diagnostico29->CurrentValue;
			$ViewValue = &$this->Count28consulta_final_2020_Codigo_diagnostico29->ViewValue;
			$ViewAttrs = &$this->Count28consulta_final_2020_Codigo_diagnostico29->ViewAttrs;
			$CellAttrs = &$this->Count28consulta_final_2020_Codigo_diagnostico29->CellAttrs;
			$HrefValue = &$this->Count28consulta_final_2020_Codigo_diagnostico29->HrefValue;
			$LinkAttrs = &$this->Count28consulta_final_2020_Codigo_diagnostico29->LinkAttrs;
			$this->Cell_Rendered($this->Count28consulta_final_2020_Codigo_diagnostico29, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Codigo_tres
			$CurrentValue = $this->Codigo_tres->CurrentValue;
			$ViewValue = &$this->Codigo_tres->ViewValue;
			$ViewAttrs = &$this->Codigo_tres->ViewAttrs;
			$CellAttrs = &$this->Codigo_tres->CellAttrs;
			$HrefValue = &$this->Codigo_tres->HrefValue;
			$LinkAttrs = &$this->Codigo_tres->LinkAttrs;
			$this->Cell_Rendered($this->Codigo_tres, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Titulo_codigo_tres
			$CurrentValue = $this->Titulo_codigo_tres->CurrentValue;
			$ViewValue = &$this->Titulo_codigo_tres->ViewValue;
			$ViewAttrs = &$this->Titulo_codigo_tres->ViewAttrs;
			$CellAttrs = &$this->Titulo_codigo_tres->CellAttrs;
			$HrefValue = &$this->Titulo_codigo_tres->HrefValue;
			$LinkAttrs = &$this->Titulo_codigo_tres->LinkAttrs;
			$this->Cell_Rendered($this->Titulo_codigo_tres, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Sexo
			$CurrentValue = $this->Sexo->CurrentValue;
			$ViewValue = &$this->Sexo->ViewValue;
			$ViewAttrs = &$this->Sexo->ViewAttrs;
			$CellAttrs = &$this->Sexo->CellAttrs;
			$HrefValue = &$this->Sexo->HrefValue;
			$LinkAttrs = &$this->Sexo->LinkAttrs;
			$this->Cell_Rendered($this->Sexo, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Edad
			$CurrentValue = $this->Edad->CurrentValue;
			$ViewValue = &$this->Edad->ViewValue;
			$ViewAttrs = &$this->Edad->ViewAttrs;
			$CellAttrs = &$this->Edad->CellAttrs;
			$HrefValue = &$this->Edad->HrefValue;
			$LinkAttrs = &$this->Edad->LinkAttrs;
			$this->Cell_Rendered($this->Edad, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Unidad_edad
			$CurrentValue = $this->Unidad_edad->CurrentValue;
			$ViewValue = &$this->Unidad_edad->ViewValue;
			$ViewAttrs = &$this->Unidad_edad->ViewAttrs;
			$CellAttrs = &$this->Unidad_edad->CellAttrs;
			$HrefValue = &$this->Unidad_edad->HrefValue;
			$LinkAttrs = &$this->Unidad_edad->LinkAttrs;
			$this->Cell_Rendered($this->Unidad_edad, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);

			// Zona_residencia
			$CurrentValue = $this->Zona_residencia->CurrentValue;
			$ViewValue = &$this->Zona_residencia->ViewValue;
			$ViewAttrs = &$this->Zona_residencia->ViewAttrs;
			$CellAttrs = &$this->Zona_residencia->CellAttrs;
			$HrefValue = &$this->Zona_residencia->HrefValue;
			$LinkAttrs = &$this->Zona_residencia->LinkAttrs;
			$this->Cell_Rendered($this->Zona_residencia, $CurrentValue, $ViewValue, $ViewAttrs, $CellAttrs, $HrefValue, $LinkAttrs);
		}

		// Call Row_Rendered event
		$this->Row_Rendered();
		$this->SetupFieldCount();
	}

	// Setup field count
	function SetupFieldCount() {
		$this->GrpFldCount = 0;
		$this->SubGrpFldCount = 0;
		$this->DtlFldCount = 0;
		if ($this->Count28consulta_final_2020_Codigo_diagnostico29->Visible) $this->DtlFldCount += 1;
		if ($this->Codigo_tres->Visible) $this->DtlFldCount += 1;
		if ($this->Titulo_codigo_tres->Visible) $this->DtlFldCount += 1;
		if ($this->Sexo->Visible) $this->DtlFldCount += 1;
		if ($this->Edad->Visible) $this->DtlFldCount += 1;
		if ($this->Unidad_edad->Visible) $this->DtlFldCount += 1;
		if ($this->Zona_residencia->Visible) $this->DtlFldCount += 1;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $ReportBreadcrumb;
		$ReportBreadcrumb = new crBreadcrumb();
		$url = substr(ewr_CurrentUrl(), strrpos(ewr_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$ReportBreadcrumb->Add("rpt", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	function SetupExportOptionsExt() {
		global $ReportLanguage;
		$item =& $this->ExportOptions->GetItem("pdf");
		$item->Visible = TRUE;
		$exportid = session_id();
		$url = $this->ExportPdfUrl;
		$item->Body = "<a title=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" data-caption=\"" . ewr_HtmlEncode($ReportLanguage->Phrase("ExportToPDF", TRUE)) . "\" href=\"javascript:void(0);\" onclick=\"ewr_ExportCharts(this, '" . $url . "', '" . $exportid . "');\">" . $ReportLanguage->Phrase("ExportToPDF") . "</a>";
	}

	// Return extended filter
	function GetExtendedFilter() {
		global $gsFormError;
		$sFilter = "";
		if ($this->DrillDown)
			return "";
		$bPostBack = ewr_IsHttpPost();
		$bRestoreSession = TRUE;
		$bSetupFilter = FALSE;

		// Reset extended filter if filter changed
		if ($bPostBack) {

		// Reset search command
		} elseif (@$_GET["cmd"] == "reset") {

			// Load default values
			$this->SetSessionFilterValues($this->Codigo_tres->SearchValue, $this->Codigo_tres->SearchOperator, $this->Codigo_tres->SearchCondition, $this->Codigo_tres->SearchValue2, $this->Codigo_tres->SearchOperator2, 'Codigo_tres'); // Field Codigo_tres
			$this->SetSessionDropDownValue($this->Sexo->DropDownValue, 'Sexo'); // Field Sexo
			$this->SetSessionFilterValues($this->Edad->SearchValue, $this->Edad->SearchOperator, $this->Edad->SearchCondition, $this->Edad->SearchValue2, $this->Edad->SearchOperator2, 'Edad'); // Field Edad
			$this->SetSessionDropDownValue($this->Unidad_edad->DropDownValue, 'Unidad_edad'); // Field Unidad_edad
			$this->SetSessionDropDownValue($this->Zona_residencia->DropDownValue, 'Zona_residencia'); // Field Zona_residencia

			//$bSetupFilter = TRUE; // No need to set up, just use default
		} else {
			$bRestoreSession = !$this->SearchCommand;

			// Field Codigo_tres
			if ($this->GetFilterValues($this->Codigo_tres)) {
				$bSetupFilter = TRUE;
			}

			// Field Sexo
			if ($this->GetDropDownValue($this->Sexo->DropDownValue, 'Sexo')) {
				$bSetupFilter = TRUE;
			} elseif ($this->Sexo->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_filtro_2019_consulta_Sexo'])) {
				$bSetupFilter = TRUE;
			}

			// Field Edad
			if ($this->GetFilterValues($this->Edad)) {
				$bSetupFilter = TRUE;
			}

			// Field Unidad_edad
			if ($this->GetDropDownValue($this->Unidad_edad->DropDownValue, 'Unidad_edad')) {
				$bSetupFilter = TRUE;
			} elseif ($this->Unidad_edad->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_filtro_2019_consulta_Unidad_edad'])) {
				$bSetupFilter = TRUE;
			}

			// Field Zona_residencia
			if ($this->GetDropDownValue($this->Zona_residencia->DropDownValue, 'Zona_residencia')) {
				$bSetupFilter = TRUE;
			} elseif ($this->Zona_residencia->DropDownValue <> EWR_INIT_VALUE && !isset($_SESSION['sv_filtro_2019_consulta_Zona_residencia'])) {
				$bSetupFilter = TRUE;
			}
			if (!$this->ValidateForm()) {
				$this->setFailureMessage($gsFormError);
				return $sFilter;
			}
		}

		// Restore session
		if ($bRestoreSession) {
			$this->GetSessionFilterValues($this->Codigo_tres); // Field Codigo_tres
			$this->GetSessionDropDownValue($this->Sexo); // Field Sexo
			$this->GetSessionFilterValues($this->Edad); // Field Edad
			$this->GetSessionDropDownValue($this->Unidad_edad); // Field Unidad_edad
			$this->GetSessionDropDownValue($this->Zona_residencia); // Field Zona_residencia
		}

		// Call page filter validated event
		$this->Page_FilterValidated();

		// Build SQL
		$this->BuildExtendedFilter($this->Codigo_tres, $sFilter, FALSE, TRUE); // Field Codigo_tres
		$this->BuildDropDownFilter($this->Sexo, $sFilter, "", FALSE, TRUE); // Field Sexo
		$this->BuildExtendedFilter($this->Edad, $sFilter, FALSE, TRUE); // Field Edad
		$this->BuildDropDownFilter($this->Unidad_edad, $sFilter, "", FALSE, TRUE); // Field Unidad_edad
		$this->BuildDropDownFilter($this->Zona_residencia, $sFilter, "", FALSE, TRUE); // Field Zona_residencia

		// Save parms to session
		$this->SetSessionFilterValues($this->Codigo_tres->SearchValue, $this->Codigo_tres->SearchOperator, $this->Codigo_tres->SearchCondition, $this->Codigo_tres->SearchValue2, $this->Codigo_tres->SearchOperator2, 'Codigo_tres'); // Field Codigo_tres
		$this->SetSessionDropDownValue($this->Sexo->DropDownValue, 'Sexo'); // Field Sexo
		$this->SetSessionFilterValues($this->Edad->SearchValue, $this->Edad->SearchOperator, $this->Edad->SearchCondition, $this->Edad->SearchValue2, $this->Edad->SearchOperator2, 'Edad'); // Field Edad
		$this->SetSessionDropDownValue($this->Unidad_edad->DropDownValue, 'Unidad_edad'); // Field Unidad_edad
		$this->SetSessionDropDownValue($this->Zona_residencia->DropDownValue, 'Zona_residencia'); // Field Zona_residencia

		// Setup filter
		if ($bSetupFilter) {
		}

		// Field Sexo
		ewr_LoadDropDownList($this->Sexo->DropDownList, $this->Sexo->DropDownValue);

		// Field Unidad_edad
		ewr_LoadDropDownList($this->Unidad_edad->DropDownList, $this->Unidad_edad->DropDownValue);

		// Field Zona_residencia
		ewr_LoadDropDownList($this->Zona_residencia->DropDownList, $this->Zona_residencia->DropDownValue);
		return $sFilter;
	}

	// Build dropdown filter
	function BuildDropDownFilter(&$fld, &$FilterClause, $FldOpr, $Default = FALSE, $SaveFilter = FALSE) {
		$FldVal = ($Default) ? $fld->DefaultDropDownValue : $fld->DropDownValue;
		$sSql = "";
		if (is_array($FldVal)) {
			foreach ($FldVal as $val) {
				$sWrk = $this->GetDropDownFilter($fld, $val, $FldOpr);

				// Call Page Filtering event
				if (substr($val, 0, 2) <> "@@") $this->Page_Filtering($fld, $sWrk, "dropdown", $FldOpr, $val);
				if ($sWrk <> "") {
					if ($sSql <> "")
						$sSql .= " OR " . $sWrk;
					else
						$sSql = $sWrk;
				}
			}
		} else {
			$sSql = $this->GetDropDownFilter($fld, $FldVal, $FldOpr);

			// Call Page Filtering event
			if (substr($FldVal, 0, 2) <> "@@") $this->Page_Filtering($fld, $sSql, "dropdown", $FldOpr, $FldVal);
		}
		if ($sSql <> "") {
			ewr_AddFilter($FilterClause, $sSql);
			if ($SaveFilter) $fld->CurrentFilter = $sSql;
		}
	}

	function GetDropDownFilter(&$fld, $FldVal, $FldOpr) {
		$FldName = $fld->FldName;
		$FldExpression = $fld->FldExpression;
		$FldDataType = $fld->FldDataType;
		$FldDelimiter = $fld->FldDelimiter;
		$FldVal = strval($FldVal);
		$sWrk = "";
		if ($FldVal == EWR_NULL_VALUE) {
			$sWrk = $FldExpression . " IS NULL";
		} elseif ($FldVal == EWR_NOT_NULL_VALUE) {
			$sWrk = $FldExpression . " IS NOT NULL";
		} elseif ($FldVal == EWR_EMPTY_VALUE) {
			$sWrk = $FldExpression . " = ''";
		} elseif ($FldVal == EWR_ALL_VALUE) {
			$sWrk = "1 = 1";
		} else {
			if (substr($FldVal, 0, 2) == "@@") {
				$sWrk = $this->GetCustomFilter($fld, $FldVal);
			} elseif ($FldDelimiter <> "" && trim($FldVal) <> "") {
				$sWrk = ewr_GetMultiSearchSql($FldExpression, trim($FldVal));
			} else {
				if ($FldVal <> "" && $FldVal <> EWR_INIT_VALUE) {
					if ($FldDataType == EWR_DATATYPE_DATE && $FldOpr <> "") {
						$sWrk = ewr_DateFilterString($FldExpression, $FldOpr, $FldVal, $FldDataType);
					} else {
						$sWrk = ewr_FilterString("=", $FldVal, $FldDataType);
						if ($sWrk <> "") $sWrk = $FldExpression . $sWrk;
					}
				}
			}
		}
		return $sWrk;
	}

	// Get custom filter
	function GetCustomFilter(&$fld, $FldVal) {
		$sWrk = "";
		if (is_array($fld->AdvancedFilters)) {
			foreach ($fld->AdvancedFilters as $filter) {
				if ($filter->ID == $FldVal && $filter->Enabled) {
					$sFld = $fld->FldExpression;
					$sFn = $filter->FunctionName;
					$wrkid = (substr($filter->ID,0,2) == "@@") ? substr($filter->ID,2) : $filter->ID;
					if ($sFn <> "")
						$sWrk = $sFn($sFld);
					else
						$sWrk = "";
					$this->Page_Filtering($fld, $sWrk, "custom", $wrkid);
					break;
				}
			}
		}
		return $sWrk;
	}

	// Build extended filter
	function BuildExtendedFilter(&$fld, &$FilterClause, $Default = FALSE, $SaveFilter = FALSE) {
		$sWrk = ewr_GetExtendedFilter($fld, $Default);
		if (!$Default)
			$this->Page_Filtering($fld, $sWrk, "extended", $fld->SearchOperator, $fld->SearchValue, $fld->SearchCondition, $fld->SearchOperator2, $fld->SearchValue2);
		if ($sWrk <> "") {
			ewr_AddFilter($FilterClause, $sWrk);
			if ($SaveFilter) $fld->CurrentFilter = $sWrk;
		}
	}

	// Get drop down value from querystring
	function GetDropDownValue(&$sv, $parm) {
		if (ewr_IsHttpPost())
			return FALSE; // Skip post back
		if (isset($_GET["sv_$parm"])) {
			$sv = ewr_StripSlashes(@$_GET["sv_$parm"]);
			return TRUE;
		}
		return FALSE;
	}

	// Get filter values from querystring
	function GetFilterValues(&$fld) {
		$parm = substr($fld->FldVar, 2);
		if (ewr_IsHttpPost())
			return; // Skip post back
		$got = FALSE;
		if (isset($_GET["sv_$parm"])) {
			$fld->SearchValue = ewr_StripSlashes(@$_GET["sv_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["so_$parm"])) {
			$fld->SearchOperator = ewr_StripSlashes(@$_GET["so_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["sc_$parm"])) {
			$fld->SearchCondition = ewr_StripSlashes(@$_GET["sc_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["sv2_$parm"])) {
			$fld->SearchValue2 = ewr_StripSlashes(@$_GET["sv2_$parm"]);
			$got = TRUE;
		}
		if (isset($_GET["so2_$parm"])) {
			$fld->SearchOperator2 = ewr_StripSlashes($_GET["so2_$parm"]);
			$got = TRUE;
		}
		return $got;
	}

	// Set default ext filter
	function SetDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2) {
		$fld->DefaultSearchValue = $sv1; // Default ext filter value 1
		$fld->DefaultSearchValue2 = $sv2; // Default ext filter value 2 (if operator 2 is enabled)
		$fld->DefaultSearchOperator = $so1; // Default search operator 1
		$fld->DefaultSearchOperator2 = $so2; // Default search operator 2 (if operator 2 is enabled)
		$fld->DefaultSearchCondition = $sc; // Default search condition (if operator 2 is enabled)
	}

	// Apply default ext filter
	function ApplyDefaultExtFilter(&$fld) {
		$fld->SearchValue = $fld->DefaultSearchValue;
		$fld->SearchValue2 = $fld->DefaultSearchValue2;
		$fld->SearchOperator = $fld->DefaultSearchOperator;
		$fld->SearchOperator2 = $fld->DefaultSearchOperator2;
		$fld->SearchCondition = $fld->DefaultSearchCondition;
	}

	// Check if Text Filter applied
	function TextFilterApplied(&$fld) {
		return (strval($fld->SearchValue) <> strval($fld->DefaultSearchValue) ||
			strval($fld->SearchValue2) <> strval($fld->DefaultSearchValue2) ||
			(strval($fld->SearchValue) <> "" &&
				strval($fld->SearchOperator) <> strval($fld->DefaultSearchOperator)) ||
			(strval($fld->SearchValue2) <> "" &&
				strval($fld->SearchOperator2) <> strval($fld->DefaultSearchOperator2)) ||
			strval($fld->SearchCondition) <> strval($fld->DefaultSearchCondition));
	}

	// Check if Non-Text Filter applied
	function NonTextFilterApplied(&$fld) {
		if (is_array($fld->DropDownValue)) {
			if (is_array($fld->DefaultDropDownValue)) {
				if (count($fld->DefaultDropDownValue) <> count($fld->DropDownValue))
					return TRUE;
				else
					return (count(array_diff($fld->DefaultDropDownValue, $fld->DropDownValue)) <> 0);
			} else {
				return TRUE;
			}
		} else {
			if (is_array($fld->DefaultDropDownValue))
				return TRUE;
			else
				$v1 = strval($fld->DefaultDropDownValue);
			if ($v1 == EWR_INIT_VALUE)
				$v1 = "";
			$v2 = strval($fld->DropDownValue);
			if ($v2 == EWR_INIT_VALUE || $v2 == EWR_ALL_VALUE)
				$v2 = "";
			return ($v1 <> $v2);
		}
	}

	// Get dropdown value from session
	function GetSessionDropDownValue(&$fld) {
		$parm = substr($fld->FldVar, 2);
		$this->GetSessionValue($fld->DropDownValue, 'sv_filtro_2019_consulta_' . $parm);
	}

	// Get filter values from session
	function GetSessionFilterValues(&$fld) {
		$parm = substr($fld->FldVar, 2);
		$this->GetSessionValue($fld->SearchValue, 'sv_filtro_2019_consulta_' . $parm);
		$this->GetSessionValue($fld->SearchOperator, 'so_filtro_2019_consulta_' . $parm);
		$this->GetSessionValue($fld->SearchCondition, 'sc_filtro_2019_consulta_' . $parm);
		$this->GetSessionValue($fld->SearchValue2, 'sv2_filtro_2019_consulta_' . $parm);
		$this->GetSessionValue($fld->SearchOperator2, 'so2_filtro_2019_consulta_' . $parm);
	}

	// Get value from session
	function GetSessionValue(&$sv, $sn) {
		if (array_key_exists($sn, $_SESSION))
			$sv = $_SESSION[$sn];
	}

	// Set dropdown value to session
	function SetSessionDropDownValue($sv, $parm) {
		$_SESSION['sv_filtro_2019_consulta_' . $parm] = $sv;
	}

	// Set filter values to session
	function SetSessionFilterValues($sv1, $so1, $sc, $sv2, $so2, $parm) {
		$_SESSION['sv_filtro_2019_consulta_' . $parm] = $sv1;
		$_SESSION['so_filtro_2019_consulta_' . $parm] = $so1;
		$_SESSION['sc_filtro_2019_consulta_' . $parm] = $sc;
		$_SESSION['sv2_filtro_2019_consulta_' . $parm] = $sv2;
		$_SESSION['so2_filtro_2019_consulta_' . $parm] = $so2;
	}

	// Check if has Session filter values
	function HasSessionFilterValues($parm) {
		return ((@$_SESSION['sv_' . $parm] <> "" && @$_SESSION['sv_' . $parm] <> EWR_INIT_VALUE) ||
			(@$_SESSION['sv_' . $parm] <> "" && @$_SESSION['sv_' . $parm] <> EWR_INIT_VALUE) ||
			(@$_SESSION['sv2_' . $parm] <> "" && @$_SESSION['sv2_' . $parm] <> EWR_INIT_VALUE));
	}

	// Dropdown filter exist
	function DropDownFilterExist(&$fld, $FldOpr) {
		$sWrk = "";
		$this->BuildDropDownFilter($fld, $sWrk, $FldOpr);
		return ($sWrk <> "");
	}

	// Extended filter exist
	function ExtendedFilterExist(&$fld) {
		$sExtWrk = "";
		$this->BuildExtendedFilter($fld, $sExtWrk);
		return ($sExtWrk <> "");
	}

	// Validate form
	function ValidateForm() {
		global $ReportLanguage, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EWR_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ewr_CheckInteger($this->Edad->SearchValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= $this->Edad->FldErrMsg();
		}
		if (!ewr_CheckInteger($this->Edad->SearchValue2)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= $this->Edad->FldErrMsg();
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			$gsFormError .= ($gsFormError <> "") ? "<p>&nbsp;</p>" : "";
			$gsFormError .= $sFormCustomError;
		}
		return $ValidateForm;
	}

	// Clear selection stored in session
	function ClearSessionSelection($parm) {
		$_SESSION["sel_filtro_2019_consulta_$parm"] = "";
		$_SESSION["rf_filtro_2019_consulta_$parm"] = "";
		$_SESSION["rt_filtro_2019_consulta_$parm"] = "";
	}

	// Load selection from session
	function LoadSelectionFromSession($parm) {
		$fld = &$this->fields($parm);
		$fld->SelectionList = @$_SESSION["sel_filtro_2019_consulta_$parm"];
		$fld->RangeFrom = @$_SESSION["rf_filtro_2019_consulta_$parm"];
		$fld->RangeTo = @$_SESSION["rt_filtro_2019_consulta_$parm"];
	}

	// Load default value for filters
	function LoadDefaultFilters() {

		/**
		* Set up default values for non Text filters
		*/

		// Field Sexo
		$this->Sexo->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->Sexo->DropDownValue = $this->Sexo->DefaultDropDownValue;

		// Field Unidad_edad
		$this->Unidad_edad->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->Unidad_edad->DropDownValue = $this->Unidad_edad->DefaultDropDownValue;

		// Field Zona_residencia
		$this->Zona_residencia->DefaultDropDownValue = EWR_INIT_VALUE;
		if (!$this->SearchCommand) $this->Zona_residencia->DropDownValue = $this->Zona_residencia->DefaultDropDownValue;

		/**
		* Set up default values for extended filters
		* function SetDefaultExtFilter(&$fld, $so1, $sv1, $sc, $so2, $sv2)
		* Parameters:
		* $fld - Field object
		* $so1 - Default search operator 1
		* $sv1 - Default ext filter value 1
		* $sc - Default search condition (if operator 2 is enabled)
		* $so2 - Default search operator 2 (if operator 2 is enabled)
		* $sv2 - Default ext filter value 2 (if operator 2 is enabled)
		*/

		// Field Codigo_tres
		$this->SetDefaultExtFilter($this->Codigo_tres, "=", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand) $this->ApplyDefaultExtFilter($this->Codigo_tres);

		// Field Edad
		$this->SetDefaultExtFilter($this->Edad, "BETWEEN", NULL, 'AND', "=", NULL);
		if (!$this->SearchCommand) $this->ApplyDefaultExtFilter($this->Edad);

		/**
		* Set up default values for popup filters
		*/
	}

	// Check if filter applied
	function CheckFilter() {

		// Check Codigo_tres text filter
		if ($this->TextFilterApplied($this->Codigo_tres))
			return TRUE;

		// Check Sexo extended filter
		if ($this->NonTextFilterApplied($this->Sexo))
			return TRUE;

		// Check Edad text filter
		if ($this->TextFilterApplied($this->Edad))
			return TRUE;

		// Check Unidad_edad extended filter
		if ($this->NonTextFilterApplied($this->Unidad_edad))
			return TRUE;

		// Check Zona_residencia extended filter
		if ($this->NonTextFilterApplied($this->Zona_residencia))
			return TRUE;
		return FALSE;
	}

	// Show list of filters
	function ShowFilterList() {
		global $ReportLanguage;

		// Initialize
		$sFilterList = "";

		// Field Codigo_tres
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildExtendedFilter($this->Codigo_tres, $sExtWrk);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Codigo_tres->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field Sexo
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->Sexo, $sExtWrk, "");
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Sexo->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field Edad
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildExtendedFilter($this->Edad, $sExtWrk);
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Edad->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field Unidad_edad
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->Unidad_edad, $sExtWrk, "");
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Unidad_edad->FldCaption() . "</span>" . $sFilter . "</div>";

		// Field Zona_residencia
		$sExtWrk = "";
		$sWrk = "";
		$this->BuildDropDownFilter($this->Zona_residencia, $sExtWrk, "");
		$sFilter = "";
		if ($sExtWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sExtWrk</span>";
		elseif ($sWrk <> "")
			$sFilter .= "<span class=\"ewFilterValue\">$sWrk</span>";
		if ($sFilter <> "")
			$sFilterList .= "<div><span class=\"ewFilterCaption\">" . $this->Zona_residencia->FldCaption() . "</span>" . $sFilter . "</div>";
		$divstyle = "";
		$divdataclass = "";

		// Show Filters
		if ($sFilterList <> "") {
			$sMessage = "<div class=\"ewDisplayTable\"" . $divstyle . "><div id=\"ewrFilterList\" class=\"alert alert-info\"" . $divdataclass . "><div id=\"ewrCurrentFilters\">" . $ReportLanguage->Phrase("CurrentFilters") . "</div>" . $sFilterList . "</div></div>";
			$this->Message_Showing($sMessage, "");
			echo $sMessage;
		}
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";

		// Field Codigo_tres
		$sWrk = "";
		if ($this->Codigo_tres->SearchValue <> "" || $this->Codigo_tres->SearchValue2 <> "") {
			$sWrk = "\"sv_Codigo_tres\":\"" . ewr_JsEncode2($this->Codigo_tres->SearchValue) . "\"," .
			$sWrk = "\"so_Codigo_tres\":\"" . ewr_JsEncode2($this->Codigo_tres->SearchOperator) . "\"," .
			$sWrk = "\"sc_Codigo_tres\":\"" . ewr_JsEncode2($this->Codigo_tres->SearchCondition) . "\"," .
			$sWrk = "\"sv2_Codigo_tres\":\"" . ewr_JsEncode2($this->Codigo_tres->SearchValue2) . "\"," .
			$sWrk = "\"so2_Codigo_tres\":\"" . ewr_JsEncode2($this->Codigo_tres->SearchOperator2) . "\"";
		}
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field Sexo
		$sWrk = "";
		$sWrk = ($this->Sexo->DropDownValue <> EWR_INIT_VALUE) ? $this->Sexo->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_Sexo\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field Edad
		$sWrk = "";
		if ($this->Edad->SearchValue <> "" || $this->Edad->SearchValue2 <> "") {
			$sWrk = "\"sv_Edad\":\"" . ewr_JsEncode2($this->Edad->SearchValue) . "\"," .
			$sWrk = "\"so_Edad\":\"" . ewr_JsEncode2($this->Edad->SearchOperator) . "\"," .
			$sWrk = "\"sc_Edad\":\"" . ewr_JsEncode2($this->Edad->SearchCondition) . "\"," .
			$sWrk = "\"sv2_Edad\":\"" . ewr_JsEncode2($this->Edad->SearchValue2) . "\"," .
			$sWrk = "\"so2_Edad\":\"" . ewr_JsEncode2($this->Edad->SearchOperator2) . "\"";
		}
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field Unidad_edad
		$sWrk = "";
		$sWrk = ($this->Unidad_edad->DropDownValue <> EWR_INIT_VALUE) ? $this->Unidad_edad->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_Unidad_edad\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Field Zona_residencia
		$sWrk = "";
		$sWrk = ($this->Zona_residencia->DropDownValue <> EWR_INIT_VALUE) ? $this->Zona_residencia->DropDownValue : "";
		if (is_array($sWrk))
			$sWrk = implode("||", $sWrk);
		if ($sWrk <> "")
			$sWrk = "\"sv_Zona_residencia\":\"" . ewr_JsEncode2($sWrk) . "\"";
		if ($sWrk <> "") {
			if ($sFilterList <> "") $sFilterList .= ",";
			$sFilterList .= $sWrk;
		}

		// Return filter list in json
		if ($sFilterList <> "")
			return "{" . $sFilterList . "}";
		else
			return "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ewr_StripSlashes(@$_POST["filter"]), TRUE);

		// Field Codigo_tres
		if (array_key_exists("sv_Codigo_tres", $filter) || array_key_exists("so_Codigo_tres", $filter) ||
			array_key_exists("sc_Codigo_tres", $filter) ||
			array_key_exists("sv2_Codigo_tres", $filter) || array_key_exists("so2_Codigo_tres", $filter))
			$this->SetSessionFilterValues(@$filter["sv_Codigo_tres"], @$filter["so_Codigo_tres"], @$filter["sc_Codigo_tres"], @$filter["sv2_Codigo_tres"], @$filter["so2_Codigo_tres"], "Codigo_tres");

		// Field Sexo
		if (array_key_exists("sv_Sexo", $filter)) {
			$sWrk = $filter["sv_Sexo"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, "Sexo");
		}

		// Field Edad
		if (array_key_exists("sv_Edad", $filter) || array_key_exists("so_Edad", $filter) ||
			array_key_exists("sc_Edad", $filter) ||
			array_key_exists("sv2_Edad", $filter) || array_key_exists("so2_Edad", $filter))
			$this->SetSessionFilterValues(@$filter["sv_Edad"], @$filter["so_Edad"], @$filter["sc_Edad"], @$filter["sv2_Edad"], @$filter["so2_Edad"], "Edad");

		// Field Unidad_edad
		if (array_key_exists("sv_Unidad_edad", $filter)) {
			$sWrk = $filter["sv_Unidad_edad"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, "Unidad_edad");
		}

		// Field Zona_residencia
		if (array_key_exists("sv_Zona_residencia", $filter)) {
			$sWrk = $filter["sv_Zona_residencia"];
			if (strpos($sWrk, "||") !== FALSE)
				$sWrk = explode("||", $sWrk);
			$this->SetSessionDropDownValue($sWrk, "Zona_residencia");
		}
	}

	// Return popup filter
	function GetPopupFilter() {
		$sWrk = "";
		if ($this->DrillDown)
			return "";
		return $sWrk;
	}

	//-------------------------------------------------------------------------------
	// Function GetSort
	// - Return Sort parameters based on Sort Links clicked
	// - Variables setup: Session[EWR_TABLE_SESSION_ORDER_BY], Session["sort_Table_Field"]
	function GetSort() {
		if ($this->DrillDown)
			return "";

		// Check for a resetsort command
		if (strlen(@$_GET["cmd"]) > 0) {
			$sCmd = @$_GET["cmd"];
			if ($sCmd == "resetsort") {
				$this->setOrderBy("");
				$this->setStartGroup(1);
				$this->Count28consulta_final_2020_Codigo_diagnostico29->setSort("");
				$this->Codigo_tres->setSort("");
				$this->Titulo_codigo_tres->setSort("");
				$this->Sexo->setSort("");
				$this->Edad->setSort("");
				$this->Unidad_edad->setSort("");
				$this->Zona_residencia->setSort("");
			}

		// Check for an Order parameter
		} elseif (@$_GET["order"] <> "") {
			$this->CurrentOrder = ewr_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$sSortSql = $this->SortSql();
			$this->setOrderBy($sSortSql);
			$this->setStartGroup(1);
		}
		return $this->getOrderBy();
	}

	// Export to WORD
	function ExportWord($html) {
		global $gsExportFile;
		header('Content-Type: application/vnd.ms-word' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		header('Content-Disposition: attachment; filename=' . $gsExportFile . '.doc');
		echo $html;
	}

	// Export to EXCEL
	function ExportExcel($html) {
		global $gsExportFile;
		header('Content-Type: application/vnd.ms-excel' . (EWR_CHARSET <> '' ? ';charset=' . EWR_CHARSET : ''));
		header('Content-Disposition: attachment; filename=' . $gsExportFile . '.xls');
		echo $html;
	}

	// Export PDF
	function ExportPDF($html) {
		global $gsExportFile;
		include_once "dompdf061/dompdf_config.inc.php";
		@ini_set("memory_limit", EWR_PDF_MEMORY_LIMIT);
		set_time_limit(EWR_PDF_TIME_LIMIT);
		$dompdf = new DOMPDF();
		$dompdf->load_html($html);
		ob_end_clean();
		$dompdf->set_paper("a4", "portrait");
		$dompdf->render();
		ewr_DeleteTmpImages($html);
		$dompdf->stream($gsExportFile . ".pdf", array("Attachment" => 1)); // 0 to open in browser, 1 to download

//		exit();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ewr_Header(FALSE) ?>
<?php

// Create page object
if (!isset($filtro_2019_consulta_rpt)) $filtro_2019_consulta_rpt = new crfiltro_2019_consulta_rpt();
if (isset($Page)) $OldPage = $Page;
$Page = &$filtro_2019_consulta_rpt;

// Page init
$Page->Page_Init();

// Page main
$Page->Page_Main();

// Global Page Rendering event (in ewrusrfn*.php)
Page_Rendering();

// Page Rendering event
$Page->Page_Render();
?>
<?php include_once "phprptinc/header.php" ?>
<?php if ($Page->Export == "") { ?>
<script type="text/javascript">

// Create page object
var filtro_2019_consulta_rpt = new ewr_Page("filtro_2019_consulta_rpt");

// Page properties
filtro_2019_consulta_rpt.PageID = "rpt"; // Page ID
var EWR_PAGE_ID = filtro_2019_consulta_rpt.PageID;

// Extend page with Chart_Rendering function
filtro_2019_consulta_rpt.Chart_Rendering = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }

// Extend page with Chart_Rendered function
filtro_2019_consulta_rpt.Chart_Rendered = 
 function(chart, chartid) { // DO NOT CHANGE THIS LINE!

 	//alert(chartid);
 }
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Form object
var ffiltro_2019_consultarpt = new ewr_Form("ffiltro_2019_consultarpt");

// Validate method
ffiltro_2019_consultarpt.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	var elm = fobj.sv_Edad;
	if (elm && !ewr_CheckInteger(elm.value)) {
		if (!this.OnError(elm, "<?php echo ewr_JsEncode2($Page->Edad->FldErrMsg()) ?>"))
			return false;
	}
	var elm = fobj.sv2_Edad;
	if (elm && !ewr_CheckInteger(elm.value)) {
		if (!this.OnError(elm, "<?php echo ewr_JsEncode2($Page->Edad->FldErrMsg()) ?>"))
			return false;
	}

	// Call Form Custom Validate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate method
ffiltro_2019_consultarpt.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }
<?php if (EWR_CLIENT_VALIDATE) { ?>
ffiltro_2019_consultarpt.ValidateRequired = true; // Uses JavaScript validation
<?php } else { ?>
ffiltro_2019_consultarpt.ValidateRequired = false; // No JavaScript validation
<?php } ?>

// Use Ajax
ffiltro_2019_consultarpt.Lists["sv_Codigo_tres"] = {"LinkField":"sv_Codigo_tres","Ajax":true,"DisplayFields":["sv_Codigo_tres","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
ffiltro_2019_consultarpt.Lists["sv_Sexo[]"] = {"LinkField":"sv_Sexo","Ajax":true,"DisplayFields":["sv_Sexo","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
ffiltro_2019_consultarpt.Lists["sv_Unidad_edad"] = {"LinkField":"sv_Unidad_edad","Ajax":true,"DisplayFields":["sv_Unidad_edad","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
ffiltro_2019_consultarpt.Lists["sv_Zona_residencia"] = {"LinkField":"sv_Zona_residencia","Ajax":true,"DisplayFields":["sv_Zona_residencia","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
</script>
<?php } ?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if ($Page->Export == "") { ?>
<!-- container (begin) -->
<div id="ewContainer" class="ewContainer">
<!-- top container (begin) -->
<div id="ewTop" class="ewTop">
<a id="top"></a>
<?php } ?>
<!-- top slot -->
<div class="ewToolbar">
<?php if ($Page->Export == "" && (!$Page->DrillDown || !$Page->DrillDownInPanel)) { ?>
<?php if ($ReportBreadcrumb) $ReportBreadcrumb->Render(); ?>
<?php } ?>
<?php
if (!$Page->DrillDownInPanel) {
	$Page->ExportOptions->Render("body");
	$Page->SearchOptions->Render("body");
	$Page->FilterOptions->Render("body");
}
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<?php echo $ReportLanguage->SelectionForm(); ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php $Page->ShowPageHeader(); ?>
<?php $Page->ShowMessage(); ?>
<?php if ($Page->Export == "") { ?>
</div>
<!-- top container (end) -->
	<!-- left container (begin) -->
	<div id="ewLeft" class="ewLeft">
<?php } ?>
	<!-- Left slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- left container (end) -->
	<!-- center container - report (begin) -->
	<div id="ewCenter" class="ewCenter">
<?php } ?>
	<!-- center slot -->
<!-- summary report starts -->
<?php if ($Page->Export <> "pdf") { ?>
<div id="report_summary">
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<!-- Search form (begin) -->
<form name="ffiltro_2019_consultarpt" id="ffiltro_2019_consultarpt" class="form-inline ewForm ewExtFilterForm" action="<?php echo ewr_CurrentPage() ?>">
<?php $SearchPanelClass = ($Page->Filter <> "") ? " in" : " in"; ?>
<div id="ffiltro_2019_consultarpt_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<div id="r_1" class="ewRow">
<div id="c_Codigo_tres" class="ewCell form-group">
	<label class="ewSearchCaption ewLabel"><?php echo $Page->Codigo_tres->FldCaption() ?></label>
	<span class="ewSearchOperator"><?php echo $ReportLanguage->Phrase("="); ?><input type="hidden" name="so_Codigo_tres" id="so_Codigo_tres" value="="></span>
	<span class="control-group ewSearchField">
<?php
	$wrkonchange = trim(" " . @$Page->Codigo_tres->EditAttrs["onchange"]);
	if ($wrkonchange <> "") $wrkonchange = " onchange=\"" . ewr_JsEncode2($wrkonchange) . "\"";
	$Page->Codigo_tres->EditAttrs["onchange"] = "";
	ewr_PrependClass($Page->Codigo_tres->EditAttrs["class"], "form-control"); // PR8
?>
<span id="as_sv_Codigo_tres" style="white-space: nowrap; z-index: 8980">
	<input type="text" id="sx_sv_Codigo_tres" name="sx_sv_Codigo_tres" size="30" maxlength="10" placeholder="<?php echo $Page->Codigo_tres->PlaceHolder ?>" value="<?php echo ewr_HtmlEncode($Page->Codigo_tres->SearchValue) ?>"<?php echo $Page->Codigo_tres->EditAttributes() ?>>
	<span id="sc_sv_Codigo_tres" style="display: inline; z-index: 8980"></span>
</span>
<input type="hidden" id="sv_Codigo_tres" name="sv_Codigo_tres" value="<?php echo ewr_HtmlEncode($Page->Codigo_tres->SearchValue) ?>"<?php echo $wrkonchange ?>>
<?php
$sSqlWrk = "SELECT DISTINCT consulta_final_2020.Codigo_tres, consulta_final_2020.Codigo_tres AS `DispFld` FROM (Select Count(consulta_final_2020.Codigo_diagnostico) As `Count(consulta_final_2020.Codigo_diagnostico)`, consulta_final_2020.Codigo_tres As Codigo_tres, consulta_final_2020.Contador, consulta_final_2020.Titulo_codigo_tres, consulta_final_2020.Sexo, consulta_final_2020.Edad, consulta_final_2020.Unidad_edad, consulta_final_2020.Zona_residencia From consulta_final_2020 Group By consulta_final_2020.Codigo_tres Order By `Count(consulta_final_2020.Codigo_diagnostico)` Desc) AS `EW_TMP_LOOKUPTABLE`";
$sWhereWrk = "consulta_final_2020.Codigo_tres LIKE '{query_value}%'";

// Call Lookup selecting
$Page->Lookup_Selecting($Page->Codigo_tres, $sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " ORDER BY consulta_final_2020.Codigo_tres";
$sSqlWrk .= " LIMIT " . EWR_AUTO_SUGGEST_MAX_ENTRIES;
?>
<input type="hidden" name="q_sv_Codigo_tres" id="q_sv_Codigo_tres" value="s=<?php echo ewr_Encrypt($sSqlWrk) ?>">
<script type="text/javascript">
ffiltro_2019_consultarpt.CreateAutoSuggest("sv_Codigo_tres", false);
</script>
</span>
</div>
</div>
<div id="r_2" class="ewRow">
<div id="c_Sexo" class="ewCell form-group">
	<label class="ewSearchCaption ewLabel"><?php echo $Page->Sexo->FldCaption() ?></label>
	<span class="ewSearchField">
<span id="tp_sv_Sexo" class="<?php echo EWR_ITEM_TEMPLATE_CLASSNAME; ?>"><input type="checkbox" name="sv_Sexo[]" id="sv_Sexo[]" value="{value}"<?php echo $Page->Sexo->EditAttributes() ?>></span>
<span id="dsl_sv_Sexo" data-repeatcolumn="5" class="ewItemList">
<?php
	$cntf = is_array($Page->Sexo->AdvancedFilters) ? count($Page->Sexo->AdvancedFilters) : 0;
	$cntd = is_array($Page->Sexo->DropDownList) ? count($Page->Sexo->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->Sexo->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->Sexo->DropDownValue, $filter->ID) ? " checked=\"checked\"" : "";
?>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 5, 1) ?>
<label><input type="checkbox" name="sv_Sexo[]" value="<?php echo $filter->ID ?>"<?php echo $selwrk ?><?php echo $Page->Sexo->EditAttributes() ?>><?php echo $filter->Name ?></label>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 5, 2) ?>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " checked=\"checked\"";
?>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 5, 1) ?>
<label><input type="checkbox" name="sv_Sexo[]" value="<?php echo $Page->Sexo->DropDownList[$i] ?>"<?php echo $selwrk ?><?php echo $Page->Sexo->EditAttributes() ?>><?php echo ewr_DropDownDisplayValue($Page->Sexo->DropDownList[$i], "", 0) ?></label>
<?php echo ewr_RepeatColumnTable($totcnt, $wrkcnt, 5, 2) ?>
<?php
		$wrkcnt += 1;
	}
?>
</span>
<?php
$sSqlWrk = "SELECT DISTINCT consulta_final_2020.Sexo, consulta_final_2020.Sexo AS `DispFld` FROM (Select Count(consulta_final_2020.Codigo_diagnostico) As `Count(consulta_final_2020.Codigo_diagnostico)`, consulta_final_2020.Codigo_tres As Codigo_tres, consulta_final_2020.Contador, consulta_final_2020.Titulo_codigo_tres, consulta_final_2020.Sexo, consulta_final_2020.Edad, consulta_final_2020.Unidad_edad, consulta_final_2020.Zona_residencia From consulta_final_2020 Group By consulta_final_2020.Codigo_tres Order By `Count(consulta_final_2020.Codigo_diagnostico)` Desc) AS `EW_TMP_LOOKUPTABLE`";
$sWhereWrk = "";

// Call Lookup selecting
$Page->Lookup_Selecting($Page->Sexo, $sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " ORDER BY consulta_final_2020.Sexo";
?>
<input type="hidden" name="s_sv_Sexo" id="s_sv_Sexo" value="s=<?php echo ewr_Encrypt($sSqlWrk) ?>&amp;f0=<?php echo ewr_Encrypt("consulta_final_2020.Sexo = {filter_value}"); ?>&amp;t0=200&amp;ds=&amp;df=0&amp;dlm=<?php echo ewr_Encrypt($Page->Sexo->FldDelimiter) ?>"></span>
</div>
</div>
<div id="r_3" class="ewRow">
<div id="c_Edad" class="ewCell form-group">
	<label for="sv_Edad" class="ewSearchCaption ewLabel"><?php echo $Page->Edad->FldCaption() ?></label>
	<span class="ewSearchOperator"><?php echo $ReportLanguage->Phrase("BETWEEN"); ?><input type="hidden" name="so_Edad" id="so_Edad" value="BETWEEN"></span>
	<span class="control-group ewSearchField">
<?php ewr_PrependClass($Page->Edad->EditAttrs["class"], "form-control"); // PR8 ?>
<input type="text" id="sv_Edad" name="sv_Edad" size="30" placeholder="<?php echo $Page->Edad->PlaceHolder ?>" value="<?php echo ewr_HtmlEncode($Page->Edad->SearchValue) ?>"<?php echo $Page->Edad->EditAttributes() ?>>
</span>
	<span class="ewSearchCond btw1_Edad"><?php echo $ReportLanguage->Phrase("AND") ?></span>
	<span class="ewSearchField btw1_Edad">
<?php ewr_PrependClass($Page->Edad->EditAttrs["class"], "form-control"); // PR8 ?>
<input type="text" id="sv2_Edad" name="sv2_Edad" size="30" placeholder="<?php echo $Page->Edad->PlaceHolder ?>" value="<?php echo ewr_HtmlEncode($Page->Edad->SearchValue2) ?>"<?php echo $Page->Edad->EditAttributes() ?>>
</span>
</div>
</div>
<div id="r_4" class="ewRow">
<div id="c_Unidad_edad" class="ewCell form-group">
	<label for="sv_Unidad_edad" class="ewSearchCaption ewLabel"><?php echo $Page->Unidad_edad->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->Unidad_edad->EditAttrs["class"], "form-control"); ?>
<select id="sv_Unidad_edad" name="sv_Unidad_edad"<?php echo $Page->Unidad_edad->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->Unidad_edad->AdvancedFilters) ? count($Page->Unidad_edad->AdvancedFilters) : 0;
	$cntd = is_array($Page->Unidad_edad->DropDownList) ? count($Page->Unidad_edad->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->Unidad_edad->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->Unidad_edad->DropDownValue, $filter->ID) ? " selected=\"selected\"" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected=\"selected\"";
?>
<option value="<?php echo $Page->Unidad_edad->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->Unidad_edad->DropDownList[$i], "", 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<?php
$sSqlWrk = "SELECT DISTINCT consulta_final_2020.Unidad_edad, consulta_final_2020.Unidad_edad AS `DispFld` FROM (Select Count(consulta_final_2020.Codigo_diagnostico) As `Count(consulta_final_2020.Codigo_diagnostico)`, consulta_final_2020.Codigo_tres As Codigo_tres, consulta_final_2020.Contador, consulta_final_2020.Titulo_codigo_tres, consulta_final_2020.Sexo, consulta_final_2020.Edad, consulta_final_2020.Unidad_edad, consulta_final_2020.Zona_residencia From consulta_final_2020 Group By consulta_final_2020.Codigo_tres Order By `Count(consulta_final_2020.Codigo_diagnostico)` Desc) AS `EW_TMP_LOOKUPTABLE`";
$sWhereWrk = "";

// Call Lookup selecting
$Page->Lookup_Selecting($Page->Unidad_edad, $sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " ORDER BY consulta_final_2020.Unidad_edad";
?>
<input type="hidden" name="s_sv_Unidad_edad" id="s_sv_Unidad_edad" value="s=<?php echo ewr_Encrypt($sSqlWrk) ?>&amp;f0=<?php echo ewr_Encrypt("consulta_final_2020.Unidad_edad = {filter_value}"); ?>&amp;t0=16&amp;ds=&amp;df=0&amp;dlm=<?php echo ewr_Encrypt($Page->Unidad_edad->FldDelimiter) ?>"></span>
</div>
</div>
<div id="r_5" class="ewRow">
<div id="c_Zona_residencia" class="ewCell form-group">
	<label for="sv_Zona_residencia" class="ewSearchCaption ewLabel"><?php echo $Page->Zona_residencia->FldCaption() ?></label>
	<span class="ewSearchField">
<?php ewr_PrependClass($Page->Zona_residencia->EditAttrs["class"], "form-control"); ?>
<select id="sv_Zona_residencia" name="sv_Zona_residencia"<?php echo $Page->Zona_residencia->EditAttributes() ?>>
<option value=""><?php echo $ReportLanguage->Phrase("PleaseSelect") ?></option>
<?php
	$cntf = is_array($Page->Zona_residencia->AdvancedFilters) ? count($Page->Zona_residencia->AdvancedFilters) : 0;
	$cntd = is_array($Page->Zona_residencia->DropDownList) ? count($Page->Zona_residencia->DropDownList) : 0;
	$totcnt = $cntf + $cntd;
	$wrkcnt = 0;
	if ($cntf > 0) {
		foreach ($Page->Zona_residencia->AdvancedFilters as $filter) {
			if ($filter->Enabled) {
				$selwrk = ewr_MatchedFilterValue($Page->Zona_residencia->DropDownValue, $filter->ID) ? " selected=\"selected\"" : "";
?>
<option value="<?php echo $filter->ID ?>"<?php echo $selwrk ?>><?php echo $filter->Name ?></option>
<?php
				$wrkcnt += 1;
			}
		}
	}
	for ($i = 0; $i < $cntd; $i++) {
		$selwrk = " selected=\"selected\"";
?>
<option value="<?php echo $Page->Zona_residencia->DropDownList[$i] ?>"<?php echo $selwrk ?>><?php echo ewr_DropDownDisplayValue($Page->Zona_residencia->DropDownList[$i], "", 0) ?></option>
<?php
		$wrkcnt += 1;
	}
?>
</select>
<?php
$sSqlWrk = "SELECT DISTINCT consulta_final_2020.Zona_residencia, consulta_final_2020.Zona_residencia AS `DispFld` FROM (Select Count(consulta_final_2020.Codigo_diagnostico) As `Count(consulta_final_2020.Codigo_diagnostico)`, consulta_final_2020.Codigo_tres As Codigo_tres, consulta_final_2020.Contador, consulta_final_2020.Titulo_codigo_tres, consulta_final_2020.Sexo, consulta_final_2020.Edad, consulta_final_2020.Unidad_edad, consulta_final_2020.Zona_residencia From consulta_final_2020 Group By consulta_final_2020.Codigo_tres Order By `Count(consulta_final_2020.Codigo_diagnostico)` Desc) AS `EW_TMP_LOOKUPTABLE`";
$sWhereWrk = "";

// Call Lookup selecting
$Page->Lookup_Selecting($Page->Zona_residencia, $sWhereWrk);
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk .= " ORDER BY consulta_final_2020.Zona_residencia";
?>
<input type="hidden" name="s_sv_Zona_residencia" id="s_sv_Zona_residencia" value="s=<?php echo ewr_Encrypt($sSqlWrk) ?>&amp;f0=<?php echo ewr_Encrypt("consulta_final_2020.Zona_residencia = {filter_value}"); ?>&amp;t0=200&amp;ds=&amp;df=0&amp;dlm=<?php echo ewr_Encrypt($Page->Zona_residencia->FldDelimiter) ?>"></span>
</div>
</div>
<div class="ewRow"><input type="submit" name="btnsubmit" id="btnsubmit" class="btn btn-primary" value="<?php echo $ReportLanguage->Phrase("Search") ?>">
<input type="reset" name="btnreset" id="btnreset" class="btn hide" value="<?php echo $ReportLanguage->Phrase("Reset") ?>"></div>
</div>
</form>
<script type="text/javascript">
ffiltro_2019_consultarpt.Init();
ffiltro_2019_consultarpt.FilterList = <?php echo $Page->GetFilterList() ?>;
</script>
<!-- Search form (end) -->
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->ShowFilterList() ?>
<?php } ?>
<?php } ?>
<?php

// Set the last group to display if not export all
if ($Page->ExportAll && $Page->Export <> "") {
	$Page->StopGrp = $Page->TotalGrps;
} else {
	$Page->StopGrp = $Page->StartGrp + $Page->DisplayGrps - 1;
}

// Stop group <= total number of groups
if (intval($Page->StopGrp) > intval($Page->TotalGrps))
	$Page->StopGrp = $Page->TotalGrps;
$Page->RecCount = 0;
$Page->RecIndex = 0;

// Get first row
if ($Page->TotalGrps > 0) {
	$Page->GetRow(1);
	$Page->GrpCount = 1;
}
$Page->GrpIdx = ewr_InitArray(2, -1);
$Page->GrpIdx[0] = -1;
$Page->GrpIdx[1] = $Page->StopGrp - $Page->StartGrp + 1;
while ($rs && !$rs->EOF && $Page->GrpCount <= $Page->DisplayGrps || $Page->ShowHeader) {

	// Show dummy header for custom template
	// Show header

	if ($Page->ShowHeader) {
?>
<?php if ($Page->Export <> "pdf") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<thead>
	<!-- Table header -->
	<tr class="ewTableHeader">
<?php if ($Page->Count28consulta_final_2020_Codigo_diagnostico29->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Count28consulta_final_2020_Codigo_diagnostico29"><div class="filtro_2019_consulta_Count28consulta_final_2020_Codigo_diagnostico29"><span class="ewTableHeaderCaption"><?php echo $Page->Count28consulta_final_2020_Codigo_diagnostico29->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Count28consulta_final_2020_Codigo_diagnostico29">
<?php if ($Page->SortUrl($Page->Count28consulta_final_2020_Codigo_diagnostico29) == "") { ?>
		<div class="ewTableHeaderBtn filtro_2019_consulta_Count28consulta_final_2020_Codigo_diagnostico29">
			<span class="ewTableHeaderCaption"><?php echo $Page->Count28consulta_final_2020_Codigo_diagnostico29->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer filtro_2019_consulta_Count28consulta_final_2020_Codigo_diagnostico29" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Count28consulta_final_2020_Codigo_diagnostico29) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Count28consulta_final_2020_Codigo_diagnostico29->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Count28consulta_final_2020_Codigo_diagnostico29->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Count28consulta_final_2020_Codigo_diagnostico29->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Codigo_tres->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Codigo_tres"><div class="filtro_2019_consulta_Codigo_tres"><span class="ewTableHeaderCaption"><?php echo $Page->Codigo_tres->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Codigo_tres">
<?php if ($Page->SortUrl($Page->Codigo_tres) == "") { ?>
		<div class="ewTableHeaderBtn filtro_2019_consulta_Codigo_tres">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_tres->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer filtro_2019_consulta_Codigo_tres" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Codigo_tres) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Codigo_tres->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Codigo_tres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Codigo_tres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Titulo_codigo_tres->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Titulo_codigo_tres"><div class="filtro_2019_consulta_Titulo_codigo_tres"><span class="ewTableHeaderCaption"><?php echo $Page->Titulo_codigo_tres->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Titulo_codigo_tres">
<?php if ($Page->SortUrl($Page->Titulo_codigo_tres) == "") { ?>
		<div class="ewTableHeaderBtn filtro_2019_consulta_Titulo_codigo_tres">
			<span class="ewTableHeaderCaption"><?php echo $Page->Titulo_codigo_tres->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer filtro_2019_consulta_Titulo_codigo_tres" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Titulo_codigo_tres) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Titulo_codigo_tres->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Titulo_codigo_tres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Titulo_codigo_tres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Sexo->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Sexo"><div class="filtro_2019_consulta_Sexo"><span class="ewTableHeaderCaption"><?php echo $Page->Sexo->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Sexo">
<?php if ($Page->SortUrl($Page->Sexo) == "") { ?>
		<div class="ewTableHeaderBtn filtro_2019_consulta_Sexo">
			<span class="ewTableHeaderCaption"><?php echo $Page->Sexo->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer filtro_2019_consulta_Sexo" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Sexo) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Sexo->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Sexo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Sexo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Edad->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Edad"><div class="filtro_2019_consulta_Edad"><span class="ewTableHeaderCaption"><?php echo $Page->Edad->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Edad">
<?php if ($Page->SortUrl($Page->Edad) == "") { ?>
		<div class="ewTableHeaderBtn filtro_2019_consulta_Edad">
			<span class="ewTableHeaderCaption"><?php echo $Page->Edad->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer filtro_2019_consulta_Edad" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Edad) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Edad->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Unidad_edad->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Unidad_edad"><div class="filtro_2019_consulta_Unidad_edad"><span class="ewTableHeaderCaption"><?php echo $Page->Unidad_edad->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Unidad_edad">
<?php if ($Page->SortUrl($Page->Unidad_edad) == "") { ?>
		<div class="ewTableHeaderBtn filtro_2019_consulta_Unidad_edad">
			<span class="ewTableHeaderCaption"><?php echo $Page->Unidad_edad->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer filtro_2019_consulta_Unidad_edad" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Unidad_edad) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Unidad_edad->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Unidad_edad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Unidad_edad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
<?php if ($Page->Zona_residencia->Visible) { ?>
<?php if ($Page->Export <> "" || $Page->DrillDown) { ?>
	<td data-field="Zona_residencia"><div class="filtro_2019_consulta_Zona_residencia"><span class="ewTableHeaderCaption"><?php echo $Page->Zona_residencia->FldCaption() ?></span></div></td>
<?php } else { ?>
	<td data-field="Zona_residencia">
<?php if ($Page->SortUrl($Page->Zona_residencia) == "") { ?>
		<div class="ewTableHeaderBtn filtro_2019_consulta_Zona_residencia">
			<span class="ewTableHeaderCaption"><?php echo $Page->Zona_residencia->FldCaption() ?></span>
		</div>
<?php } else { ?>
		<div class="ewTableHeaderBtn ewPointer filtro_2019_consulta_Zona_residencia" onclick="ewr_Sort(event,'<?php echo $Page->SortUrl($Page->Zona_residencia) ?>',0);">
			<span class="ewTableHeaderCaption"><?php echo $Page->Zona_residencia->FldCaption() ?></span>
			<span class="ewTableHeaderSort"><?php if ($Page->Zona_residencia->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($Page->Zona_residencia->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span>
		</div>
<?php } ?>
	</td>
<?php } ?>
<?php } ?>
	</tr>
</thead>
<tbody>
<?php
		if ($Page->TotalGrps == 0) break; // Show header only
		$Page->ShowHeader = FALSE;
	}
	$Page->RecCount++;
	$Page->RecIndex++;

		// Render detail row
		$Page->ResetAttrs();
		$Page->RowType = EWR_ROWTYPE_DETAIL;
		$Page->RenderRow();
?>
	<tr<?php echo $Page->RowAttributes(); ?>>
<?php if ($Page->Count28consulta_final_2020_Codigo_diagnostico29->Visible) { ?>
		<td data-field="Count28consulta_final_2020_Codigo_diagnostico29"<?php echo $Page->Count28consulta_final_2020_Codigo_diagnostico29->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_filtro_2019_consulta_Count28consulta_final_2020_Codigo_diagnostico29"<?php echo $Page->Count28consulta_final_2020_Codigo_diagnostico29->ViewAttributes() ?>><?php echo $Page->Count28consulta_final_2020_Codigo_diagnostico29->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Codigo_tres->Visible) { ?>
		<td data-field="Codigo_tres"<?php echo $Page->Codigo_tres->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_filtro_2019_consulta_Codigo_tres"<?php echo $Page->Codigo_tres->ViewAttributes() ?>><?php echo $Page->Codigo_tres->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Titulo_codigo_tres->Visible) { ?>
		<td data-field="Titulo_codigo_tres"<?php echo $Page->Titulo_codigo_tres->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_filtro_2019_consulta_Titulo_codigo_tres"<?php echo $Page->Titulo_codigo_tres->ViewAttributes() ?>><?php echo $Page->Titulo_codigo_tres->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Sexo->Visible) { ?>
		<td data-field="Sexo"<?php echo $Page->Sexo->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_filtro_2019_consulta_Sexo"<?php echo $Page->Sexo->ViewAttributes() ?>><?php echo $Page->Sexo->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Edad->Visible) { ?>
		<td data-field="Edad"<?php echo $Page->Edad->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_filtro_2019_consulta_Edad"<?php echo $Page->Edad->ViewAttributes() ?>><?php echo $Page->Edad->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Unidad_edad->Visible) { ?>
		<td data-field="Unidad_edad"<?php echo $Page->Unidad_edad->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_filtro_2019_consulta_Unidad_edad"<?php echo $Page->Unidad_edad->ViewAttributes() ?>><?php echo $Page->Unidad_edad->ListViewValue() ?></span></td>
<?php } ?>
<?php if ($Page->Zona_residencia->Visible) { ?>
		<td data-field="Zona_residencia"<?php echo $Page->Zona_residencia->CellAttributes() ?>>
<span data-class="tpx<?php echo $Page->RecCount ?>_<?php echo $Page->RecCount ?>_filtro_2019_consulta_Zona_residencia"<?php echo $Page->Zona_residencia->ViewAttributes() ?>><?php echo $Page->Zona_residencia->ListViewValue() ?></span></td>
<?php } ?>
	</tr>
<?php

		// Accumulate page summary
		$Page->AccumulateSummary();

		// Get next record
		$Page->GetRow(2);
	$Page->GrpCount++;
} // End while
?>
<?php if ($Page->TotalGrps > 0) { ?>
</tbody>
<tfoot>
	</tfoot>
<?php } elseif (!$Page->ShowHeader) { // No header displayed ?>
<?php if ($Page->Export <> "pdf") { ?>
<div class="ewGrid"<?php echo $Page->ReportTableStyle ?>>
<?php } ?>
<!-- Report grid (begin) -->
<?php if ($Page->Export <> "pdf") { ?>
<div class="<?php if (ewr_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php } ?>
<table class="<?php echo $Page->ReportTableClass ?>">
<?php } ?>
</table>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export == "" && !($Page->DrillDown && $Page->TotalGrps > 0)) { ?>
<div class="ewGridLowerPanel">
<?php include "filtro_2019_consultarptpager.php" ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<?php if ($Page->Export <> "pdf") { ?>
</div>
<?php } ?>
<!-- Summary Report Ends -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- center container - report (end) -->
	<!-- right container (begin) -->
	<div id="ewRight" class="ewRight">
<?php } ?>
	<!-- Right slot -->
<?php if ($Page->Export == "") { ?>
	</div>
	<!-- right container (end) -->
<div class="clearfix"></div>
<!-- bottom container (begin) -->
<div id="ewBottom" class="ewBottom">
<?php } ?>
	<!-- Bottom slot -->
<?php if ($Page->Export == "") { ?>
	</div>
<!-- Bottom Container (End) -->
</div>
<!-- Table Container (End) -->
<?php } ?>
<?php $Page->ShowPageFooter(); ?>
<?php if (EWR_DEBUG_ENABLED) echo ewr_DebugMsg(); ?>
<?php

// Close recordsets
if ($rsgrp) $rsgrp->Close();
if ($rs) $rs->Close();
?>
<?php if ($Page->Export == "" && !$Page->DrillDown) { ?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "phprptinc/footer.php" ?>
<?php
$Page->Page_Terminate();
if (isset($OldPage)) $Page = $OldPage;
?>
