<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "CIE10info.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$CIE10_add = NULL; // Initialize page object first

class cCIE10_add extends cCIE10 {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = "{034B1A10-E944-4CA3-9700-945506084CBC}";

	// Table name
	var $TableName = 'CIE10';

	// Page object name
	var $PageObjName = 'CIE10_add';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (CIE10)
		if (!isset($GLOBALS["CIE10"]) || get_class($GLOBALS["CIE10"]) == "cCIE10") {
			$GLOBALS["CIE10"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["CIE10"];
		}

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'CIE10', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $CIE10;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($CIE10);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $FormClassName = "form-horizontal ewForm ewAddForm";
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $StartRec;
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
			$this->CopyRecord = $this->LoadOldRecord(); // Load old recordset
			$this->LoadFormValues(); // Load form values
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["Id"] != "") {
				$this->Id->setQueryStringValue($_GET["Id"]);
				$this->setKey("Id", $this->Id->CurrentValue); // Set up key
			} else {
				$this->setKey("Id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
			}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		} else {
			if ($this->CurrentAction == "I") // Load default values for blank record
				$this->LoadDefaultValues();
		}

		// Perform action based on action code
		switch ($this->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "C": // Copy an existing record
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("CIE10list.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "CIE10list.php")
						$sReturnUrl = $this->AddMasterUrl($sReturnUrl); // List page, return to list page with correct master key if necessary
					elseif (ew_GetPageName($sReturnUrl) == "CIE10view.php")
						$sReturnUrl = $this->GetViewUrl(); // View page, return to view page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD; // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $Language;

		// Get upload data
	}

	// Load default values
	function LoadDefaultValues() {
		$this->Codigo->CurrentValue = NULL;
		$this->Codigo->OldValue = $this->Codigo->CurrentValue;
		$this->Causa_Completa->CurrentValue = NULL;
		$this->Causa_Completa->OldValue = $this->Causa_Completa->CurrentValue;
		$this->Causa->CurrentValue = NULL;
		$this->Causa->OldValue = $this->Causa->CurrentValue;
		$this->Letra->CurrentValue = NULL;
		$this->Letra->OldValue = $this->Letra->CurrentValue;
		$this->Numero->CurrentValue = NULL;
		$this->Numero->OldValue = $this->Numero->CurrentValue;
		$this->monitoreado->CurrentValue = NULL;
		$this->monitoreado->OldValue = $this->monitoreado->CurrentValue;
		$this->Grupo_Mortalidad->CurrentValue = NULL;
		$this->Grupo_Mortalidad->OldValue = $this->Grupo_Mortalidad->CurrentValue;
		$this->Nombre_Subgrupo->CurrentValue = NULL;
		$this->Nombre_Subgrupo->OldValue = $this->Nombre_Subgrupo->CurrentValue;
		$this->Grupo_General->CurrentValue = NULL;
		$this->Grupo_General->OldValue = $this->Grupo_General->CurrentValue;
		$this->Nombre->CurrentValue = NULL;
		$this->Nombre->OldValue = $this->Nombre->CurrentValue;
		$this->Codigo_tres->CurrentValue = NULL;
		$this->Codigo_tres->OldValue = $this->Codigo_tres->CurrentValue;
		$this->Nombre_codigo_tres->CurrentValue = NULL;
		$this->Nombre_codigo_tres->OldValue = $this->Nombre_codigo_tres->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->Codigo->FldIsDetailKey) {
			$this->Codigo->setFormValue($objForm->GetValue("x_Codigo"));
		}
		if (!$this->Causa_Completa->FldIsDetailKey) {
			$this->Causa_Completa->setFormValue($objForm->GetValue("x_Causa_Completa"));
		}
		if (!$this->Causa->FldIsDetailKey) {
			$this->Causa->setFormValue($objForm->GetValue("x_Causa"));
		}
		if (!$this->Letra->FldIsDetailKey) {
			$this->Letra->setFormValue($objForm->GetValue("x_Letra"));
		}
		if (!$this->Numero->FldIsDetailKey) {
			$this->Numero->setFormValue($objForm->GetValue("x_Numero"));
		}
		if (!$this->monitoreado->FldIsDetailKey) {
			$this->monitoreado->setFormValue($objForm->GetValue("x_monitoreado"));
		}
		if (!$this->Grupo_Mortalidad->FldIsDetailKey) {
			$this->Grupo_Mortalidad->setFormValue($objForm->GetValue("x_Grupo_Mortalidad"));
		}
		if (!$this->Nombre_Subgrupo->FldIsDetailKey) {
			$this->Nombre_Subgrupo->setFormValue($objForm->GetValue("x_Nombre_Subgrupo"));
		}
		if (!$this->Grupo_General->FldIsDetailKey) {
			$this->Grupo_General->setFormValue($objForm->GetValue("x_Grupo_General"));
		}
		if (!$this->Nombre->FldIsDetailKey) {
			$this->Nombre->setFormValue($objForm->GetValue("x_Nombre"));
		}
		if (!$this->Codigo_tres->FldIsDetailKey) {
			$this->Codigo_tres->setFormValue($objForm->GetValue("x_Codigo_tres"));
		}
		if (!$this->Nombre_codigo_tres->FldIsDetailKey) {
			$this->Nombre_codigo_tres->setFormValue($objForm->GetValue("x_Nombre_codigo_tres"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadOldRecord();
		$this->Codigo->CurrentValue = $this->Codigo->FormValue;
		$this->Causa_Completa->CurrentValue = $this->Causa_Completa->FormValue;
		$this->Causa->CurrentValue = $this->Causa->FormValue;
		$this->Letra->CurrentValue = $this->Letra->FormValue;
		$this->Numero->CurrentValue = $this->Numero->FormValue;
		$this->monitoreado->CurrentValue = $this->monitoreado->FormValue;
		$this->Grupo_Mortalidad->CurrentValue = $this->Grupo_Mortalidad->FormValue;
		$this->Nombre_Subgrupo->CurrentValue = $this->Nombre_Subgrupo->FormValue;
		$this->Grupo_General->CurrentValue = $this->Grupo_General->FormValue;
		$this->Nombre->CurrentValue = $this->Nombre->FormValue;
		$this->Codigo_tres->CurrentValue = $this->Codigo_tres->FormValue;
		$this->Nombre_codigo_tres->CurrentValue = $this->Nombre_codigo_tres->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Id->setDbValue($rs->fields('Id'));
		$this->Codigo->setDbValue($rs->fields('Codigo'));
		$this->Causa_Completa->setDbValue($rs->fields('Causa_Completa'));
		$this->Causa->setDbValue($rs->fields('Causa'));
		$this->Letra->setDbValue($rs->fields('Letra'));
		$this->Numero->setDbValue($rs->fields('Numero'));
		$this->monitoreado->setDbValue($rs->fields('monitoreado'));
		$this->Grupo_Mortalidad->setDbValue($rs->fields('Grupo_Mortalidad'));
		$this->Nombre_Subgrupo->setDbValue($rs->fields('Nombre_Subgrupo'));
		$this->Grupo_General->setDbValue($rs->fields('Grupo_General'));
		$this->Nombre->setDbValue($rs->fields('Nombre'));
		$this->Codigo_tres->setDbValue($rs->fields('Codigo_tres'));
		$this->Nombre_codigo_tres->setDbValue($rs->fields('Nombre_codigo_tres'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Id->DbValue = $row['Id'];
		$this->Codigo->DbValue = $row['Codigo'];
		$this->Causa_Completa->DbValue = $row['Causa_Completa'];
		$this->Causa->DbValue = $row['Causa'];
		$this->Letra->DbValue = $row['Letra'];
		$this->Numero->DbValue = $row['Numero'];
		$this->monitoreado->DbValue = $row['monitoreado'];
		$this->Grupo_Mortalidad->DbValue = $row['Grupo_Mortalidad'];
		$this->Nombre_Subgrupo->DbValue = $row['Nombre_Subgrupo'];
		$this->Grupo_General->DbValue = $row['Grupo_General'];
		$this->Nombre->DbValue = $row['Nombre'];
		$this->Codigo_tres->DbValue = $row['Codigo_tres'];
		$this->Nombre_codigo_tres->DbValue = $row['Nombre_codigo_tres'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("Id")) <> "")
			$this->Id->CurrentValue = $this->getKey("Id"); // Id
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Id
		// Codigo
		// Causa_Completa
		// Causa
		// Letra
		// Numero
		// monitoreado
		// Grupo_Mortalidad
		// Nombre_Subgrupo
		// Grupo_General
		// Nombre
		// Codigo_tres
		// Nombre_codigo_tres

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Id
		$this->Id->ViewValue = $this->Id->CurrentValue;
		$this->Id->ViewCustomAttributes = "";

		// Codigo
		$this->Codigo->ViewValue = $this->Codigo->CurrentValue;
		$this->Codigo->ViewCustomAttributes = "";

		// Causa_Completa
		$this->Causa_Completa->ViewValue = $this->Causa_Completa->CurrentValue;
		$this->Causa_Completa->ViewCustomAttributes = "";

		// Causa
		$this->Causa->ViewValue = $this->Causa->CurrentValue;
		$this->Causa->ViewCustomAttributes = "";

		// Letra
		$this->Letra->ViewValue = $this->Letra->CurrentValue;
		$this->Letra->ViewCustomAttributes = "";

		// Numero
		$this->Numero->ViewValue = $this->Numero->CurrentValue;
		$this->Numero->ViewCustomAttributes = "";

		// monitoreado
		$this->monitoreado->ViewValue = $this->monitoreado->CurrentValue;
		$this->monitoreado->ViewCustomAttributes = "";

		// Grupo_Mortalidad
		$this->Grupo_Mortalidad->ViewValue = $this->Grupo_Mortalidad->CurrentValue;
		$this->Grupo_Mortalidad->ViewCustomAttributes = "";

		// Nombre_Subgrupo
		$this->Nombre_Subgrupo->ViewValue = $this->Nombre_Subgrupo->CurrentValue;
		$this->Nombre_Subgrupo->ViewCustomAttributes = "";

		// Grupo_General
		$this->Grupo_General->ViewValue = $this->Grupo_General->CurrentValue;
		$this->Grupo_General->ViewCustomAttributes = "";

		// Nombre
		$this->Nombre->ViewValue = $this->Nombre->CurrentValue;
		$this->Nombre->ViewCustomAttributes = "";

		// Codigo_tres
		$this->Codigo_tres->ViewValue = $this->Codigo_tres->CurrentValue;
		$this->Codigo_tres->ViewCustomAttributes = "";

		// Nombre_codigo_tres
		$this->Nombre_codigo_tres->ViewValue = $this->Nombre_codigo_tres->CurrentValue;
		$this->Nombre_codigo_tres->ViewCustomAttributes = "";

			// Codigo
			$this->Codigo->LinkCustomAttributes = "";
			$this->Codigo->HrefValue = "";
			$this->Codigo->TooltipValue = "";

			// Causa_Completa
			$this->Causa_Completa->LinkCustomAttributes = "";
			$this->Causa_Completa->HrefValue = "";
			$this->Causa_Completa->TooltipValue = "";

			// Causa
			$this->Causa->LinkCustomAttributes = "";
			$this->Causa->HrefValue = "";
			$this->Causa->TooltipValue = "";

			// Letra
			$this->Letra->LinkCustomAttributes = "";
			$this->Letra->HrefValue = "";
			$this->Letra->TooltipValue = "";

			// Numero
			$this->Numero->LinkCustomAttributes = "";
			$this->Numero->HrefValue = "";
			$this->Numero->TooltipValue = "";

			// monitoreado
			$this->monitoreado->LinkCustomAttributes = "";
			$this->monitoreado->HrefValue = "";
			$this->monitoreado->TooltipValue = "";

			// Grupo_Mortalidad
			$this->Grupo_Mortalidad->LinkCustomAttributes = "";
			$this->Grupo_Mortalidad->HrefValue = "";
			$this->Grupo_Mortalidad->TooltipValue = "";

			// Nombre_Subgrupo
			$this->Nombre_Subgrupo->LinkCustomAttributes = "";
			$this->Nombre_Subgrupo->HrefValue = "";
			$this->Nombre_Subgrupo->TooltipValue = "";

			// Grupo_General
			$this->Grupo_General->LinkCustomAttributes = "";
			$this->Grupo_General->HrefValue = "";
			$this->Grupo_General->TooltipValue = "";

			// Nombre
			$this->Nombre->LinkCustomAttributes = "";
			$this->Nombre->HrefValue = "";
			$this->Nombre->TooltipValue = "";

			// Codigo_tres
			$this->Codigo_tres->LinkCustomAttributes = "";
			$this->Codigo_tres->HrefValue = "";
			$this->Codigo_tres->TooltipValue = "";

			// Nombre_codigo_tres
			$this->Nombre_codigo_tres->LinkCustomAttributes = "";
			$this->Nombre_codigo_tres->HrefValue = "";
			$this->Nombre_codigo_tres->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// Codigo
			$this->Codigo->EditAttrs["class"] = "form-control";
			$this->Codigo->EditCustomAttributes = "";
			$this->Codigo->EditValue = ew_HtmlEncode($this->Codigo->CurrentValue);
			$this->Codigo->PlaceHolder = ew_RemoveHtml($this->Codigo->FldCaption());

			// Causa_Completa
			$this->Causa_Completa->EditAttrs["class"] = "form-control";
			$this->Causa_Completa->EditCustomAttributes = "";
			$this->Causa_Completa->EditValue = ew_HtmlEncode($this->Causa_Completa->CurrentValue);
			$this->Causa_Completa->PlaceHolder = ew_RemoveHtml($this->Causa_Completa->FldCaption());

			// Causa
			$this->Causa->EditAttrs["class"] = "form-control";
			$this->Causa->EditCustomAttributes = "";
			$this->Causa->EditValue = ew_HtmlEncode($this->Causa->CurrentValue);
			$this->Causa->PlaceHolder = ew_RemoveHtml($this->Causa->FldCaption());

			// Letra
			$this->Letra->EditAttrs["class"] = "form-control";
			$this->Letra->EditCustomAttributes = "";
			$this->Letra->EditValue = ew_HtmlEncode($this->Letra->CurrentValue);
			$this->Letra->PlaceHolder = ew_RemoveHtml($this->Letra->FldCaption());

			// Numero
			$this->Numero->EditAttrs["class"] = "form-control";
			$this->Numero->EditCustomAttributes = "";
			$this->Numero->EditValue = ew_HtmlEncode($this->Numero->CurrentValue);
			$this->Numero->PlaceHolder = ew_RemoveHtml($this->Numero->FldCaption());

			// monitoreado
			$this->monitoreado->EditAttrs["class"] = "form-control";
			$this->monitoreado->EditCustomAttributes = "";
			$this->monitoreado->EditValue = ew_HtmlEncode($this->monitoreado->CurrentValue);
			$this->monitoreado->PlaceHolder = ew_RemoveHtml($this->monitoreado->FldCaption());

			// Grupo_Mortalidad
			$this->Grupo_Mortalidad->EditAttrs["class"] = "form-control";
			$this->Grupo_Mortalidad->EditCustomAttributes = "";
			$this->Grupo_Mortalidad->EditValue = ew_HtmlEncode($this->Grupo_Mortalidad->CurrentValue);
			$this->Grupo_Mortalidad->PlaceHolder = ew_RemoveHtml($this->Grupo_Mortalidad->FldCaption());

			// Nombre_Subgrupo
			$this->Nombre_Subgrupo->EditAttrs["class"] = "form-control";
			$this->Nombre_Subgrupo->EditCustomAttributes = "";
			$this->Nombre_Subgrupo->EditValue = ew_HtmlEncode($this->Nombre_Subgrupo->CurrentValue);
			$this->Nombre_Subgrupo->PlaceHolder = ew_RemoveHtml($this->Nombre_Subgrupo->FldCaption());

			// Grupo_General
			$this->Grupo_General->EditAttrs["class"] = "form-control";
			$this->Grupo_General->EditCustomAttributes = "";
			$this->Grupo_General->EditValue = ew_HtmlEncode($this->Grupo_General->CurrentValue);
			$this->Grupo_General->PlaceHolder = ew_RemoveHtml($this->Grupo_General->FldCaption());

			// Nombre
			$this->Nombre->EditAttrs["class"] = "form-control";
			$this->Nombre->EditCustomAttributes = "";
			$this->Nombre->EditValue = ew_HtmlEncode($this->Nombre->CurrentValue);
			$this->Nombre->PlaceHolder = ew_RemoveHtml($this->Nombre->FldCaption());

			// Codigo_tres
			$this->Codigo_tres->EditAttrs["class"] = "form-control";
			$this->Codigo_tres->EditCustomAttributes = "";
			$this->Codigo_tres->EditValue = ew_HtmlEncode($this->Codigo_tres->CurrentValue);
			$this->Codigo_tres->PlaceHolder = ew_RemoveHtml($this->Codigo_tres->FldCaption());

			// Nombre_codigo_tres
			$this->Nombre_codigo_tres->EditAttrs["class"] = "form-control";
			$this->Nombre_codigo_tres->EditCustomAttributes = "";
			$this->Nombre_codigo_tres->EditValue = ew_HtmlEncode($this->Nombre_codigo_tres->CurrentValue);
			$this->Nombre_codigo_tres->PlaceHolder = ew_RemoveHtml($this->Nombre_codigo_tres->FldCaption());

			// Add refer script
			// Codigo

			$this->Codigo->LinkCustomAttributes = "";
			$this->Codigo->HrefValue = "";

			// Causa_Completa
			$this->Causa_Completa->LinkCustomAttributes = "";
			$this->Causa_Completa->HrefValue = "";

			// Causa
			$this->Causa->LinkCustomAttributes = "";
			$this->Causa->HrefValue = "";

			// Letra
			$this->Letra->LinkCustomAttributes = "";
			$this->Letra->HrefValue = "";

			// Numero
			$this->Numero->LinkCustomAttributes = "";
			$this->Numero->HrefValue = "";

			// monitoreado
			$this->monitoreado->LinkCustomAttributes = "";
			$this->monitoreado->HrefValue = "";

			// Grupo_Mortalidad
			$this->Grupo_Mortalidad->LinkCustomAttributes = "";
			$this->Grupo_Mortalidad->HrefValue = "";

			// Nombre_Subgrupo
			$this->Nombre_Subgrupo->LinkCustomAttributes = "";
			$this->Nombre_Subgrupo->HrefValue = "";

			// Grupo_General
			$this->Grupo_General->LinkCustomAttributes = "";
			$this->Grupo_General->HrefValue = "";

			// Nombre
			$this->Nombre->LinkCustomAttributes = "";
			$this->Nombre->HrefValue = "";

			// Codigo_tres
			$this->Codigo_tres->LinkCustomAttributes = "";
			$this->Codigo_tres->HrefValue = "";

			// Nombre_codigo_tres
			$this->Nombre_codigo_tres->LinkCustomAttributes = "";
			$this->Nombre_codigo_tres->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!ew_CheckInteger($this->Numero->FormValue)) {
			ew_AddMessage($gsFormError, $this->Numero->FldErrMsg());
		}
		if (!ew_CheckInteger($this->monitoreado->FormValue)) {
			ew_AddMessage($gsFormError, $this->monitoreado->FldErrMsg());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $Language, $Security;
		$conn = &$this->Connection();

		// Load db values from rsold
		if ($rsold) {
			$this->LoadDbValues($rsold);
		}
		$rsnew = array();

		// Codigo
		$this->Codigo->SetDbValueDef($rsnew, $this->Codigo->CurrentValue, NULL, FALSE);

		// Causa_Completa
		$this->Causa_Completa->SetDbValueDef($rsnew, $this->Causa_Completa->CurrentValue, NULL, FALSE);

		// Causa
		$this->Causa->SetDbValueDef($rsnew, $this->Causa->CurrentValue, NULL, FALSE);

		// Letra
		$this->Letra->SetDbValueDef($rsnew, $this->Letra->CurrentValue, NULL, FALSE);

		// Numero
		$this->Numero->SetDbValueDef($rsnew, $this->Numero->CurrentValue, NULL, FALSE);

		// monitoreado
		$this->monitoreado->SetDbValueDef($rsnew, $this->monitoreado->CurrentValue, NULL, FALSE);

		// Grupo_Mortalidad
		$this->Grupo_Mortalidad->SetDbValueDef($rsnew, $this->Grupo_Mortalidad->CurrentValue, NULL, FALSE);

		// Nombre_Subgrupo
		$this->Nombre_Subgrupo->SetDbValueDef($rsnew, $this->Nombre_Subgrupo->CurrentValue, NULL, FALSE);

		// Grupo_General
		$this->Grupo_General->SetDbValueDef($rsnew, $this->Grupo_General->CurrentValue, NULL, FALSE);

		// Nombre
		$this->Nombre->SetDbValueDef($rsnew, $this->Nombre->CurrentValue, NULL, FALSE);

		// Codigo_tres
		$this->Codigo_tres->SetDbValueDef($rsnew, $this->Codigo_tres->CurrentValue, NULL, FALSE);

		// Nombre_codigo_tres
		$this->Nombre_codigo_tres->SetDbValueDef($rsnew, $this->Nombre_codigo_tres->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {

				// Get insert id if necessary
				$this->Id->setDbValue($conn->Insert_ID());
				$rsnew['Id'] = $this->Id->DbValue;
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$Breadcrumb->Add("list", $this->TableVar, $this->AddMasterUrl("CIE10list.php"), "", $this->TableVar, TRUE);
		$PageId = ($this->CurrentAction == "C") ? "Copy" : "Add";
		$Breadcrumb->Add("add", $PageId, $url);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($CIE10_add)) $CIE10_add = new cCIE10_add();

// Page init
$CIE10_add->Page_Init();

// Page main
$CIE10_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$CIE10_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "add";
var CurrentForm = fCIE10add = new ew_Form("fCIE10add", "add");

// Validate form
fCIE10add.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_Numero");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($CIE10->Numero->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_monitoreado");
			if (elm && !ew_CheckInteger(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($CIE10->monitoreado->FldErrMsg()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fCIE10add.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fCIE10add.ValidateRequired = true;
<?php } else { ?>
fCIE10add.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php $CIE10_add->ShowPageHeader(); ?>
<?php
$CIE10_add->ShowMessage();
?>
<form name="fCIE10add" id="fCIE10add" class="<?php echo $CIE10_add->FormClassName ?>" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($CIE10_add->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $CIE10_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="CIE10">
<input type="hidden" name="a_add" id="a_add" value="A">
<div>
<?php if ($CIE10->Codigo->Visible) { // Codigo ?>
	<div id="r_Codigo" class="form-group">
		<label id="elh_CIE10_Codigo" for="x_Codigo" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Codigo->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Codigo->CellAttributes() ?>>
<span id="el_CIE10_Codigo">
<input type="text" data-table="CIE10" data-field="x_Codigo" name="x_Codigo" id="x_Codigo" size="30" maxlength="4" placeholder="<?php echo ew_HtmlEncode($CIE10->Codigo->getPlaceHolder()) ?>" value="<?php echo $CIE10->Codigo->EditValue ?>"<?php echo $CIE10->Codigo->EditAttributes() ?>>
</span>
<?php echo $CIE10->Codigo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Causa_Completa->Visible) { // Causa_Completa ?>
	<div id="r_Causa_Completa" class="form-group">
		<label id="elh_CIE10_Causa_Completa" for="x_Causa_Completa" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Causa_Completa->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Causa_Completa->CellAttributes() ?>>
<span id="el_CIE10_Causa_Completa">
<input type="text" data-table="CIE10" data-field="x_Causa_Completa" name="x_Causa_Completa" id="x_Causa_Completa" size="30" maxlength="150" placeholder="<?php echo ew_HtmlEncode($CIE10->Causa_Completa->getPlaceHolder()) ?>" value="<?php echo $CIE10->Causa_Completa->EditValue ?>"<?php echo $CIE10->Causa_Completa->EditAttributes() ?>>
</span>
<?php echo $CIE10->Causa_Completa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Causa->Visible) { // Causa ?>
	<div id="r_Causa" class="form-group">
		<label id="elh_CIE10_Causa" for="x_Causa" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Causa->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Causa->CellAttributes() ?>>
<span id="el_CIE10_Causa">
<textarea data-table="CIE10" data-field="x_Causa" name="x_Causa" id="x_Causa" cols="35" rows="4" placeholder="<?php echo ew_HtmlEncode($CIE10->Causa->getPlaceHolder()) ?>"<?php echo $CIE10->Causa->EditAttributes() ?>><?php echo $CIE10->Causa->EditValue ?></textarea>
</span>
<?php echo $CIE10->Causa->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Letra->Visible) { // Letra ?>
	<div id="r_Letra" class="form-group">
		<label id="elh_CIE10_Letra" for="x_Letra" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Letra->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Letra->CellAttributes() ?>>
<span id="el_CIE10_Letra">
<input type="text" data-table="CIE10" data-field="x_Letra" name="x_Letra" id="x_Letra" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($CIE10->Letra->getPlaceHolder()) ?>" value="<?php echo $CIE10->Letra->EditValue ?>"<?php echo $CIE10->Letra->EditAttributes() ?>>
</span>
<?php echo $CIE10->Letra->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Numero->Visible) { // Numero ?>
	<div id="r_Numero" class="form-group">
		<label id="elh_CIE10_Numero" for="x_Numero" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Numero->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Numero->CellAttributes() ?>>
<span id="el_CIE10_Numero">
<input type="text" data-table="CIE10" data-field="x_Numero" name="x_Numero" id="x_Numero" size="30" placeholder="<?php echo ew_HtmlEncode($CIE10->Numero->getPlaceHolder()) ?>" value="<?php echo $CIE10->Numero->EditValue ?>"<?php echo $CIE10->Numero->EditAttributes() ?>>
</span>
<?php echo $CIE10->Numero->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->monitoreado->Visible) { // monitoreado ?>
	<div id="r_monitoreado" class="form-group">
		<label id="elh_CIE10_monitoreado" for="x_monitoreado" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->monitoreado->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->monitoreado->CellAttributes() ?>>
<span id="el_CIE10_monitoreado">
<input type="text" data-table="CIE10" data-field="x_monitoreado" name="x_monitoreado" id="x_monitoreado" size="30" placeholder="<?php echo ew_HtmlEncode($CIE10->monitoreado->getPlaceHolder()) ?>" value="<?php echo $CIE10->monitoreado->EditValue ?>"<?php echo $CIE10->monitoreado->EditAttributes() ?>>
</span>
<?php echo $CIE10->monitoreado->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Grupo_Mortalidad->Visible) { // Grupo_Mortalidad ?>
	<div id="r_Grupo_Mortalidad" class="form-group">
		<label id="elh_CIE10_Grupo_Mortalidad" for="x_Grupo_Mortalidad" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Grupo_Mortalidad->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Grupo_Mortalidad->CellAttributes() ?>>
<span id="el_CIE10_Grupo_Mortalidad">
<input type="text" data-table="CIE10" data-field="x_Grupo_Mortalidad" name="x_Grupo_Mortalidad" id="x_Grupo_Mortalidad" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($CIE10->Grupo_Mortalidad->getPlaceHolder()) ?>" value="<?php echo $CIE10->Grupo_Mortalidad->EditValue ?>"<?php echo $CIE10->Grupo_Mortalidad->EditAttributes() ?>>
</span>
<?php echo $CIE10->Grupo_Mortalidad->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Nombre_Subgrupo->Visible) { // Nombre_Subgrupo ?>
	<div id="r_Nombre_Subgrupo" class="form-group">
		<label id="elh_CIE10_Nombre_Subgrupo" for="x_Nombre_Subgrupo" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Nombre_Subgrupo->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Nombre_Subgrupo->CellAttributes() ?>>
<span id="el_CIE10_Nombre_Subgrupo">
<input type="text" data-table="CIE10" data-field="x_Nombre_Subgrupo" name="x_Nombre_Subgrupo" id="x_Nombre_Subgrupo" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($CIE10->Nombre_Subgrupo->getPlaceHolder()) ?>" value="<?php echo $CIE10->Nombre_Subgrupo->EditValue ?>"<?php echo $CIE10->Nombre_Subgrupo->EditAttributes() ?>>
</span>
<?php echo $CIE10->Nombre_Subgrupo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Grupo_General->Visible) { // Grupo_General ?>
	<div id="r_Grupo_General" class="form-group">
		<label id="elh_CIE10_Grupo_General" for="x_Grupo_General" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Grupo_General->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Grupo_General->CellAttributes() ?>>
<span id="el_CIE10_Grupo_General">
<input type="text" data-table="CIE10" data-field="x_Grupo_General" name="x_Grupo_General" id="x_Grupo_General" size="30" maxlength="10" placeholder="<?php echo ew_HtmlEncode($CIE10->Grupo_General->getPlaceHolder()) ?>" value="<?php echo $CIE10->Grupo_General->EditValue ?>"<?php echo $CIE10->Grupo_General->EditAttributes() ?>>
</span>
<?php echo $CIE10->Grupo_General->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Nombre->Visible) { // Nombre ?>
	<div id="r_Nombre" class="form-group">
		<label id="elh_CIE10_Nombre" for="x_Nombre" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Nombre->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Nombre->CellAttributes() ?>>
<span id="el_CIE10_Nombre">
<input type="text" data-table="CIE10" data-field="x_Nombre" name="x_Nombre" id="x_Nombre" size="30" maxlength="100" placeholder="<?php echo ew_HtmlEncode($CIE10->Nombre->getPlaceHolder()) ?>" value="<?php echo $CIE10->Nombre->EditValue ?>"<?php echo $CIE10->Nombre->EditAttributes() ?>>
</span>
<?php echo $CIE10->Nombre->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Codigo_tres->Visible) { // Codigo_tres ?>
	<div id="r_Codigo_tres" class="form-group">
		<label id="elh_CIE10_Codigo_tres" for="x_Codigo_tres" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Codigo_tres->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Codigo_tres->CellAttributes() ?>>
<span id="el_CIE10_Codigo_tres">
<input type="text" data-table="CIE10" data-field="x_Codigo_tres" name="x_Codigo_tres" id="x_Codigo_tres" size="30" maxlength="3" placeholder="<?php echo ew_HtmlEncode($CIE10->Codigo_tres->getPlaceHolder()) ?>" value="<?php echo $CIE10->Codigo_tres->EditValue ?>"<?php echo $CIE10->Codigo_tres->EditAttributes() ?>>
</span>
<?php echo $CIE10->Codigo_tres->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($CIE10->Nombre_codigo_tres->Visible) { // Nombre_codigo_tres ?>
	<div id="r_Nombre_codigo_tres" class="form-group">
		<label id="elh_CIE10_Nombre_codigo_tres" for="x_Nombre_codigo_tres" class="col-sm-2 control-label ewLabel"><?php echo $CIE10->Nombre_codigo_tres->FldCaption() ?></label>
		<div class="col-sm-10"><div<?php echo $CIE10->Nombre_codigo_tres->CellAttributes() ?>>
<span id="el_CIE10_Nombre_codigo_tres">
<input type="text" data-table="CIE10" data-field="x_Nombre_codigo_tres" name="x_Nombre_codigo_tres" id="x_Nombre_codigo_tres" size="30" maxlength="150" placeholder="<?php echo ew_HtmlEncode($CIE10->Nombre_codigo_tres->getPlaceHolder()) ?>" value="<?php echo $CIE10->Nombre_codigo_tres->EditValue ?>"<?php echo $CIE10->Nombre_codigo_tres->EditAttributes() ?>>
</span>
<?php echo $CIE10->Nombre_codigo_tres->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div>
<div class="form-group">
	<div class="col-sm-offset-2 col-sm-10">
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
<button class="btn btn-default ewButton" name="btnCancel" id="btnCancel" type="button" data-href="<?php echo $CIE10_add->getReturnUrl() ?>"><?php echo $Language->Phrase("CancelBtn") ?></button>
	</div>
</div>
</form>
<script type="text/javascript">
fCIE10add.Init();
</script>
<?php
$CIE10_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$CIE10_add->Page_Terminate();
?>
