<?php

// Global variable for table object
$CIE10 = NULL;

//
// Table class for CIE10
//
class cCIE10 extends cTable {
	var $Id;
	var $Codigo;
	var $Causa_Completa;
	var $Causa;
	var $Letra;
	var $Numero;
	var $monitoreado;
	var $Grupo_Mortalidad;
	var $Nombre_Subgrupo;
	var $Grupo_General;
	var $Nombre;
	var $Codigo_tres;
	var $Nombre_codigo_tres;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'CIE10';
		$this->TableName = 'CIE10';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`CIE10`";
		$this->DBID = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PHPExcel only)
		$this->ExportExcelPageSize = ""; // Page size (PHPExcel only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = ew_AllowAddDeleteRow(); // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// Id
		$this->Id = new cField('CIE10', 'CIE10', 'x_Id', 'Id', '`Id`', '`Id`', 3, -1, FALSE, '`Id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->Id->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Id'] = &$this->Id;

		// Codigo
		$this->Codigo = new cField('CIE10', 'CIE10', 'x_Codigo', 'Codigo', '`Codigo`', '`Codigo`', 200, -1, FALSE, '`Codigo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Codigo'] = &$this->Codigo;

		// Causa_Completa
		$this->Causa_Completa = new cField('CIE10', 'CIE10', 'x_Causa_Completa', 'Causa_Completa', '`Causa_Completa`', '`Causa_Completa`', 200, -1, FALSE, '`Causa_Completa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Causa_Completa'] = &$this->Causa_Completa;

		// Causa
		$this->Causa = new cField('CIE10', 'CIE10', 'x_Causa', 'Causa', '`Causa`', '`Causa`', 201, -1, FALSE, '`Causa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->fields['Causa'] = &$this->Causa;

		// Letra
		$this->Letra = new cField('CIE10', 'CIE10', 'x_Letra', 'Letra', '`Letra`', '`Letra`', 200, -1, FALSE, '`Letra`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Letra'] = &$this->Letra;

		// Numero
		$this->Numero = new cField('CIE10', 'CIE10', 'x_Numero', 'Numero', '`Numero`', '`Numero`', 3, -1, FALSE, '`Numero`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Numero->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Numero'] = &$this->Numero;

		// monitoreado
		$this->monitoreado = new cField('CIE10', 'CIE10', 'x_monitoreado', 'monitoreado', '`monitoreado`', '`monitoreado`', 3, -1, FALSE, '`monitoreado`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->monitoreado->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['monitoreado'] = &$this->monitoreado;

		// Grupo_Mortalidad
		$this->Grupo_Mortalidad = new cField('CIE10', 'CIE10', 'x_Grupo_Mortalidad', 'Grupo_Mortalidad', '`Grupo_Mortalidad`', '`Grupo_Mortalidad`', 200, -1, FALSE, '`Grupo_Mortalidad`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Grupo_Mortalidad'] = &$this->Grupo_Mortalidad;

		// Nombre_Subgrupo
		$this->Nombre_Subgrupo = new cField('CIE10', 'CIE10', 'x_Nombre_Subgrupo', 'Nombre_Subgrupo', '`Nombre_Subgrupo`', '`Nombre_Subgrupo`', 200, -1, FALSE, '`Nombre_Subgrupo`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Nombre_Subgrupo'] = &$this->Nombre_Subgrupo;

		// Grupo_General
		$this->Grupo_General = new cField('CIE10', 'CIE10', 'x_Grupo_General', 'Grupo_General', '`Grupo_General`', '`Grupo_General`', 200, -1, FALSE, '`Grupo_General`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Grupo_General'] = &$this->Grupo_General;

		// Nombre
		$this->Nombre = new cField('CIE10', 'CIE10', 'x_Nombre', 'Nombre', '`Nombre`', '`Nombre`', 200, -1, FALSE, '`Nombre`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Nombre'] = &$this->Nombre;

		// Codigo_tres
		$this->Codigo_tres = new cField('CIE10', 'CIE10', 'x_Codigo_tres', 'Codigo_tres', '`Codigo_tres`', '`Codigo_tres`', 200, -1, FALSE, '`Codigo_tres`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Codigo_tres'] = &$this->Codigo_tres;

		// Nombre_codigo_tres
		$this->Nombre_codigo_tres = new cField('CIE10', 'CIE10', 'x_Nombre_codigo_tres', 'Nombre_codigo_tres', '`Nombre_codigo_tres`', '`Nombre_codigo_tres`', 200, -1, FALSE, '`Nombre_codigo_tres`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Nombre_codigo_tres'] = &$this->Nombre_codigo_tres;
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Table level SQL
	var $_SqlFrom = "";

	function getSqlFrom() { // From
		return ($this->_SqlFrom <> "") ? $this->_SqlFrom : "`CIE10`";
	}

	function SqlFrom() { // For backward compatibility
    	return $this->getSqlFrom();
	}

	function setSqlFrom($v) {
    	$this->_SqlFrom = $v;
	}
	var $_SqlSelect = "";

	function getSqlSelect() { // Select
		return ($this->_SqlSelect <> "") ? $this->_SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}

	function SqlSelect() { // For backward compatibility
    	return $this->getSqlSelect();
	}

	function setSqlSelect($v) {
    	$this->_SqlSelect = $v;
	}
	var $_SqlWhere = "";

	function getSqlWhere() { // Where
		$sWhere = ($this->_SqlWhere <> "") ? $this->_SqlWhere : "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlWhere() { // For backward compatibility
    	return $this->getSqlWhere();
	}

	function setSqlWhere($v) {
    	$this->_SqlWhere = $v;
	}
	var $_SqlGroupBy = "";

	function getSqlGroupBy() { // Group By
		return ($this->_SqlGroupBy <> "") ? $this->_SqlGroupBy : "";
	}

	function SqlGroupBy() { // For backward compatibility
    	return $this->getSqlGroupBy();
	}

	function setSqlGroupBy($v) {
    	$this->_SqlGroupBy = $v;
	}
	var $_SqlHaving = "";

	function getSqlHaving() { // Having
		return ($this->_SqlHaving <> "") ? $this->_SqlHaving : "";
	}

	function SqlHaving() { // For backward compatibility
    	return $this->getSqlHaving();
	}

	function setSqlHaving($v) {
    	$this->_SqlHaving = $v;
	}
	var $_SqlOrderBy = "";

	function getSqlOrderBy() { // Order By
		return ($this->_SqlOrderBy <> "") ? $this->_SqlOrderBy : "";
	}

	function SqlOrderBy() { // For backward compatibility
    	return $this->getSqlOrderBy();
	}

	function setSqlOrderBy($v) {
    	$this->_SqlOrderBy = $v;
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = EW_USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$sFilter = $this->CurrentFilter;
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$sFilter, $sSort);
	}

	// Table SQL with List page filter
	function SelectSQL() {
		$sFilter = $this->getSessionWhere();
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$this->Recordset_Selecting($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sSort);
	}

	// Try to get record count
	function TryGetRecordCount($sSql) {
		$cnt = -1;
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') && preg_match("/^SELECT \* FROM/i", $sSql)) {
			$sSql = "SELECT COUNT(*) FROM" . preg_replace('/^SELECT\s([\s\S]+)?\*\sFROM/i', "", $sSql);
			$sOrderBy = $this->GetOrderBy();
			if (substr($sSql, strlen($sOrderBy) * -1) == $sOrderBy)
				$sSql = substr($sSql, 0, strlen($sSql) - strlen($sOrderBy)); // Remove ORDER BY clause
		} else {
			$sSql = "SELECT COUNT(*) FROM (" . $sSql . ") EW_COUNT_TABLE";
		}
		$conn = &$this->Connection();
		if ($rs = $conn->Execute($sSql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($sFilter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $sFilter;
		$this->Recordset_Selecting($this->CurrentFilter);

		//$sSql = $this->SQL();
		$sSql = $this->GetSQL($this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function SelectRecordCount() {
		$sSql = $this->SelectSQL();
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			$conn = &$this->Connection();
			if ($rs = $conn->Execute($sSql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// INSERT statement
	function InsertSQL(&$rs) {
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		while (substr($names, -1) == ",")
			$names = substr($names, 0, -1);
		while (substr($values, -1) == ",")
			$values = substr($values, 0, -1);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		$conn = &$this->Connection();
		return $conn->Execute($this->InsertSQL($rs));
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		while (substr($sql, -1) == ",")
			$sql = substr($sql, 0, -1);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE) {
		$conn = &$this->Connection();
		return $conn->Execute($this->UpdateSQL($rs, $where, $curfilter));
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Id', $rs))
				ew_AddFilter($where, ew_QuotedName('Id', $this->DBID) . '=' . ew_QuotedValue($rs['Id'], $this->Id->FldDataType, $this->DBID));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "", $curfilter = TRUE) {
		$conn = &$this->Connection();
		return $conn->Execute($this->DeleteSQL($rs, $where, $curfilter));
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "`Id` = @Id@";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		if (!is_numeric($this->Id->CurrentValue))
			$sKeyFilter = "0=1"; // Invalid key
		$sKeyFilter = str_replace("@Id@", ew_AdjustSql($this->Id->CurrentValue, $this->DBID), $sKeyFilter); // Replace key value
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "CIE10list.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// List URL
	function GetListUrl() {
		return "CIE10list.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			$url = $this->KeyUrl("CIE10view.php", $this->UrlParm($parm));
		else
			$url = $this->KeyUrl("CIE10view.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
		return $this->AddMasterUrl($url);
	}

	// Add URL
	function GetAddUrl($parm = "") {
		if ($parm <> "")
			$url = "CIE10add.php?" . $this->UrlParm($parm);
		else
			$url = "CIE10add.php";
		return $this->AddMasterUrl($url);
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		$url = $this->KeyUrl("CIE10edit.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
		return $this->AddMasterUrl($url);
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		$url = $this->KeyUrl("CIE10add.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
		return $this->AddMasterUrl($url);
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("CIE10delete.php", $this->UrlParm());
	}

	// Add master url
	function AddMasterUrl($url) {
		return $url;
	}

	function KeyToJson() {
		$json = "";
		$json .= "Id:" . ew_VarToJson($this->Id->CurrentValue, "number", "'");
		return "{" . $json . "}";
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		if (!is_null($this->Id->CurrentValue)) {
			$sUrl .= "Id=" . urlencode($this->Id->CurrentValue);
		} else {
			return "javascript:ew_Alert(ewLanguage.Phrase('InvalidRecord'));";
		}
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&amp;ordertype=" . $fld->ReverseSort());
			return ew_CurrentPage() . "?" . $sUrlParm;
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = ew_StripSlashes($_POST["key_m"]);
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = ew_StripSlashes($_GET["key_m"]);
			$cnt = count($arKeys);
		} elseif (!empty($_GET) || !empty($_POST)) {
			$isPost = ew_IsHttpPost();
			if ($isPost && isset($_POST["Id"]))
				$arKeys[] = ew_StripSlashes($_POST["Id"]);
			elseif (isset($_GET["Id"]))
				$arKeys[] = ew_StripSlashes($_GET["Id"]);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$this->Id->CurrentValue = $key;
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($sFilter) {

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $sFilter;
		//$sSql = $this->SQL();

		$sSql = $this->GetSQL($sFilter, "");
		$conn = &$this->Connection();
		$rs = $conn->Execute($sSql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->Id->setDbValue($rs->fields('Id'));
		$this->Codigo->setDbValue($rs->fields('Codigo'));
		$this->Causa_Completa->setDbValue($rs->fields('Causa_Completa'));
		$this->Causa->setDbValue($rs->fields('Causa'));
		$this->Letra->setDbValue($rs->fields('Letra'));
		$this->Numero->setDbValue($rs->fields('Numero'));
		$this->monitoreado->setDbValue($rs->fields('monitoreado'));
		$this->Grupo_Mortalidad->setDbValue($rs->fields('Grupo_Mortalidad'));
		$this->Nombre_Subgrupo->setDbValue($rs->fields('Nombre_Subgrupo'));
		$this->Grupo_General->setDbValue($rs->fields('Grupo_General'));
		$this->Nombre->setDbValue($rs->fields('Nombre'));
		$this->Codigo_tres->setDbValue($rs->fields('Codigo_tres'));
		$this->Nombre_codigo_tres->setDbValue($rs->fields('Nombre_codigo_tres'));
	}

	// Render list row values
	function RenderListRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

   // Common render codes
		// Id
		// Codigo
		// Causa_Completa
		// Causa
		// Letra
		// Numero
		// monitoreado
		// Grupo_Mortalidad
		// Nombre_Subgrupo
		// Grupo_General
		// Nombre
		// Codigo_tres
		// Nombre_codigo_tres
		// Id

		$this->Id->ViewValue = $this->Id->CurrentValue;
		$this->Id->ViewCustomAttributes = "";

		// Codigo
		$this->Codigo->ViewValue = $this->Codigo->CurrentValue;
		$this->Codigo->ViewCustomAttributes = "";

		// Causa_Completa
		$this->Causa_Completa->ViewValue = $this->Causa_Completa->CurrentValue;
		$this->Causa_Completa->ViewCustomAttributes = "";

		// Causa
		$this->Causa->ViewValue = $this->Causa->CurrentValue;
		$this->Causa->ViewCustomAttributes = "";

		// Letra
		$this->Letra->ViewValue = $this->Letra->CurrentValue;
		$this->Letra->ViewCustomAttributes = "";

		// Numero
		$this->Numero->ViewValue = $this->Numero->CurrentValue;
		$this->Numero->ViewCustomAttributes = "";

		// monitoreado
		$this->monitoreado->ViewValue = $this->monitoreado->CurrentValue;
		$this->monitoreado->ViewCustomAttributes = "";

		// Grupo_Mortalidad
		$this->Grupo_Mortalidad->ViewValue = $this->Grupo_Mortalidad->CurrentValue;
		$this->Grupo_Mortalidad->ViewCustomAttributes = "";

		// Nombre_Subgrupo
		$this->Nombre_Subgrupo->ViewValue = $this->Nombre_Subgrupo->CurrentValue;
		$this->Nombre_Subgrupo->ViewCustomAttributes = "";

		// Grupo_General
		$this->Grupo_General->ViewValue = $this->Grupo_General->CurrentValue;
		$this->Grupo_General->ViewCustomAttributes = "";

		// Nombre
		$this->Nombre->ViewValue = $this->Nombre->CurrentValue;
		$this->Nombre->ViewCustomAttributes = "";

		// Codigo_tres
		$this->Codigo_tres->ViewValue = $this->Codigo_tres->CurrentValue;
		$this->Codigo_tres->ViewCustomAttributes = "";

		// Nombre_codigo_tres
		$this->Nombre_codigo_tres->ViewValue = $this->Nombre_codigo_tres->CurrentValue;
		$this->Nombre_codigo_tres->ViewCustomAttributes = "";

		// Id
		$this->Id->LinkCustomAttributes = "";
		$this->Id->HrefValue = "";
		$this->Id->TooltipValue = "";

		// Codigo
		$this->Codigo->LinkCustomAttributes = "";
		$this->Codigo->HrefValue = "";
		$this->Codigo->TooltipValue = "";

		// Causa_Completa
		$this->Causa_Completa->LinkCustomAttributes = "";
		$this->Causa_Completa->HrefValue = "";
		$this->Causa_Completa->TooltipValue = "";

		// Causa
		$this->Causa->LinkCustomAttributes = "";
		$this->Causa->HrefValue = "";
		$this->Causa->TooltipValue = "";

		// Letra
		$this->Letra->LinkCustomAttributes = "";
		$this->Letra->HrefValue = "";
		$this->Letra->TooltipValue = "";

		// Numero
		$this->Numero->LinkCustomAttributes = "";
		$this->Numero->HrefValue = "";
		$this->Numero->TooltipValue = "";

		// monitoreado
		$this->monitoreado->LinkCustomAttributes = "";
		$this->monitoreado->HrefValue = "";
		$this->monitoreado->TooltipValue = "";

		// Grupo_Mortalidad
		$this->Grupo_Mortalidad->LinkCustomAttributes = "";
		$this->Grupo_Mortalidad->HrefValue = "";
		$this->Grupo_Mortalidad->TooltipValue = "";

		// Nombre_Subgrupo
		$this->Nombre_Subgrupo->LinkCustomAttributes = "";
		$this->Nombre_Subgrupo->HrefValue = "";
		$this->Nombre_Subgrupo->TooltipValue = "";

		// Grupo_General
		$this->Grupo_General->LinkCustomAttributes = "";
		$this->Grupo_General->HrefValue = "";
		$this->Grupo_General->TooltipValue = "";

		// Nombre
		$this->Nombre->LinkCustomAttributes = "";
		$this->Nombre->HrefValue = "";
		$this->Nombre->TooltipValue = "";

		// Codigo_tres
		$this->Codigo_tres->LinkCustomAttributes = "";
		$this->Codigo_tres->HrefValue = "";
		$this->Codigo_tres->TooltipValue = "";

		// Nombre_codigo_tres
		$this->Nombre_codigo_tres->LinkCustomAttributes = "";
		$this->Nombre_codigo_tres->HrefValue = "";
		$this->Nombre_codigo_tres->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Render edit row values
	function RenderEditRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Id
		$this->Id->EditAttrs["class"] = "form-control";
		$this->Id->EditCustomAttributes = "";
		$this->Id->EditValue = $this->Id->CurrentValue;
		$this->Id->ViewCustomAttributes = "";

		// Codigo
		$this->Codigo->EditAttrs["class"] = "form-control";
		$this->Codigo->EditCustomAttributes = "";
		$this->Codigo->EditValue = $this->Codigo->CurrentValue;
		$this->Codigo->PlaceHolder = ew_RemoveHtml($this->Codigo->FldCaption());

		// Causa_Completa
		$this->Causa_Completa->EditAttrs["class"] = "form-control";
		$this->Causa_Completa->EditCustomAttributes = "";
		$this->Causa_Completa->EditValue = $this->Causa_Completa->CurrentValue;
		$this->Causa_Completa->PlaceHolder = ew_RemoveHtml($this->Causa_Completa->FldCaption());

		// Causa
		$this->Causa->EditAttrs["class"] = "form-control";
		$this->Causa->EditCustomAttributes = "";
		$this->Causa->EditValue = $this->Causa->CurrentValue;
		$this->Causa->PlaceHolder = ew_RemoveHtml($this->Causa->FldCaption());

		// Letra
		$this->Letra->EditAttrs["class"] = "form-control";
		$this->Letra->EditCustomAttributes = "";
		$this->Letra->EditValue = $this->Letra->CurrentValue;
		$this->Letra->PlaceHolder = ew_RemoveHtml($this->Letra->FldCaption());

		// Numero
		$this->Numero->EditAttrs["class"] = "form-control";
		$this->Numero->EditCustomAttributes = "";
		$this->Numero->EditValue = $this->Numero->CurrentValue;
		$this->Numero->PlaceHolder = ew_RemoveHtml($this->Numero->FldCaption());

		// monitoreado
		$this->monitoreado->EditAttrs["class"] = "form-control";
		$this->monitoreado->EditCustomAttributes = "";
		$this->monitoreado->EditValue = $this->monitoreado->CurrentValue;
		$this->monitoreado->PlaceHolder = ew_RemoveHtml($this->monitoreado->FldCaption());

		// Grupo_Mortalidad
		$this->Grupo_Mortalidad->EditAttrs["class"] = "form-control";
		$this->Grupo_Mortalidad->EditCustomAttributes = "";
		$this->Grupo_Mortalidad->EditValue = $this->Grupo_Mortalidad->CurrentValue;
		$this->Grupo_Mortalidad->PlaceHolder = ew_RemoveHtml($this->Grupo_Mortalidad->FldCaption());

		// Nombre_Subgrupo
		$this->Nombre_Subgrupo->EditAttrs["class"] = "form-control";
		$this->Nombre_Subgrupo->EditCustomAttributes = "";
		$this->Nombre_Subgrupo->EditValue = $this->Nombre_Subgrupo->CurrentValue;
		$this->Nombre_Subgrupo->PlaceHolder = ew_RemoveHtml($this->Nombre_Subgrupo->FldCaption());

		// Grupo_General
		$this->Grupo_General->EditAttrs["class"] = "form-control";
		$this->Grupo_General->EditCustomAttributes = "";
		$this->Grupo_General->EditValue = $this->Grupo_General->CurrentValue;
		$this->Grupo_General->PlaceHolder = ew_RemoveHtml($this->Grupo_General->FldCaption());

		// Nombre
		$this->Nombre->EditAttrs["class"] = "form-control";
		$this->Nombre->EditCustomAttributes = "";
		$this->Nombre->EditValue = $this->Nombre->CurrentValue;
		$this->Nombre->PlaceHolder = ew_RemoveHtml($this->Nombre->FldCaption());

		// Codigo_tres
		$this->Codigo_tres->EditAttrs["class"] = "form-control";
		$this->Codigo_tres->EditCustomAttributes = "";
		$this->Codigo_tres->EditValue = $this->Codigo_tres->CurrentValue;
		$this->Codigo_tres->PlaceHolder = ew_RemoveHtml($this->Codigo_tres->FldCaption());

		// Nombre_codigo_tres
		$this->Nombre_codigo_tres->EditAttrs["class"] = "form-control";
		$this->Nombre_codigo_tres->EditCustomAttributes = "";
		$this->Nombre_codigo_tres->EditValue = $this->Nombre_codigo_tres->CurrentValue;
		$this->Nombre_codigo_tres->PlaceHolder = ew_RemoveHtml($this->Nombre_codigo_tres->FldCaption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {

		// Call Row Rendered event
		$this->Row_Rendered();
	}
	var $ExportDoc;

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;
		if (!$Doc->ExportCustom) {

			// Write header
			$Doc->ExportTableHeader();
			if ($Doc->Horizontal) { // Horizontal format, write header
				$Doc->BeginExportRow();
				if ($ExportPageType == "view") {
					if ($this->Id->Exportable) $Doc->ExportCaption($this->Id);
					if ($this->Codigo->Exportable) $Doc->ExportCaption($this->Codigo);
					if ($this->Causa_Completa->Exportable) $Doc->ExportCaption($this->Causa_Completa);
					if ($this->Causa->Exportable) $Doc->ExportCaption($this->Causa);
					if ($this->Letra->Exportable) $Doc->ExportCaption($this->Letra);
					if ($this->Numero->Exportable) $Doc->ExportCaption($this->Numero);
					if ($this->monitoreado->Exportable) $Doc->ExportCaption($this->monitoreado);
					if ($this->Grupo_Mortalidad->Exportable) $Doc->ExportCaption($this->Grupo_Mortalidad);
					if ($this->Nombre_Subgrupo->Exportable) $Doc->ExportCaption($this->Nombre_Subgrupo);
					if ($this->Grupo_General->Exportable) $Doc->ExportCaption($this->Grupo_General);
					if ($this->Nombre->Exportable) $Doc->ExportCaption($this->Nombre);
					if ($this->Codigo_tres->Exportable) $Doc->ExportCaption($this->Codigo_tres);
					if ($this->Nombre_codigo_tres->Exportable) $Doc->ExportCaption($this->Nombre_codigo_tres);
				} else {
					if ($this->Id->Exportable) $Doc->ExportCaption($this->Id);
					if ($this->Codigo->Exportable) $Doc->ExportCaption($this->Codigo);
					if ($this->Causa_Completa->Exportable) $Doc->ExportCaption($this->Causa_Completa);
					if ($this->Letra->Exportable) $Doc->ExportCaption($this->Letra);
					if ($this->Numero->Exportable) $Doc->ExportCaption($this->Numero);
					if ($this->monitoreado->Exportable) $Doc->ExportCaption($this->monitoreado);
					if ($this->Grupo_Mortalidad->Exportable) $Doc->ExportCaption($this->Grupo_Mortalidad);
					if ($this->Nombre_Subgrupo->Exportable) $Doc->ExportCaption($this->Nombre_Subgrupo);
					if ($this->Grupo_General->Exportable) $Doc->ExportCaption($this->Grupo_General);
					if ($this->Nombre->Exportable) $Doc->ExportCaption($this->Nombre);
					if ($this->Codigo_tres->Exportable) $Doc->ExportCaption($this->Codigo_tres);
					if ($this->Nombre_codigo_tres->Exportable) $Doc->ExportCaption($this->Nombre_codigo_tres);
				}
				$Doc->EndExportRow();
			}
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				if (!$Doc->ExportCustom) {
					$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
					if ($ExportPageType == "view") {
						if ($this->Id->Exportable) $Doc->ExportField($this->Id);
						if ($this->Codigo->Exportable) $Doc->ExportField($this->Codigo);
						if ($this->Causa_Completa->Exportable) $Doc->ExportField($this->Causa_Completa);
						if ($this->Causa->Exportable) $Doc->ExportField($this->Causa);
						if ($this->Letra->Exportable) $Doc->ExportField($this->Letra);
						if ($this->Numero->Exportable) $Doc->ExportField($this->Numero);
						if ($this->monitoreado->Exportable) $Doc->ExportField($this->monitoreado);
						if ($this->Grupo_Mortalidad->Exportable) $Doc->ExportField($this->Grupo_Mortalidad);
						if ($this->Nombre_Subgrupo->Exportable) $Doc->ExportField($this->Nombre_Subgrupo);
						if ($this->Grupo_General->Exportable) $Doc->ExportField($this->Grupo_General);
						if ($this->Nombre->Exportable) $Doc->ExportField($this->Nombre);
						if ($this->Codigo_tres->Exportable) $Doc->ExportField($this->Codigo_tres);
						if ($this->Nombre_codigo_tres->Exportable) $Doc->ExportField($this->Nombre_codigo_tres);
					} else {
						if ($this->Id->Exportable) $Doc->ExportField($this->Id);
						if ($this->Codigo->Exportable) $Doc->ExportField($this->Codigo);
						if ($this->Causa_Completa->Exportable) $Doc->ExportField($this->Causa_Completa);
						if ($this->Letra->Exportable) $Doc->ExportField($this->Letra);
						if ($this->Numero->Exportable) $Doc->ExportField($this->Numero);
						if ($this->monitoreado->Exportable) $Doc->ExportField($this->monitoreado);
						if ($this->Grupo_Mortalidad->Exportable) $Doc->ExportField($this->Grupo_Mortalidad);
						if ($this->Nombre_Subgrupo->Exportable) $Doc->ExportField($this->Nombre_Subgrupo);
						if ($this->Grupo_General->Exportable) $Doc->ExportField($this->Grupo_General);
						if ($this->Nombre->Exportable) $Doc->ExportField($this->Nombre);
						if ($this->Codigo_tres->Exportable) $Doc->ExportField($this->Codigo_tres);
						if ($this->Nombre_codigo_tres->Exportable) $Doc->ExportField($this->Nombre_codigo_tres);
					}
					$Doc->EndExportRow();
				}
			}

			// Call Row Export server event
			if ($Doc->ExportCustom)
				$this->Row_Export($Recordset->fields);
			$Recordset->MoveNext();
		}
		if (!$Doc->ExportCustom) {
			$Doc->ExportTableFooter();
		}
	}

	// Get auto fill value
	function GetAutoFill($id, $val) {
		$rsarr = array();
		$rowcnt = 0;

		// Output
		if (is_array($rsarr) && $rowcnt > 0) {
			$fldcnt = count($rsarr[0]);
			for ($i = 0; $i < $rowcnt; $i++) {
				for ($j = 0; $j < $fldcnt; $j++) {
					$str = strval($rsarr[$i][$j]);
					$str = ew_ConvertToUtf8($str);
					if (isset($post["keepCRLF"])) {
						$str = str_replace(array("\r", "\n"), array("\\r", "\\n"), $str);
					} else {
						$str = str_replace(array("\r", "\n"), array(" ", " "), $str);
					}
					$rsarr[$i][$j] = $str;
				}
			}
			return ew_ArrayToJson($rsarr);
		} else {
			return FALSE;
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here	
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here	
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here	
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->FldName, $fld->LookupFilters, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here	
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>); 

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
