<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg12.php" ?>
<?php include_once ((EW_USE_ADODB) ? "adodb5/adodb.inc.php" : "ewmysql12.php") ?>
<?php include_once "phpfn12.php" ?>
<?php include_once "CIE10info.php" ?>
<?php include_once "userfn12.php" ?>
<?php

//
// Page class
//

$CIE10_list = NULL; // Initialize page object first

class cCIE10_list extends cCIE10 {

	// Page ID
	var $PageID = 'list';

	// Project ID
	var $ProjectID = "{034B1A10-E944-4CA3-9700-945506084CBC}";

	// Table name
	var $TableName = 'CIE10';

	// Page object name
	var $PageObjName = 'CIE10_list';

	// Grid form hidden field names
	var $FormName = 'fCIE10list';
	var $FormActionName = 'k_action';
	var $FormKeyName = 'k_key';
	var $FormOldKeyName = 'k_oldkey';
	var $FormBlankRowName = 'k_blankrow';
	var $FormKeyCountName = 'key_count';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Custom export
	var $ExportExcelCustom = FALSE;
	var $ExportWordCustom = FALSE;
	var $ExportPdfCustom = FALSE;
	var $ExportEmailCustom = FALSE;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Methods to clear message
	function ClearMessage() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
	}

	function ClearFailureMessage() {
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
	}

	function ClearSuccessMessage() {
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
	}

	function ClearWarningMessage() {
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	function ClearMessages() {
		$_SESSION[EW_SESSION_MESSAGE] = "";
		$_SESSION[EW_SESSION_FAILURE_MESSAGE] = "";
		$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = "";
		$_SESSION[EW_SESSION_WARNING_MESSAGE] = "";
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-info ewInfo\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-danger ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}
	var $Token = "";
	var $TokenTimeout = 0;
	var $CheckToken = EW_CHECK_TOKEN;
	var $CheckTokenFn = "ew_CheckToken";
	var $CreateTokenFn = "ew_CreateToken";

	// Valid Post
	function ValidPost() {
		if (!$this->CheckToken || !ew_IsHttpPost())
			return TRUE;
		if (!isset($_POST[EW_TOKEN_NAME]))
			return FALSE;
		$fn = $this->CheckTokenFn;
		if (is_callable($fn))
			return $fn($_POST[EW_TOKEN_NAME], $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	function CreateToken() {
		global $gsToken;
		if ($this->CheckToken) {
			$fn = $this->CreateTokenFn;
			if ($this->Token == "" && is_callable($fn)) // Create token
				$this->Token = $fn();
			$gsToken = $this->Token; // Save to global variable
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language;
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = ew_SessionTimeoutTime();

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (CIE10)
		if (!isset($GLOBALS["CIE10"]) || get_class($GLOBALS["CIE10"]) == "cCIE10") {
			$GLOBALS["CIE10"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["CIE10"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->PageUrl() . "export=print";
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel";
		$this->ExportWordUrl = $this->PageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html";
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf";
		$this->AddUrl = "CIE10add.php";
		$this->InlineAddUrl = $this->PageUrl() . "a=add";
		$this->GridAddUrl = $this->PageUrl() . "a=gridadd";
		$this->GridEditUrl = $this->PageUrl() . "a=gridedit";
		$this->MultiDeleteUrl = "CIE10delete.php";
		$this->MultiUpdateUrl = "CIE10update.php";

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'list', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'CIE10', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect($this->DBID);

		// List options
		$this->ListOptions = new cListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['addedit'] = new cListOptions();
		$this->OtherOptions['addedit']->Tag = "div";
		$this->OtherOptions['addedit']->TagClassName = "ewAddEditOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "div";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "div";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";

		// Filter options
		$this->FilterOptions = new cListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ewFilterOption fCIE10listsrch";

		// List actions
		$this->ListActions = new cListActions();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsCustomExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up current action

		// Get grid add count
		$gridaddcnt = @$_GET[EW_TABLE_GRID_ADD_ROW_COUNT];
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->SetupListOptions();
		$this->Id->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->ValidPost()) {
			echo $Language->Phrase("InvalidPostRequest");
			$this->Page_Terminate();
			exit();
		}

		// Process auto fill
		if (@$_POST["ajax"] == "autofill") {
			$results = $this->GetAutoFill(@$_POST["name"], @$_POST["q"]);
			if ($results) {

				// Clean output buffer
				if (!EW_DEBUG_ENABLED && ob_get_length())
					ob_end_clean();
				echo $results;
				$this->Page_Terminate();
				exit();
			}
		}

		// Create Token
		$this->CreateToken();

		// Setup other options
		$this->SetupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->Add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == EW_ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $gsExportFile, $gTmpImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EW_EXPORT, $CIE10;
		if ($this->CustomExport <> "" && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EW_EXPORT)) {
				$sContent = ob_get_contents();
			if ($gsExportFile == "") $gsExportFile = $this->TableVar;
			$class = $EW_EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($CIE10);
				$doc->Text = $sContent;
				if ($this->Export == "email")
					echo $this->ExportEmail($doc->Text);
				else
					$doc->Export();
				ew_DeleteTmpImages(); // Delete temp images
				exit();
			}
		}
		$this->Page_Redirecting($url);

		 // Close connection
		ew_CloseConn();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}

	// Class variables
	var $ListOptions; // List options
	var $ExportOptions; // Export options
	var $SearchOptions; // Search options
	var $OtherOptions = array(); // Other options
	var $FilterOptions; // Filter options
	var $ListActions; // List actions
	var $SelectedCount = 0;
	var $SelectedIndex = 0;
	var $DisplayRecs = 20;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $DefaultSearchWhere = ""; // Default search WHERE clause
	var $SearchWhere = ""; // Search WHERE clause
	var $RecCnt = 0; // Record count
	var $EditRowCnt;
	var $StartRowCnt = 1;
	var $RowCnt = 0;
	var $Attrs = array(); // Row attributes and cell attributes
	var $RowIndex = 0; // Row index
	var $KeyCount = 0; // Key count
	var $RowAction = ""; // Row action
	var $RowOldKey = ""; // Row old key (for copy)
	var $RecPerRow = 0;
	var $MultiColumnClass;
	var $MultiColumnEditClass = "col-sm-12";
	var $MultiColumnCnt = 12;
	var $MultiColumnEditCnt = 12;
	var $GridCnt = 0;
	var $ColCnt = 0;
	var $DbMasterFilter = ""; // Master filter
	var $DbDetailFilter = ""; // Detail filter
	var $MasterRecordExists;	
	var $MultiSelectKey;
	var $Command;
	var $RestoreSearch = FALSE;
	var $DetailPages;
	var $Recordset;
	var $OldRecordset;

	//
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $gsSearchError, $Security;

		// Search filters
		$sSrchAdvanced = ""; // Advanced search filter
		$sSrchBasic = ""; // Basic search filter
		$sFilter = "";

		// Get command
		$this->Command = strtolower(@$_GET["cmd"]);
		if ($this->IsPageRequest()) { // Validate request

			// Process list action first
			if ($this->ProcessListAction()) // Ajax request
				$this->Page_Terminate();

			// Handle reset command
			$this->ResetCmd();

			// Set up Breadcrumb
			if ($this->Export == "")
				$this->SetupBreadcrumb();

			// Hide list options
			if ($this->Export <> "") {
				$this->ListOptions->HideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->CurrentAction == "gridadd" || $this->CurrentAction == "gridedit") {
				$this->ListOptions->HideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->Export <> "" || $this->CurrentAction <> "") {
				$this->ExportOptions->HideAllOptions();
				$this->FilterOptions->HideAllOptions();
			}

			// Hide other options
			if ($this->Export <> "") {
				foreach ($this->OtherOptions as &$option)
					$option->HideAllOptions();
			}

			// Get default search criteria
			ew_AddFilter($this->DefaultSearchWhere, $this->BasicSearchWhere(TRUE));

			// Get basic search values
			$this->LoadBasicSearchValues();

			// Restore filter list
			$this->RestoreFilterList();

			// Restore search parms from Session if not searching / reset / export
			if (($this->Export <> "" || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->CheckSearchParms())
				$this->RestoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->SetUpSortOrder();

			// Get basic search criteria
			if ($gsSearchError == "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Restore display records
		if ($this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		$this->LoadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->CheckSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->LoadDefault();
			if ($this->BasicSearch->Keyword != "")
				$sSrchBasic = $this->BasicSearchWhere();
		}

		// Build search criteria
		ew_AddFilter($this->SearchWhere, $sSrchAdvanced);
		ew_AddFilter($this->SearchWhere, $sSrchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} else {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$sFilter = "";
		ew_AddFilter($sFilter, $this->DbDetailFilter);
		ew_AddFilter($sFilter, $this->SearchWhere);

		// Set up filter in session
		$this->setSessionWhere($sFilter);
		$this->CurrentFilter = "";

		// Load record count first
		if (!$this->IsAddOrEdit()) {
			$bSelectLimit = $this->UseSelectLimit;
			if ($bSelectLimit) {
				$this->TotalRecs = $this->SelectRecordCount();
			} else {
				if ($this->Recordset = $this->LoadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
		}

		// Search options
		$this->SetupSearchOptions();
	}

	// Build filter for all keys
	function BuildKeyFilter() {
		global $objForm;
		$sWrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$objForm->Index = $rowindex;
		$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		while ($sThisKey <> "") {
			if ($this->SetupKeyValues($sThisKey)) {
				$sFilter = $this->KeyFilter();
				if ($sWrkFilter <> "") $sWrkFilter .= " OR ";
				$sWrkFilter .= $sFilter;
			} else {
				$sWrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$objForm->Index = $rowindex;
			$sThisKey = strval($objForm->GetValue($this->FormKeyName));
		}
		return $sWrkFilter;
	}

	// Set up key values
	function SetupKeyValues($key) {
		$arrKeyFlds = explode($GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arrKeyFlds) >= 1) {
			$this->Id->setFormValue($arrKeyFlds[0]);
			if (!is_numeric($this->Id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	function GetFilterList() {

		// Initialize
		$sFilterList = "";
		$sFilterList = ew_Concat($sFilterList, $this->Id->AdvancedSearch->ToJSON(), ","); // Field Id
		$sFilterList = ew_Concat($sFilterList, $this->Codigo->AdvancedSearch->ToJSON(), ","); // Field Codigo
		$sFilterList = ew_Concat($sFilterList, $this->Causa_Completa->AdvancedSearch->ToJSON(), ","); // Field Causa_Completa
		$sFilterList = ew_Concat($sFilterList, $this->Causa->AdvancedSearch->ToJSON(), ","); // Field Causa
		$sFilterList = ew_Concat($sFilterList, $this->Letra->AdvancedSearch->ToJSON(), ","); // Field Letra
		$sFilterList = ew_Concat($sFilterList, $this->Numero->AdvancedSearch->ToJSON(), ","); // Field Numero
		$sFilterList = ew_Concat($sFilterList, $this->monitoreado->AdvancedSearch->ToJSON(), ","); // Field monitoreado
		$sFilterList = ew_Concat($sFilterList, $this->Grupo_Mortalidad->AdvancedSearch->ToJSON(), ","); // Field Grupo_Mortalidad
		$sFilterList = ew_Concat($sFilterList, $this->Nombre_Subgrupo->AdvancedSearch->ToJSON(), ","); // Field Nombre_Subgrupo
		$sFilterList = ew_Concat($sFilterList, $this->Grupo_General->AdvancedSearch->ToJSON(), ","); // Field Grupo_General
		$sFilterList = ew_Concat($sFilterList, $this->Nombre->AdvancedSearch->ToJSON(), ","); // Field Nombre
		$sFilterList = ew_Concat($sFilterList, $this->Codigo_tres->AdvancedSearch->ToJSON(), ","); // Field Codigo_tres
		$sFilterList = ew_Concat($sFilterList, $this->Nombre_codigo_tres->AdvancedSearch->ToJSON(), ","); // Field Nombre_codigo_tres
		if ($this->BasicSearch->Keyword <> "") {
			$sWrk = "\"" . EW_TABLE_BASIC_SEARCH . "\":\"" . ew_JsEncode2($this->BasicSearch->Keyword) . "\",\"" . EW_TABLE_BASIC_SEARCH_TYPE . "\":\"" . ew_JsEncode2($this->BasicSearch->Type) . "\"";
			$sFilterList = ew_Concat($sFilterList, $sWrk, ",");
		}

		// Return filter list in json
		return ($sFilterList <> "") ? "{" . $sFilterList . "}" : "null";
	}

	// Restore list of filters
	function RestoreFilterList() {

		// Return if not reset filter
		if (@$_POST["cmd"] <> "resetfilter")
			return FALSE;
		$filter = json_decode(ew_StripSlashes(@$_POST["filter"]), TRUE);
		$this->Command = "search";

		// Field Id
		$this->Id->AdvancedSearch->SearchValue = @$filter["x_Id"];
		$this->Id->AdvancedSearch->SearchOperator = @$filter["z_Id"];
		$this->Id->AdvancedSearch->SearchCondition = @$filter["v_Id"];
		$this->Id->AdvancedSearch->SearchValue2 = @$filter["y_Id"];
		$this->Id->AdvancedSearch->SearchOperator2 = @$filter["w_Id"];
		$this->Id->AdvancedSearch->Save();

		// Field Codigo
		$this->Codigo->AdvancedSearch->SearchValue = @$filter["x_Codigo"];
		$this->Codigo->AdvancedSearch->SearchOperator = @$filter["z_Codigo"];
		$this->Codigo->AdvancedSearch->SearchCondition = @$filter["v_Codigo"];
		$this->Codigo->AdvancedSearch->SearchValue2 = @$filter["y_Codigo"];
		$this->Codigo->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo"];
		$this->Codigo->AdvancedSearch->Save();

		// Field Causa_Completa
		$this->Causa_Completa->AdvancedSearch->SearchValue = @$filter["x_Causa_Completa"];
		$this->Causa_Completa->AdvancedSearch->SearchOperator = @$filter["z_Causa_Completa"];
		$this->Causa_Completa->AdvancedSearch->SearchCondition = @$filter["v_Causa_Completa"];
		$this->Causa_Completa->AdvancedSearch->SearchValue2 = @$filter["y_Causa_Completa"];
		$this->Causa_Completa->AdvancedSearch->SearchOperator2 = @$filter["w_Causa_Completa"];
		$this->Causa_Completa->AdvancedSearch->Save();

		// Field Causa
		$this->Causa->AdvancedSearch->SearchValue = @$filter["x_Causa"];
		$this->Causa->AdvancedSearch->SearchOperator = @$filter["z_Causa"];
		$this->Causa->AdvancedSearch->SearchCondition = @$filter["v_Causa"];
		$this->Causa->AdvancedSearch->SearchValue2 = @$filter["y_Causa"];
		$this->Causa->AdvancedSearch->SearchOperator2 = @$filter["w_Causa"];
		$this->Causa->AdvancedSearch->Save();

		// Field Letra
		$this->Letra->AdvancedSearch->SearchValue = @$filter["x_Letra"];
		$this->Letra->AdvancedSearch->SearchOperator = @$filter["z_Letra"];
		$this->Letra->AdvancedSearch->SearchCondition = @$filter["v_Letra"];
		$this->Letra->AdvancedSearch->SearchValue2 = @$filter["y_Letra"];
		$this->Letra->AdvancedSearch->SearchOperator2 = @$filter["w_Letra"];
		$this->Letra->AdvancedSearch->Save();

		// Field Numero
		$this->Numero->AdvancedSearch->SearchValue = @$filter["x_Numero"];
		$this->Numero->AdvancedSearch->SearchOperator = @$filter["z_Numero"];
		$this->Numero->AdvancedSearch->SearchCondition = @$filter["v_Numero"];
		$this->Numero->AdvancedSearch->SearchValue2 = @$filter["y_Numero"];
		$this->Numero->AdvancedSearch->SearchOperator2 = @$filter["w_Numero"];
		$this->Numero->AdvancedSearch->Save();

		// Field monitoreado
		$this->monitoreado->AdvancedSearch->SearchValue = @$filter["x_monitoreado"];
		$this->monitoreado->AdvancedSearch->SearchOperator = @$filter["z_monitoreado"];
		$this->monitoreado->AdvancedSearch->SearchCondition = @$filter["v_monitoreado"];
		$this->monitoreado->AdvancedSearch->SearchValue2 = @$filter["y_monitoreado"];
		$this->monitoreado->AdvancedSearch->SearchOperator2 = @$filter["w_monitoreado"];
		$this->monitoreado->AdvancedSearch->Save();

		// Field Grupo_Mortalidad
		$this->Grupo_Mortalidad->AdvancedSearch->SearchValue = @$filter["x_Grupo_Mortalidad"];
		$this->Grupo_Mortalidad->AdvancedSearch->SearchOperator = @$filter["z_Grupo_Mortalidad"];
		$this->Grupo_Mortalidad->AdvancedSearch->SearchCondition = @$filter["v_Grupo_Mortalidad"];
		$this->Grupo_Mortalidad->AdvancedSearch->SearchValue2 = @$filter["y_Grupo_Mortalidad"];
		$this->Grupo_Mortalidad->AdvancedSearch->SearchOperator2 = @$filter["w_Grupo_Mortalidad"];
		$this->Grupo_Mortalidad->AdvancedSearch->Save();

		// Field Nombre_Subgrupo
		$this->Nombre_Subgrupo->AdvancedSearch->SearchValue = @$filter["x_Nombre_Subgrupo"];
		$this->Nombre_Subgrupo->AdvancedSearch->SearchOperator = @$filter["z_Nombre_Subgrupo"];
		$this->Nombre_Subgrupo->AdvancedSearch->SearchCondition = @$filter["v_Nombre_Subgrupo"];
		$this->Nombre_Subgrupo->AdvancedSearch->SearchValue2 = @$filter["y_Nombre_Subgrupo"];
		$this->Nombre_Subgrupo->AdvancedSearch->SearchOperator2 = @$filter["w_Nombre_Subgrupo"];
		$this->Nombre_Subgrupo->AdvancedSearch->Save();

		// Field Grupo_General
		$this->Grupo_General->AdvancedSearch->SearchValue = @$filter["x_Grupo_General"];
		$this->Grupo_General->AdvancedSearch->SearchOperator = @$filter["z_Grupo_General"];
		$this->Grupo_General->AdvancedSearch->SearchCondition = @$filter["v_Grupo_General"];
		$this->Grupo_General->AdvancedSearch->SearchValue2 = @$filter["y_Grupo_General"];
		$this->Grupo_General->AdvancedSearch->SearchOperator2 = @$filter["w_Grupo_General"];
		$this->Grupo_General->AdvancedSearch->Save();

		// Field Nombre
		$this->Nombre->AdvancedSearch->SearchValue = @$filter["x_Nombre"];
		$this->Nombre->AdvancedSearch->SearchOperator = @$filter["z_Nombre"];
		$this->Nombre->AdvancedSearch->SearchCondition = @$filter["v_Nombre"];
		$this->Nombre->AdvancedSearch->SearchValue2 = @$filter["y_Nombre"];
		$this->Nombre->AdvancedSearch->SearchOperator2 = @$filter["w_Nombre"];
		$this->Nombre->AdvancedSearch->Save();

		// Field Codigo_tres
		$this->Codigo_tres->AdvancedSearch->SearchValue = @$filter["x_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchOperator = @$filter["z_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchCondition = @$filter["v_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchValue2 = @$filter["y_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->SearchOperator2 = @$filter["w_Codigo_tres"];
		$this->Codigo_tres->AdvancedSearch->Save();

		// Field Nombre_codigo_tres
		$this->Nombre_codigo_tres->AdvancedSearch->SearchValue = @$filter["x_Nombre_codigo_tres"];
		$this->Nombre_codigo_tres->AdvancedSearch->SearchOperator = @$filter["z_Nombre_codigo_tres"];
		$this->Nombre_codigo_tres->AdvancedSearch->SearchCondition = @$filter["v_Nombre_codigo_tres"];
		$this->Nombre_codigo_tres->AdvancedSearch->SearchValue2 = @$filter["y_Nombre_codigo_tres"];
		$this->Nombre_codigo_tres->AdvancedSearch->SearchOperator2 = @$filter["w_Nombre_codigo_tres"];
		$this->Nombre_codigo_tres->AdvancedSearch->Save();
		$this->BasicSearch->setKeyword(@$filter[EW_TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[EW_TABLE_BASIC_SEARCH_TYPE]);
	}

	// Return basic search SQL
	function BasicSearchSQL($arKeywords, $type) {
		$sWhere = "";
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Causa_Completa, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Causa, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Letra, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Grupo_Mortalidad, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Nombre_Subgrupo, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Grupo_General, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Nombre, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Codigo_tres, $arKeywords, $type);
		$this->BuildBasicSearchSQL($sWhere, $this->Nombre_codigo_tres, $arKeywords, $type);
		return $sWhere;
	}

	// Build basic search SQL
	function BuildBasicSearchSql(&$Where, &$Fld, $arKeywords, $type) {
		$sDefCond = ($type == "OR") ? "OR" : "AND";
		$arSQL = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$Keyword = $arKeywords[$i];
			$Keyword = trim($Keyword);
			if (EW_BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$Keyword = preg_replace(EW_BASIC_SEARCH_IGNORE_PATTERN, "\\", $Keyword);
				$ar = explode("\\", $Keyword);
			} else {
				$ar = array($Keyword);
			}
			foreach ($ar as $Keyword) {
				if ($Keyword <> "") {
					$sWrk = "";
					if ($Keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j-1] = "OR";
					} elseif ($Keyword == EW_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NULL";
					} elseif ($Keyword == EW_NOT_NULL_VALUE) {
						$sWrk = $Fld->FldExpression . " IS NOT NULL";
					} elseif ($Fld->FldIsVirtual && $Fld->FldVirtualSearch) {
						$sWrk = $Fld->FldVirtualExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					} elseif ($Fld->FldDataType != EW_DATATYPE_NUMBER || is_numeric($Keyword)) {
						$sWrk = $Fld->FldBasicSearchExpression . ew_Like(ew_QuotedValue("%" . $Keyword . "%", EW_DATATYPE_STRING, $this->DBID), $this->DBID);
					}
					if ($sWrk <> "") {
						$arSQL[$j] = $sWrk;
						$arCond[$j] = $sDefCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSQL);
		$bQuoted = FALSE;
		$sSql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt-1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$bQuoted) $sSql .= "(";
					$bQuoted = TRUE;
				}
				$sSql .= $arSQL[$i];
				if ($bQuoted && $arCond[$i] <> "OR") {
					$sSql .= ")";
					$bQuoted = FALSE;
				}
				$sSql .= " " . $arCond[$i] . " ";
			}
			$sSql .= $arSQL[$cnt-1];
			if ($bQuoted)
				$sSql .= ")";
		}
		if ($sSql <> "") {
			if ($Where <> "") $Where .= " OR ";
			$Where .=  "(" . $sSql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	function BasicSearchWhere($Default = FALSE) {
		global $Security;
		$sSearchStr = "";
		$sSearchKeyword = ($Default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$sSearchType = ($Default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;
		if ($sSearchKeyword <> "") {
			$sSearch = trim($sSearchKeyword);
			if ($sSearchType <> "=") {
				$ar = array();

				// Match quoted keywords (i.e.: "...")
				if (preg_match_all('/"([^"]*)"/i', $sSearch, $matches, PREG_SET_ORDER)) {
					foreach ($matches as $match) {
						$p = strpos($sSearch, $match[0]);
						$str = substr($sSearch, 0, $p);
						$sSearch = substr($sSearch, $p + strlen($match[0]));
						if (strlen(trim($str)) > 0)
							$ar = array_merge($ar, explode(" ", trim($str)));
						$ar[] = $match[1]; // Save quoted keyword
					}
				}

				// Match individual keywords
				if (strlen(trim($sSearch)) > 0)
					$ar = array_merge($ar, explode(" ", trim($sSearch)));

				// Search keyword in any fields
				if (($sSearchType == "OR" || $sSearchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
					foreach ($ar as $sKeyword) {
						if ($sKeyword <> "") {
							if ($sSearchStr <> "") $sSearchStr .= " " . $sSearchType . " ";
							$sSearchStr .= "(" . $this->BasicSearchSQL(array($sKeyword), $sSearchType) . ")";
						}
					}
				} else {
					$sSearchStr = $this->BasicSearchSQL($ar, $sSearchType);
				}
			} else {
				$sSearchStr = $this->BasicSearchSQL(array($sSearch), $sSearchType);
			}
			if (!$Default) $this->Command = "search";
		}
		if (!$Default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($sSearchKeyword);
			$this->BasicSearch->setType($sSearchType);
		}
		return $sSearchStr;
	}

	// Check if search parm exists
	function CheckSearchParms() {

		// Check basic search
		if ($this->BasicSearch->IssetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	function ResetSearchParms() {

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->ResetBasicSearchParms();
	}

	// Load advanced search default values
	function LoadAdvancedSearchDefault() {
		return FALSE;
	}

	// Clear all basic search parameters
	function ResetBasicSearchParms() {
		$this->BasicSearch->UnsetSession();
	}

	// Restore all search parameters
	function RestoreSearchParms() {
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->Load();
	}

	// Set up sort parameters
	function SetUpSortOrder() {

		// Check for "order" parameter
		if (@$_GET["order"] <> "") {
			$this->CurrentOrder = ew_StripSlashes(@$_GET["order"]);
			$this->CurrentOrderType = @$_GET["ordertype"];
			$this->UpdateSort($this->Id); // Id
			$this->UpdateSort($this->Codigo); // Codigo
			$this->UpdateSort($this->Causa_Completa); // Causa_Completa
			$this->UpdateSort($this->Letra); // Letra
			$this->UpdateSort($this->Numero); // Numero
			$this->UpdateSort($this->monitoreado); // monitoreado
			$this->UpdateSort($this->Grupo_Mortalidad); // Grupo_Mortalidad
			$this->UpdateSort($this->Nombre_Subgrupo); // Nombre_Subgrupo
			$this->UpdateSort($this->Grupo_General); // Grupo_General
			$this->UpdateSort($this->Nombre); // Nombre
			$this->UpdateSort($this->Codigo_tres); // Codigo_tres
			$this->UpdateSort($this->Nombre_codigo_tres); // Nombre_codigo_tres
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	function LoadSortOrder() {
		$sOrderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($sOrderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$sOrderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($sOrderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)
	function ResetCmd() {

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->ResetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$sOrderBy = "";
				$this->setSessionOrderBy($sOrderBy);
				$this->Id->setSort("");
				$this->Codigo->setSort("");
				$this->Causa_Completa->setSort("");
				$this->Letra->setSort("");
				$this->Numero->setSort("");
				$this->monitoreado->setSort("");
				$this->Grupo_Mortalidad->setSort("");
				$this->Nombre_Subgrupo->setSort("");
				$this->Grupo_General->setSort("");
				$this->Nombre->setSort("");
				$this->Codigo_tres->setSort("");
				$this->Nombre_codigo_tres->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	function SetupListOptions() {
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->Add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->Add("view");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = TRUE;
		$item->OnLeft = FALSE;

		// "edit"
		$item = &$this->ListOptions->Add("edit");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = TRUE;
		$item->OnLeft = FALSE;

		// "copy"
		$item = &$this->ListOptions->Add("copy");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = TRUE;
		$item->OnLeft = FALSE;

		// "delete"
		$item = &$this->ListOptions->Add("delete");
		$item->CssStyle = "white-space: nowrap;";
		$item->Visible = TRUE;
		$item->OnLeft = FALSE;

		// List actions
		$item = &$this->ListOptions->Add("listactions");
		$item->CssStyle = "white-space: nowrap;";
		$item->OnLeft = FALSE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->Add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = FALSE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew_SelectAllKey(this);\">";
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseImageAndText = TRUE;
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->Phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && ew_IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->ButtonClass = "btn-sm"; // Class for button group

		// Call ListOptions_Load event
		$this->ListOptions_Load();
		$this->SetupListOptionsExt();
		$item = &$this->ListOptions->GetItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->GroupOptionVisible();
	}

	// Render list options
	function RenderListOptions() {
		global $Security, $Language, $objForm;
		$this->ListOptions->LoadDefault();

		// "view"
		$oListOpt = &$this->ListOptions->Items["view"];
		if (TRUE)
			$oListOpt->Body = "<a class=\"ewRowLink ewView\" title=\"" . ew_HtmlTitle($Language->Phrase("ViewLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("ViewLink")) . "\" href=\"" . ew_HtmlEncode($this->ViewUrl) . "\">" . $Language->Phrase("ViewLink") . "</a>";
		else
			$oListOpt->Body = "";

		// "edit"
		$oListOpt = &$this->ListOptions->Items["edit"];
		if (TRUE) {
			$oListOpt->Body = "<a class=\"ewRowLink ewEdit\" title=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("EditLink")) . "\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("EditLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "copy"
		$oListOpt = &$this->ListOptions->Items["copy"];
		if (TRUE) {
			$oListOpt->Body = "<a class=\"ewRowLink ewCopy\" title=\"" . ew_HtmlTitle($Language->Phrase("CopyLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("CopyLink")) . "\" href=\"" . ew_HtmlEncode($this->CopyUrl) . "\">" . $Language->Phrase("CopyLink") . "</a>";
		} else {
			$oListOpt->Body = "";
		}

		// "delete"
		$oListOpt = &$this->ListOptions->Items["delete"];
		if (TRUE)
			$oListOpt->Body = "<a class=\"ewRowLink ewDelete\"" . "" . " title=\"" . ew_HtmlTitle($Language->Phrase("DeleteLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("DeleteLink")) . "\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("DeleteLink") . "</a>";
		else
			$oListOpt->Body = "";

		// Set up list action buttons
		$oListOpt = &$this->ListOptions->GetItem("listactions");
		if ($oListOpt && $this->Export == "" && $this->CurrentAction == "") {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode(str_replace(" ewIcon", "", $listaction->Icon)) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\"></span> " : "";
					$links[] = "<li><a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ewAction ewListAction\" data-action=\"" . ew_HtmlEncode($action) . "\" title=\"" . ew_HtmlTitle($caption) . "\" data-caption=\"" . ew_HtmlTitle($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({key:" . $this->KeyToJson() . "}," . $listaction->ToJson(TRUE) . "));return false;\">" . $Language->Phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default btn-sm ewActions\" title=\"" . ew_HtmlTitle($Language->Phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->Phrase("ListActionButton") . "<b class=\"caret\"></b></button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($oListOpt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$oListOpt->Body = $body;
				$oListOpt->Visible = TRUE;
			}
		}

		// "checkbox"
		$oListOpt = &$this->ListOptions->Items["checkbox"];
		$oListOpt->Body = "<input type=\"checkbox\" name=\"key_m[]\" value=\"" . ew_HtmlEncode($this->Id->CurrentValue) . "\" onclick='ew_ClickMultiCheckbox(event);'>";
		$this->RenderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAddEdit ewAdd\" title=\"" . ew_HtmlTitle($Language->Phrase("AddLink")) . "\" data-caption=\"" . ew_HtmlTitle($Language->Phrase("AddLink")) . "\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "");
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseImageAndText = TRUE;
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$option->ButtonClass = "btn-sm"; // Class for button group
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->Phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->Add("savecurrentfilter");
		$item->Body = "<a class=\"ewSaveFilter\" data-form=\"fCIE10listsrch\" href=\"#\">" . $Language->Phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->Add("deletefilter");
		$item->Body = "<a class=\"ewDeleteFilter\" data-form=\"fCIE10listsrch\" href=\"#\">" . $Language->Phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->Phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->Add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	function RenderOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == EW_ACTION_MULTIPLE) {
					$item = &$option->Add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<span class=\"" . ew_HtmlEncode($listaction->Icon) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\"></span> " : $caption;
					$item->Body = "<a class=\"ewAction ewListAction\" title=\"" . ew_HtmlEncode($caption) . "\" data-caption=\"" . ew_HtmlEncode($caption) . "\" href=\"\" onclick=\"ew_SubmitAction(event,jQuery.extend({f:document.fCIE10list}," . $listaction->ToJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->GetItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->HideAllOptions();
			}
	}

	// Process list action
	function ProcessListAction() {
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$sFilter = $this->GetKeyFilter();
		$UserAction = @$_POST["useraction"];
		if ($sFilter <> "" && $UserAction <> "") {

			// Check permission first
			$ActionCaption = $UserAction;
			if (array_key_exists($UserAction, $this->ListActions->Items)) {
				$ActionCaption = $this->ListActions->Items[$UserAction]->Caption;
				if (!$this->ListActions->Items[$UserAction]->Allow) {
					$errmsg = str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionNotAllowed"));
					if (@$_POST["ajax"] == $UserAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $sFilter;
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			$rs = $conn->Execute($sSql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $UserAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->BeginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$Processed = $this->Row_CustomAction($UserAction, $row);
					if (!$Processed) break;
					$rs->MoveNext();
				}
				if ($Processed) {
					$conn->CommitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->RollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $ActionCaption, $Language->Phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->Close();
			$this->CurrentAction = ""; // Clear action
			if (@$_POST["ajax"] == $UserAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->ClearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->ClearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	function SetupSearchOptions() {
		global $Language;
		$this->SearchOptions = new cListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ewSearchOption";

		// Search button
		$item = &$this->SearchOptions->Add("searchtoggle");
		$SearchToggleClass = ($this->SearchWhere <> "") ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ewSearchToggle" . $SearchToggleClass . "\" title=\"" . $Language->Phrase("SearchPanel") . "\" data-caption=\"" . $Language->Phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fCIE10listsrch\">" . $Language->Phrase("SearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->Add("showall");
		$item->Body = "<a class=\"btn btn-default ewShowAll\" title=\"" . $Language->Phrase("ShowAll") . "\" data-caption=\"" . $Language->Phrase("ShowAll") . "\" href=\"" . $this->PageUrl() . "cmd=reset\">" . $Language->Phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseImageAndText = TRUE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->Phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->Add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->Export <> "" || $this->CurrentAction <> "")
			$this->SearchOptions->HideAllOptions();
	}

	function SetupListOptionsExt() {
		global $Security, $Language;
	}

	function RenderListOptionsExt() {
		global $Security, $Language;
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	function LoadBasicSearchValues() {
		$this->BasicSearch->Keyword = @$_GET[EW_TABLE_BASIC_SEARCH];
		if ($this->BasicSearch->Keyword <> "") $this->Command = "search";
		$this->BasicSearch->Type = @$_GET[EW_TABLE_BASIC_SEARCH_TYPE];
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {

		// Load List page SQL
		$sSql = $this->SelectSQL();
		$conn = &$this->Connection();

		// Load recordset
		$dbtype = ew_GetConnectionType($this->DBID);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["EW_ERROR_FN"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset, array("_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())));
			} else {
				$rs = $conn->SelectLimit($sSql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = ew_LoadRecordset($sSql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn = &$this->Connection();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->Id->setDbValue($rs->fields('Id'));
		$this->Codigo->setDbValue($rs->fields('Codigo'));
		$this->Causa_Completa->setDbValue($rs->fields('Causa_Completa'));
		$this->Causa->setDbValue($rs->fields('Causa'));
		$this->Letra->setDbValue($rs->fields('Letra'));
		$this->Numero->setDbValue($rs->fields('Numero'));
		$this->monitoreado->setDbValue($rs->fields('monitoreado'));
		$this->Grupo_Mortalidad->setDbValue($rs->fields('Grupo_Mortalidad'));
		$this->Nombre_Subgrupo->setDbValue($rs->fields('Nombre_Subgrupo'));
		$this->Grupo_General->setDbValue($rs->fields('Grupo_General'));
		$this->Nombre->setDbValue($rs->fields('Nombre'));
		$this->Codigo_tres->setDbValue($rs->fields('Codigo_tres'));
		$this->Nombre_codigo_tres->setDbValue($rs->fields('Nombre_codigo_tres'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Id->DbValue = $row['Id'];
		$this->Codigo->DbValue = $row['Codigo'];
		$this->Causa_Completa->DbValue = $row['Causa_Completa'];
		$this->Causa->DbValue = $row['Causa'];
		$this->Letra->DbValue = $row['Letra'];
		$this->Numero->DbValue = $row['Numero'];
		$this->monitoreado->DbValue = $row['monitoreado'];
		$this->Grupo_Mortalidad->DbValue = $row['Grupo_Mortalidad'];
		$this->Nombre_Subgrupo->DbValue = $row['Nombre_Subgrupo'];
		$this->Grupo_General->DbValue = $row['Grupo_General'];
		$this->Nombre->DbValue = $row['Nombre'];
		$this->Codigo_tres->DbValue = $row['Codigo_tres'];
		$this->Nombre_codigo_tres->DbValue = $row['Nombre_codigo_tres'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("Id")) <> "")
			$this->Id->CurrentValue = $this->getKey("Id"); // Id
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$conn = &$this->Connection();
			$this->OldRecordset = ew_LoadRecordset($sSql, $conn);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $Security, $Language, $gsLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->GetViewUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->InlineEditUrl = $this->GetInlineEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->InlineCopyUrl = $this->GetInlineCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Id
		// Codigo
		// Causa_Completa
		// Causa
		// Letra
		// Numero
		// monitoreado
		// Grupo_Mortalidad
		// Nombre_Subgrupo
		// Grupo_General
		// Nombre
		// Codigo_tres
		// Nombre_codigo_tres

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

		// Id
		$this->Id->ViewValue = $this->Id->CurrentValue;
		$this->Id->ViewCustomAttributes = "";

		// Codigo
		$this->Codigo->ViewValue = $this->Codigo->CurrentValue;
		$this->Codigo->ViewCustomAttributes = "";

		// Causa_Completa
		$this->Causa_Completa->ViewValue = $this->Causa_Completa->CurrentValue;
		$this->Causa_Completa->ViewCustomAttributes = "";

		// Letra
		$this->Letra->ViewValue = $this->Letra->CurrentValue;
		$this->Letra->ViewCustomAttributes = "";

		// Numero
		$this->Numero->ViewValue = $this->Numero->CurrentValue;
		$this->Numero->ViewCustomAttributes = "";

		// monitoreado
		$this->monitoreado->ViewValue = $this->monitoreado->CurrentValue;
		$this->monitoreado->ViewCustomAttributes = "";

		// Grupo_Mortalidad
		$this->Grupo_Mortalidad->ViewValue = $this->Grupo_Mortalidad->CurrentValue;
		$this->Grupo_Mortalidad->ViewCustomAttributes = "";

		// Nombre_Subgrupo
		$this->Nombre_Subgrupo->ViewValue = $this->Nombre_Subgrupo->CurrentValue;
		$this->Nombre_Subgrupo->ViewCustomAttributes = "";

		// Grupo_General
		$this->Grupo_General->ViewValue = $this->Grupo_General->CurrentValue;
		$this->Grupo_General->ViewCustomAttributes = "";

		// Nombre
		$this->Nombre->ViewValue = $this->Nombre->CurrentValue;
		$this->Nombre->ViewCustomAttributes = "";

		// Codigo_tres
		$this->Codigo_tres->ViewValue = $this->Codigo_tres->CurrentValue;
		$this->Codigo_tres->ViewCustomAttributes = "";

		// Nombre_codigo_tres
		$this->Nombre_codigo_tres->ViewValue = $this->Nombre_codigo_tres->CurrentValue;
		$this->Nombre_codigo_tres->ViewCustomAttributes = "";

			// Id
			$this->Id->LinkCustomAttributes = "";
			$this->Id->HrefValue = "";
			$this->Id->TooltipValue = "";

			// Codigo
			$this->Codigo->LinkCustomAttributes = "";
			$this->Codigo->HrefValue = "";
			$this->Codigo->TooltipValue = "";

			// Causa_Completa
			$this->Causa_Completa->LinkCustomAttributes = "";
			$this->Causa_Completa->HrefValue = "";
			$this->Causa_Completa->TooltipValue = "";

			// Letra
			$this->Letra->LinkCustomAttributes = "";
			$this->Letra->HrefValue = "";
			$this->Letra->TooltipValue = "";

			// Numero
			$this->Numero->LinkCustomAttributes = "";
			$this->Numero->HrefValue = "";
			$this->Numero->TooltipValue = "";

			// monitoreado
			$this->monitoreado->LinkCustomAttributes = "";
			$this->monitoreado->HrefValue = "";
			$this->monitoreado->TooltipValue = "";

			// Grupo_Mortalidad
			$this->Grupo_Mortalidad->LinkCustomAttributes = "";
			$this->Grupo_Mortalidad->HrefValue = "";
			$this->Grupo_Mortalidad->TooltipValue = "";

			// Nombre_Subgrupo
			$this->Nombre_Subgrupo->LinkCustomAttributes = "";
			$this->Nombre_Subgrupo->HrefValue = "";
			$this->Nombre_Subgrupo->TooltipValue = "";

			// Grupo_General
			$this->Grupo_General->LinkCustomAttributes = "";
			$this->Grupo_General->HrefValue = "";
			$this->Grupo_General->TooltipValue = "";

			// Nombre
			$this->Nombre->LinkCustomAttributes = "";
			$this->Nombre->HrefValue = "";
			$this->Nombre->TooltipValue = "";

			// Codigo_tres
			$this->Codigo_tres->LinkCustomAttributes = "";
			$this->Codigo_tres->HrefValue = "";
			$this->Codigo_tres->TooltipValue = "";

			// Nombre_codigo_tres
			$this->Nombre_codigo_tres->LinkCustomAttributes = "";
			$this->Nombre_codigo_tres->HrefValue = "";
			$this->Nombre_codigo_tres->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$url = substr(ew_CurrentUrl(), strrpos(ew_CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->Add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example: 
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

	    //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($CIE10_list)) $CIE10_list = new cCIE10_list();

// Page init
$CIE10_list->Page_Init();

// Page main
$CIE10_list->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$CIE10_list->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Form object
var CurrentPageID = EW_PAGE_ID = "list";
var CurrentForm = fCIE10list = new ew_Form("fCIE10list", "list");
fCIE10list.FormKeyCountName = '<?php echo $CIE10_list->FormKeyCountName ?>';

// Form_CustomValidate event
fCIE10list.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fCIE10list.ValidateRequired = true;
<?php } else { ?>
fCIE10list.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

var CurrentSearchForm = fCIE10listsrch = new ew_Form("fCIE10listsrch");
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<div class="ewToolbar">
<?php $Breadcrumb->Render(); ?>
<?php if ($CIE10_list->TotalRecs > 0 && $CIE10_list->ExportOptions->Visible()) { ?>
<?php $CIE10_list->ExportOptions->Render("body") ?>
<?php } ?>
<?php if ($CIE10_list->SearchOptions->Visible()) { ?>
<?php $CIE10_list->SearchOptions->Render("body") ?>
<?php } ?>
<?php if ($CIE10_list->FilterOptions->Visible()) { ?>
<?php $CIE10_list->FilterOptions->Render("body") ?>
<?php } ?>
<?php echo $Language->SelectionForm(); ?>
<div class="clearfix"></div>
</div>
<?php
	$bSelectLimit = $CIE10_list->UseSelectLimit;
	if ($bSelectLimit) {
		if ($CIE10_list->TotalRecs <= 0)
			$CIE10_list->TotalRecs = $CIE10->SelectRecordCount();
	} else {
		if (!$CIE10_list->Recordset && ($CIE10_list->Recordset = $CIE10_list->LoadRecordset()))
			$CIE10_list->TotalRecs = $CIE10_list->Recordset->RecordCount();
	}
	$CIE10_list->StartRec = 1;
	if ($CIE10_list->DisplayRecs <= 0 || ($CIE10->Export <> "" && $CIE10->ExportAll)) // Display all records
		$CIE10_list->DisplayRecs = $CIE10_list->TotalRecs;
	if (!($CIE10->Export <> "" && $CIE10->ExportAll))
		$CIE10_list->SetUpStartRec(); // Set up start record position
	if ($bSelectLimit)
		$CIE10_list->Recordset = $CIE10_list->LoadRecordset($CIE10_list->StartRec-1, $CIE10_list->DisplayRecs);

	// Set no record found message
	if ($CIE10->CurrentAction == "" && $CIE10_list->TotalRecs == 0) {
		if ($CIE10_list->SearchWhere == "0=101")
			$CIE10_list->setWarningMessage($Language->Phrase("EnterSearchCriteria"));
		else
			$CIE10_list->setWarningMessage($Language->Phrase("NoRecord"));
	}
$CIE10_list->RenderOtherOptions();
?>
<?php if ($CIE10->Export == "" && $CIE10->CurrentAction == "") { ?>
<form name="fCIE10listsrch" id="fCIE10listsrch" class="form-inline ewForm" action="<?php echo ew_CurrentPage() ?>">
<?php $SearchPanelClass = ($CIE10_list->SearchWhere <> "") ? " in" : " in"; ?>
<div id="fCIE10listsrch_SearchPanel" class="ewSearchPanel collapse<?php echo $SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="CIE10">
	<div class="ewBasicSearch">
<div id="xsr_1" class="ewRow">
	<div class="ewQuickSearch input-group">
	<input type="text" name="<?php echo EW_TABLE_BASIC_SEARCH ?>" id="<?php echo EW_TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo ew_HtmlEncode($CIE10_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo ew_HtmlEncode($Language->Phrase("Search")) ?>">
	<input type="hidden" name="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo EW_TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo ew_HtmlEncode($CIE10_list->BasicSearch->getType()) ?>">
	<div class="input-group-btn">
		<button type="button" data-toggle="dropdown" class="btn btn-default"><span id="searchtype"><?php echo $CIE10_list->BasicSearch->getTypeNameShort() ?></span><span class="caret"></span></button>
		<ul class="dropdown-menu pull-right" role="menu">
			<li<?php if ($CIE10_list->BasicSearch->getType() == "") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this)"><?php echo $Language->Phrase("QuickSearchAuto") ?></a></li>
			<li<?php if ($CIE10_list->BasicSearch->getType() == "=") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'=')"><?php echo $Language->Phrase("QuickSearchExact") ?></a></li>
			<li<?php if ($CIE10_list->BasicSearch->getType() == "AND") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'AND')"><?php echo $Language->Phrase("QuickSearchAll") ?></a></li>
			<li<?php if ($CIE10_list->BasicSearch->getType() == "OR") echo " class=\"active\""; ?>><a href="javascript:void(0);" onclick="ew_SetSearchType(this,'OR')"><?php echo $Language->Phrase("QuickSearchAny") ?></a></li>
		</ul>
	<button class="btn btn-primary ewButton" name="btnsubmit" id="btnsubmit" type="submit"><?php echo $Language->Phrase("QuickSearchBtn") ?></button>
	</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php $CIE10_list->ShowPageHeader(); ?>
<?php
$CIE10_list->ShowMessage();
?>
<?php if ($CIE10_list->TotalRecs > 0 || $CIE10->CurrentAction <> "") { ?>
<div class="panel panel-default ewGrid">
<form name="fCIE10list" id="fCIE10list" class="form-inline ewForm ewListForm" action="<?php echo ew_CurrentPage() ?>" method="post">
<?php if ($CIE10_list->CheckToken) { ?>
<input type="hidden" name="<?php echo EW_TOKEN_NAME ?>" value="<?php echo $CIE10_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="CIE10">
<div id="gmp_CIE10" class="<?php if (ew_IsResponsiveLayout()) { echo "table-responsive "; } ?>ewGridMiddlePanel">
<?php if ($CIE10_list->TotalRecs > 0) { ?>
<table id="tbl_CIE10list" class="table ewTable">
<?php echo $CIE10->TableCustomInnerHtml ?>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<?php

// Header row
$CIE10_list->RowType = EW_ROWTYPE_HEADER;

// Render list options
$CIE10_list->RenderListOptions();

// Render list options (header, left)
$CIE10_list->ListOptions->Render("header", "left");
?>
<?php if ($CIE10->Id->Visible) { // Id ?>
	<?php if ($CIE10->SortUrl($CIE10->Id) == "") { ?>
		<th data-name="Id"><div id="elh_CIE10_Id" class="CIE10_Id"><div class="ewTableHeaderCaption"><?php echo $CIE10->Id->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Id"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Id) ?>',1);"><div id="elh_CIE10_Id" class="CIE10_Id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Id->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Id->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Id->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Codigo->Visible) { // Codigo ?>
	<?php if ($CIE10->SortUrl($CIE10->Codigo) == "") { ?>
		<th data-name="Codigo"><div id="elh_CIE10_Codigo" class="CIE10_Codigo"><div class="ewTableHeaderCaption"><?php echo $CIE10->Codigo->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Codigo) ?>',1);"><div id="elh_CIE10_Codigo" class="CIE10_Codigo">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Codigo->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Codigo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Codigo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Causa_Completa->Visible) { // Causa_Completa ?>
	<?php if ($CIE10->SortUrl($CIE10->Causa_Completa) == "") { ?>
		<th data-name="Causa_Completa"><div id="elh_CIE10_Causa_Completa" class="CIE10_Causa_Completa"><div class="ewTableHeaderCaption"><?php echo $CIE10->Causa_Completa->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Causa_Completa"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Causa_Completa) ?>',1);"><div id="elh_CIE10_Causa_Completa" class="CIE10_Causa_Completa">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Causa_Completa->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Causa_Completa->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Causa_Completa->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Letra->Visible) { // Letra ?>
	<?php if ($CIE10->SortUrl($CIE10->Letra) == "") { ?>
		<th data-name="Letra"><div id="elh_CIE10_Letra" class="CIE10_Letra"><div class="ewTableHeaderCaption"><?php echo $CIE10->Letra->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Letra"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Letra) ?>',1);"><div id="elh_CIE10_Letra" class="CIE10_Letra">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Letra->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Letra->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Letra->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Numero->Visible) { // Numero ?>
	<?php if ($CIE10->SortUrl($CIE10->Numero) == "") { ?>
		<th data-name="Numero"><div id="elh_CIE10_Numero" class="CIE10_Numero"><div class="ewTableHeaderCaption"><?php echo $CIE10->Numero->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Numero"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Numero) ?>',1);"><div id="elh_CIE10_Numero" class="CIE10_Numero">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Numero->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Numero->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Numero->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->monitoreado->Visible) { // monitoreado ?>
	<?php if ($CIE10->SortUrl($CIE10->monitoreado) == "") { ?>
		<th data-name="monitoreado"><div id="elh_CIE10_monitoreado" class="CIE10_monitoreado"><div class="ewTableHeaderCaption"><?php echo $CIE10->monitoreado->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="monitoreado"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->monitoreado) ?>',1);"><div id="elh_CIE10_monitoreado" class="CIE10_monitoreado">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->monitoreado->FldCaption() ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->monitoreado->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->monitoreado->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Grupo_Mortalidad->Visible) { // Grupo_Mortalidad ?>
	<?php if ($CIE10->SortUrl($CIE10->Grupo_Mortalidad) == "") { ?>
		<th data-name="Grupo_Mortalidad"><div id="elh_CIE10_Grupo_Mortalidad" class="CIE10_Grupo_Mortalidad"><div class="ewTableHeaderCaption"><?php echo $CIE10->Grupo_Mortalidad->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Grupo_Mortalidad"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Grupo_Mortalidad) ?>',1);"><div id="elh_CIE10_Grupo_Mortalidad" class="CIE10_Grupo_Mortalidad">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Grupo_Mortalidad->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Grupo_Mortalidad->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Grupo_Mortalidad->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Nombre_Subgrupo->Visible) { // Nombre_Subgrupo ?>
	<?php if ($CIE10->SortUrl($CIE10->Nombre_Subgrupo) == "") { ?>
		<th data-name="Nombre_Subgrupo"><div id="elh_CIE10_Nombre_Subgrupo" class="CIE10_Nombre_Subgrupo"><div class="ewTableHeaderCaption"><?php echo $CIE10->Nombre_Subgrupo->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nombre_Subgrupo"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Nombre_Subgrupo) ?>',1);"><div id="elh_CIE10_Nombre_Subgrupo" class="CIE10_Nombre_Subgrupo">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Nombre_Subgrupo->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Nombre_Subgrupo->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Nombre_Subgrupo->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Grupo_General->Visible) { // Grupo_General ?>
	<?php if ($CIE10->SortUrl($CIE10->Grupo_General) == "") { ?>
		<th data-name="Grupo_General"><div id="elh_CIE10_Grupo_General" class="CIE10_Grupo_General"><div class="ewTableHeaderCaption"><?php echo $CIE10->Grupo_General->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Grupo_General"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Grupo_General) ?>',1);"><div id="elh_CIE10_Grupo_General" class="CIE10_Grupo_General">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Grupo_General->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Grupo_General->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Grupo_General->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Nombre->Visible) { // Nombre ?>
	<?php if ($CIE10->SortUrl($CIE10->Nombre) == "") { ?>
		<th data-name="Nombre"><div id="elh_CIE10_Nombre" class="CIE10_Nombre"><div class="ewTableHeaderCaption"><?php echo $CIE10->Nombre->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nombre"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Nombre) ?>',1);"><div id="elh_CIE10_Nombre" class="CIE10_Nombre">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Nombre->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Nombre->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Nombre->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Codigo_tres->Visible) { // Codigo_tres ?>
	<?php if ($CIE10->SortUrl($CIE10->Codigo_tres) == "") { ?>
		<th data-name="Codigo_tres"><div id="elh_CIE10_Codigo_tres" class="CIE10_Codigo_tres"><div class="ewTableHeaderCaption"><?php echo $CIE10->Codigo_tres->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Codigo_tres"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Codigo_tres) ?>',1);"><div id="elh_CIE10_Codigo_tres" class="CIE10_Codigo_tres">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Codigo_tres->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Codigo_tres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Codigo_tres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php if ($CIE10->Nombre_codigo_tres->Visible) { // Nombre_codigo_tres ?>
	<?php if ($CIE10->SortUrl($CIE10->Nombre_codigo_tres) == "") { ?>
		<th data-name="Nombre_codigo_tres"><div id="elh_CIE10_Nombre_codigo_tres" class="CIE10_Nombre_codigo_tres"><div class="ewTableHeaderCaption"><?php echo $CIE10->Nombre_codigo_tres->FldCaption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nombre_codigo_tres"><div class="ewPointer" onclick="ew_Sort(event,'<?php echo $CIE10->SortUrl($CIE10->Nombre_codigo_tres) ?>',1);"><div id="elh_CIE10_Nombre_codigo_tres" class="CIE10_Nombre_codigo_tres">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><?php echo $CIE10->Nombre_codigo_tres->FldCaption() ?><?php echo $Language->Phrase("SrchLegend") ?></span><span class="ewTableHeaderSort"><?php if ($CIE10->Nombre_codigo_tres->getSort() == "ASC") { ?><span class="caret ewSortUp"></span><?php } elseif ($CIE10->Nombre_codigo_tres->getSort() == "DESC") { ?><span class="caret"></span><?php } ?></span></div>
        </div></div></th>
	<?php } ?>
<?php } ?>		
<?php

// Render list options (header, right)
$CIE10_list->ListOptions->Render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($CIE10->ExportAll && $CIE10->Export <> "") {
	$CIE10_list->StopRec = $CIE10_list->TotalRecs;
} else {

	// Set the last record to display
	if ($CIE10_list->TotalRecs > $CIE10_list->StartRec + $CIE10_list->DisplayRecs - 1)
		$CIE10_list->StopRec = $CIE10_list->StartRec + $CIE10_list->DisplayRecs - 1;
	else
		$CIE10_list->StopRec = $CIE10_list->TotalRecs;
}
$CIE10_list->RecCnt = $CIE10_list->StartRec - 1;
if ($CIE10_list->Recordset && !$CIE10_list->Recordset->EOF) {
	$CIE10_list->Recordset->MoveFirst();
	$bSelectLimit = $CIE10_list->UseSelectLimit;
	if (!$bSelectLimit && $CIE10_list->StartRec > 1)
		$CIE10_list->Recordset->Move($CIE10_list->StartRec - 1);
} elseif (!$CIE10->AllowAddDeleteRow && $CIE10_list->StopRec == 0) {
	$CIE10_list->StopRec = $CIE10->GridAddRowCount;
}

// Initialize aggregate
$CIE10->RowType = EW_ROWTYPE_AGGREGATEINIT;
$CIE10->ResetAttrs();
$CIE10_list->RenderRow();
while ($CIE10_list->RecCnt < $CIE10_list->StopRec) {
	$CIE10_list->RecCnt++;
	if (intval($CIE10_list->RecCnt) >= intval($CIE10_list->StartRec)) {
		$CIE10_list->RowCnt++;

		// Set up key count
		$CIE10_list->KeyCount = $CIE10_list->RowIndex;

		// Init row class and style
		$CIE10->ResetAttrs();
		$CIE10->CssClass = "";
		if ($CIE10->CurrentAction == "gridadd") {
		} else {
			$CIE10_list->LoadRowValues($CIE10_list->Recordset); // Load row values
		}
		$CIE10->RowType = EW_ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$CIE10->RowAttrs = array_merge($CIE10->RowAttrs, array('data-rowindex'=>$CIE10_list->RowCnt, 'id'=>'r' . $CIE10_list->RowCnt . '_CIE10', 'data-rowtype'=>$CIE10->RowType));

		// Render row
		$CIE10_list->RenderRow();

		// Render list options
		$CIE10_list->RenderListOptions();
?>
	<tr<?php echo $CIE10->RowAttributes() ?>>
<?php

// Render list options (body, left)
$CIE10_list->ListOptions->Render("body", "left", $CIE10_list->RowCnt);
?>
	<?php if ($CIE10->Id->Visible) { // Id ?>
		<td data-name="Id"<?php echo $CIE10->Id->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Id" class="CIE10_Id">
<span<?php echo $CIE10->Id->ViewAttributes() ?>>
<?php echo $CIE10->Id->ListViewValue() ?></span>
</span>
<a id="<?php echo $CIE10_list->PageObjName . "_row_" . $CIE10_list->RowCnt ?>"></a></td>
	<?php } ?>
	<?php if ($CIE10->Codigo->Visible) { // Codigo ?>
		<td data-name="Codigo"<?php echo $CIE10->Codigo->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Codigo" class="CIE10_Codigo">
<span<?php echo $CIE10->Codigo->ViewAttributes() ?>>
<?php echo $CIE10->Codigo->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->Causa_Completa->Visible) { // Causa_Completa ?>
		<td data-name="Causa_Completa"<?php echo $CIE10->Causa_Completa->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Causa_Completa" class="CIE10_Causa_Completa">
<span<?php echo $CIE10->Causa_Completa->ViewAttributes() ?>>
<?php echo $CIE10->Causa_Completa->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->Letra->Visible) { // Letra ?>
		<td data-name="Letra"<?php echo $CIE10->Letra->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Letra" class="CIE10_Letra">
<span<?php echo $CIE10->Letra->ViewAttributes() ?>>
<?php echo $CIE10->Letra->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->Numero->Visible) { // Numero ?>
		<td data-name="Numero"<?php echo $CIE10->Numero->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Numero" class="CIE10_Numero">
<span<?php echo $CIE10->Numero->ViewAttributes() ?>>
<?php echo $CIE10->Numero->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->monitoreado->Visible) { // monitoreado ?>
		<td data-name="monitoreado"<?php echo $CIE10->monitoreado->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_monitoreado" class="CIE10_monitoreado">
<span<?php echo $CIE10->monitoreado->ViewAttributes() ?>>
<?php echo $CIE10->monitoreado->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->Grupo_Mortalidad->Visible) { // Grupo_Mortalidad ?>
		<td data-name="Grupo_Mortalidad"<?php echo $CIE10->Grupo_Mortalidad->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Grupo_Mortalidad" class="CIE10_Grupo_Mortalidad">
<span<?php echo $CIE10->Grupo_Mortalidad->ViewAttributes() ?>>
<?php echo $CIE10->Grupo_Mortalidad->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->Nombre_Subgrupo->Visible) { // Nombre_Subgrupo ?>
		<td data-name="Nombre_Subgrupo"<?php echo $CIE10->Nombre_Subgrupo->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Nombre_Subgrupo" class="CIE10_Nombre_Subgrupo">
<span<?php echo $CIE10->Nombre_Subgrupo->ViewAttributes() ?>>
<?php echo $CIE10->Nombre_Subgrupo->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->Grupo_General->Visible) { // Grupo_General ?>
		<td data-name="Grupo_General"<?php echo $CIE10->Grupo_General->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Grupo_General" class="CIE10_Grupo_General">
<span<?php echo $CIE10->Grupo_General->ViewAttributes() ?>>
<?php echo $CIE10->Grupo_General->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->Nombre->Visible) { // Nombre ?>
		<td data-name="Nombre"<?php echo $CIE10->Nombre->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Nombre" class="CIE10_Nombre">
<span<?php echo $CIE10->Nombre->ViewAttributes() ?>>
<?php echo $CIE10->Nombre->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->Codigo_tres->Visible) { // Codigo_tres ?>
		<td data-name="Codigo_tres"<?php echo $CIE10->Codigo_tres->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Codigo_tres" class="CIE10_Codigo_tres">
<span<?php echo $CIE10->Codigo_tres->ViewAttributes() ?>>
<?php echo $CIE10->Codigo_tres->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CIE10->Nombre_codigo_tres->Visible) { // Nombre_codigo_tres ?>
		<td data-name="Nombre_codigo_tres"<?php echo $CIE10->Nombre_codigo_tres->CellAttributes() ?>>
<span id="el<?php echo $CIE10_list->RowCnt ?>_CIE10_Nombre_codigo_tres" class="CIE10_Nombre_codigo_tres">
<span<?php echo $CIE10->Nombre_codigo_tres->ViewAttributes() ?>>
<?php echo $CIE10->Nombre_codigo_tres->ListViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$CIE10_list->ListOptions->Render("body", "right", $CIE10_list->RowCnt);
?>
	</tr>
<?php
	}
	if ($CIE10->CurrentAction <> "gridadd")
		$CIE10_list->Recordset->MoveNext();
}
?>
</tbody>
</table>
<?php } ?>
<?php if ($CIE10->CurrentAction == "") { ?>
<input type="hidden" name="a_list" id="a_list" value="">
<?php } ?>
</div>
</form>
<?php

// Close recordset
if ($CIE10_list->Recordset)
	$CIE10_list->Recordset->Close();
?>
<div class="panel-footer ewGridLowerPanel">
<?php if ($CIE10->CurrentAction <> "gridadd" && $CIE10->CurrentAction <> "gridedit") { ?>
<form name="ewPagerForm" class="ewForm form-inline ewPagerForm" action="<?php echo ew_CurrentPage() ?>">
<?php if (!isset($CIE10_list->Pager)) $CIE10_list->Pager = new cPrevNextPager($CIE10_list->StartRec, $CIE10_list->DisplayRecs, $CIE10_list->TotalRecs) ?>
<?php if ($CIE10_list->Pager->RecordCount > 0) { ?>
<div class="ewPager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ewPrevNext"><div class="input-group">
<div class="input-group-btn">
<!--first page button-->
	<?php if ($CIE10_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerFirst") ?>" href="<?php echo $CIE10_list->PageUrl() ?>start=<?php echo $CIE10_list->Pager->FirstButton->Start ?>"><span class="icon-first ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerFirst") ?>"><span class="icon-first ewIcon"></span></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($CIE10_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerPrevious") ?>" href="<?php echo $CIE10_list->PageUrl() ?>start=<?php echo $CIE10_list->Pager->PrevButton->Start ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerPrevious") ?>"><span class="icon-prev ewIcon"></span></a>
	<?php } ?>
</div>
<!--current page number-->
	<input class="form-control input-sm" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $CIE10_list->Pager->CurrentPage ?>">
<div class="input-group-btn">
<!--next page button-->
	<?php if ($CIE10_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerNext") ?>" href="<?php echo $CIE10_list->PageUrl() ?>start=<?php echo $CIE10_list->Pager->NextButton->Start ?>"><span class="icon-next ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerNext") ?>"><span class="icon-next ewIcon"></span></a>
	<?php } ?>
<!--last page button-->
	<?php if ($CIE10_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default btn-sm" title="<?php echo $Language->Phrase("PagerLast") ?>" href="<?php echo $CIE10_list->PageUrl() ?>start=<?php echo $CIE10_list->Pager->LastButton->Start ?>"><span class="icon-last ewIcon"></span></a>
	<?php } else { ?>
	<a class="btn btn-default btn-sm disabled" title="<?php echo $Language->Phrase("PagerLast") ?>"><span class="icon-last ewIcon"></span></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $CIE10_list->Pager->PageCount ?></span>
</div>
<div class="ewPager ewRec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $CIE10_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $CIE10_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $CIE10_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ewListOtherOptions">
<?php
	foreach ($CIE10_list->OtherOptions as &$option)
		$option->Render("body", "bottom");
?>
</div>
<div class="clearfix"></div>
</div>
</div>
<?php } ?>
<?php if ($CIE10_list->TotalRecs == 0 && $CIE10->CurrentAction == "") { // Show other options ?>
<div class="ewListOtherOptions">
<?php
	foreach ($CIE10_list->OtherOptions as &$option) {
		$option->ButtonClass = "";
		$option->Render("body", "");
	}
?>
</div>
<div class="clearfix"></div>
<?php } ?>
<script type="text/javascript">
fCIE10listsrch.Init();
fCIE10listsrch.FilterList = <?php echo $CIE10_list->GetFilterList() ?>;
fCIE10list.Init();
</script>
<?php
$CIE10_list->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$CIE10_list->Page_Terminate();
?>
