<?php

// Global variable for table object
$Consulta = NULL;

//
// Table class for Consulta
//
class cConsulta extends cTable {
	var $Num_factura;
	var $Codigo_prestador;
	var $Tipo_id_usuario;
	var $Numero_id_usuario;
	var $Fecha_consulta;
	var $Numero_autorizacion;
	var $Codigo_consulta;
	var $Finalidad_consulta;
	var $Causa_externa;
	var $Codigo_diagnostico;
	var $Codigo_diagnostico_rel1;
	var $Codigo_diagnostico_rel2;
	var $Codigo_diagnostico_rel3;
	var $Tipo_diagnostico_principal;
	var $Valor_consulta;
	var $Valor_cuota_mod;
	var $Valor_neto;

	//
	// Table class constructor
	//
	function __construct() {
		global $Language;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();
		$this->TableVar = 'Consulta';
		$this->TableName = 'Consulta';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`Consulta`";
		$this->DBID = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = ""; // Page orientation (PHPExcel only)
		$this->ExportExcelPageSize = ""; // Page size (PHPExcel only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = ew_AllowAddDeleteRow(); // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new cBasicSearch($this->TableVar);

		// Num_factura
		$this->Num_factura = new cField('Consulta', 'Consulta', 'x_Num_factura', 'Num_factura', '`Num_factura`', '`Num_factura`', 200, -1, FALSE, '`Num_factura`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Num_factura'] = &$this->Num_factura;

		// Codigo_prestador
		$this->Codigo_prestador = new cField('Consulta', 'Consulta', 'x_Codigo_prestador', 'Codigo_prestador', '`Codigo_prestador`', '`Codigo_prestador`', 200, -1, FALSE, '`Codigo_prestador`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Codigo_prestador'] = &$this->Codigo_prestador;

		// Tipo_id_usuario
		$this->Tipo_id_usuario = new cField('Consulta', 'Consulta', 'x_Tipo_id_usuario', 'Tipo_id_usuario', '`Tipo_id_usuario`', '`Tipo_id_usuario`', 200, -1, FALSE, '`Tipo_id_usuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Tipo_id_usuario'] = &$this->Tipo_id_usuario;

		// Numero_id_usuario
		$this->Numero_id_usuario = new cField('Consulta', 'Consulta', 'x_Numero_id_usuario', 'Numero_id_usuario', '`Numero_id_usuario`', '`Numero_id_usuario`', 200, -1, FALSE, '`Numero_id_usuario`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Numero_id_usuario'] = &$this->Numero_id_usuario;

		// Fecha_consulta
		$this->Fecha_consulta = new cField('Consulta', 'Consulta', 'x_Fecha_consulta', 'Fecha_consulta', '`Fecha_consulta`', '`Fecha_consulta`', 200, -1, FALSE, '`Fecha_consulta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Fecha_consulta'] = &$this->Fecha_consulta;

		// Numero_autorizacion
		$this->Numero_autorizacion = new cField('Consulta', 'Consulta', 'x_Numero_autorizacion', 'Numero_autorizacion', '`Numero_autorizacion`', '`Numero_autorizacion`', 20, -1, FALSE, '`Numero_autorizacion`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Numero_autorizacion->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Numero_autorizacion'] = &$this->Numero_autorizacion;

		// Codigo_consulta
		$this->Codigo_consulta = new cField('Consulta', 'Consulta', 'x_Codigo_consulta', 'Codigo_consulta', '`Codigo_consulta`', '`Codigo_consulta`', 3, -1, FALSE, '`Codigo_consulta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Codigo_consulta->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Codigo_consulta'] = &$this->Codigo_consulta;

		// Finalidad_consulta
		$this->Finalidad_consulta = new cField('Consulta', 'Consulta', 'x_Finalidad_consulta', 'Finalidad_consulta', '`Finalidad_consulta`', '`Finalidad_consulta`', 3, -1, FALSE, '`Finalidad_consulta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Finalidad_consulta->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Finalidad_consulta'] = &$this->Finalidad_consulta;

		// Causa_externa
		$this->Causa_externa = new cField('Consulta', 'Consulta', 'x_Causa_externa', 'Causa_externa', '`Causa_externa`', '`Causa_externa`', 3, -1, FALSE, '`Causa_externa`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Causa_externa->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Causa_externa'] = &$this->Causa_externa;

		// Codigo_diagnostico
		$this->Codigo_diagnostico = new cField('Consulta', 'Consulta', 'x_Codigo_diagnostico', 'Codigo_diagnostico', '`Codigo_diagnostico`', '`Codigo_diagnostico`', 200, -1, FALSE, '`Codigo_diagnostico`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Codigo_diagnostico'] = &$this->Codigo_diagnostico;

		// Codigo_diagnostico_rel1
		$this->Codigo_diagnostico_rel1 = new cField('Consulta', 'Consulta', 'x_Codigo_diagnostico_rel1', 'Codigo_diagnostico_rel1', '`Codigo_diagnostico_rel1`', '`Codigo_diagnostico_rel1`', 200, -1, FALSE, '`Codigo_diagnostico_rel1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Codigo_diagnostico_rel1'] = &$this->Codigo_diagnostico_rel1;

		// Codigo_diagnostico_rel2
		$this->Codigo_diagnostico_rel2 = new cField('Consulta', 'Consulta', 'x_Codigo_diagnostico_rel2', 'Codigo_diagnostico_rel2', '`Codigo_diagnostico_rel2`', '`Codigo_diagnostico_rel2`', 200, -1, FALSE, '`Codigo_diagnostico_rel2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Codigo_diagnostico_rel2'] = &$this->Codigo_diagnostico_rel2;

		// Codigo_diagnostico_rel3
		$this->Codigo_diagnostico_rel3 = new cField('Consulta', 'Consulta', 'x_Codigo_diagnostico_rel3', 'Codigo_diagnostico_rel3', '`Codigo_diagnostico_rel3`', '`Codigo_diagnostico_rel3`', 200, -1, FALSE, '`Codigo_diagnostico_rel3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Codigo_diagnostico_rel3'] = &$this->Codigo_diagnostico_rel3;

		// Tipo_diagnostico_principal
		$this->Tipo_diagnostico_principal = new cField('Consulta', 'Consulta', 'x_Tipo_diagnostico_principal', 'Tipo_diagnostico_principal', '`Tipo_diagnostico_principal`', '`Tipo_diagnostico_principal`', 3, -1, FALSE, '`Tipo_diagnostico_principal`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tipo_diagnostico_principal->FldDefaultErrMsg = $Language->Phrase("IncorrectInteger");
		$this->fields['Tipo_diagnostico_principal'] = &$this->Tipo_diagnostico_principal;

		// Valor_consulta
		$this->Valor_consulta = new cField('Consulta', 'Consulta', 'x_Valor_consulta', 'Valor_consulta', '`Valor_consulta`', '`Valor_consulta`', 200, -1, FALSE, '`Valor_consulta`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Valor_consulta'] = &$this->Valor_consulta;

		// Valor_cuota_mod
		$this->Valor_cuota_mod = new cField('Consulta', 'Consulta', 'x_Valor_cuota_mod', 'Valor_cuota_mod', '`Valor_cuota_mod`', '`Valor_cuota_mod`', 200, -1, FALSE, '`Valor_cuota_mod`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Valor_cuota_mod'] = &$this->Valor_cuota_mod;

		// Valor_neto
		$this->Valor_neto = new cField('Consulta', 'Consulta', 'x_Valor_neto', 'Valor_neto', '`Valor_neto`', '`Valor_neto`', 200, -1, FALSE, '`Valor_neto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fields['Valor_neto'] = &$this->Valor_neto;
	}

	// Single column sort
	function UpdateSort(&$ofld) {
		if ($this->CurrentOrder == $ofld->FldName) {
			$sSortField = $ofld->FldExpression;
			$sLastSort = $ofld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$sThisSort = $this->CurrentOrderType;
			} else {
				$sThisSort = ($sLastSort == "ASC") ? "DESC" : "ASC";
			}
			$ofld->setSort($sThisSort);
			$this->setSessionOrderBy($sSortField . " " . $sThisSort); // Save to Session
		} else {
			$ofld->setSort("");
		}
	}

	// Table level SQL
	var $_SqlFrom = "";

	function getSqlFrom() { // From
		return ($this->_SqlFrom <> "") ? $this->_SqlFrom : "`Consulta`";
	}

	function SqlFrom() { // For backward compatibility
    	return $this->getSqlFrom();
	}

	function setSqlFrom($v) {
    	$this->_SqlFrom = $v;
	}
	var $_SqlSelect = "";

	function getSqlSelect() { // Select
		return ($this->_SqlSelect <> "") ? $this->_SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}

	function SqlSelect() { // For backward compatibility
    	return $this->getSqlSelect();
	}

	function setSqlSelect($v) {
    	$this->_SqlSelect = $v;
	}
	var $_SqlWhere = "";

	function getSqlWhere() { // Where
		$sWhere = ($this->_SqlWhere <> "") ? $this->_SqlWhere : "";
		$this->TableFilter = "";
		ew_AddFilter($sWhere, $this->TableFilter);
		return $sWhere;
	}

	function SqlWhere() { // For backward compatibility
    	return $this->getSqlWhere();
	}

	function setSqlWhere($v) {
    	$this->_SqlWhere = $v;
	}
	var $_SqlGroupBy = "";

	function getSqlGroupBy() { // Group By
		return ($this->_SqlGroupBy <> "") ? $this->_SqlGroupBy : "";
	}

	function SqlGroupBy() { // For backward compatibility
    	return $this->getSqlGroupBy();
	}

	function setSqlGroupBy($v) {
    	$this->_SqlGroupBy = $v;
	}
	var $_SqlHaving = "";

	function getSqlHaving() { // Having
		return ($this->_SqlHaving <> "") ? $this->_SqlHaving : "";
	}

	function SqlHaving() { // For backward compatibility
    	return $this->getSqlHaving();
	}

	function setSqlHaving($v) {
    	$this->_SqlHaving = $v;
	}
	var $_SqlOrderBy = "";

	function getSqlOrderBy() { // Order By
		return ($this->_SqlOrderBy <> "") ? $this->_SqlOrderBy : "";
	}

	function SqlOrderBy() { // For backward compatibility
    	return $this->getSqlOrderBy();
	}

	function setSqlOrderBy($v) {
    	$this->_SqlOrderBy = $v;
	}

	// Apply User ID filters
	function ApplyUserIDFilters($sFilter) {
		return $sFilter;
	}

	// Check if User ID security allows view all
	function UserIDAllow($id = "") {
		$allow = EW_USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	function GetSQL($where, $orderby) {
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderby);
	}

	// Table SQL
	function SQL() {
		$sFilter = $this->CurrentFilter;
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$sFilter, $sSort);
	}

	// Table SQL with List page filter
	function SelectSQL() {
		$sFilter = $this->getSessionWhere();
		ew_AddFilter($sFilter, $this->CurrentFilter);
		$sFilter = $this->ApplyUserIDFilters($sFilter);
		$this->Recordset_Selecting($sFilter);
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $sFilter, $sSort);
	}

	// Get ORDER BY clause
	function GetOrderBy() {
		$sSort = $this->getSessionOrderBy();
		return ew_BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sSort);
	}

	// Try to get record count
	function TryGetRecordCount($sSql) {
		$cnt = -1;
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') && preg_match("/^SELECT \* FROM/i", $sSql)) {
			$sSql = "SELECT COUNT(*) FROM" . preg_replace('/^SELECT\s([\s\S]+)?\*\sFROM/i', "", $sSql);
			$sOrderBy = $this->GetOrderBy();
			if (substr($sSql, strlen($sOrderBy) * -1) == $sOrderBy)
				$sSql = substr($sSql, 0, strlen($sSql) - strlen($sOrderBy)); // Remove ORDER BY clause
		} else {
			$sSql = "SELECT COUNT(*) FROM (" . $sSql . ") EW_COUNT_TABLE";
		}
		$conn = &$this->Connection();
		if ($rs = $conn->Execute($sSql)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// Get record count based on filter (for detail record count in master table pages)
	function LoadRecordCount($sFilter) {
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $sFilter;
		$this->Recordset_Selecting($this->CurrentFilter);

		//$sSql = $this->SQL();
		$sSql = $this->GetSQL($this->CurrentFilter, "");
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			if ($rs = $this->LoadRs($this->CurrentFilter)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		$this->CurrentFilter = $origFilter;
		return intval($cnt);
	}

	// Get record count (for current List page)
	function SelectRecordCount() {
		$sSql = $this->SelectSQL();
		$cnt = $this->TryGetRecordCount($sSql);
		if ($cnt == -1) {
			$conn = &$this->Connection();
			if ($rs = $conn->Execute($sSql)) {
				$cnt = $rs->RecordCount();
				$rs->Close();
			}
		}
		return intval($cnt);
	}

	// INSERT statement
	function InsertSQL(&$rs) {
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$names .= $this->fields[$name]->FldExpression . ",";
			$values .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		while (substr($names, -1) == ",")
			$names = substr($names, 0, -1);
		while (substr($values, -1) == ",")
			$values = substr($values, 0, -1);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	function Insert(&$rs) {
		$conn = &$this->Connection();
		return $conn->Execute($this->InsertSQL($rs));
	}

	// UPDATE statement
	function UpdateSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->FldIsCustom)
				continue;
			$sql .= $this->fields[$name]->FldExpression . "=";
			$sql .= ew_QuotedValue($value, $this->fields[$name]->FldDataType, $this->DBID) . ",";
		}
		while (substr($sql, -1) == ",")
			$sql = substr($sql, 0, -1);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		ew_AddFilter($filter, $where);
		if ($filter <> "")	$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	function Update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE) {
		$conn = &$this->Connection();
		return $conn->Execute($this->UpdateSQL($rs, $where, $curfilter));
	}

	// DELETE statement
	function DeleteSQL(&$rs, $where = "", $curfilter = TRUE) {
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->ArrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		ew_AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	function Delete(&$rs, $where = "", $curfilter = TRUE) {
		$conn = &$this->Connection();
		return $conn->Execute($this->DeleteSQL($rs, $where, $curfilter));
	}

	// Key filter WHERE clause
	function SqlKeyFilter() {
		return "";
	}

	// Key filter
	function KeyFilter() {
		$sKeyFilter = $this->SqlKeyFilter();
		return $sKeyFilter;
	}

	// Return page URL
	function getReturnUrl() {
		$name = EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ew_ServerVar("HTTP_REFERER") <> "" && ew_ReferPage() <> ew_CurrentPage() && ew_ReferPage() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ew_ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "Consultalist.php";
		}
	}

	function setReturnUrl($v) {
		$_SESSION[EW_PROJECT_NAME . "_" . $this->TableVar . "_" . EW_TABLE_RETURN_URL] = $v;
	}

	// List URL
	function GetListUrl() {
		return "Consultalist.php";
	}

	// View URL
	function GetViewUrl($parm = "") {
		if ($parm <> "")
			$url = $this->KeyUrl("Consultaview.php", $this->UrlParm($parm));
		else
			$url = $this->KeyUrl("Consultaview.php", $this->UrlParm(EW_TABLE_SHOW_DETAIL . "="));
		return $this->AddMasterUrl($url);
	}

	// Add URL
	function GetAddUrl($parm = "") {
		if ($parm <> "")
			$url = "Consultaadd.php?" . $this->UrlParm($parm);
		else
			$url = "Consultaadd.php";
		return $this->AddMasterUrl($url);
	}

	// Edit URL
	function GetEditUrl($parm = "") {
		$url = $this->KeyUrl("Consultaedit.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline edit URL
	function GetInlineEditUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=edit"));
		return $this->AddMasterUrl($url);
	}

	// Copy URL
	function GetCopyUrl($parm = "") {
		$url = $this->KeyUrl("Consultaadd.php", $this->UrlParm($parm));
		return $this->AddMasterUrl($url);
	}

	// Inline copy URL
	function GetInlineCopyUrl() {
		$url = $this->KeyUrl(ew_CurrentPage(), $this->UrlParm("a=copy"));
		return $this->AddMasterUrl($url);
	}

	// Delete URL
	function GetDeleteUrl() {
		return $this->KeyUrl("Consultadelete.php", $this->UrlParm());
	}

	// Add master url
	function AddMasterUrl($url) {
		return $url;
	}

	function KeyToJson() {
		$json = "";
		return "{" . $json . "}";
	}

	// Add key value to URL
	function KeyUrl($url, $parm = "") {
		$sUrl = $url . "?";
		if ($parm <> "") $sUrl .= $parm . "&";
		return $sUrl;
	}

	// Sort URL
	function SortUrl(&$fld) {
		if ($this->CurrentAction <> "" || $this->Export <> "" ||
			in_array($fld->FldType, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$sUrlParm = $this->UrlParm("order=" . urlencode($fld->FldName) . "&amp;ordertype=" . $fld->ReverseSort());
			return ew_CurrentPage() . "?" . $sUrlParm;
		} else {
			return "";
		}
	}

	// Get record keys from $_POST/$_GET/$_SESSION
	function GetRecordKeys() {
		global $EW_COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (isset($_POST["key_m"])) {
			$arKeys = ew_StripSlashes($_POST["key_m"]);
			$cnt = count($arKeys);
		} elseif (isset($_GET["key_m"])) {
			$arKeys = ew_StripSlashes($_GET["key_m"]);
			$cnt = count($arKeys);
		} elseif (!empty($_GET) || !empty($_POST)) {
			$isPost = ew_IsHttpPost();

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get key filter
	function GetKeyFilter() {
		$arKeys = $this->GetRecordKeys();
		$sKeyFilter = "";
		foreach ($arKeys as $key) {
			if ($sKeyFilter <> "") $sKeyFilter .= " OR ";
			$sKeyFilter .= "(" . $this->KeyFilter() . ")";
		}
		return $sKeyFilter;
	}

	// Load rows based on filter
	function &LoadRs($sFilter) {

		// Set up filter (SQL WHERE clause) and get return SQL
		//$this->CurrentFilter = $sFilter;
		//$sSql = $this->SQL();

		$sSql = $this->GetSQL($sFilter, "");
		$conn = &$this->Connection();
		$rs = $conn->Execute($sSql);
		return $rs;
	}

	// Load row values from recordset
	function LoadListRowValues(&$rs) {
		$this->Num_factura->setDbValue($rs->fields('Num_factura'));
		$this->Codigo_prestador->setDbValue($rs->fields('Codigo_prestador'));
		$this->Tipo_id_usuario->setDbValue($rs->fields('Tipo_id_usuario'));
		$this->Numero_id_usuario->setDbValue($rs->fields('Numero_id_usuario'));
		$this->Fecha_consulta->setDbValue($rs->fields('Fecha_consulta'));
		$this->Numero_autorizacion->setDbValue($rs->fields('Numero_autorizacion'));
		$this->Codigo_consulta->setDbValue($rs->fields('Codigo_consulta'));
		$this->Finalidad_consulta->setDbValue($rs->fields('Finalidad_consulta'));
		$this->Causa_externa->setDbValue($rs->fields('Causa_externa'));
		$this->Codigo_diagnostico->setDbValue($rs->fields('Codigo_diagnostico'));
		$this->Codigo_diagnostico_rel1->setDbValue($rs->fields('Codigo_diagnostico_rel1'));
		$this->Codigo_diagnostico_rel2->setDbValue($rs->fields('Codigo_diagnostico_rel2'));
		$this->Codigo_diagnostico_rel3->setDbValue($rs->fields('Codigo_diagnostico_rel3'));
		$this->Tipo_diagnostico_principal->setDbValue($rs->fields('Tipo_diagnostico_principal'));
		$this->Valor_consulta->setDbValue($rs->fields('Valor_consulta'));
		$this->Valor_cuota_mod->setDbValue($rs->fields('Valor_cuota_mod'));
		$this->Valor_neto->setDbValue($rs->fields('Valor_neto'));
	}

	// Render list row values
	function RenderListRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

   // Common render codes
		// Num_factura
		// Codigo_prestador
		// Tipo_id_usuario
		// Numero_id_usuario
		// Fecha_consulta
		// Numero_autorizacion
		// Codigo_consulta
		// Finalidad_consulta
		// Causa_externa
		// Codigo_diagnostico
		// Codigo_diagnostico_rel1
		// Codigo_diagnostico_rel2
		// Codigo_diagnostico_rel3
		// Tipo_diagnostico_principal
		// Valor_consulta
		// Valor_cuota_mod
		// Valor_neto
		// Num_factura

		$this->Num_factura->ViewValue = $this->Num_factura->CurrentValue;
		$this->Num_factura->ViewCustomAttributes = "";

		// Codigo_prestador
		$this->Codigo_prestador->ViewValue = $this->Codigo_prestador->CurrentValue;
		$this->Codigo_prestador->ViewCustomAttributes = "";

		// Tipo_id_usuario
		$this->Tipo_id_usuario->ViewValue = $this->Tipo_id_usuario->CurrentValue;
		$this->Tipo_id_usuario->ViewCustomAttributes = "";

		// Numero_id_usuario
		$this->Numero_id_usuario->ViewValue = $this->Numero_id_usuario->CurrentValue;
		$this->Numero_id_usuario->ViewCustomAttributes = "";

		// Fecha_consulta
		$this->Fecha_consulta->ViewValue = $this->Fecha_consulta->CurrentValue;
		$this->Fecha_consulta->ViewCustomAttributes = "";

		// Numero_autorizacion
		$this->Numero_autorizacion->ViewValue = $this->Numero_autorizacion->CurrentValue;
		$this->Numero_autorizacion->ViewCustomAttributes = "";

		// Codigo_consulta
		$this->Codigo_consulta->ViewValue = $this->Codigo_consulta->CurrentValue;
		$this->Codigo_consulta->ViewCustomAttributes = "";

		// Finalidad_consulta
		$this->Finalidad_consulta->ViewValue = $this->Finalidad_consulta->CurrentValue;
		$this->Finalidad_consulta->ViewCustomAttributes = "";

		// Causa_externa
		$this->Causa_externa->ViewValue = $this->Causa_externa->CurrentValue;
		$this->Causa_externa->ViewCustomAttributes = "";

		// Codigo_diagnostico
		$this->Codigo_diagnostico->ViewValue = $this->Codigo_diagnostico->CurrentValue;
		$this->Codigo_diagnostico->ViewCustomAttributes = "";

		// Codigo_diagnostico_rel1
		$this->Codigo_diagnostico_rel1->ViewValue = $this->Codigo_diagnostico_rel1->CurrentValue;
		$this->Codigo_diagnostico_rel1->ViewCustomAttributes = "";

		// Codigo_diagnostico_rel2
		$this->Codigo_diagnostico_rel2->ViewValue = $this->Codigo_diagnostico_rel2->CurrentValue;
		$this->Codigo_diagnostico_rel2->ViewCustomAttributes = "";

		// Codigo_diagnostico_rel3
		$this->Codigo_diagnostico_rel3->ViewValue = $this->Codigo_diagnostico_rel3->CurrentValue;
		$this->Codigo_diagnostico_rel3->ViewCustomAttributes = "";

		// Tipo_diagnostico_principal
		$this->Tipo_diagnostico_principal->ViewValue = $this->Tipo_diagnostico_principal->CurrentValue;
		$this->Tipo_diagnostico_principal->ViewCustomAttributes = "";

		// Valor_consulta
		$this->Valor_consulta->ViewValue = $this->Valor_consulta->CurrentValue;
		$this->Valor_consulta->ViewCustomAttributes = "";

		// Valor_cuota_mod
		$this->Valor_cuota_mod->ViewValue = $this->Valor_cuota_mod->CurrentValue;
		$this->Valor_cuota_mod->ViewCustomAttributes = "";

		// Valor_neto
		$this->Valor_neto->ViewValue = $this->Valor_neto->CurrentValue;
		$this->Valor_neto->ViewCustomAttributes = "";

		// Num_factura
		$this->Num_factura->LinkCustomAttributes = "";
		$this->Num_factura->HrefValue = "";
		$this->Num_factura->TooltipValue = "";

		// Codigo_prestador
		$this->Codigo_prestador->LinkCustomAttributes = "";
		$this->Codigo_prestador->HrefValue = "";
		$this->Codigo_prestador->TooltipValue = "";

		// Tipo_id_usuario
		$this->Tipo_id_usuario->LinkCustomAttributes = "";
		$this->Tipo_id_usuario->HrefValue = "";
		$this->Tipo_id_usuario->TooltipValue = "";

		// Numero_id_usuario
		$this->Numero_id_usuario->LinkCustomAttributes = "";
		$this->Numero_id_usuario->HrefValue = "";
		$this->Numero_id_usuario->TooltipValue = "";

		// Fecha_consulta
		$this->Fecha_consulta->LinkCustomAttributes = "";
		$this->Fecha_consulta->HrefValue = "";
		$this->Fecha_consulta->TooltipValue = "";

		// Numero_autorizacion
		$this->Numero_autorizacion->LinkCustomAttributes = "";
		$this->Numero_autorizacion->HrefValue = "";
		$this->Numero_autorizacion->TooltipValue = "";

		// Codigo_consulta
		$this->Codigo_consulta->LinkCustomAttributes = "";
		$this->Codigo_consulta->HrefValue = "";
		$this->Codigo_consulta->TooltipValue = "";

		// Finalidad_consulta
		$this->Finalidad_consulta->LinkCustomAttributes = "";
		$this->Finalidad_consulta->HrefValue = "";
		$this->Finalidad_consulta->TooltipValue = "";

		// Causa_externa
		$this->Causa_externa->LinkCustomAttributes = "";
		$this->Causa_externa->HrefValue = "";
		$this->Causa_externa->TooltipValue = "";

		// Codigo_diagnostico
		$this->Codigo_diagnostico->LinkCustomAttributes = "";
		$this->Codigo_diagnostico->HrefValue = "";
		$this->Codigo_diagnostico->TooltipValue = "";

		// Codigo_diagnostico_rel1
		$this->Codigo_diagnostico_rel1->LinkCustomAttributes = "";
		$this->Codigo_diagnostico_rel1->HrefValue = "";
		$this->Codigo_diagnostico_rel1->TooltipValue = "";

		// Codigo_diagnostico_rel2
		$this->Codigo_diagnostico_rel2->LinkCustomAttributes = "";
		$this->Codigo_diagnostico_rel2->HrefValue = "";
		$this->Codigo_diagnostico_rel2->TooltipValue = "";

		// Codigo_diagnostico_rel3
		$this->Codigo_diagnostico_rel3->LinkCustomAttributes = "";
		$this->Codigo_diagnostico_rel3->HrefValue = "";
		$this->Codigo_diagnostico_rel3->TooltipValue = "";

		// Tipo_diagnostico_principal
		$this->Tipo_diagnostico_principal->LinkCustomAttributes = "";
		$this->Tipo_diagnostico_principal->HrefValue = "";
		$this->Tipo_diagnostico_principal->TooltipValue = "";

		// Valor_consulta
		$this->Valor_consulta->LinkCustomAttributes = "";
		$this->Valor_consulta->HrefValue = "";
		$this->Valor_consulta->TooltipValue = "";

		// Valor_cuota_mod
		$this->Valor_cuota_mod->LinkCustomAttributes = "";
		$this->Valor_cuota_mod->HrefValue = "";
		$this->Valor_cuota_mod->TooltipValue = "";

		// Valor_neto
		$this->Valor_neto->LinkCustomAttributes = "";
		$this->Valor_neto->HrefValue = "";
		$this->Valor_neto->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Render edit row values
	function RenderEditRow() {
		global $Security, $gsLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Num_factura
		$this->Num_factura->EditAttrs["class"] = "form-control";
		$this->Num_factura->EditCustomAttributes = "";
		$this->Num_factura->EditValue = $this->Num_factura->CurrentValue;
		$this->Num_factura->PlaceHolder = ew_RemoveHtml($this->Num_factura->FldCaption());

		// Codigo_prestador
		$this->Codigo_prestador->EditAttrs["class"] = "form-control";
		$this->Codigo_prestador->EditCustomAttributes = "";
		$this->Codigo_prestador->EditValue = $this->Codigo_prestador->CurrentValue;
		$this->Codigo_prestador->PlaceHolder = ew_RemoveHtml($this->Codigo_prestador->FldCaption());

		// Tipo_id_usuario
		$this->Tipo_id_usuario->EditAttrs["class"] = "form-control";
		$this->Tipo_id_usuario->EditCustomAttributes = "";
		$this->Tipo_id_usuario->EditValue = $this->Tipo_id_usuario->CurrentValue;
		$this->Tipo_id_usuario->PlaceHolder = ew_RemoveHtml($this->Tipo_id_usuario->FldCaption());

		// Numero_id_usuario
		$this->Numero_id_usuario->EditAttrs["class"] = "form-control";
		$this->Numero_id_usuario->EditCustomAttributes = "";
		$this->Numero_id_usuario->EditValue = $this->Numero_id_usuario->CurrentValue;
		$this->Numero_id_usuario->PlaceHolder = ew_RemoveHtml($this->Numero_id_usuario->FldCaption());

		// Fecha_consulta
		$this->Fecha_consulta->EditAttrs["class"] = "form-control";
		$this->Fecha_consulta->EditCustomAttributes = "";
		$this->Fecha_consulta->EditValue = $this->Fecha_consulta->CurrentValue;
		$this->Fecha_consulta->PlaceHolder = ew_RemoveHtml($this->Fecha_consulta->FldCaption());

		// Numero_autorizacion
		$this->Numero_autorizacion->EditAttrs["class"] = "form-control";
		$this->Numero_autorizacion->EditCustomAttributes = "";
		$this->Numero_autorizacion->EditValue = $this->Numero_autorizacion->CurrentValue;
		$this->Numero_autorizacion->PlaceHolder = ew_RemoveHtml($this->Numero_autorizacion->FldCaption());

		// Codigo_consulta
		$this->Codigo_consulta->EditAttrs["class"] = "form-control";
		$this->Codigo_consulta->EditCustomAttributes = "";
		$this->Codigo_consulta->EditValue = $this->Codigo_consulta->CurrentValue;
		$this->Codigo_consulta->PlaceHolder = ew_RemoveHtml($this->Codigo_consulta->FldCaption());

		// Finalidad_consulta
		$this->Finalidad_consulta->EditAttrs["class"] = "form-control";
		$this->Finalidad_consulta->EditCustomAttributes = "";
		$this->Finalidad_consulta->EditValue = $this->Finalidad_consulta->CurrentValue;
		$this->Finalidad_consulta->PlaceHolder = ew_RemoveHtml($this->Finalidad_consulta->FldCaption());

		// Causa_externa
		$this->Causa_externa->EditAttrs["class"] = "form-control";
		$this->Causa_externa->EditCustomAttributes = "";
		$this->Causa_externa->EditValue = $this->Causa_externa->CurrentValue;
		$this->Causa_externa->PlaceHolder = ew_RemoveHtml($this->Causa_externa->FldCaption());

		// Codigo_diagnostico
		$this->Codigo_diagnostico->EditAttrs["class"] = "form-control";
		$this->Codigo_diagnostico->EditCustomAttributes = "";
		$this->Codigo_diagnostico->EditValue = $this->Codigo_diagnostico->CurrentValue;
		$this->Codigo_diagnostico->PlaceHolder = ew_RemoveHtml($this->Codigo_diagnostico->FldCaption());

		// Codigo_diagnostico_rel1
		$this->Codigo_diagnostico_rel1->EditAttrs["class"] = "form-control";
		$this->Codigo_diagnostico_rel1->EditCustomAttributes = "";
		$this->Codigo_diagnostico_rel1->EditValue = $this->Codigo_diagnostico_rel1->CurrentValue;
		$this->Codigo_diagnostico_rel1->PlaceHolder = ew_RemoveHtml($this->Codigo_diagnostico_rel1->FldCaption());

		// Codigo_diagnostico_rel2
		$this->Codigo_diagnostico_rel2->EditAttrs["class"] = "form-control";
		$this->Codigo_diagnostico_rel2->EditCustomAttributes = "";
		$this->Codigo_diagnostico_rel2->EditValue = $this->Codigo_diagnostico_rel2->CurrentValue;
		$this->Codigo_diagnostico_rel2->PlaceHolder = ew_RemoveHtml($this->Codigo_diagnostico_rel2->FldCaption());

		// Codigo_diagnostico_rel3
		$this->Codigo_diagnostico_rel3->EditAttrs["class"] = "form-control";
		$this->Codigo_diagnostico_rel3->EditCustomAttributes = "";
		$this->Codigo_diagnostico_rel3->EditValue = $this->Codigo_diagnostico_rel3->CurrentValue;
		$this->Codigo_diagnostico_rel3->PlaceHolder = ew_RemoveHtml($this->Codigo_diagnostico_rel3->FldCaption());

		// Tipo_diagnostico_principal
		$this->Tipo_diagnostico_principal->EditAttrs["class"] = "form-control";
		$this->Tipo_diagnostico_principal->EditCustomAttributes = "";
		$this->Tipo_diagnostico_principal->EditValue = $this->Tipo_diagnostico_principal->CurrentValue;
		$this->Tipo_diagnostico_principal->PlaceHolder = ew_RemoveHtml($this->Tipo_diagnostico_principal->FldCaption());

		// Valor_consulta
		$this->Valor_consulta->EditAttrs["class"] = "form-control";
		$this->Valor_consulta->EditCustomAttributes = "";
		$this->Valor_consulta->EditValue = $this->Valor_consulta->CurrentValue;
		$this->Valor_consulta->PlaceHolder = ew_RemoveHtml($this->Valor_consulta->FldCaption());

		// Valor_cuota_mod
		$this->Valor_cuota_mod->EditAttrs["class"] = "form-control";
		$this->Valor_cuota_mod->EditCustomAttributes = "";
		$this->Valor_cuota_mod->EditValue = $this->Valor_cuota_mod->CurrentValue;
		$this->Valor_cuota_mod->PlaceHolder = ew_RemoveHtml($this->Valor_cuota_mod->FldCaption());

		// Valor_neto
		$this->Valor_neto->EditAttrs["class"] = "form-control";
		$this->Valor_neto->EditCustomAttributes = "";
		$this->Valor_neto->EditValue = $this->Valor_neto->CurrentValue;
		$this->Valor_neto->PlaceHolder = ew_RemoveHtml($this->Valor_neto->FldCaption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	function AggregateListRowValues() {
	}

	// Aggregate list row (for rendering)
	function AggregateListRow() {

		// Call Row Rendered event
		$this->Row_Rendered();
	}
	var $ExportDoc;

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	function ExportDocument(&$Doc, &$Recordset, $StartRec, $StopRec, $ExportPageType = "") {
		if (!$Recordset || !$Doc)
			return;
		if (!$Doc->ExportCustom) {

			// Write header
			$Doc->ExportTableHeader();
			if ($Doc->Horizontal) { // Horizontal format, write header
				$Doc->BeginExportRow();
				if ($ExportPageType == "view") {
					if ($this->Num_factura->Exportable) $Doc->ExportCaption($this->Num_factura);
					if ($this->Codigo_prestador->Exportable) $Doc->ExportCaption($this->Codigo_prestador);
					if ($this->Tipo_id_usuario->Exportable) $Doc->ExportCaption($this->Tipo_id_usuario);
					if ($this->Numero_id_usuario->Exportable) $Doc->ExportCaption($this->Numero_id_usuario);
					if ($this->Fecha_consulta->Exportable) $Doc->ExportCaption($this->Fecha_consulta);
					if ($this->Numero_autorizacion->Exportable) $Doc->ExportCaption($this->Numero_autorizacion);
					if ($this->Codigo_consulta->Exportable) $Doc->ExportCaption($this->Codigo_consulta);
					if ($this->Finalidad_consulta->Exportable) $Doc->ExportCaption($this->Finalidad_consulta);
					if ($this->Causa_externa->Exportable) $Doc->ExportCaption($this->Causa_externa);
					if ($this->Codigo_diagnostico->Exportable) $Doc->ExportCaption($this->Codigo_diagnostico);
					if ($this->Codigo_diagnostico_rel1->Exportable) $Doc->ExportCaption($this->Codigo_diagnostico_rel1);
					if ($this->Codigo_diagnostico_rel2->Exportable) $Doc->ExportCaption($this->Codigo_diagnostico_rel2);
					if ($this->Codigo_diagnostico_rel3->Exportable) $Doc->ExportCaption($this->Codigo_diagnostico_rel3);
					if ($this->Tipo_diagnostico_principal->Exportable) $Doc->ExportCaption($this->Tipo_diagnostico_principal);
					if ($this->Valor_consulta->Exportable) $Doc->ExportCaption($this->Valor_consulta);
					if ($this->Valor_cuota_mod->Exportable) $Doc->ExportCaption($this->Valor_cuota_mod);
					if ($this->Valor_neto->Exportable) $Doc->ExportCaption($this->Valor_neto);
				} else {
					if ($this->Num_factura->Exportable) $Doc->ExportCaption($this->Num_factura);
					if ($this->Codigo_prestador->Exportable) $Doc->ExportCaption($this->Codigo_prestador);
					if ($this->Tipo_id_usuario->Exportable) $Doc->ExportCaption($this->Tipo_id_usuario);
					if ($this->Numero_id_usuario->Exportable) $Doc->ExportCaption($this->Numero_id_usuario);
					if ($this->Fecha_consulta->Exportable) $Doc->ExportCaption($this->Fecha_consulta);
					if ($this->Numero_autorizacion->Exportable) $Doc->ExportCaption($this->Numero_autorizacion);
					if ($this->Codigo_consulta->Exportable) $Doc->ExportCaption($this->Codigo_consulta);
					if ($this->Finalidad_consulta->Exportable) $Doc->ExportCaption($this->Finalidad_consulta);
					if ($this->Causa_externa->Exportable) $Doc->ExportCaption($this->Causa_externa);
					if ($this->Codigo_diagnostico->Exportable) $Doc->ExportCaption($this->Codigo_diagnostico);
					if ($this->Codigo_diagnostico_rel1->Exportable) $Doc->ExportCaption($this->Codigo_diagnostico_rel1);
					if ($this->Codigo_diagnostico_rel2->Exportable) $Doc->ExportCaption($this->Codigo_diagnostico_rel2);
					if ($this->Codigo_diagnostico_rel3->Exportable) $Doc->ExportCaption($this->Codigo_diagnostico_rel3);
					if ($this->Tipo_diagnostico_principal->Exportable) $Doc->ExportCaption($this->Tipo_diagnostico_principal);
					if ($this->Valor_consulta->Exportable) $Doc->ExportCaption($this->Valor_consulta);
					if ($this->Valor_cuota_mod->Exportable) $Doc->ExportCaption($this->Valor_cuota_mod);
					if ($this->Valor_neto->Exportable) $Doc->ExportCaption($this->Valor_neto);
				}
				$Doc->EndExportRow();
			}
		}

		// Move to first record
		$RecCnt = $StartRec - 1;
		if (!$Recordset->EOF) {
			$Recordset->MoveFirst();
			if ($StartRec > 1)
				$Recordset->Move($StartRec - 1);
		}
		while (!$Recordset->EOF && $RecCnt < $StopRec) {
			$RecCnt++;
			if (intval($RecCnt) >= intval($StartRec)) {
				$RowCnt = intval($RecCnt) - intval($StartRec) + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($RowCnt > 1 && ($RowCnt - 1) % $this->ExportPageBreakCount == 0)
						$Doc->ExportPageBreak();
				}
				$this->LoadListRowValues($Recordset);

				// Render row
				$this->RowType = EW_ROWTYPE_VIEW; // Render view
				$this->ResetAttrs();
				$this->RenderListRow();
				if (!$Doc->ExportCustom) {
					$Doc->BeginExportRow($RowCnt); // Allow CSS styles if enabled
					if ($ExportPageType == "view") {
						if ($this->Num_factura->Exportable) $Doc->ExportField($this->Num_factura);
						if ($this->Codigo_prestador->Exportable) $Doc->ExportField($this->Codigo_prestador);
						if ($this->Tipo_id_usuario->Exportable) $Doc->ExportField($this->Tipo_id_usuario);
						if ($this->Numero_id_usuario->Exportable) $Doc->ExportField($this->Numero_id_usuario);
						if ($this->Fecha_consulta->Exportable) $Doc->ExportField($this->Fecha_consulta);
						if ($this->Numero_autorizacion->Exportable) $Doc->ExportField($this->Numero_autorizacion);
						if ($this->Codigo_consulta->Exportable) $Doc->ExportField($this->Codigo_consulta);
						if ($this->Finalidad_consulta->Exportable) $Doc->ExportField($this->Finalidad_consulta);
						if ($this->Causa_externa->Exportable) $Doc->ExportField($this->Causa_externa);
						if ($this->Codigo_diagnostico->Exportable) $Doc->ExportField($this->Codigo_diagnostico);
						if ($this->Codigo_diagnostico_rel1->Exportable) $Doc->ExportField($this->Codigo_diagnostico_rel1);
						if ($this->Codigo_diagnostico_rel2->Exportable) $Doc->ExportField($this->Codigo_diagnostico_rel2);
						if ($this->Codigo_diagnostico_rel3->Exportable) $Doc->ExportField($this->Codigo_diagnostico_rel3);
						if ($this->Tipo_diagnostico_principal->Exportable) $Doc->ExportField($this->Tipo_diagnostico_principal);
						if ($this->Valor_consulta->Exportable) $Doc->ExportField($this->Valor_consulta);
						if ($this->Valor_cuota_mod->Exportable) $Doc->ExportField($this->Valor_cuota_mod);
						if ($this->Valor_neto->Exportable) $Doc->ExportField($this->Valor_neto);
					} else {
						if ($this->Num_factura->Exportable) $Doc->ExportField($this->Num_factura);
						if ($this->Codigo_prestador->Exportable) $Doc->ExportField($this->Codigo_prestador);
						if ($this->Tipo_id_usuario->Exportable) $Doc->ExportField($this->Tipo_id_usuario);
						if ($this->Numero_id_usuario->Exportable) $Doc->ExportField($this->Numero_id_usuario);
						if ($this->Fecha_consulta->Exportable) $Doc->ExportField($this->Fecha_consulta);
						if ($this->Numero_autorizacion->Exportable) $Doc->ExportField($this->Numero_autorizacion);
						if ($this->Codigo_consulta->Exportable) $Doc->ExportField($this->Codigo_consulta);
						if ($this->Finalidad_consulta->Exportable) $Doc->ExportField($this->Finalidad_consulta);
						if ($this->Causa_externa->Exportable) $Doc->ExportField($this->Causa_externa);
						if ($this->Codigo_diagnostico->Exportable) $Doc->ExportField($this->Codigo_diagnostico);
						if ($this->Codigo_diagnostico_rel1->Exportable) $Doc->ExportField($this->Codigo_diagnostico_rel1);
						if ($this->Codigo_diagnostico_rel2->Exportable) $Doc->ExportField($this->Codigo_diagnostico_rel2);
						if ($this->Codigo_diagnostico_rel3->Exportable) $Doc->ExportField($this->Codigo_diagnostico_rel3);
						if ($this->Tipo_diagnostico_principal->Exportable) $Doc->ExportField($this->Tipo_diagnostico_principal);
						if ($this->Valor_consulta->Exportable) $Doc->ExportField($this->Valor_consulta);
						if ($this->Valor_cuota_mod->Exportable) $Doc->ExportField($this->Valor_cuota_mod);
						if ($this->Valor_neto->Exportable) $Doc->ExportField($this->Valor_neto);
					}
					$Doc->EndExportRow();
				}
			}

			// Call Row Export server event
			if ($Doc->ExportCustom)
				$this->Row_Export($Recordset->fields);
			$Recordset->MoveNext();
		}
		if (!$Doc->ExportCustom) {
			$Doc->ExportTableFooter();
		}
	}

	// Get auto fill value
	function GetAutoFill($id, $val) {
		$rsarr = array();
		$rowcnt = 0;

		// Output
		if (is_array($rsarr) && $rowcnt > 0) {
			$fldcnt = count($rsarr[0]);
			for ($i = 0; $i < $rowcnt; $i++) {
				for ($j = 0; $j < $fldcnt; $j++) {
					$str = strval($rsarr[$i][$j]);
					$str = ew_ConvertToUtf8($str);
					if (isset($post["keepCRLF"])) {
						$str = str_replace(array("\r", "\n"), array("\\r", "\\n"), $str);
					} else {
						$str = str_replace(array("\r", "\n"), array(" ", " "), $str);
					}
					$rsarr[$i][$j] = $str;
				}
			}
			return ew_ArrayToJson($rsarr);
		} else {
			return FALSE;
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here	
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here	
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here	
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending(&$Email, &$Args) {

		//var_dump($Email); var_dump($Args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->FldName, $fld->LookupFilters, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here	
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>); 

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
